/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SyntheticPropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DescriptorDerivedFromTypeAlias;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.deprecation.CommonDeprecationUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedOperatorMod;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfoKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u000234B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\fJ\u001f\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\fJ<\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00162\b\b\u0002\u0010 \u001a\u00020\u0016H\u0007J2\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016J\u0012\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\fH\u0002J\u001a\u0010(\u001a\u00020)*\u00020\f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140+H\u0002J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u00100\u001a\u00020\fH\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00132\u0006\u00100\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010,\u001a\u00020\u0016*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00f2\u0001\u0004\n\u00020\u0017\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationSettings", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationSettings;)V", "deprecations", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "computeDeprecation", "descriptor", "isHiddenBecauseOfKotlinVersionAccessibility", "Lorg/jetbrains/kotlin/resolve/SinceKotlinAccessibility;", "getDeprecations", "", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "areDeprecationsInheritedFromOverriden", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getHiddenDeprecationsFromOverriden", "isDeprecatedHidden", "isHiddenInResolution", "call", "Lorg/jetbrains/kotlin/psi/Call;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isSuperCall", "fromImportingScope", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "deprecationsByConstituentTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "deprecationByOverridden", "root", "getOwnDeprecations", "addDeprecationIfPresent", "", "result", "", "isBuiltInOperatorMod", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "shouldSkipDeprecationOnKotlinIoReadBytes", "getDeprecationFromUserData", "target", "getDeprecationByVersionRequirement", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByVersionRequirement;", "DeprecationInfo", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeprecationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecationResolver.kt\norg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n766#2:320\n857#2,2:321\n766#2:323\n857#2,2:324\n1747#2,3:326\n1747#2,3:329\n2624#2,3:332\n2624#2,3:335\n1620#2,3:338\n1603#2,9:342\n1855#2:351\n1856#2:353\n1612#2:354\n1855#2,2:355\n1#3:341\n1#3:352\n*S KotlinDebug\n*F\n+ 1 DeprecationResolver.kt\norg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver\n*L\n62#1:320\n62#1:321,2\n72#1:323\n72#1:324,2\n114#1:326,3\n144#1:329,3\n197#1:332,3\n219#1:335,3\n240#1:338,3\n307#1:342,9\n307#1:351\n307#1:353\n307#1:354\n189#1:355,2\n307#1:352\n*E\n"})
public final class DeprecationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DeprecationSettings deprecationSettings;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, DeprecationInfo> deprecations;
    @NotNull
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, SinceKotlinAccessibility> isHiddenBecauseOfKotlinVersionAccessibility;
    @NotNull
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");

    public DeprecationResolver(@NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DeprecationSettings deprecationSettings) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)deprecationSettings, (String)"deprecationSettings");
        this.languageVersionSettings = languageVersionSettings2;
        this.deprecationSettings = deprecationSettings;
        this.deprecations = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, DeprecationInfo>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final DeprecationInfo invoke(DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                return DeprecationResolver.access$computeDeprecation(this.this$0, descriptor2);
            }
        });
        this.isHiddenBecauseOfKotlinVersionAccessibility = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, SinceKotlinAccessibility>(this){
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final SinceKotlinAccessibility invoke(DeclarationDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                return SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(descriptor2, DeprecationResolver.access$getLanguageVersionSettings$p(this.this$0));
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DeprecationInfo computeDeprecation(DeclarationDescriptor descriptor2) {
        DeprecationInfo deprecationInfo;
        List<DescriptorBasedDeprecationInfo> deprecations2 = this.getOwnDeprecations(descriptor2);
        if (!((Collection)deprecations2).isEmpty()) {
            deprecationInfo = new DeprecationInfo(deprecations2, false, null, 4, null);
            return deprecationInfo;
        } else {
            if (descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() instanceof SyntheticPropertyDescriptor) {
                void $this$filterTo$iv$iv;
                FunctionDescriptor originalMethod;
                PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNull((Object)propertyDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SyntheticPropertyDescriptor");
                SyntheticPropertyDescriptor syntheticProperty = (SyntheticPropertyDescriptor)((Object)propertyDescriptor);
                FunctionDescriptor functionDescriptor = originalMethod = descriptor2 instanceof PropertyGetterDescriptor ? syntheticProperty.getGetMethod() : syntheticProperty.getSetMethod();
                if (originalMethod == null) {
                    return DeprecationInfo.Companion.getEMPTY();
                }
                DeprecationInfo originalMethodDeprecationInfo = (DeprecationInfo)this.deprecations.invoke(originalMethod);
                Iterable $this$filter$iv = originalMethodDeprecationInfo.getDeprecations();
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DescriptorBasedDeprecationInfo it = (DescriptorBasedDeprecationInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getDeprecationLevel() == DeprecationLevelValue.WARNING && it.getForcePropagationToOverrides())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredDeprecations = (List)destination$iv$iv;
                return DeprecationInfo.copy$default(originalMethodDeprecationInfo, filteredDeprecations, false, null, 6, null);
            }
            if (descriptor2 instanceof CallableMemberDescriptor) {
                boolean bl;
                List inheritedDeprecations = CollectionsKt.listOfNotNull((Object)this.deprecationByOverridden((CallableMemberDescriptor)descriptor2));
                boolean bl2 = bl = !((Collection)inheritedDeprecations).isEmpty();
                if (bl) {
                    boolean bl3 = this.languageVersionSettings.supportsFeature(LanguageFeature.StopPropagatingDeprecationThroughOverrides);
                    if (bl3) {
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = inheritedDeprecations;
                        boolean $i$f$filter = false;
                        Iterable $i$f$filter2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            DescriptorBasedDeprecationInfo it = (DescriptorBasedDeprecationInfo)element$iv$iv;
                            boolean bl4 = false;
                            if (!it.getForcePropagationToOverrides()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list2 = inheritedDeprecations;
                        boolean bl5 = true;
                        List list3 = (List)destination$iv$iv;
                        deprecationInfo = new DeprecationInfo(list3, bl5, list2);
                        return deprecationInfo;
                    } else {
                        if (bl3) throw new NoWhenBranchMatchedException();
                        deprecationInfo = new DeprecationInfo(inheritedDeprecations, true, null, 4, null);
                    }
                    return deprecationInfo;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    deprecationInfo = DeprecationInfo.Companion.getEMPTY();
                }
                return deprecationInfo;
            } else {
                deprecationInfo = DeprecationInfo.Companion.getEMPTY();
            }
        }
        return deprecationInfo;
    }

    @NotNull
    public final List<DescriptorBasedDeprecationInfo> getDeprecations(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getDeprecations();
    }

    public final boolean areDeprecationsInheritedFromOverriden(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getHasInheritedDeprecations();
    }

    @NotNull
    public final List<DescriptorBasedDeprecationInfo> getHiddenDeprecationsFromOverriden(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        return ((DeprecationInfo)this.deprecations.invoke(declarationDescriptor)).getHiddenInheritedDeprecations();
    }

    public final boolean isDeprecatedHidden(@NotNull DeclarationDescriptor descriptor2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Iterable $this$any$iv = this.getDeprecations(descriptor2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DescriptorBasedDeprecationInfo it = (DescriptorBasedDeprecationInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDeprecationLevel() == DeprecationLevelValue.HIDDEN)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Call call3 = call2;
        return this.isHiddenInResolution(descriptor2, call3 != null ? call3.getCallElement() : null, bindingContext, isSuperCall, fromImportingScope);
    }

    public static /* synthetic */ boolean isHiddenInResolution$default(DeprecationResolver deprecationResolver, DeclarationDescriptor declarationDescriptor, Call call2, BindingContext bindingContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            call2 = null;
        }
        if ((n & 4) != 0) {
            bindingContext = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return deprecationResolver.isHiddenInResolution(declarationDescriptor, call2, bindingContext, bl, bl2);
    }

    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable KtElement callElement, @Nullable BindingContext bindingContext, boolean isSuperCall, boolean fromImportingScope) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor2).isHiddenToOvercomeSignatureClash()) {
                return true;
            }
            if (((FunctionDescriptor)descriptor2).isHiddenForResolutionEverywhereBesideSupercalls() && !isSuperCall) {
                return true;
            }
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        SinceKotlinAccessibility sinceKotlinAccessibility = (SinceKotlinAccessibility)this.isHiddenBecauseOfKotlinVersionAccessibility.invoke(declarationDescriptor);
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessible) {
            return true;
        }
        if (sinceKotlinAccessibility instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
            boolean bl;
            block10: {
                if (callElement != null && bindingContext != null) {
                    OptInUsageChecker.Companion $this$isHiddenInResolution_u24lambda_u244 = OptInUsageChecker.Companion;
                    boolean bl2 = false;
                    Iterable $this$any$iv = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)sinceKotlinAccessibility).getMarkerClasses();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ClassDescriptor classDescriptor2 = (ClassDescriptor)element$iv;
                            boolean bl3 = false;
                            if (!(!$this$isHiddenInResolution_u24lambda_u244.isOptInAllowed((PsiElement)callElement, DescriptorUtilsKt.getFqNameSafe(classDescriptor2), this.languageVersionSettings, bindingContext))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = !fromImportingScope;
                }
            }
            return bl;
        }
        return this.isDeprecatedHidden(descriptor2);
    }

    private final List<DescriptorBasedDeprecationInfo> deprecationsByConstituentTypes(KotlinType $this$deprecationsByConstituentTypes) {
        SmartList<DescriptorBasedDeprecationInfo> smartList;
        SmartList<DescriptorBasedDeprecationInfo> deprecations2 = smartList = new SmartList<DescriptorBasedDeprecationInfo>();
        boolean bl = false;
        TypeUtils.contains($this$deprecationsByConstituentTypes, (Function1<UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(deprecations2, this){
            final /* synthetic */ SmartList<DescriptorBasedDeprecationInfo> $deprecations;
            final /* synthetic */ DeprecationResolver this$0;
            {
                this.$deprecations = $deprecations;
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(UnwrappedType type2) {
                block0: {
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) break block0;
                    ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                    SmartList<DescriptorBasedDeprecationInfo> smartList = this.$deprecations;
                    DeprecationResolver deprecationResolver = this.this$0;
                    ClassifierDescriptor it = classifierDescriptor2;
                    boolean bl = false;
                    smartList.addAll((Collection<DescriptorBasedDeprecationInfo>)deprecationResolver.getDeprecations(it));
                }
                return false;
            }
        }));
        return smartList;
    }

    private final DescriptorBasedDeprecationInfo deprecationByOverridden(CallableMemberDescriptor root2) {
        boolean $i$f$none;
        Iterable $this$none$iv;
        HashSet<CallableMemberDescriptor> visited2 = new HashSet<CallableMemberDescriptor>();
        LinkedHashSet<DescriptorBasedDeprecationInfo> deprecations2 = new LinkedHashSet<DescriptorBasedDeprecationInfo>();
        Ref.BooleanRef hasUndeprecatedOverridden = new Ref.BooleanRef();
        DeprecationResolver.deprecationByOverridden$traverse(visited2, this, deprecations2, hasUndeprecatedOverridden, root2);
        if (deprecations2.isEmpty()) {
            return null;
        }
        if (hasUndeprecatedOverridden.element) {
            boolean bl;
            block11: {
                $this$none$iv = deprecations2;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        DescriptorBasedDeprecationInfo it = (DescriptorBasedDeprecationInfo)element$iv;
                        boolean bl2 = false;
                        if (!it.getForcePropagationToOverrides()) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
        }
        if (root2.getKind().isReal()) {
            boolean bl;
            block12: {
                $this$none$iv = deprecations2;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        DescriptorBasedDeprecationInfo p0 = (DescriptorBasedDeprecationInfo)element$iv;
                        boolean bl3 = false;
                        if (!p0.getPropagatesToOverrides()) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
        }
        return new DeprecatedByOverridden((Collection<? extends DescriptorBasedDeprecationInfo>)deprecations2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DescriptorBasedDeprecationInfo> getOwnDeprecations(DeclarationDescriptor $this$getOwnDeprecations) {
        if (this.isBuiltInOperatorMod($this$getOwnDeprecations) && !OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        if (this.shouldSkipDeprecationOnKotlinIoReadBytes($this$getOwnDeprecations, this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        this.addDeprecationIfPresent($this$getOwnDeprecations, result2);
        DeclarationDescriptor declarationDescriptor = $this$getOwnDeprecations;
        if (declarationDescriptor instanceof TypeAliasDescriptor) {
            Iterable $this$mapTo$iv = this.deprecationsByConstituentTypes(((TypeAliasDescriptor)$this$getOwnDeprecations).getExpandedType());
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void deprecation;
                DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = (DescriptorBasedDeprecationInfo)item$iv;
                Collection collection = result2;
                boolean bl = false;
                collection.add(deprecation instanceof DeprecatedByAnnotation ? (DescriptorBasedDeprecationInfo)new DeprecatedTypealiasByAnnotation((TypeAliasDescriptor)$this$getOwnDeprecations, (DeprecatedByAnnotation)deprecation) : deprecation);
            }
        } else if (declarationDescriptor instanceof DescriptorDerivedFromTypeAlias) {
            result2.addAll(this.getOwnDeprecations(((DescriptorDerivedFromTypeAlias)((Object)$this$getOwnDeprecations)).getTypeAliasDescriptor()));
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$getOwnDeprecations).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            this.addDeprecationIfPresent(propertyDescriptor, result2);
        }
        return CollectionsKt.distinct((Iterable)result2);
    }

    private final void addDeprecationIfPresent(DeclarationDescriptor $this$addDeprecationIfPresent, List<DescriptorBasedDeprecationInfo> result2) {
        block3: {
            DeprecatedByAnnotation deprecatedByAnnotation;
            AnnotationDescriptor annotation2;
            AnnotationDescriptor annotationDescriptor = $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
            if (annotationDescriptor == null) {
                annotationDescriptor = $this$addDeprecationIfPresent.getAnnotations().findAnnotation(JAVA_DEPRECATED);
            }
            if ((annotation2 = annotationDescriptor) != null && (deprecatedByAnnotation = DeprecatedByAnnotation.Companion.create(annotation2, $this$addDeprecationIfPresent.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin), $this$addDeprecationIfPresent, this.deprecationSettings.propagatedToOverrides(annotation2), this.languageVersionSettings.getApiVersion())) != null) {
                DescriptorBasedDeprecationInfo deprecation = $this$addDeprecationIfPresent instanceof TypeAliasConstructorDescriptor ? (DescriptorBasedDeprecationInfo)new DeprecatedTypealiasByAnnotation(((TypeAliasConstructorDescriptor)$this$addDeprecationIfPresent).getTypeAliasDescriptor(), deprecatedByAnnotation) : (this.isBuiltInOperatorMod($this$addDeprecationIfPresent) ? (DescriptorBasedDeprecationInfo)new DeprecatedOperatorMod(this.languageVersionSettings, deprecatedByAnnotation) : (DescriptorBasedDeprecationInfo)deprecatedByAnnotation);
                result2.add(deprecation);
            }
            for (DescriptorBasedDeprecationInfo deprecation : this.getDeprecationByVersionRequirement($this$addDeprecationIfPresent)) {
                result2.add(deprecation);
            }
            DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = this.getDeprecationFromUserData($this$addDeprecationIfPresent);
            if (descriptorBasedDeprecationInfo == null) break block3;
            DescriptorBasedDeprecationInfo p0 = descriptorBasedDeprecationInfo;
            boolean bl = false;
            result2.add(p0);
        }
    }

    private final boolean isBuiltInOperatorMod(DeclarationDescriptor $this$isBuiltInOperatorMod) {
        return $this$isBuiltInOperatorMod instanceof FunctionDescriptor && OperatorCallCheckerKt.isOperatorMod((FunctionDescriptor)$this$isBuiltInOperatorMod) && KotlinBuiltIns.isUnderKotlinPackage($this$isBuiltInOperatorMod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSkipDeprecationOnKotlinIoReadBytes(DeclarationDescriptor descriptor2, LanguageVersionSettings languageVersionSettings2) {
        if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"readBytes")) return false;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Object object = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (!Intrinsics.areEqual((Object)(object != null && (object = object.getFqName()) != null ? ((FqName)object).asString() : null), (Object)"kotlin.io")) return false;
        if (!(descriptor2 instanceof FunctionDescriptor)) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        Annotated annotated = valueParameterDescriptor;
        if (valueParameterDescriptor == null) return false;
        KotlinType kotlinType = annotated.getType();
        annotated = kotlinType;
        if (kotlinType == null) return false;
        Annotated annotated2 = annotated;
        boolean bl = false;
        if (!KotlinBuiltIns.isInt((KotlinType)annotated2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (languageVersionSettings2.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) >= 0) return false;
        return true;
    }

    private final DescriptorBasedDeprecationInfo getDeprecationFromUserData(DeclarationDescriptor target) {
        CallableDescriptor callableDescriptor = target instanceof CallableDescriptor ? (CallableDescriptor)target : null;
        return callableDescriptor != null ? callableDescriptor.getUserData(DescriptorBasedDeprecationInfoKt.getDEPRECATED_FUNCTION_KEY()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeprecatedByVersionRequirement> getDeprecationByVersionRequirement(DeclarationDescriptor target) {
        void $this$mapNotNullTo$iv$iv;
        Object object = target instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)target : null;
        if (object == null || (object = object.getVersionRequirements()) == null) {
            DeserializedClassDescriptor deserializedClassDescriptor = target instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)target : null;
            if (deserializedClassDescriptor != null) {
                object = deserializedClassDescriptor.getVersionRequirements();
            } else {
                return CollectionsKt.emptyList();
            }
        }
        List<VersionRequirement> versionRequirements = object;
        Iterable $this$mapNotNull$iv = versionRequirements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DeprecatedByVersionRequirement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VersionRequirement versionRequirement = (VersionRequirement)element$iv$iv;
            boolean bl2 = false;
            if ((!CommonDeprecationUtilsKt.isFulfilled(versionRequirement, this.languageVersionSettings) ? new DeprecatedByVersionRequirement(versionRequirement, target) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext, boolean isSuperCall) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, isSuperCall, false, 16, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2, @Nullable BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, bindingContext, false, false, 24, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, @Nullable Call call2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, call2, null, false, false, 28, null);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, null, null, false, false, 30, null);
    }

    private static final void deprecationByOverridden$traverse(HashSet<CallableMemberDescriptor> visited2, DeprecationResolver this$0, LinkedHashSet<DescriptorBasedDeprecationInfo> deprecations2, Ref.BooleanRef hasUndeprecatedOverridden, CallableMemberDescriptor node) {
        if (visited2.contains(node)) {
            return;
        }
        visited2.add(node);
        List<DescriptorBasedDeprecationInfo> deprecationsByAnnotation = this$0.getOwnDeprecations(node);
        Collection<? extends CallableMemberDescriptor> collection = node.getOriginal().getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        Collection<? extends CallableMemberDescriptor> overriddenDescriptors = collection;
        if (!((Collection)deprecationsByAnnotation).isEmpty()) {
            deprecations2.addAll((Collection<DescriptorBasedDeprecationInfo>)deprecationsByAnnotation);
        } else {
            if (overriddenDescriptors.isEmpty()) {
                hasUndeprecatedOverridden.element = true;
                return;
            }
            Iterable $this$forEach$iv = overriddenDescriptors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallableMemberDescriptor p0 = (CallableMemberDescriptor)element$iv;
                boolean bl = false;
                DeprecationResolver.deprecationByOverridden$traverse(visited2, this$0, deprecations2, hasUndeprecatedOverridden, p0);
            }
        }
    }

    public static final /* synthetic */ DeprecationInfo access$computeDeprecation(DeprecationResolver $this, DeclarationDescriptor descriptor2) {
        return $this.computeDeprecation(descriptor2);
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(DeprecationResolver $this) {
        return $this.languageVersionSettings;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$Companion;", "", "<init>", "()V", "JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "getJAVA_DEPRECATED", "()Lorg/jetbrains/kotlin/name/FqName;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getJAVA_DEPRECATED() {
            return JAVA_DEPRECATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "", "deprecations", "", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "hasInheritedDeprecations", "", "hiddenInheritedDeprecations", "<init>", "(Ljava/util/List;ZLjava/util/List;)V", "getDeprecations", "()Ljava/util/List;", "getHasInheritedDeprecations", "()Z", "getHiddenInheritedDeprecations", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "frontend"})
    private static final class DeprecationInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<DescriptorBasedDeprecationInfo> deprecations;
        private final boolean hasInheritedDeprecations;
        @NotNull
        private final List<DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations;
        @NotNull
        private static final DeprecationInfo EMPTY = new DeprecationInfo(CollectionsKt.emptyList(), false, CollectionsKt.emptyList());

        public DeprecationInfo(@NotNull List<? extends DescriptorBasedDeprecationInfo> deprecations2, boolean hasInheritedDeprecations, @NotNull List<? extends DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations) {
            Intrinsics.checkNotNullParameter(deprecations2, (String)"deprecations");
            Intrinsics.checkNotNullParameter(hiddenInheritedDeprecations, (String)"hiddenInheritedDeprecations");
            this.deprecations = deprecations2;
            this.hasInheritedDeprecations = hasInheritedDeprecations;
            this.hiddenInheritedDeprecations = hiddenInheritedDeprecations;
        }

        public /* synthetic */ DeprecationInfo(List list2, boolean bl, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, list3);
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> getDeprecations() {
            return this.deprecations;
        }

        public final boolean getHasInheritedDeprecations() {
            return this.hasInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> getHiddenInheritedDeprecations() {
            return this.hiddenInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> component1() {
            return this.deprecations;
        }

        public final boolean component2() {
            return this.hasInheritedDeprecations;
        }

        @NotNull
        public final List<DescriptorBasedDeprecationInfo> component3() {
            return this.hiddenInheritedDeprecations;
        }

        @NotNull
        public final DeprecationInfo copy(@NotNull List<? extends DescriptorBasedDeprecationInfo> deprecations2, boolean hasInheritedDeprecations, @NotNull List<? extends DescriptorBasedDeprecationInfo> hiddenInheritedDeprecations) {
            Intrinsics.checkNotNullParameter(deprecations2, (String)"deprecations");
            Intrinsics.checkNotNullParameter(hiddenInheritedDeprecations, (String)"hiddenInheritedDeprecations");
            return new DeprecationInfo(deprecations2, hasInheritedDeprecations, hiddenInheritedDeprecations);
        }

        public static /* synthetic */ DeprecationInfo copy$default(DeprecationInfo deprecationInfo, List list2, boolean bl, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = deprecationInfo.deprecations;
            }
            if ((n & 2) != 0) {
                bl = deprecationInfo.hasInheritedDeprecations;
            }
            if ((n & 4) != 0) {
                list3 = deprecationInfo.hiddenInheritedDeprecations;
            }
            return deprecationInfo.copy(list2, bl, list3);
        }

        @NotNull
        public String toString() {
            return "DeprecationInfo(deprecations=" + this.deprecations + ", hasInheritedDeprecations=" + this.hasInheritedDeprecations + ", hiddenInheritedDeprecations=" + this.hiddenInheritedDeprecations + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.deprecations).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasInheritedDeprecations);
            result2 = result2 * 31 + ((Object)this.hiddenInheritedDeprecations).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecationInfo)) {
                return false;
            }
            DeprecationInfo deprecationInfo = (DeprecationInfo)other;
            if (!Intrinsics.areEqual(this.deprecations, deprecationInfo.deprecations)) {
                return false;
            }
            if (this.hasInheritedDeprecations != deprecationInfo.hasInheritedDeprecations) {
                return false;
            }
            return Intrinsics.areEqual(this.hiddenInheritedDeprecations, deprecationInfo.hiddenInheritedDeprecations);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver$DeprecationInfo;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DeprecationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

