/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ApiVersionIsAtLeastArgumentsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isApiVersionIsAtLeast", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nApiVersionIsAtLeastArgumentsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVersionIsAtLeastArgumentsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ApiVersionIsAtLeastArgumentsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1726#2,3:65\n*S KotlinDebug\n*F\n+ 1 ApiVersionIsAtLeastArgumentsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ApiVersionIsAtLeastArgumentsChecker\n*L\n59#1:65,3\n*E\n"})
public final class ApiVersionIsAtLeastArgumentsChecker
implements CallChecker {
    @NotNull
    public static final ApiVersionIsAtLeastArgumentsChecker INSTANCE = new ApiVersionIsAtLeastArgumentsChecker();

    private ApiVersionIsAtLeastArgumentsChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isApiVersionIsAtLeast((CallableDescriptor)resolvedCall2.getResultingDescriptor())) {
            return;
        }
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        boolean shouldInlineConstVals = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineConstVals);
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument = iterator2.next().getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression ktExpression;
                ConstantValue<?> constant;
                KtExpression ktExpression2 = valueArgument.getArgumentExpression();
                if (ktExpression2 == null || KtPsiUtil.deparenthesize(ktExpression2) == null || (constant = JvmConstantsKt.getCompileTimeConstant(ktExpression, bindingContext2, false, shouldInlineConstVals)) != null) continue;
                context2.getTrace().report(ErrorsJvm.API_VERSION_IS_AT_LEAST_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)ktExpression)));
            }
        }
    }

    private final boolean isApiVersionIsAtLeast(CallableDescriptor descriptor2) {
        boolean bl;
        FunctionDescriptor functionDescriptor;
        block9: {
            FunctionDescriptor functionDescriptor2 = descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null;
            if (functionDescriptor2 == null) {
                return false;
            }
            functionDescriptor = functionDescriptor2;
            if (!Intrinsics.areEqual((Object)functionDescriptor.getName().asString(), (Object)"apiVersionIsAtLeast")) {
                return false;
            }
            KotlinType kotlinType = functionDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType2 = kotlinType;
            if (!KotlinBuiltIns.isBoolean(returnType2)) {
                return false;
            }
            List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (KotlinBuiltIns.isInt(it.getType())) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingPackage = packageFragmentDescriptor;
        return Intrinsics.areEqual((Object)containingPackage.getFqName().asString(), (Object)"kotlin.internal");
    }
}

