/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.AssignmentCheckUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AssignmentChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u009f\u0001\u0010\u0004\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t \b*D\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AssignmentChecker;", "<init>", "()V", "TYPE_MISMATCH_ERRORS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "check", "", "assignmentExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSyntheticAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n37#2,2:66\n2624#3,3:68\n*S KotlinDebug\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n*L\n49#1:66,2\n60#1:68,3\n*E\n"})
public final class JvmSyntheticAssignmentChecker
implements AssignmentChecker {
    @NotNull
    public static final JvmSyntheticAssignmentChecker INSTANCE = new JvmSyntheticAssignmentChecker();
    @NotNull
    private static final Set<DiagnosticFactoryWithPsiElement<? extends KtExpression, ? extends AbstractDiagnostic<? extends KtExpression>>> TYPE_MISMATCH_ERRORS;

    private JvmSyntheticAssignmentChecker() {
    }

    @Override
    public void check(@NotNull KtBinaryExpression assignmentExpression, @NotNull CallCheckerContext context2) {
        boolean bl;
        KotlinType rValueType;
        KtExpression rValue;
        KotlinType substitutedPropertyType;
        block18: {
            Intrinsics.checkNotNullParameter((Object)assignmentExpression, (String)"assignmentExpression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            KtExpression ktExpression = assignmentExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KtElement ktElement = left;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
            if (!TowerUtilsKt.isSynthesized(resultingDescriptor)) {
                return;
            }
            if (!(resultingDescriptor instanceof SyntheticJavaPropertyDescriptor)) {
                return;
            }
            Object object = resolvedCall3.getExtensionReceiver();
            if (object == null || (object = object.getType()) == null) {
                return;
            }
            Object receiverType = object;
            Annotated annotated = resolvedCall3.getCandidateDescriptor().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return;
            }
            Annotated unsubstitutedReceiverType = annotated;
            if (((KotlinType)receiverType).getConstructor() != ((KotlinType)unsubstitutedReceiverType).getConstructor()) {
                return;
            }
            KotlinType kotlinType = resolvedCall3.getCandidateDescriptor().getReturnType();
            if (kotlinType == null) {
                return;
            }
            KotlinType propertyType = kotlinType;
            List substitutionParameters = new ArrayList();
            List substitutionArguments = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)((KotlinType)unsubstitutedReceiverType).getArguments(), (Iterable)((KotlinType)receiverType).getArguments())) {
                TypeParameterDescriptor typeParameter2;
                TypeProjection unsubstitutedArgument = (TypeProjection)pair.component1();
                TypeProjection substitutedArgument = (TypeProjection)pair.component2();
                ClassifierDescriptor classifierDescriptor = unsubstitutedArgument.getType().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null) == null) continue;
                typeParameter2 = typeParameter2;
                ((Collection)substitutionParameters).add(typeParameter2);
                ((Collection)substitutionArguments).add(substitutedArgument);
            }
            Collection $this$toTypedArray$iv = substitutionParameters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = substitutionArguments;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new IndexedParametersSubstitution(thisCollection$iv.toArray(new TypeParameterDescriptor[0]), thisCollection$iv.toArray(new TypeProjection[0]), true));
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            KotlinType kotlinType2 = substitutor2.substitute(propertyType.unwrap(), Variance.IN_VARIANCE);
            if (kotlinType2 == null) {
                return;
            }
            substitutedPropertyType = kotlinType2;
            if (TypeUtilsKt.isNothing(substitutedPropertyType)) {
                context2.getTrace().report(ErrorsJvm.SYNTHETIC_SETTER_PROJECTED_OUT.on((KtExpression)((PsiElement)left), resultingDescriptor));
                return;
            }
            KtExpression ktExpression2 = assignmentExpression.getRight();
            if (ktExpression2 == null) {
                return;
            }
            rValue = ktExpression2;
            BindingContext bindingContext2 = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
            KotlinType kotlinType3 = CallUtilKt.getType(rValue, bindingContext2);
            if (kotlinType3 == null) {
                return;
            }
            rValueType = kotlinType3;
            if (AssignmentCheckUtilsKt.isAssignmentCorrectWithDataFlowInfo(substitutedPropertyType, rValue, rValueType, context2)) {
                return;
            }
            Iterable $this$none$iv = context2.getTrace().getBindingContext().getDiagnostics().forElement(rValue);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)TYPE_MISMATCH_ERRORS, it.getFactory())) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            context2.getTrace().report(Errors.TYPE_MISMATCH_WARNING.on((KtExpression)((PsiElement)rValue), substitutedPropertyType, rValueType));
        }
    }

    static {
        Object[] objectArray = new DiagnosticFactoryWithPsiElement[]{Errors.TYPE_MISMATCH, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE};
        TYPE_MISMATCH_ERRORS = SetsKt.setOf((Object[])objectArray);
    }
}

