/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "FLEXIBLE_TYPE_COMMENT", "DECOMPILED_CONTRACT_STUB", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "mustNotBeWrittenToDecompiledText", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n3183#2,10:202\n*S KotlinDebug\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n*L\n157#1:202,10\n*E\n"})
public final class BuildDecompiledTextKt {
    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultDecompilerRendererOptions, (String)"<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
        $this$defaultDecompilerRendererOptions.setDefaultParameterValueRenderer((Function1<? super ValueParameterDescriptor, String>)((Function1)defaultDecompilerRendererOptions.1.INSTANCE));
        $this$defaultDecompilerRendererOptions.setIncludePropertyConstant(true);
        $this$defaultDecompilerRendererOptions.setPropertyConstantRenderer(defaultDecompilerRendererOptions.2.INSTANCE);
    }

    public static final boolean mustNotBeWrittenToDecompiledText(@NotNull CallableMemberDescriptor $this$mustNotBeWrittenToDecompiledText) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$mustNotBeWrittenToDecompiledText, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustNotBeWrittenToDecompiledText.getKind().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                Name name2 = $this$mustNotBeWrittenToDecompiledText.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                if (!DataClassDescriptorResolver.INSTANCE.isComponentLike(name2)) {
                    Object[] objectArray = new Name[]{OperatorNameConventions.EQUALS, StandardNames.HASHCODE_NAME, OperatorNameConventions.TO_STRING};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains($this$mustNotBeWrittenToDecompiledText.getName())) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer2, (String)"descriptorRenderer");
        StringBuilder builder2 = new StringBuilder();
        BuildDecompiledTextKt.buildDecompiledText$appendDecompiledTextAndPackageName(builder2, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, descriptorRenderer2, declarationDescriptor, "", null, 16, null);
            builder2.append("\n");
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new DecompiledText(string2);
    }

    private static final void buildDecompiledText$appendDecompiledTextAndPackageName(StringBuilder builder2, FqName $packageFqName) {
        builder2.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder2.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder2.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledText$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder2) {
        if (firstPassed.element) {
            builder2.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledText$appendDescriptor(StringBuilder builder2, DescriptorRenderer $descriptorRenderer, DeclarationDescriptor descriptor2, String indent, Boolean lastEnumEntry) {
        StringBuilder stringBuilder2;
        if (DescriptorUtils.isEnumEntry(descriptor2)) {
            for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
                builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation2, null, 2, null));
                builder2.append(" ");
            }
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            builder2.append(KtPsiUtilKt.quoteIfNeeded(string2));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull((Object)bl);
            stringBuilder2 = builder2.append(bl != false ? ";" : ",");
        } else {
            stringBuilder2 = builder2.append(StringsKt.replace$default((String)$descriptorRenderer.render(descriptor2), (String)"= ...", (String)"/* = compiled code */", (boolean)false, (int)4, null));
        }
        if (descriptor2 instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder2.append(" ").append("/* platform type */");
            }
        }
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor2).getModality() != Modality.ABSTRACT) {
                StringBuilder stringBuilder3;
                if (descriptor2 instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240 = builder2;
                    boolean bl = false;
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor2).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append("contract { /* compiled contract */ }").append("; ");
                    }
                    stringBuilder3 = $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append("/* compiled code */").append(" }");
                } else {
                    stringBuilder3 = builder2.append(" ").append("/* compiled code */");
                }
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                    Name name2;
                    Object annotation32;
                    if (accessor.isDefault()) continue;
                    builder2.append('\n' + indent + "    ");
                    builder2.append(accessor.getVisibility().getInternalDisplayName()).append(" ");
                    builder2.append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(accessor.getModality().name())).append(" ");
                    if (accessor.isExternal()) {
                        builder2.append("external ");
                    }
                    for (Object annotation32 : accessor.getAnnotations()) {
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, (AnnotationDescriptor)annotation32, null, 2, null));
                        builder2.append(" ");
                    }
                    if (accessor instanceof PropertyGetterDescriptor) {
                        builder2.append("get");
                        continue;
                    }
                    if (!(accessor instanceof PropertySetterDescriptor)) continue;
                    builder2.append("set(");
                    ValueParameterDescriptor parameterDescriptor = ((PropertySetterDescriptor)accessor).getValueParameters().get(0);
                    annotation32 = parameterDescriptor.getAnnotations().iterator();
                    while (annotation32.hasNext()) {
                        AnnotationDescriptor annotation4 = (AnnotationDescriptor)annotation32.next();
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation4, null, 2, null));
                        builder2.append(" ");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)parameterDescriptor.getName(), (String)"getName(...)");
                    Name paramName = Intrinsics.areEqual((Object)name2, (Object)SpecialNames.IMPLICIT_SET_PARAMETER) ? StandardNames.DEFAULT_VALUE_PARAMETER : name2;
                    StringBuilder stringBuilder4 = builder2.append(paramName.asString()).append(": ");
                    KotlinType kotlinType = parameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    stringBuilder4.append($descriptorRenderer.renderType(kotlinType));
                    builder2.append(")");
                    builder2.append(" {").append("/* compiled code */").append(" }");
                }
            }
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
            builder2.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors2 = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors2;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (DescriptorUtils.isEnumEntry(p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries2 = (List)pair.component1();
            List members = (List)pair.component2();
            first$iv = enumEntries2.iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index2 = n++;
                Object e = first$iv.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)e;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(builder2, $descriptorRenderer, enumEntry, subindent, index2 == CollectionsKt.getLastIndex((List)enumEntries2));
            }
            ClassDescriptor companionObject2 = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
            if (companionObject2 != null) {
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, companionObject2, subindent, null, 16, null);
            }
            for (DeclarationDescriptor member2 : members) {
                if (!Intrinsics.areEqual((Object)member2.getContainingDeclaration(), (Object)descriptor2) || Intrinsics.areEqual((Object)member2, (Object)companionObject2) || member2 instanceof CallableMemberDescriptor && BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText((CallableMemberDescriptor)member2)) continue;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, member2, subindent, null, 16, null);
            }
            builder2.append(indent).append("}");
        }
        builder2.append("\n");
    }

    static /* synthetic */ void buildDecompiledText$appendDescriptor$default(StringBuilder stringBuilder2, DescriptorRenderer descriptorRenderer2, DeclarationDescriptor declarationDescriptor, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(stringBuilder2, descriptorRenderer2, declarationDescriptor, string2, bl);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

