/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.ComparableRangeToHandler;
import org.jetbrains.kotlin.backend.common.lower.FloatingPointRangeToHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.ArrayIndicesHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.CharSequenceIndicesHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.CollectionIndicesHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.DefaultProgressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.DownToHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.RangeToHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.RangeUntilHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.ReversedHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.UntilHandler;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000b0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/RangeHeaderInfoBuilder;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lkotlin/jvm/functions/Function0;)V", "progressionHandlers", "", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "getProgressionHandlers", "()Ljava/util/List;", "callHandlers", "", "getCallHandlers", "expressionHandlers", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultProgressionHandler;", "getExpressionHandlers", "ir.backend.common"})
public class RangeHeaderInfoBuilder
extends HeaderInfoBuilder {
    @NotNull
    private final List<HeaderInfoHandler<IrCall, ProgressionType>> progressionHandlers;
    @NotNull
    private final List<HeaderInfoHandler> callHandlers;
    @NotNull
    private final List<DefaultProgressionHandler> expressionHandlers;

    public RangeHeaderInfoBuilder(@NotNull CommonBackendContext context2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        super(context2, scopeOwnerSymbol, true);
        Object[] objectArray = new HeaderInfoHandler[]{new CollectionIndicesHandler(context2), new ArrayIndicesHandler(context2), new CharSequenceIndicesHandler(context2), new UntilHandler(context2), new RangeUntilHandler(context2), new DownToHandler(context2), new RangeToHandler(context2)};
        this.progressionHandlers = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new HeaderInfoHandler[]{FloatingPointRangeToHandler.INSTANCE, new ComparableRangeToHandler(context2), new ReversedHandler(context2, this)};
        this.callHandlers = CollectionsKt.listOf((Object[])objectArray);
        this.expressionHandlers = CollectionsKt.listOf((Object)new DefaultProgressionHandler(context2, true));
    }

    @Override
    @NotNull
    protected List<HeaderInfoHandler<IrCall, ProgressionType>> getProgressionHandlers() {
        return this.progressionHandlers;
    }

    @Override
    @NotNull
    protected List<HeaderInfoHandler> getCallHandlers() {
        return this.callHandlers;
    }

    @NotNull
    protected List<DefaultProgressionHandler> getExpressionHandlers() {
        return this.expressionHandlers;
    }
}

