/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.MultifileFacadesKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\f\u0010\b\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0002\u001a\f\u0010\u0011\u001a\u00020\u0004*\u0004\u0018\u00010\u0012\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"continuationParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isInvokeSuspendOfLambda", "", "isInvokeSuspendForInlineOfLambda", "isInvokeSuspendOfContinuation", "isInvokeOfSuspendCallableReference", "isBridgeToSuspendImplMethod", "isStaticInlineClassReplacementDelegatingCall", "BRIDGE_ORIGINS", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "isNonBoxingSuspendDelegation", "isStaticInlineClassReplacementForDefaultInterfaceMethod", "shouldContainSuspendMarkers", "hasContinuation", "isReadOfCrossinline", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmIrCoroutineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIrCoroutineUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmIrCoroutineUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n659#2,11:108\n1#3:119\n1247#4,2:120\n*S KotlinDebug\n*F\n+ 1 JvmIrCoroutineUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmIrCoroutineUtilsKt\n*L\n24#1:108,11\n46#1:120,2\n*E\n"})
public final class JvmIrCoroutineUtilsKt {
    @NotNull
    private static final Set<IrDeclarationOriginImpl> BRIDGE_ORIGINS;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IrValueParameter continuationParameter(@NotNull IrFunction $this$continuationParameter) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter((Object)$this$continuationParameter, (String)"<this>");
        if (JvmIrCoroutineUtilsKt.isInvokeSuspendOfLambda($this$continuationParameter) || JvmIrCoroutineUtilsKt.isInvokeSuspendForInlineOfLambda($this$continuationParameter)) {
            irValueParameter = $this$continuationParameter.getDispatchReceiverParameter();
        } else {
            Object object;
            block4: {
                void var3_3;
                Iterable $this$singleOrNull$iv = $this$continuationParameter.getValueParameters();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS())) continue;
                    if (found$iv) {
                        object = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                object = !found$iv ? null : var3_3;
            }
            irValueParameter = (IrValueParameter)object;
        }
        return irValueParameter;
    }

    public static final boolean isInvokeSuspendOfLambda(@NotNull IrFunction $this$isInvokeSuspendOfLambda) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspendOfLambda, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isInvokeSuspendOfLambda.getName().asString(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass($this$isInvokeSuspendOfLambda).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_LAMBDA());
    }

    private static final boolean isInvokeSuspendForInlineOfLambda(IrFunction $this$isInvokeSuspendForInlineOfLambda) {
        return Intrinsics.areEqual((Object)$this$isInvokeSuspendForInlineOfLambda.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE()) && Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass($this$isInvokeSuspendForInlineOfLambda).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_LAMBDA());
    }

    public static final boolean isInvokeSuspendOfContinuation(@NotNull IrFunction $this$isInvokeSuspendOfContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspendOfContinuation, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isInvokeSuspendOfContinuation.getName().asString(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass($this$isInvokeSuspendOfContinuation).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInvokeOfSuspendCallableReference(IrFunction $this$isInvokeOfSuspendCallableReference) {
        if (!AdditionalIrUtilsKt.isSuspend($this$isInvokeOfSuspendCallableReference)) return false;
        String name2 = $this$isInvokeOfSuspendCallableReference.getName().asString();
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)name2, (Object)"invoke")) {
            Intrinsics.checkNotNull((Object)name2);
            if (!StringsKt.startsWith$default((String)name2, (String)"invoke-", (boolean)false, (int)2, null)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if (!Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass($this$isInvokeOfSuspendCallableReference).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) return false;
        IrAttributeContainer irAttributeContainer = IrUtilsKt.getParentAsClass($this$isInvokeOfSuspendCallableReference).getAttributeOwnerId();
        if (!(irAttributeContainer instanceof IrFunctionReference)) return true;
        IrFunctionReference irFunctionReference = (IrFunctionReference)irAttributeContainer;
        Object object = irFunctionReference;
        if (irFunctionReference == null) return true;
        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)((IrCallableReference)object).getSymbol();
        object = irFunctionSymbol;
        if (irFunctionSymbol == null) return true;
        IrFunction irFunction = object.getOwner();
        object = irFunction;
        if (irFunction == null) return true;
        if (!((IrFunction)object).isInline()) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isBridgeToSuspendImplMethod(IrFunction $this$isBridgeToSuspendImplMethod) {
        boolean bl;
        if (!AdditionalIrUtilsKt.isSuspend($this$isBridgeToSuspendImplMethod)) return false;
        if (!($this$isBridgeToSuspendImplMethod instanceof IrSimpleFunction)) return false;
        IrDeclarationParent irDeclarationParent = $this$isBridgeToSuspendImplMethod.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        Sequence<IrSimpleFunction> sequence2 = (Sequence<IrSimpleFunction>)irDeclarationParent;
        Sequence<IrSimpleFunction> sequence3 = sequence2;
        if (sequence2 == null) return false;
        Sequence<IrSimpleFunction> sequence4 = IrUtilsKt.getFunctions((IrClass)sequence3);
        sequence3 = sequence4;
        if (sequence4 == null) return false;
        Sequence<IrSimpleFunction> $this$any$iv = sequence3;
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getName().asString(), (Object)($this$isBridgeToSuspendImplMethod.getName().asString() + "$suspendImpl")) && Intrinsics.areEqual((Object)it.getAttributeOwnerId(), (Object)((IrSimpleFunction)$this$isBridgeToSuspendImplMethod).getAttributeOwnerId())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isStaticInlineClassReplacementDelegatingCall(IrFunction $this$isStaticInlineClassReplacementDelegatingCall) {
        Object v1;
        block4: {
            if (!($this$isStaticInlineClassReplacementDelegatingCall instanceof IrAttributeContainer) || JvmIrUtilsKt.isStaticInlineClassReplacement($this$isStaticInlineClassReplacementDelegatingCall)) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = $this$isStaticInlineClassReplacementDelegatingCall.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irClass == null) {
                return false;
            }
            IrClass parentClass = irClass;
            if (!IrDeclarationsKt.isSingleFieldValueClass(parentClass)) {
                return false;
            }
            Iterable iterable = parentClass.getDeclarations();
            for (Object t : iterable) {
                IrDeclaration it = (IrDeclaration)t;
                boolean bl = false;
                if (!(it instanceof IrAttributeContainer && Intrinsics.areEqual((Object)((IrAttributeContainer)((Object)it)).getAttributeOwnerId(), (Object)((IrAttributeContainer)((Object)$this$isStaticInlineClassReplacementDelegatingCall)).getAttributeOwnerId()) && it != $this$isStaticInlineClassReplacementDelegatingCall)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        IrDeclaration irDeclaration2 = v1;
        return irDeclaration2 != null ? JvmIrUtilsKt.isStaticInlineClassReplacement(irDeclaration2) : false;
    }

    public static final boolean isNonBoxingSuspendDelegation(@NotNull IrFunction $this$isNonBoxingSuspendDelegation) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonBoxingSuspendDelegation, (String)"<this>");
        return CollectionsKt.contains((Iterable)BRIDGE_ORIGINS, (Object)$this$isNonBoxingSuspendDelegation.getOrigin()) || MultifileFacadesKt.isMultifileBridge($this$isNonBoxingSuspendDelegation) || JvmIrCoroutineUtilsKt.isBridgeToSuspendImplMethod($this$isNonBoxingSuspendDelegation) || JvmIrCoroutineUtilsKt.isStaticInlineClassReplacementForDefaultInterfaceMethod($this$isNonBoxingSuspendDelegation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStaticInlineClassReplacementForDefaultInterfaceMethod(@NotNull IrFunction $this$isStaticInlineClassReplacementForDefaultInterfaceMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isStaticInlineClassReplacementForDefaultInterfaceMethod, (String)"<this>");
        if (!JvmIrUtilsKt.isStaticInlineClassReplacement($this$isStaticInlineClassReplacementForDefaultInterfaceMethod)) return false;
        if (!($this$isStaticInlineClassReplacementForDefaultInterfaceMethod instanceof IrSimpleFunction)) return false;
        IrAttributeContainer irAttributeContainer = ((IrSimpleFunction)$this$isStaticInlineClassReplacementForDefaultInterfaceMethod).getAttributeOwnerId();
        Intrinsics.checkNotNull((Object)irAttributeContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        if (!((IrSimpleFunction)irAttributeContainer).isFakeOverride()) return false;
        return true;
    }

    public static final boolean shouldContainSuspendMarkers(@NotNull IrFunction $this$shouldContainSuspendMarkers) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainSuspendMarkers, (String)"<this>");
        return !JvmIrCoroutineUtilsKt.isNonBoxingSuspendDelegation($this$shouldContainSuspendMarkers) && !Intrinsics.areEqual((Object)$this$shouldContainSuspendMarkers.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER()) && !JvmIrCoroutineUtilsKt.isInvokeSuspendOfContinuation($this$shouldContainSuspendMarkers) && !JvmIrCoroutineUtilsKt.isInvokeOfSuspendCallableReference($this$shouldContainSuspendMarkers) && !JvmIrCoroutineUtilsKt.isStaticInlineClassReplacementDelegatingCall($this$shouldContainSuspendMarkers);
    }

    public static final boolean hasContinuation(@NotNull IrFunction $this$hasContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasContinuation, (String)"<this>");
        return JvmIrCoroutineUtilsKt.isInvokeSuspendOfLambda($this$hasContinuation) || AdditionalIrUtilsKt.isSuspend($this$hasContinuation) && JvmIrCoroutineUtilsKt.shouldContainSuspendMarkers($this$hasContinuation) && !JvmIrInlineUtilsKt.isEffectivelyInlineOnly($this$hasContinuation) && !Intrinsics.areEqual((Object)$this$hasContinuation.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getINLINE_LAMBDA()) && !Intrinsics.areEqual((Object)$this$hasContinuation.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE()) && !Intrinsics.areEqual((Object)$this$hasContinuation.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE());
    }

    public static final boolean isReadOfCrossinline(@Nullable IrExpression $this$isReadOfCrossinline) {
        boolean bl;
        IrExpression irExpression = $this$isReadOfCrossinline;
        if (irExpression instanceof IrGetValue) {
            IrValueDeclaration irValueDeclaration = ((IrGetValue)$this$isReadOfCrossinline).getSymbol().getOwner();
            IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
            bl = irValueParameter != null ? irValueParameter.isCrossinline() : false;
        } else {
            bl = irExpression instanceof IrGetField ? Intrinsics.areEqual((Object)((IrField)((IrGetField)$this$isReadOfCrossinline).getSymbol().getOwner()).getOrigin(), (Object)LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE()) : false;
        }
        return bl;
    }

    static {
        Object[] objectArray = new IrDeclarationOriginImpl[]{IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER(), JvmLoweredDeclarationOrigin.INSTANCE.getJVM_STATIC_WRAPPER(), JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER(), JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_ACCESSOR(), JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_ACCESSOR_FOR_HIDDEN_CONSTRUCTOR(), JvmLoweredDeclarationOrigin.INSTANCE.getSUPER_INTERFACE_METHOD_BRIDGE(), IrDeclarationOrigin.Companion.getBRIDGE(), IrDeclarationOrigin.Companion.getBRIDGE_SPECIAL(), IrDeclarationOrigin.Companion.getSYNTHETIC_GENERATED_SAM_IMPLEMENTATION()};
        BRIDGE_ORIGINS = SetsKt.setOf((Object[])objectArray);
    }
}

