/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleSerializer;
import org.jetbrains.kotlin.backend.konan.serialization.KonanDeclarationTable;
import org.jetbrains.kotlin.backend.konan.serialization.KonanGlobalDeclarationTable;
import org.jetbrains.kotlin.backend.konan.serialization.KonanIrFileSerializer;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\n\u0012\b\b\u0002\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrModuleSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrFileSerializer;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "normalizeAbsolutePaths", "", "sourceBaseDirs", "", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "bodiesOnlyForInlines", "skipPrivateApi", "<init>", "(Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;ZLjava/util/Collection;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;ZZ)V", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/konan/serialization/KonanGlobalDeclarationTable;", "backendSpecificFileFilter", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createSerializerForFile", "ir.serialization.native"})
public final class KonanIrModuleSerializer
extends IrModuleSerializer<KonanIrFileSerializer> {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean bodiesOnlyForInlines;
    private final boolean skipPrivateApi;
    @NotNull
    private final KonanGlobalDeclarationTable globalDeclarationTable;

    public KonanIrModuleSerializer(@NotNull IrMessageLogger messageLogger, @NotNull IrBuiltIns irBuiltIns, @NotNull CompatibilityMode compatibilityMode, boolean normalizeAbsolutePaths, @NotNull Collection<String> sourceBaseDirs, @NotNull LanguageVersionSettings languageVersionSettings2, boolean bodiesOnlyForInlines, boolean skipPrivateApi) {
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        Intrinsics.checkNotNullParameter(sourceBaseDirs, (String)"sourceBaseDirs");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        super(messageLogger, compatibilityMode, normalizeAbsolutePaths, sourceBaseDirs);
        this.languageVersionSettings = languageVersionSettings2;
        this.bodiesOnlyForInlines = bodiesOnlyForInlines;
        this.skipPrivateApi = skipPrivateApi;
        this.globalDeclarationTable = new KonanGlobalDeclarationTable(irBuiltIns);
    }

    public /* synthetic */ KonanIrModuleSerializer(IrMessageLogger irMessageLogger, IrBuiltIns irBuiltIns, CompatibilityMode compatibilityMode, boolean bl, Collection collection, LanguageVersionSettings languageVersionSettings2, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        this(irMessageLogger, irBuiltIns, compatibilityMode, bl, collection, languageVersionSettings2, bl2, bl3);
    }

    @Override
    protected boolean backendSpecificFileFilter(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !Intrinsics.areEqual((Object)file2.getFileEntry().getName(), (Object)"CTypeDefinitions");
    }

    @Override
    @NotNull
    public KonanIrFileSerializer createSerializerForFile(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        IrMessageLogger irMessageLogger = this.getMessageLogger();
        KonanDeclarationTable konanDeclarationTable = new KonanDeclarationTable(this.globalDeclarationTable);
        CompatibilityMode compatibilityMode = this.getCompatibilityMode();
        boolean bl = this.getNormalizeAbsolutePaths();
        Collection<String> collection = this.getSourceBaseDirs();
        LanguageVersionSettings languageVersionSettings2 = this.languageVersionSettings;
        boolean bl2 = this.bodiesOnlyForInlines;
        boolean bl3 = this.skipPrivateApi;
        return new KonanIrFileSerializer(irMessageLogger, (DeclarationTable)konanDeclarationTable, languageVersionSettings2, bl2, compatibilityMode, bl, collection, bl3);
    }
}

