/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics.file;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.statistics.file.PrinterKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u001f\u0010\u000e\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\fH\u0002J\u001f\u0010\u0013\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\fH\u0002J!\u0010\u0015\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\fJ1\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;", "", "out", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "indentUnit", "", "indent", "<init>", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/lang/Appendable;", "append", "", "s", "println", "strings", "", "([Ljava/lang/String;)V", "printLineSeparator", "print", "printIndent", "printWithNoIndent", "pushIndent", "popIndent", "withIndent", "T", "headLine", "fn", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Printer.kt\norg/jetbrains/kotlin/build/report/statistics/file/Printer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class Printer {
    @NotNull
    private final Appendable out;
    @NotNull
    private final String indentUnit;
    @NotNull
    private String indent;

    public Printer(@NotNull Appendable out, @NotNull String indentUnit, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indentUnit, (String)"indentUnit");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.out = out;
        this.indentUnit = indentUnit;
        this.indent = indent;
    }

    public /* synthetic */ Printer(Appendable appendable, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "  ";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(appendable, string2, string3);
    }

    private final void append(String s) {
        try {
            this.out.append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void println(String ... strings2) {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        this.print(Arrays.copyOf(strings2, strings2.length));
        this.printLineSeparator();
    }

    private final void printLineSeparator() {
        String string2 = PrinterKt.access$getLINE_SEPARATOR$p();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"access$getLINE_SEPARATOR$p(...)");
        this.append(string2);
    }

    public final void print(String ... strings2) {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        if (!(strings2.length == 0)) {
            this.printIndent();
        }
        this.printWithNoIndent(Arrays.copyOf(strings2, strings2.length));
    }

    private final void printIndent() {
        this.append(this.indent);
    }

    private final void printWithNoIndent(String ... strings2) {
        for (String s : strings2) {
            this.append(s);
        }
    }

    public final void pushIndent() {
        this.indent = this.indent + this.indentUnit;
    }

    public final void popIndent() {
        if (!(this.indent.length() >= this.indentUnit.length())) {
            boolean bl = false;
            String string2 = "No indentation to pop";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = this.indent.substring(this.indentUnit.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        this.indent = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withIndent(@Nullable String headLine, @NotNull Function0<? extends T> fn) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$withIndent = false;
        if (headLine != null) {
            stringArray = new String[]{headLine};
            this.println(stringArray);
        }
        this.pushIndent();
        try {
            stringArray = fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.popIndent();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object withIndent$default(Printer $this, String headLine, Function0 fn, int n, Object stringArray) {
        if ((n & 1) != 0) {
            headLine = null;
        }
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        boolean $i$f$withIndent = false;
        if (headLine != null) {
            stringArray = new String[]{headLine};
            $this.println(stringArray);
        }
        $this.pushIndent();
        try {
            stringArray = fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this.popIndent();
            InlineMarker.finallyEnd((int)1);
        }
        return stringArray;
    }
}

