/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.KotlinModificationTrackerService;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.cli.jvm.compiler.ClassFilterForFacade;
import org.jetbrains.kotlin.cli.jvm.compiler.CliExtraDiagnosticsProviderKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.builder.LightClassBuilderKt;
import org.jetbrains.kotlin.cli.jvm.compiler.builder.LightClassConstructionContext;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliExtraDiagnosticsProvider;", "", "<init>", "()V", "forClassOrObject", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "kclass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "forFacade", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "calculateForFacade", "cli"})
@SourceDebugExtension(value={"SMAP\nCliExtraDiagnosticsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliExtraDiagnosticsProvider.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliExtraDiagnosticsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class CliExtraDiagnosticsProvider {
    @NotNull
    public static final CliExtraDiagnosticsProvider INSTANCE = new CliExtraDiagnosticsProvider();

    private CliExtraDiagnosticsProvider() {
    }

    @NotNull
    public final Diagnostics forClassOrObject(@NotNull KtClassOrObject kclass) {
        Intrinsics.checkNotNullParameter((Object)kclass, (String)"kclass");
        if (KtLightClassForSourceDeclarationKt.shouldNotBeVisibleAsLightClass(kclass)) {
            return Diagnostics.Companion.getEMPTY();
        }
        Object t = CliExtraDiagnosticsProviderKt.access$getLightClassCachedValue(kclass).getValue();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
        return (Diagnostics)t;
    }

    @NotNull
    public final Diagnostics forFacade(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object t = CachedValuesManager.getCachedValue(file2, () -> CliExtraDiagnosticsProvider.forFacade$lambda$0(file2));
        Intrinsics.checkNotNullExpressionValue(t, (String)"getCachedValue(...)");
        return (Diagnostics)t;
    }

    private final Diagnostics calculateForFacade(KtFile file2) {
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FqName facadeFqName = JvmFileClassUtilKt.getJavaFileFacadeFqName(file2);
        KotlinAsJavaSupport kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(project2);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        Collection<KtFile> collection = kotlinAsJavaSupport.findFilesForFacade(facadeFqName, globalSearchScope);
        if (collection.isEmpty()) {
            boolean bl = false;
            return Diagnostics.Companion.getEMPTY();
        }
        Collection<KtFile> facadeCollection = collection;
        LightClassGenerationSupport lightClassGenerationSupport = LightClassGenerationSupport.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)lightClassGenerationSupport, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport");
        LightClassConstructionContext context2 = ((CliLightClassGenerationSupport)lightClassGenerationSupport).getContext();
        FqName fqName2 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
        Diagnostics diagnostics2 = LightClassBuilderKt.extraJvmDiagnosticsFromBackend(fqName2, facadeCollection, ClassFilterForFacade.INSTANCE, context2, (Function2<? super GenerationState, ? super Collection<? extends KtFile>, Unit>)((Function2)new Function2<GenerationState, Collection<? extends KtFile>, Unit>(facadeFqName){
            final /* synthetic */ FqName $facadeFqName;
            {
                this.$facadeFqName = $facadeFqName;
                super(2);
            }

            public final void invoke(GenerationState state, Collection<? extends KtFile> files2) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                KtFile representativeFile = (KtFile)CollectionsKt.first((Iterable)files2);
                JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(representativeFile);
                if (!fileClassInfo.getWithJvmMultifileClass()) {
                    PackageCodegen packageCodegen = state.getFactory().forPackage(representativeFile.getPackageFqName(), files2);
                    Intrinsics.checkNotNullExpressionValue((Object)packageCodegen, (String)"forPackage(...)");
                    PackageCodegen codegen2 = packageCodegen;
                    codegen2.generate();
                    state.getFactory().done();
                    return;
                }
                MultifileClassCodegen multifileClassCodegen = state.getFactory().forMultifileClass(this.$facadeFqName, files2);
                Intrinsics.checkNotNullExpressionValue((Object)multifileClassCodegen, (String)"forMultifileClass(...)");
                MultifileClassCodegen codegen3 = multifileClassCodegen;
                codegen3.generate();
                state.getFactory().done();
            }
        })).component3();
        return diagnostics2;
    }

    private static final CachedValueProvider.Result forFacade$lambda$0(KtFile $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Diagnostics diagnostics2 = INSTANCE.calculateForFacade($file);
        Object[] objectArray = new Object[1];
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = KotlinModificationTrackerService.Companion.getInstance(project).getOutOfBlockModificationTracker();
        return CachedValueProvider.Result.create(diagnostics2, objectArray);
    }
}

