/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0017J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/descriptors/annotations/TargetedAnnotations;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "standardAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "targetedAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationWithTarget;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "isEmpty", "", "getUseSiteTargetedAnnotations", "iterator", "", "toString", "", "frontend"})
public final class TargetedAnnotations
implements Annotations {
    @NotNull
    private final List<AnnotationDescriptor> standardAnnotations;
    @NotNull
    private final List<AnnotationWithTarget> targetedAnnotations;

    public TargetedAnnotations(@NotNull List<? extends AnnotationDescriptor> standardAnnotations, @NotNull List<AnnotationWithTarget> targetedAnnotations) {
        Intrinsics.checkNotNullParameter(standardAnnotations, (String)"standardAnnotations");
        Intrinsics.checkNotNullParameter(targetedAnnotations, (String)"targetedAnnotations");
        this.standardAnnotations = standardAnnotations;
        this.targetedAnnotations = targetedAnnotations;
    }

    @Override
    public boolean isEmpty() {
        return this.standardAnnotations.isEmpty() && this.targetedAnnotations.isEmpty();
    }

    @Override
    @Deprecated(message="This method should only be used in frontend where we split annotations according to their use-site targets.")
    @NotNull
    public List<AnnotationWithTarget> getUseSiteTargetedAnnotations() {
        return this.targetedAnnotations;
    }

    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        return this.standardAnnotations.iterator();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.plus((Collection)this.standardAnnotations, (Iterable)this.targetedAnnotations).toString();
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        return Annotations.DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean hasAnnotation(@NotNull FqName fqName2) {
        return Annotations.DefaultImpls.hasAnnotation(this, fqName2);
    }
}

