/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!*\u00020#2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010$\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0018\u0010\u0017\u001a\u00020\u0005*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "<init>", "()V", "isNativeOrEffectivelyExternal", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reportExternalEnum", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "additionalCheck", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "hasExternalLikeAnnotations", "allowsReporting", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "varargElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "superInterfaces", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "checkEnumEntry", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,157:1\n1601#2,9:158\n1853#2:167\n1854#2:169\n1610#2:170\n1745#2,3:171\n817#2:175\n845#2,2:176\n764#2:178\n855#2,2:179\n1#3:168\n43#4:174\n*S KotlinDebug\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n*L\n52#1:158,9\n52#1:167\n52#1:169\n52#1:170\n53#1:171,3\n145#1:175\n145#1:176,2\n146#1:178\n146#1:179,2\n52#1:168\n58#1:174\n*E\n"})
public final class FirJsExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirJsHelpersKt.isNativeObject(symbol2, session2);
    }

    @Override
    public void reportExternalEnum(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), (DiagnosticContext)context2, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void additionalCheck(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirClass && ((FirClass)declaration).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block11: {
                void $this$mapNotNullTo$iv$iv;
                List superClasses2 = CollectionsKt.toMutableList((Collection)this.superInterfaces((FirClass)declaration, context2.getSession()));
                ConeClassLikeType coneClassLikeType = FirJsHelpersKt.superClassNotAny((FirClass)declaration, context2.getSession());
                if (coneClassLikeType != null) {
                    ConeClassLikeType it = coneClassLikeType;
                    boolean bl2 = false;
                    superClasses2.add(it);
                }
                if (((FirClass)declaration).getClassKind() == ClassKind.ENUM_CLASS || ((FirClass)declaration).getClassKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll((List)superClasses2, (Function1)additionalCheck.2.INSTANCE);
                }
                Iterable $this$mapNotNull$iv = superClasses2;
                boolean $i$f$mapNotNull = false;
                Iterable bl2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirClassLikeSymbol<?> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    if (TypeUtilsKt.toSymbol(it, context2.getSession()) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superDeclarations = (List)destination$iv$iv;
                Iterable $this$any$iv = superDeclarations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirClassLikeSymbol it = (FirClassLikeSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirJsHelpersKt.isNativeObject((FirBasedSymbol)it, context2) && !Intrinsics.areEqual((Object)it.getClassId().asSingleFqName(), (Object)StandardNames.FqNames.throwable))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration, reporter, context2, valueClassInExternalDiagnostic, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(context2){
            final /* synthetic */ CheckerContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FirHelpersKt.isValueClass(it, this.$context.getSession());
            }
        }));
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration, reporter, context2, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), (Function1<? super ConeKotlinType, Boolean>)((Function1)additionalCheck.5.INSTANCE));
        }
        this.checkEnumEntry(declaration, context2, reporter);
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return JsStandardClassIds.Callables.definedExternallyPropertyNames.contains(callableId);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsNative, session2);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual((Object)$this$allowsReporting.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeClassLikeType> superInterfaces(FirClass $this$superInterfaces, FirSession session2) {
        void $this$filterTo$iv$iv;
        ConeClassLikeType it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = FirDeclarationUtilKt.getSuperConeTypes($this$superInterfaces);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            if (ConeBuiltinTypeUtilsKt.isAny(it) || ConeBuiltinTypeUtilsKt.isNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(it, session2);
            if (!((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkEnumEntry(FirDeclaration $this$checkEnumEntry, CheckerContext context2, DiagnosticReporter reporter) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression2 = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression2 == null) break block1;
            FirExpression it = firExpression2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, CheckerContext $context, ConeKotlinType type2, KtSourceElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type2)).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, DiagnosticReporter $reporter, CheckerContext $context, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl2 = false;
                FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter2 : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = parameter2.getSource();
            KtSourceElement ktSourceElement4 = ktParam = (ktSourceElement3 != null ? KtSourceElementKt.getPsi(ktSourceElement3) : null) instanceof KtParameter ? parameter2.getSource() : ((FirFunction)$declaration).getSource();
            boolean bl3 = ktSourceElement4 != null ? INSTANCE.getAllowsReporting(ktSourceElement4) : false;
            if (!bl3) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter2);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, typeToCheck, ktParam);
        }
    }
}

