/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeObjCNameOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCNameOverridesChecker INSTANCE = new FirNativeObjCNameOverridesChecker();

    private FirNativeObjCNameOverridesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(firTypeScope, declaration, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirNamedFunctionSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                if (!ClassMembersKt.isIntersectionOverride(symbol2)) {
                    return;
                }
                FirNativeObjCNameUtilities.INSTANCE.checkCallableMember(this.$firTypeScope, symbol2, this.$declaration, this.$context, this.$reporter);
            }
        }));
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, (Function1)new Function1<FirVariableSymbol<?>, Unit>(firTypeScope, declaration, context2, reporter){
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.$firTypeScope = $firTypeScope;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(FirVariableSymbol<?> symbol2) {
                Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                if (!ClassMembersKt.isIntersectionOverride((FirCallableSymbol)symbol2)) {
                    return;
                }
                FirNativeObjCNameUtilities.INSTANCE.checkCallableMember(this.$firTypeScope, (FirCallableSymbol)symbol2, this.$declaration, this.$context, this.$reporter);
            }
        });
    }
}

