/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCOverrideInitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCOverrideInitChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n37#2:91\n1724#3,3:92\n764#3:95\n855#3,2:96\n1853#3,2:98\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCOverrideInitChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOverrideInitChecker\n*L\n85#1:91\n34#1:92,3\n41#1:95\n41#1:96,2\n66#1:98,2\n*E\n"})
public final class FirNativeObjCOverrideInitChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOverrideInitChecker INSTANCE = new FirNativeObjCOverrideInitChecker();

    private FirNativeObjCOverrideInitChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session2 = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration.getSymbol(), context2.getSession())) {
            FirNativeObjCOverrideInitChecker.check$checkKotlinObjCClass(session2, reporter, context2, declaration);
        }
    }

    private static final boolean check$overridesConstructor(FirConstructor $this$check_u24overridesConstructor, FirConstructor other) {
        boolean bl;
        block4: {
            if ($this$check_u24overridesConstructor.getValueParameters().size() != other.getValueParameters().size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)$this$check_u24overridesConstructor.getValueParameters(), (Iterable)other.getValueParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    FirValueParameter thisParameter = (FirValueParameter)pair.component1();
                    FirValueParameter otherParameter = (FirValueParameter)pair.component2();
                    if (Intrinsics.areEqual((Object)thisParameter.getName(), (Object)otherParameter.getName()) && Intrinsics.areEqual((Object)FirTypeUtilsKt.getConeType(thisParameter.getReturnTypeRef()), (Object)FirTypeUtilsKt.getConeType(otherParameter.getReturnTypeRef()))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$checkCanGenerateOverrideInit(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass, FirConstructor constructor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)firClass, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        FirRegularClassSymbol superClass = SupertypeUtilsKt.getSuperClassSymbolOrAny(((FirRegularClass)firClass).getSymbol(), session2);
        Iterable $this$filter$iv = DeclarationUtilsKt.constructors((FirClass)superClass.getFir(), session2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirConstructorSymbol it = (FirConstructorSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirNativeObjCOverrideInitChecker.check$overridesConstructor(constructor2, (FirConstructor)it.getFir())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superConstructors = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        FirConstructorSymbol firConstructorSymbol2 = (FirConstructorSymbol)CollectionsKt.singleOrNull((List)superConstructors);
        if (firConstructorSymbol2 == null) {
            FirNativeObjCOverrideInitChecker $this$check_u24checkCanGenerateOverrideInit_u24lambda_u242 = INSTANCE;
            boolean bl = false;
            if (superConstructors.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_DOES_NOT_OVERRIDE_ANY_SUPER_CONSTRUCTOR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_MATCHES_SEVERAL_SUPER_CONSTRUCTORS(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            }
            return;
        }
        FirConstructorSymbol superConstructor = firConstructorSymbol2;
        FirFunction firFunction = FirObjCInteropKt.getObjCInitMethod((FirConstructor)superConstructor.getFir(), session2, new ScopeSession());
        Intrinsics.checkNotNull((Object)firFunction);
        FirFunction initMethod = firFunction;
        Iterable $this$forEach$iv = ((FirRegularClass)firClass).getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirSimpleFunction) || !FirHelpersKt.getOverriddenSymbols((FirCallableDeclaration)it, $context).contains(initMethod.getSymbol()) || ClassMembersKt.isSubstitutionOrIntersectionOverride((FirCallableDeclaration)it)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)constructor2.getSource(), FirNativeErrors.INSTANCE.getCONSTRUCTOR_OVERRIDES_ALREADY_OVERRIDDEN_OBJC_INITIALIZER(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
        }
    }

    private static final void check$checkKotlinObjCClass(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirConstructor) || !FirAnnotationUtilsKt.hasAnnotation(((FirConstructor)decl).getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCOverrideInitClassId(), session2)) continue;
            FirNativeObjCOverrideInitChecker.check$checkCanGenerateOverrideInit(session2, $reporter, $context, firClass, (FirConstructor)decl);
        }
    }
}

