/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000e\"\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\"\u0016\u0010\u0015\u001a\u00020\u0016*\u00020\u00178\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018\"\u0016\u0010\u0019\u001a\u00020\u0016*\u00020\u00178\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\"\u0016\u0010\u001a\u001a\u00020\u0016*\u00020\u00178\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\"\u0016\u0010\u001b\u001a\u00020\u0016*\u00020\u00178\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018\"\u0015\u0010\u001c\u001a\u00020\u0016*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\"\u0015\u0010\u001d\u001a\u00020\u0016*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\"\u0015\u0010 \u001a\u00020!*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0015\u0010%\u001a\u00020\u0016*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'\"\u0015\u0010(\u001a\u00020\u0016*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*\u00a8\u0006+"}, d2={"expandedConeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "getExpandedConeType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassId", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/name/ClassId;", "superConeTypes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getSuperConeTypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "anonymousInitializers", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "getAnonymousInitializers", "delegateFields", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "getDelegateFields", "isJava", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isFromLibrary", "isPrecompiled", "isSynthetic", "isNonLocal", "isExtension", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "nameOrSpecialName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "getNameOrSpecialName", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Lorg/jetbrains/kotlin/name/Name;", "isMethodOfAny", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "isErrorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Z", "tree"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n38#1:114\n25#2:75\n25#2:86\n1601#3,9:76\n1853#3:85\n1854#3:88\n1610#3:89\n798#3,11:90\n798#3,11:101\n764#3:112\n855#3:113\n856#3:115\n1#4:87\n*S KotlinDebug\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n29#1:114\n18#1:75\n23#1:86\n23#1:76,9\n23#1:85\n23#1:88\n23#1:89\n26#1:90,11\n29#1:101,11\n29#1:112\n29#1:113\n29#1:115\n23#1:87\n*E\n"})
public final class FirDeclarationUtilKt {
    @Nullable
    public static final ConeClassLikeType getExpandedConeType(@NotNull FirTypeAlias $this$expandedConeType) {
        Intrinsics.checkNotNullParameter((Object)$this$expandedConeType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$expandedConeType.getExpandedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClassLikeDeclaration $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        return $this$classId.getSymbol().getClassId();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClass $this$superConeTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$superConeTypes, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$superConeTypes.getSuperTypeRefs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConeClassLikeType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = it;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnonymousInitializer> getAnonymousInitializers(@NotNull FirClass $this$anonymousInitializers) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymousInitializers, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$anonymousInitializers.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirField> getDelegateFields(@NotNull FirClass $this$delegateFields) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$delegateFields, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$delegateFields.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirField it = (FirField)element$iv$iv;
            boolean bl = false;
            FirDeclaration $this$isSynthetic$iv = it;
            boolean $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isJava(@NotNull FirDeclaration $this$isJava) {
        Intrinsics.checkNotNullParameter((Object)$this$isJava, (String)"<this>");
        boolean $i$f$isJava = false;
        return $this$isJava.getOrigin() instanceof FirDeclarationOrigin.Java;
    }

    public static final boolean isFromLibrary(@NotNull FirDeclaration $this$isFromLibrary) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromLibrary, (String)"<this>");
        boolean $i$f$isFromLibrary = false;
        return Intrinsics.areEqual((Object)$this$isFromLibrary.getOrigin(), (Object)FirDeclarationOrigin.Library.INSTANCE) || Intrinsics.areEqual((Object)$this$isFromLibrary.getOrigin(), (Object)FirDeclarationOrigin.Java.Library.INSTANCE);
    }

    public static final boolean isPrecompiled(@NotNull FirDeclaration $this$isPrecompiled) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrecompiled, (String)"<this>");
        boolean $i$f$isPrecompiled = false;
        return Intrinsics.areEqual((Object)$this$isPrecompiled.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE);
    }

    public static final boolean isSynthetic(@NotNull FirDeclaration $this$isSynthetic) {
        Intrinsics.checkNotNullParameter((Object)$this$isSynthetic, (String)"<this>");
        boolean $i$f$isSynthetic = false;
        return $this$isSynthetic.getOrigin() instanceof FirDeclarationOrigin.Synthetic;
    }

    public static final boolean isNonLocal(@NotNull FirDeclaration $this$isNonLocal) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonLocal, (String)"<this>");
        FirDeclaration firDeclaration = $this$isNonLocal;
        return firDeclaration instanceof FirFile ? true : (firDeclaration instanceof FirCallableDeclaration ? !((FirCallableDeclaration)$this$isNonLocal).getSymbol().getCallableId().isLocal() : (firDeclaration instanceof FirClassLikeDeclaration ? !((FirClassLikeDeclaration)$this$isNonLocal).getSymbol().getClassId().isLocal() : false));
    }

    public static final boolean isExtension(@NotNull FirCallableDeclaration $this$isExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtension, (String)"<this>");
        return $this$isExtension.getReceiverParameter() != null;
    }

    @NotNull
    public static final Name getNameOrSpecialName(@NotNull FirMemberDeclaration $this$nameOrSpecialName) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)$this$nameOrSpecialName, (String)"<this>");
        FirMemberDeclaration firMemberDeclaration = $this$nameOrSpecialName;
        if (firMemberDeclaration instanceof FirCallableDeclaration) {
            name2 = ((FirCallableDeclaration)$this$nameOrSpecialName).getSymbol().getCallableId().getCallableName();
        } else if (firMemberDeclaration instanceof FirClass) {
            name2 = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)$this$nameOrSpecialName).getShortClassName();
        } else if (firMemberDeclaration instanceof FirTypeAlias) {
            name2 = ((FirTypeAlias)$this$nameOrSpecialName).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name2;
    }

    public static final boolean isMethodOfAny(@NotNull FirNamedFunctionSymbol $this$isMethodOfAny) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isMethodOfAny, (String)"<this>");
        if ($this$isMethodOfAny.getReceiverParameter() != null) {
            return false;
        }
        if (!((Collection)$this$isMethodOfAny.getResolvedContextReceivers()).isEmpty()) {
            return false;
        }
        Name name2 = $this$isMethodOfAny.getName();
        return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS) ? ((object = (FirValueParameterSymbol)CollectionsKt.singleOrNull($this$isMethodOfAny.getValueParameterSymbols())) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null ? ConeBuiltinTypeUtilsKt.isNullableAny((ConeKotlinType)object) : false) : (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.HASH_CODE) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TO_STRING) ? ((FirSimpleFunction)$this$isMethodOfAny.getFir()).getValueParameters().isEmpty() : false);
    }

    public static final boolean isErrorPrimaryConstructor(@NotNull FirConstructorSymbol $this$isErrorPrimaryConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isErrorPrimaryConstructor, (String)"<this>");
        return $this$isErrorPrimaryConstructor.getFir() instanceof FirErrorPrimaryConstructor;
    }
}

