/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SwitchOptimizer;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u0003H\u0016J.\u0010\u001f\u001a\u00020\u0002*\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0018\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"\u0012\u0004\u0012\u00020\u00020!H\u0002J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020)2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002012\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u0002082\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010<\u001a\u00020\u00022\u0006\u0010:\u001a\u00020=2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "context", "visitBlock", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "wrapInCommentsInlineFunctionCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "maybeOptimizeIntoSwitch", "transformer", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitDoWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrElementToJsStatementTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1547#2:248\n1618#2,3:249\n1547#2:252\n1618#2,3:253\n1547#2:256\n1618#2,3:257\n1#3:260\n*S KotlinDebug\n*F\n+ 1 IrElementToJsStatementTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer\n*L\n40#1:248\n40#1:249,3\n49#1:252\n49#1:253,3\n77#1:256\n77#1:257,3\n*E\n"})
public final class IrElementToJsStatementTransformer
implements BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @Override
    @NotNull
    public JsStatement visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        throw new IllegalStateException("All functions must be already lowered".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext context2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable $this$map$iv = body2.getStatements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it.accept(this, context2));
        }
        List<JsStatement> list2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(list2), body2, context2, null, context2.getCurrentFunction(), 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context2) {
        JsNode jsNode;
        void $this$mapTo$iv$iv;
        Object it;
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                object = expression2 instanceof IrReturnableBlock ? (IrReturnableBlock)expression2 : null;
                if (object == null || (object = IrInlineUtilsKt.getInlineFunction((IrReturnableBlock)object)) == null) break block6;
                it = object;
                boolean bl = false;
                JsGenerationContext jsGenerationContext = context2.newFile(IrUtilsKt.getFile((IrDeclaration)it), context2.getCurrentFunction(), context2.getLocalNames());
                object = jsGenerationContext;
                if (jsGenerationContext != null) break block7;
            }
            object = context2;
        }
        Object newContext = object;
        List<IrStatement> container = IrInlineUtilsKt.getInnerInlinedBlockOrThis(expression2).getStatements();
        Iterable $this$map$iv = container;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsStatement)it2.accept(this, newContext));
        }
        List<JsStatement> statements2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
        if (expression2 instanceof IrReturnableBlock) {
            JsName label = context2.getNameForReturnableBlock((IrReturnableBlock)expression2);
            List<JsStatement> wrappedStatements = this.wrapInCommentsInlineFunctionCall(statements2, (IrReturnableBlock)expression2);
            jsNode = label != null ? (JsNode)new JsLabel(label, new JsBlock(wrappedStatements)) : (JsNode)new JsCompositeBlock((List<? extends JsStatement>)wrappedStatements);
        } else {
            jsNode = new JsBlock(statements2);
        }
        return (JsStatement)JsAstUtilsKt.withSource$default(jsNode, expression2, context2, null, null, 12, null);
    }

    private final List<JsStatement> wrapInCommentsInlineFunctionCall(List<? extends JsStatement> $this$wrapInCommentsInlineFunctionCall, IrReturnableBlock expression2) {
        IrElement owner;
        IrFunction irFunction = IrInlineUtilsKt.getInlineFunction(expression2);
        if (irFunction == null) {
            return $this$wrapInCommentsInlineFunctionCall;
        }
        IrFunction inlineFunction2 = irFunction;
        IrSimpleFunction irSimpleFunction = inlineFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)inlineFunction2 : null;
        IrPropertySymbol correspondingProperty2 = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        Object object = correspondingProperty2;
        IrElement irElement = owner = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)inlineFunction2;
        Object object2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)owner);
        if (object2 == null) {
            object2 = ((IrPossiblyExternalDeclaration)owner).getName();
        }
        FqName funName = object2;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new JsSingleLineComment(" Inline function '" + funName + "' call")), (Iterable)$this$wrapInCommentsInlineFunctionCall);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context2) {
        JsNode jsNode;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (expression2.getStatements().isEmpty()) {
            jsNode = JsEmpty.INSTANCE;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expression2.getStatements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrStatement irStatement = (IrStatement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((JsStatement)it.accept(this, context2));
            }
            List<JsStatement> list2 = MemoryOptimizedCollectionUtilKt.toSmartList((List)destination$iv$iv);
            jsNode = JsAstUtilsKt.withSource$default(new JsBlock(list2), expression2, context2, null, null, 12, null);
        }
        return (JsStatement)jsNode;
    }

    @Override
    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsStatement jsStatement = ((JsFunction)expression2.getFunction().accept(new IrFunctionToJsTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsBreak(jsNameRef2), jump, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context2) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName jsName = context2.getNameForLoop(jump.getLoop());
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsNameRef = new JsNameRef(it);
        } else {
            jsNameRef = null;
        }
        JsNameRef jsNameRef2 = jsNameRef;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsContinue(jsNameRef2), jump, context2, null, null, 12, null);
    }

    private final JsStatement maybeOptimizeIntoSwitch(IrExpression $this$maybeOptimizeIntoSwitch, JsGenerationContext context2, Function1<? super Function0<? extends JsExpression>, ? extends JsStatement> transformer2) {
        Function1 stmtTransformer2;
        JsStatement jsStatement;
        if ($this$maybeOptimizeIntoSwitch instanceof IrWhen && (jsStatement = new SwitchOptimizer(context2, true, (Function1<? super Function0<? extends JsStatement>, ? extends JsStatement>)(stmtTransformer2 = (Function1)new Function1<Function0<? extends JsStatement>, JsStatement>(transformer2, $this$maybeOptimizeIntoSwitch){
            final /* synthetic */ Function1<Function0<? extends JsExpression>, JsStatement> $transformer;
            final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
            {
                this.$transformer = $transformer;
                this.$this_maybeOptimizeIntoSwitch = $receiver;
                super(1);
            }

            public final JsStatement invoke(Function0<? extends JsStatement> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (JsStatement)this.$transformer.invoke((Object)new Function0<JsExpression>(it, this.$this_maybeOptimizeIntoSwitch){
                    final /* synthetic */ Function0<JsStatement> $it;
                    final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
                    {
                        this.$it = $it;
                        this.$this_maybeOptimizeIntoSwitch = $receiver;
                        super(0);
                    }

                    public final JsExpression invoke() {
                        JsStatement stmt = (JsStatement)this.$it.invoke();
                        boolean bl = stmt instanceof JsExpressionStatement;
                        IrExpression irExpression = this.$this_maybeOptimizeIntoSwitch;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl2 = false;
                            String string2 = RenderIrElementKt.render$default(irExpression, null, 1, null) + " is not a statement " + stmt;
                            throw new AssertionError((Object)string2);
                        }
                        Intrinsics.checkNotNull((Object)stmt, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
                        JsExpression jsExpression = ((JsExpressionStatement)stmt).getExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                        return jsExpression;
                    }
                });
            }
        })).tryOptimize((IrWhen)$this$maybeOptimizeIntoSwitch)) != null) {
            JsStatement it = jsStatement;
            boolean bl = false;
            return it;
        }
        return (JsStatement)transformer2.invoke((Object)new Function0<JsExpression>($this$maybeOptimizeIntoSwitch, context2){
            final /* synthetic */ IrExpression $this_maybeOptimizeIntoSwitch;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$this_maybeOptimizeIntoSwitch = $receiver;
                this.$context = $context;
                super(0);
            }

            public final JsExpression invoke() {
                return (JsExpression)this.$this_maybeOptimizeIntoSwitch.accept(new IrElementToJsExpressionTransformer(), this.$context);
            }
        });
    }

    @Override
    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName fieldName = context2.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrElementToJsExpressionTransformer expressionTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(fieldName, irExpression != null ? (JsExpression)irExpression.accept(expressionTransformer, context2) : null);
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)new Function1<Function0<? extends JsExpression>, JsStatement>(dest, expression2, context2){
            final /* synthetic */ JsExpression $dest;
            final /* synthetic */ IrSetField $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$dest = $dest;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            public final JsStatement invoke(Function0<? extends JsExpression> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(this.$dest, (JsExpression)it.invoke()), this.$expression, this.$context, null, null, 12, null)).makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
                return jsStatement;
            }
        }));
    }

    @Override
    @NotNull
    public JsStatement visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context2.getNameForValueDeclaration(owner));
        return this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)new Function1<Function0<? extends JsExpression>, JsStatement>(ref, expression2, context2){
            final /* synthetic */ JsNameRef $ref;
            final /* synthetic */ IrSetValue $expression;
            final /* synthetic */ JsGenerationContext $context;
            {
                this.$ref = $ref;
                this.$expression = $expression;
                this.$context = $context;
                super(1);
            }

            public final JsStatement invoke(Function0<? extends JsExpression> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                JsStatement jsStatement = ((JsBinaryOperation)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(this.$ref, (JsExpression)it.invoke()), this.$expression, this.$context, null, null, 12, null)).makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
                return jsStatement;
            }
        }));
    }

    @Override
    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context2) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrReturnTargetSymbol targetSymbol = expression2.getReturnTargetSymbol();
        if (targetSymbol instanceof IrReturnableBlockSymbol) {
            function1 = (Function1)new Function1<Function0<? extends JsExpression>, JsStatement>(context2, targetSymbol, expression2){
                final /* synthetic */ JsGenerationContext $context;
                final /* synthetic */ IrReturnTargetSymbol $targetSymbol;
                final /* synthetic */ IrReturn $expression;
                {
                    this.$context = $context;
                    this.$targetSymbol = $targetSymbol;
                    this.$expression = $expression;
                    super(1);
                }

                public final JsStatement invoke(Function0<? extends JsExpression> it) {
                    JsStatement jsStatement;
                    JsName jsName;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    JsName jsName2 = this.$context.getNameForReturnableBlock((IrReturnableBlock)((IrReturnableBlockSymbol)this.$targetSymbol).getOwner());
                    IrReturn irReturn = this.$expression;
                    IrReturnTargetSymbol irReturnTargetSymbol = this.$targetSymbol;
                    JsName it2 = jsName2;
                    boolean bl = false;
                    JsName jsName3 = jsName = !IrJsUtilsKt.isTheLastReturnStatementIn(irReturn, (IrReturnableBlockSymbol)irReturnTargetSymbol) ? jsName2 : null;
                    if (jsName != null) {
                        JsName $this$invoke_u24lambda_u241 = jsName;
                        boolean bl2 = false;
                        jsStatement = new JsBreak($this$invoke_u24lambda_u241.makeRef());
                    } else {
                        jsStatement = JsEmpty.INSTANCE;
                    }
                    return jsStatement;
                }
            };
        } else if (targetSymbol instanceof IrFunctionSymbol) {
            function1 = visitReturn.lastStatementTransformer.2.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function1 lastStatementTransformer2 = function1;
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)lastStatementTransformer2), expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return (JsStatement)JsAstUtilsKt.withSource$default(this.maybeOptimizeIntoSwitch(expression2.getValue(), context2, (Function1<? super Function0<? extends JsExpression>, ? extends JsStatement>)((Function1)visitThrow.1.INSTANCE)), expression2, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext context2) {
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName varName = context2.getNameForValueDeclaration(declaration);
        IrExpression value2 = declaration.getInitializer();
        if (value2 instanceof IrWhen) {
            JsNameRef jsNameRef = varName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            JsNameRef varRef = jsNameRef;
            Function1 transformer2 = (Function1)new Function1<Function0<? extends JsStatement>, JsStatement>(varRef){
                final /* synthetic */ JsNameRef $varRef;
                {
                    this.$varRef = $varRef;
                    super(1);
                }

                public final JsStatement invoke(Function0<? extends JsStatement> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Object object = it.invoke();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement");
                    JsExpression jsExpression = ((JsExpressionStatement)object).getExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                    JsExpression expr = jsExpression;
                    return new JsBinaryOperation(JsBinaryOperator.ASG, this.$varRef, expr).makeStmt();
                }
            };
            object = new SwitchOptimizer(context2, true, (Function1<? super Function0<? extends JsStatement>, ? extends JsStatement>)transformer2).tryOptimize((IrWhen)value2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                JsStatement[] jsStatementArray = new JsStatement[]{new JsVars(new JsVars.JsVar(varName)), it};
                return (JsStatement)JsAstUtilsKt.withSource$default(new JsBlock(jsStatementArray), declaration, context2, null, null, 12, null);
            }
        }
        IrExpression irExpression = value2;
        JsExpression jsInitializer = irExpression != null ? (JsExpression)irExpression.accept(new IrElementToJsExpressionTransformer(), context2) : null;
        object = declaration.getOrigin();
        boolean syntheticVariable = Intrinsics.areEqual((Object)object, (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) ? true : (Intrinsics.areEqual((Object)object, (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE_FOR_INLINED_PARAMETER()) ? true : (Intrinsics.areEqual((Object)object, (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE_FOR_INLINED_EXTENSION_RECEIVER()) ? true : Intrinsics.areEqual((Object)object, (Object)ES6ConstructorLoweringKt.getES6_DELEGATING_CONSTRUCTOR_CALL_REPLACEMENT())));
        JsVars.JsVar $this$visitVariable_u24lambda_u248 = sourceInfoAwareJsNode = new JsVars.JsVar(varName, jsInitializer);
        boolean bl = false;
        JsAstUtilsKt.withSource$default($this$visitVariable_u24lambda_u248, declaration, context2, declaration, null, 8, null);
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u248, syntheticVariable);
        JsVars.JsVar variable2 = sourceInfoAwareJsNode;
        SourceInfoAwareJsNode $this$visitVariable_u24lambda_u249 = sourceInfoAwareJsNode = new JsVars(variable2);
        boolean bl2 = false;
        MetadataProperties.setSynthetic($this$visitVariable_u24lambda_u249, syntheticVariable);
        return (JsStatement)((Object)sourceInfoAwareJsNode);
    }

    @Override
    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getConstructedClassType((IrConstructor)expression2.getSymbol().getOwner()))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context2)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (IrJsUtilsKt.isUnitInstanceFunction(expression2.getSymbol(), data2.getStaticContext().getBackendContext())) {
            return JsEmpty.INSTANCE;
        }
        if (data2.checkIfJsCode(expression2.getSymbol()) || data2.checkIfHasAssociatedJsCode(expression2.getSymbol())) {
            return new JsCallTransformer(expression2, data2).generateStatement();
        }
        JsStatement jsStatement = ((JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.translateCall(expression2, data2, new IrElementToJsExpressionTransformer()), expression2, data2, null, null, 12, null)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context2) {
        JsCatch jsCatch;
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept(this, context2));
        IrCatch irCatch = (IrCatch)CollectionsKt.singleOrNull(aTry.getCatches());
        if (irCatch != null) {
            IrCatch it = irCatch;
            boolean bl = false;
            JsName name2 = context2.getNameForValueDeclaration(it.getCatchParameter());
            JsStatement jsCatchBlock = (JsStatement)it.getResult().accept(this, context2);
            jsCatch = (JsCatch)JsAstUtilsKt.withSource$default(new JsCatch(JsGenerationContextKt.getEmptyScope(), name2.getIdent(), jsCatchBlock), it, context2, null, null, 12, null);
        } else {
            jsCatch = null;
        }
        JsCatch jsCatch2 = jsCatch;
        Object object = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = object != null && (object = (JsStatement)object.accept(this, context2)) != null ? JsAstUtilsKt.asBlock((JsStatement)object) : null;
        return (JsStatement)JsAstUtilsKt.withSource$default(new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock), aTry, context2, null, null, 12, null);
    }

    @Override
    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsStatement jsStatement = new SwitchOptimizer(context2).tryOptimize(expression2);
        if (jsStatement == null && (jsStatement = (JsStatement)JsAstUtilsKt.toJsNode$default(expression2, this, context2, visitWhen.1.INSTANCE, null, 8, null)) == null) {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName label = context2.getNameForLoop(loop2);
        JsExpression jsExpression = (JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2);
        Object object = loop2.getBody();
        if (object == null || (object = (JsStatement)object.accept(this, context2)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsWhile loopStatement = new JsWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext context2) {
        JsStatement jsStatement;
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName label = context2.getNameForLoop(loop2);
        JsExpression jsExpression = (JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context2);
        Object object = loop2.getBody();
        if (object == null || (object = (JsStatement)object.accept(this, context2)) == null) {
            object = JsEmpty.INSTANCE;
        }
        JsDoWhile loopStatement = new JsDoWhile(jsExpression, (JsStatement)object);
        JsName jsName = label;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitField(@NotNull IrField declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitProperty(@NotNull IrProperty declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitScript(@NotNull IrScript declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFile(@NotNull IrFile declaration, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConst(@NotNull IrConst<?> expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantValue(@NotNull IrConstantValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantObject(@NotNull IrConstantObject expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitConstantArray(@NotNull IrConstantArray expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    @NotNull
    public JsStatement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public JsStatement visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public JsStatement visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data2) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
    }
}

