/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.DataClassArrayToString;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/DataClassArrayToString;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "<init>", "()V", "getListOfAcceptableFunctions", "", "", "arrayToString", "array", "", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
public final class DataClassArrayToString
extends IntrinsicBase {
    @NotNull
    public static final DataClassArrayToString INSTANCE = new DataClassArrayToString();

    private DataClassArrayToString() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.internal.ir.dataClassArrayMemberToString");
    }

    private final String arrayToString(Object array) {
        String string2;
        Object object = array;
        if (object == null) {
            string2 = "null";
        } else if (object instanceof Object[]) {
            String string3 = Arrays.toString((Object[])array);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else if (object instanceof byte[]) {
            String string4 = Arrays.toString((byte[])array);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        } else if (object instanceof short[]) {
            String string5 = Arrays.toString((short[])array);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        } else if (object instanceof int[]) {
            String string6 = Arrays.toString((int[])array);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        } else if (object instanceof long[]) {
            String string7 = Arrays.toString((long[])array);
            string2 = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        } else if (object instanceof char[]) {
            String string8 = Arrays.toString((char[])array);
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        } else if (object instanceof boolean[]) {
            String string9 = Arrays.toString((boolean[])array);
            string2 = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(...)");
        } else if (object instanceof float[]) {
            String string10 = Arrays.toString((float[])array);
            string2 = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(...)");
        } else if (object instanceof double[]) {
            String string11 = Arrays.toString((double[])array);
            string2 = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(...)");
        } else {
            ExceptionUtilsKt.stop((Function0<? extends Object>)((Function0)arrayToString.1.INSTANCE));
            throw null;
        }
        return string2;
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        State state = environment.getCallStack$ir_interpreter().loadState(((IrValueParameter)CollectionsKt.single(irFunction.getValueParameters())).getSymbol());
        Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        Primitive array = (Primitive)state;
        environment.getCallStack$ir_interpreter().pushState(environment.convertToState$ir_interpreter(this.arrayToString(array.getValue()), irFunction.getReturnType()));
    }
}

