/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\fH\u0004J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\fH\u0004J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0012H\u0004R&\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006j\u0002`\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "<init>", "()V", "fields", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getFields", "()Ljava/util/Map;", "Ljava/util/Map;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "renderReceivers", "", "dispatchReceiver", "Lorg/jetbrains/kotlin/ir/types/IrType;", "extensionReceiver", "renderLambda", "irFunction", "renderFunction", "renderProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "renderType", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nReflectionState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public abstract class ReflectionState
implements State {
    @NotNull
    private final Map<IrSymbol, State> fields = new LinkedHashMap();

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return null;
    }

    private final String renderReceivers(IrType dispatchReceiver, IrType extensionReceiver) {
        StringBuilder stringBuilder2;
        StringBuilder $this$renderReceivers_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (dispatchReceiver != null) {
            $this$renderReceivers_u24lambda_u240.append(this.renderType(dispatchReceiver)).append(".");
        }
        if (extensionReceiver != null) {
            boolean addParentheses;
            boolean bl2 = addParentheses = dispatchReceiver != null;
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u240.append("(");
            }
            $this$renderReceivers_u24lambda_u240.append(this.renderType(extensionReceiver)).append(".");
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u240.append(")");
            }
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    protected final String renderLambda(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        IrAnnotationContainer irAnnotationContainer = irFunction.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        String receiver = irAnnotationContainer != null ? this.renderType((IrType)irAnnotationContainer) : null;
        String arguments2 = CollectionsKt.joinToString$default((Iterable)irFunction.getValueParameters(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CharSequence invoke(IrValueParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.renderType(it.getType());
            }
        }), (int)25, null);
        String returnType2 = this.renderType(irFunction.getReturnType());
        String it = arguments2 + " -> " + returnType2;
        boolean bl = false;
        return receiver != null ? receiver + '.' + it : it;
    }

    @NotNull
    protected final String renderFunction(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        IrClass irClass = IrUtilsKt.getParentClassOrNull(irFunction);
        IrSimpleType dispatchReceiver = irClass != null ? IrUtilsKt.getDefaultType(irClass) : null;
        IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
        IrType extensionReceiver = irValueParameter != null ? irValueParameter.getType() : null;
        String receivers = irFunction instanceof IrConstructor ? "" : this.renderReceivers(dispatchReceiver, extensionReceiver);
        String arguments2 = CollectionsKt.joinToString$default((Iterable)irFunction.getValueParameters(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CharSequence invoke(IrValueParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.renderType(it.getType());
            }
        }), (int)25, null);
        String returnType2 = this.renderType(irFunction.getReturnType());
        return "fun " + receivers + irFunction.getName() + arguments2 + ": " + returnType2;
    }

    @NotNull
    protected final String renderProperty(@NotNull IrProperty property) {
        IrDeclarationBase irDeclarationBase;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String prefix = property.isVar() ? "var" : "val";
        IrDeclarationBase irDeclarationBase2 = property.getGetter();
        String receivers = this.renderReceivers(irDeclarationBase2 != null && (irDeclarationBase2 = ((IrFunction)irDeclarationBase2).getDispatchReceiverParameter()) != null ? irDeclarationBase2.getType() : null, (irDeclarationBase = property.getGetter()) != null && (irDeclarationBase = ((IrFunction)irDeclarationBase).getExtensionReceiverParameter()) != null ? irDeclarationBase.getType() : null);
        IrSimpleFunction irSimpleFunction = property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        String returnType2 = this.renderType(irSimpleFunction.getReturnType());
        return prefix + ' ' + receivers + property.getName() + ": " + returnType2;
    }

    @NotNull
    protected final String renderType(@NotNull IrType $this$renderType) {
        int index2;
        Intrinsics.checkNotNullParameter((Object)$this$renderType, (String)"<this>");
        String renderedType = StringsKt.replace$default((String)RenderIrElementKt.render$default($this$renderType, null, 1, null), (String)"<root>.", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.contains$default((CharSequence)renderedType, (CharSequence)"<get-", (boolean)false, (int)2, null)) {
            int startIndex = StringsKt.indexOf$default((CharSequence)renderedType, (String)"<get-", (int)0, (boolean)false, (int)6, null);
            int lastTriangle = StringsKt.indexOf$default((CharSequence)renderedType, (char)'>', (int)startIndex, (boolean)false, (int)4, null) + 1;
            String string2 = renderedType;
            CharSequence charSequence = "get";
            renderedType = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)startIndex, (int)lastTriangle, (CharSequence)charSequence)).toString();
        }
        while ((index2 = StringsKt.indexOf$default((CharSequence)renderedType, (String)" of ", (int)0, (boolean)false, (int)6, null)) != -1) {
            int replaceUntilComma = StringsKt.indexOf$default((CharSequence)renderedType, (char)',', (int)index2, (boolean)false, (int)4, null);
            int replaceUntilTriangle = StringsKt.indexOf$default((CharSequence)renderedType, (char)'>', (int)index2, (boolean)false, (int)4, null);
            int replaceUntil = replaceUntilComma == -1 && replaceUntilTriangle == -1 ? renderedType.length() : (replaceUntilComma == -1 ? replaceUntilTriangle : (replaceUntilTriangle == -1 ? replaceUntilComma : Math.min(replaceUntilComma, replaceUntilTriangle)));
            String string3 = renderedType;
            CharSequence charSequence = "";
            renderedType = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)index2, (int)replaceUntil, (CharSequence)charSequence)).toString();
        }
        return renderedType;
    }
}

