/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.FqNameEqualityChecker;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\t\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\"\u0015\u0010\u000e\u001a\u00020\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"superTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isSubtypeOfClass", "", "superClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isStrictSubtypeOfClass", "isSubtypeOf", "superType", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "isNullable", "isBoxedArray", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "getArrayElementType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "toArrayOrPrimitiveArrayType", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/types/IrTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1745#2,3:81\n1745#2,3:84\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/types/IrTypeUtilsKt\n*L\n24#1:81,3\n43#1:84,3\n*E\n"})
public final class IrTypeUtilsKt {
    @NotNull
    public static final List<IrType> superTypes(@NotNull IrClassifierSymbol $this$superTypes) {
        List<IrType> list2;
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = $this$superTypes;
        if (irClassifierSymbol instanceof IrClassSymbol) {
            list2 = ((IrClass)((IrClassSymbol)$this$superTypes).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            list2 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$superTypes).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol instanceof IrScriptSymbol) {
            list2 = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrClassifierSymbol $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return FqNameEqualityChecker.INSTANCE.areEqual($this$isSubtypeOfClass, superClass) || IrTypeUtilsKt.isStrictSubtypeOfClass($this$isSubtypeOfClass, superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrClassifierSymbol $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            Iterable $this$any$iv = IrTypeUtilsKt.superTypes($this$isStrictSubtypeOfClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSubtypeOfClass(it, superClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSubtypeOfClass(@NotNull IrType $this$isSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isSubtypeOfClass(((IrSimpleType)$this$isSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isStrictSubtypeOfClass(@NotNull IrType $this$isStrictSubtypeOfClass, @NotNull IrClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isStrictSubtypeOfClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        return $this$isStrictSubtypeOfClass instanceof IrSimpleType && IrTypeUtilsKt.isStrictSubtypeOfClass(((IrSimpleType)$this$isStrictSubtypeOfClass).getClassifier(), superClass);
    }

    public static final boolean isSubtypeOf(@NotNull IrType $this$isSubtypeOf, @NotNull IrType superType2, @NotNull IrTypeSystemContext typeSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, IrTypeCheckerStateKt.createIrTypeCheckerState(typeSystem), (KotlinTypeMarker)$this$isSubtypeOf, (KotlinTypeMarker)superType2, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"<this>");
        IrType irType = $this$isNullable;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier2 = ((IrSimpleType)$this$isNullable).getClassifier();
            if (classifier2 instanceof IrClassSymbol) {
                if (((IrSimpleType)$this$isNullable).getNullability() != SimpleTypeNullability.MARKED_NULLABLE) return false;
                return true;
            }
            if (classifier2 instanceof IrTypeParameterSymbol) {
                switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$isNullable).getNullability().ordinal()]) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        IrType p0;
                        Iterable $this$any$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            return false;
                        }
                        Iterator iterator2 = $this$any$iv.iterator();
                        do {
                            if (!iterator2.hasNext()) return false;
                            Object element$iv = iterator2.next();
                            p0 = (IrType)element$iv;
                            boolean bl = false;
                        } while (!IrTypeUtilsKt.isNullable(p0));
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (!(classifier2 instanceof IrScriptSymbol)) throw new NoWhenBranchMatchedException();
            if (((IrSimpleType)$this$isNullable).getNullability() != SimpleTypeNullability.MARKED_NULLABLE) return false;
            return true;
        }
        if (irType instanceof IrDynamicType) {
            return true;
        }
        if (!(irType instanceof IrErrorType)) return false;
        boolean bl = ((IrErrorType)$this$isNullable).isMarkedNullable();
        return bl;
    }

    public static final boolean isBoxedArray(@NotNull IrType $this$isBoxedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isBoxedArray, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isBoxedArray);
        return Intrinsics.areEqual(object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object) : null, (Object)StandardNames.FqNames.array.toSafe());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final IrType getArrayElementType(@NotNull IrType $this$getArrayElementType, @NotNull IrBuiltIns irBuiltIns) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (!IrTypeUtilsKt.isBoxedArray($this$getArrayElementType)) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getArrayElementType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol classifier2 = irClassSymbol;
            IrType irType2 = irBuiltIns.getPrimitiveArrayElementTypes().get(classifier2);
            irType = irType2;
            if (irType2 != null) return irType;
            IrType irType3 = irBuiltIns.getUnsignedArraysElementTypes().get(classifier2);
            irType = irType3;
            if (irType3 != null) return irType;
            throw new AssertionError((Object)("Primitive array expected: " + classifier2));
        }
        IrTypeArgument argument2 = (IrTypeArgument)CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementType).getArguments());
        if (argument2 instanceof IrTypeProjection) {
            irType = ((IrTypeProjection)argument2).getType();
            return irType;
        }
        if (argument2 instanceof IrStarProjection) {
            irType = irBuiltIns.getAnyNType();
            return irType;
        }
        if (argument2 != null) throw new NoWhenBranchMatchedException();
        throw new IllegalStateException("Unexpected array argument type: null".toString());
    }

    @NotNull
    public static final IrType toArrayOrPrimitiveArrayType(@NotNull IrType $this$toArrayOrPrimitiveArrayType, @NotNull IrBuiltIns irBuiltIns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toArrayOrPrimitiveArrayType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if (IrTypePredicatesKt.isPrimitiveType$default($this$toArrayOrPrimitiveArrayType, false, 1, null)) {
            object = irBuiltIns.getPrimitiveArrayForType().get($this$toArrayOrPrimitiveArrayType);
            if (object == null || (object = IrTypesKt.getDefaultType((IrClassifierSymbol)object)) == null) {
                throw new AssertionError((Object)($this$toArrayOrPrimitiveArrayType + " not in primitiveArrayForType"));
            }
        } else {
            IrType[] irTypeArray = new IrType[]{$this$toArrayOrPrimitiveArrayType};
            object = IrTypesKt.typeWith((IrClassifierSymbol)irBuiltIns.getArrayClass(), irTypeArray);
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

