/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.stubs.StubOutputStream;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKind;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020#2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020%2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010(\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020)2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010*\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020+2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020-2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020/2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinConstantValueSerializationVisitor;", "Lorg/jetbrains/kotlin/constant/AnnotationArgumentVisitor;", "", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "<init>", "(Lcom/intellij/psi/stubs/StubOutputStream;)V", "visitArrayValue", "value", "Lorg/jetbrains/kotlin/constant/ArrayValue;", "data", "visitBooleanValue", "Lorg/jetbrains/kotlin/constant/BooleanValue;", "visitByteValue", "Lorg/jetbrains/kotlin/constant/ByteValue;", "visitCharValue", "Lorg/jetbrains/kotlin/constant/CharValue;", "visitShortValue", "Lorg/jetbrains/kotlin/constant/ShortValue;", "visitIntValue", "Lorg/jetbrains/kotlin/constant/IntValue;", "visitLongValue", "Lorg/jetbrains/kotlin/constant/LongValue;", "visitDoubleValue", "Lorg/jetbrains/kotlin/constant/DoubleValue;", "visitFloatValue", "Lorg/jetbrains/kotlin/constant/FloatValue;", "visitEnumValue", "Lorg/jetbrains/kotlin/constant/EnumValue;", "visitKClassValue", "Lorg/jetbrains/kotlin/constant/KClassValue;", "visitNullValue", "Lorg/jetbrains/kotlin/constant/NullValue;", "visitStringValue", "Lorg/jetbrains/kotlin/constant/StringValue;", "visitUByteValue", "Lorg/jetbrains/kotlin/constant/UByteValue;", "visitUShortValue", "Lorg/jetbrains/kotlin/constant/UShortValue;", "visitUIntValue", "Lorg/jetbrains/kotlin/constant/UIntValue;", "visitULongValue", "Lorg/jetbrains/kotlin/constant/ULongValue;", "visitAnnotationValue", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "visitErrorValue", "Lorg/jetbrains/kotlin/constant/ErrorValue;", "psi"})
public final class KotlinConstantValueSerializationVisitor
extends AnnotationArgumentVisitor {
    @NotNull
    private final StubOutputStream dataStream;

    public KotlinConstantValueSerializationVisitor(@NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        this.dataStream = dataStream;
    }

    public void visitArrayValue(@NotNull ArrayValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.ARRAY.ordinal());
        this.dataStream.writeInt(((List)value2.getValue()).size());
        for (ConstantValue constantValue : (List)value2.getValue()) {
            constantValue.accept(this, data2);
        }
    }

    public void visitBooleanValue(@NotNull BooleanValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.BOOLEAN.ordinal());
        this.dataStream.writeBoolean((Boolean)value2.getValue());
    }

    public void visitByteValue(@NotNull ByteValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.BYTE.ordinal());
        this.dataStream.writeByte(((Number)value2.getValue()).byteValue());
    }

    public void visitCharValue(@NotNull CharValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.CHAR.ordinal());
        this.dataStream.writeChar(((Character)value2.getValue()).charValue());
    }

    public void visitShortValue(@NotNull ShortValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.SHORT.ordinal());
        this.dataStream.writeShort(((Number)value2.getValue()).shortValue());
    }

    public void visitIntValue(@NotNull IntValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.INT.ordinal());
        this.dataStream.writeInt(((Number)value2.getValue()).intValue());
    }

    public void visitLongValue(@NotNull LongValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.LONG.ordinal());
        this.dataStream.writeLong(((Number)value2.getValue()).longValue());
    }

    public void visitDoubleValue(@NotNull DoubleValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.DOUBLE.ordinal());
        this.dataStream.writeDouble(((Number)value2.getValue()).doubleValue());
    }

    public void visitFloatValue(@NotNull FloatValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.FLOAT.ordinal());
        this.dataStream.writeFloat(((Number)value2.getValue()).floatValue());
    }

    public void visitEnumValue(@NotNull EnumValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.ENUM.ordinal());
        StubUtils.serializeClassId(this.dataStream, value2.getEnumClassId());
        this.dataStream.writeName(value2.getEnumEntryName().getIdentifier());
    }

    public void visitKClassValue(@NotNull KClassValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.KCLASS.ordinal());
        Object t = value2.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.constant.KClassValue.Value.NormalClass");
        KClassValue.Value.NormalClass normalClass = (KClassValue.Value.NormalClass)t;
        StubUtils.serializeClassId(this.dataStream, normalClass.getClassId());
        this.dataStream.writeInt(normalClass.getArrayDimensions());
    }

    public void visitNullValue(@NotNull NullValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.NULL.ordinal());
    }

    public void visitStringValue(@NotNull StringValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.STRING.ordinal());
        this.dataStream.writeName((String)value2.getValue());
    }

    public void visitUByteValue(@NotNull UByteValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.UBYTE.ordinal());
        this.dataStream.writeByte(((Number)value2.getValue()).byteValue());
    }

    public void visitUShortValue(@NotNull UShortValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.USHORT.ordinal());
        this.dataStream.writeShort(((Number)value2.getValue()).shortValue());
    }

    public void visitUIntValue(@NotNull UIntValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.UINT.ordinal());
        this.dataStream.writeInt(((Number)value2.getValue()).intValue());
    }

    public void visitULongValue(@NotNull ULongValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.ULONG.ordinal());
        this.dataStream.writeLong(((Number)value2.getValue()).longValue());
    }

    public void visitAnnotationValue(@NotNull AnnotationValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.dataStream.writeInt(KotlinConstantValueKind.ANNO.ordinal());
        KotlinTypeMarker kotlinTypeMarker = ((AnnotationValue.Value)value2.getValue()).getType();
        Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean");
        StubUtils.serializeClassId(this.dataStream, ((KotlinClassTypeBean)kotlinTypeMarker).getClassId());
        Map<Name, ConstantValue<?>> args = ((AnnotationValue.Value)value2.getValue()).getArgumentsMapping();
        this.dataStream.writeInt(args.size());
        for (Map.Entry<Name, ConstantValue<?>> arg : args.entrySet()) {
            this.dataStream.writeName(arg.getKey().asString());
            arg.getValue().accept(this, data2);
        }
    }

    public void visitErrorValue(@NotNull ErrorValue value2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        throw new IllegalStateException("Error values should not be reachable in compiled code".toString());
    }
}

