/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.WarningAwareUpperBoundChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.AbstractNullabilityChecker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.NotNullTypeParameter;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerStateKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J,\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016Jf\u0010\u001f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020#26\u0010$\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\t0%H\u0002J&\u0010)\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020#H\u0002JI\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,2\u0006\u0010-\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H+0\u0015H\u0002\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00062\u00b2\u0006\n\u0010.\u001a\u00020\u0016X\u008a\u0084\u0002\u00b2\u0006\n\u0010.\u001a\u00020\u0016X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkTypeParameterBounds", "findTypeParameterWithWrongBoundsNullability", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "dataFlowValueForWholeExpression", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "checkReceiver", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "doCheckType", "expectedType", "expressionTypeDataFlowValue", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "actualType", "exactedExpressionTypeByDataFlowNullability", "doIfNotNull", "T", "", "type", "dataFlowValue", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForEnhancedTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, new KotlinTypePreparator(){

        public UnwrappedType prepareType(KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    });
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForBaseTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, null, 2, null);

    public JavaNullabilityChecker(@NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        this.upperBoundChecker = upperBoundChecker;
    }

    @NotNull
    public final UpperBoundChecker getUpperBoundChecker() {
        return this.upperBoundChecker;
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType2, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType2, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this.checkTypeParameterBounds(expression2, expressionType2, c);
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataFlowValue>(c, expression2, expressionType2){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;
            {
                this.$c = $c;
                this.$expression = $expression;
                this.$expressionType = $expressionType;
                super(0);
            }

            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$expression, this.$expressionType, this.$c);
            }
        }));
        TypeParameterDescriptor typeParameterDescriptor = this.findTypeParameterWithWrongBoundsNullability(expressionType2, c, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda$0(this.$dataFlowValue$delegate);
            }
        }));
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            boolean bl = false;
            c.trace.report(ErrorsJvm.NULLABLE_TYPE_PARAMETER_AGAINST_NOT_NULL_TYPE_PARAMETER.on((KtElement)((PsiElement)expression2), typeParameterDescriptor2));
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        Function0 function0 = (Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda$0(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.doCheckType(expressionType2, kotlinType, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)new Function2<KotlinType, KotlinType, Unit>(c, expression2){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            {
                this.$c = $c;
                this.$expression = $expression;
                super(2);
            }

            public final void invoke(KotlinType expectedType, KotlinType actualType) {
                Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
                Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedType, actualType));
            }
        }));
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression2).getElseExpression() == null) {
                KtExpression ktExpression2 = ((KtWhenExpression)expression2).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType type2 = kotlinType2;
                if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
                    ClassDescriptor classDescriptor2 = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
                    if (classDescriptor2 == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor2;
                    BindingContext bindingContext = c.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    BindingContext context2 = bindingContext;
                    if (WhenChecker.getEnumMissingCases((KtWhenExpression)expression2, context2, enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression2, context2)) {
                        DataFlowInfo dataFlowInfo2;
                        DataFlowValue subjectDataFlowValue = c.dataFlowValueFactory.createDataFlowValue(subjectExpression, type2, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get(BindingContext.EXPRESSION_TYPE_INFO, subjectExpression);
                        DataFlowInfo dataFlowInfo3 = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace = c.trace;
                        KtExpression ktExpression3 = ((KtWhenExpression)expression2).getSubjectExpression();
                        Intrinsics.checkNotNull((Object)ktExpression3);
                        bindingTrace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression3)));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual((Object)((KtPostfixExpression)expression2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                KtExpression ktExpression4 = ((KtPostfixExpression)expression2).getBaseExpression();
                if (ktExpression4 == null) {
                    return;
                }
                KtExpression baseExpression = ktExpression4;
                KotlinType kotlinType3 = c.trace.getType(baseExpression);
                if (kotlinType3 == null) {
                    return;
                }
                KotlinType baseExpressionType = kotlinType3;
                this.doIfNotNull(baseExpressionType, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>(c, baseExpression, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $baseExpression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$baseExpression = $baseExpression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    public final DataFlowValue invoke() {
                        return this.$c.dataFlowValueFactory.createDataFlowValue(this.$baseExpression, this.$baseExpressionType, this.$c);
                    }
                }), c, (Function0)new Function0<Unit>(c, expression2, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$expression = $expression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    public final void invoke() {
                        this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                    }
                });
            }
        } else if (ktExpression instanceof KtBinaryExpression && (Intrinsics.areEqual((Object)(iElementType = ((KtBinaryExpression)expression2).getOperationToken()), (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) && ((KtBinaryExpression)expression2).getLeft() != null && ((KtBinaryExpression)expression2).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression2;
            KtExpression ktExpression5 = ((KtBinaryExpression)expression2).getLeft();
            Intrinsics.checkNotNull((Object)ktExpression5);
            KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getRight();
            Intrinsics.checkNotNull((Object)ktExpression6);
            SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression5, ktExpression6, c, (Function1<? super KtExpression, ? extends KotlinType>)((Function1)new Function1<KtExpression, KotlinType>(c){
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                public final KotlinType invoke(KtExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$c.trace.getType(it);
                }
            }), (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)new Function1<DataFlowValue, Nullability>(this, c){
                final /* synthetic */ JavaNullabilityChecker this$0;
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    super(1);
                }

                public final Nullability invoke(DataFlowValue value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    Nullability nullability = (Nullability)((Object)JavaNullabilityChecker.access$doIfNotNull(this.this$0, value2.getType(), (Function0)new Function0<DataFlowValue>(value2){
                        final /* synthetic */ DataFlowValue $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        public final DataFlowValue invoke() {
                            return this.$value;
                        }
                    }, this.$c, checkType.2.INSTANCE));
                    if (nullability == null) {
                        nullability = Nullability.UNKNOWN;
                    }
                    return nullability;
                }
            }));
        }
    }

    private final void checkTypeParameterBounds(KtExpression expression2, KotlinType expressionType2, ResolutionContext<?> c) {
        if (expressionType2 instanceof AbbreviatedType) {
            KotlinType kotlinType = ((AbbreviatedType)expressionType2).getExpandedType();
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            this.upperBoundChecker.checkBoundsOfExpandedTypeAlias(kotlinType, expression2, bindingTrace);
        }
        if (!(this.upperBoundChecker instanceof WarningAwareUpperBoundChecker)) {
            return;
        }
        Object object = c instanceof BasicCallResolutionContext ? (BasicCallResolutionContext)c : null;
        if (object == null || (object = ((BasicCallResolutionContext)object).call) == null) {
            KtCallExpression ktCallExpression = expression2 instanceof KtCallExpression ? (KtCallExpression)expression2 : null;
            object = (Call)c.trace.getBindingContext().get(BindingContext.CALL, ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null);
            if (object == null) {
                return;
            }
        }
        Object call2 = object;
        ResolvedCall resolvedCall2 = (ResolvedCall)c.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, call2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Iterable typeArguments = resolvedCall3 instanceof NewResolvedCallImpl ? (Iterable)((NewResolvedCallImpl)resolvedCall3).getResolvedCallAtom().getTypeArgumentMappingByOriginal() : (Iterable)resolvedCall3.getTypeArguments().entrySet();
        for (Map.Entry entry : typeArguments) {
            TypeParameterDescriptor typeParameter2 = (TypeParameterDescriptor)entry.getKey();
            KotlinType typeArgument = (KotlinType)entry.getValue();
            List<KtTypeProjection> list2 = call2.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeArguments(...)");
            KtModifierListOwnerStub ktModifierListOwnerStub = (KtTypeProjection)CollectionsKt.getOrNull(list2, (int)typeParameter2.getIndex());
            if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
            KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
            if (typeArgument == null) continue;
            WarningAwareUpperBoundChecker warningAwareUpperBoundChecker = (WarningAwareUpperBoundChecker)this.upperBoundChecker;
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(typeArgument);
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            WarningAwareUpperBoundChecker.checkBounds$default(warningAwareUpperBoundChecker, (KtTypeReference)typeReference, typeArgument, typeParameter2, typeSubstitutor2, bindingTrace, null, true, null, 160, null);
        }
    }

    private final TypeParameterDescriptor findTypeParameterWithWrongBoundsNullability(KotlinType expressionType2, ResolutionContext<?> c, Function0<DataFlowValue> dataFlowValueForWholeExpression) {
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUsingNullableTypeParameterAgainstNotNullAnnotated)) {
            return null;
        }
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return null;
        }
        Ref.ObjectRef foundSubtypeTypeParameter = new Ref.ObjectRef();
        TypeCheckerState typeState2 = new ClassicTypeCheckerState(c, dataFlowValueForWholeExpression, (Ref.ObjectRef<TypeParameterDescriptor>)foundSubtypeTypeParameter){
            private boolean expectsTypeArgument;
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ Function0<DataFlowValue> $dataFlowValueForWholeExpression;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $foundSubtypeTypeParameter;
            {
                this.$c = $c;
                this.$dataFlowValueForWholeExpression = $dataFlowValueForWholeExpression;
                this.$foundSubtypeTypeParameter = $foundSubtypeTypeParameter;
                super(true, false, null, null, null, 30, null);
            }

            public boolean customIsSubtypeOf(KotlinTypeMarker subType, KotlinTypeMarker superType2) {
                Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
                Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
                if (JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter((KotlinType)subType, (KotlinType)superType2) && (this.expectsTypeArgument || this.$c.dataFlowInfo.getStableNullability((DataFlowValue)this.$dataFlowValueForWholeExpression.invoke()) != Nullability.NOT_NULL)) {
                    ClassifierDescriptor classifierDescriptor = ((KotlinType)subType).getConstructor().getDeclarationDescriptor();
                    this.$foundSubtypeTypeParameter.element = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                    return false;
                }
                if (!this.expectsTypeArgument) {
                    this.expectsTypeArgument = true;
                }
                return true;
            }
        };
        KotlinTypeMarker kotlinTypeMarker = expressionType2;
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeState2, kotlinTypeMarker, (KotlinTypeMarker)kotlinType, false, 8, null);
        return (TypeParameterDescriptor)foundSubtypeTypeParameter.element;
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkNotNullParameter((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Lazy dataFlowValue$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<DataFlowValue>(c, receiverArgument){
            final /* synthetic */ CallResolutionContext<?> $c;
            final /* synthetic */ ReceiverValue $receiverArgument;
            {
                this.$c = $c;
                this.$receiverArgument = $receiverArgument;
                super(0);
            }

            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$receiverArgument, (ResolutionContext)this.$c);
            }
        }));
        if (safeAccess) {
            UserDataHolder userDataHolder = c.call.getCallOperationNode();
            if (userDataHolder == null || (userDataHolder = userDataHolder.getPsi()) == null) {
                return;
            }
            UserDataHolder safeAccessElement = userDataHolder;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.doIfNotNull(kotlinType, (Function0<DataFlowValue>)((Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
                final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
                {
                    this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                    super(0);
                }

                public final DataFlowValue invoke() {
                    return JavaNullabilityChecker.access$checkReceiver$lambda$2(this.$dataFlowValue$delegate);
                }
            }), (ResolutionContext)c, (Function0)new Function0<Unit>(c, (PsiElement)safeAccessElement, receiverArgument){
                final /* synthetic */ CallResolutionContext<?> $c;
                final /* synthetic */ PsiElement $safeAccessElement;
                final /* synthetic */ ReceiverValue $receiverArgument;
                {
                    this.$c = $c;
                    this.$safeAccessElement = $safeAccessElement;
                    this.$receiverArgument = $receiverArgument;
                    super(0);
                }

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_SAFE_CALL.on(this.$safeAccessElement, this.$receiverArgument.getType()));
                }
            });
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        Function0 function0 = (Function0)new Function0<DataFlowValue>((Lazy<DataFlowValue>)dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkReceiver$lambda$2(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, (Function0<DataFlowValue>)function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)((Function2)new Function2<KotlinType, KotlinType, Unit>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext<?> $c;
            {
                this.$receiverArgument = $receiverArgument;
                this.$c = $c;
                super(2);
            }

            public final void invoke(KotlinType expectedType, KotlinType actualType) {
                KtExpression receiverExpression;
                Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
                Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
                Object object = this.$receiverArgument;
                ExpressionReceiver expressionReceiver = object instanceof ExpressionReceiver ? (ExpressionReceiver)object : null;
                KtExpression ktExpression = receiverExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (receiverExpression != null) {
                    this.$c.trace.report(ErrorsJvm.RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)receiverExpression), actualType));
                } else {
                    KtExpression ktExpression2 = this.$c.call.getCalleeExpression();
                    object = ktExpression2 != null ? (KtElement)ktExpression2 : this.$c.call.getCallElement();
                    Intrinsics.checkNotNull((Object)object);
                    Object reportOn = object;
                    this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedType, actualType));
                }
            }
        }));
    }

    private final void doCheckType(KotlinType expressionType2, KotlinType expectedType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super KotlinType, ? super KotlinType, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        KotlinType expressionType3 = this.exactedExpressionTypeByDataFlowNullability(expressionType2, expressionTypeDataFlowValue, dataFlowInfo);
        boolean isEnhancedExpectedTypeSubtypeOfExpressionType = typeCheckerForEnhancedTypes.isSubtypeOf(expressionType3, expectedType);
        if (isEnhancedExpectedTypeSubtypeOfExpressionType) {
            return;
        }
        boolean isExpectedTypeSubtypeOfExpressionType = typeCheckerForBaseTypes.isSubtypeOf(expressionType3, expectedType);
        if (!isEnhancedExpectedTypeSubtypeOfExpressionType && isExpectedTypeSubtypeOfExpressionType) {
            reportWarning.invoke((Object)TypeWithEnhancementKt.unwrapEnhancementDeeply(expectedType), (Object)TypeWithEnhancementKt.unwrapEnhancementDeeply(expressionType3));
        }
    }

    private final KotlinType exactedExpressionTypeByDataFlowNullability(KotlinType expressionType2, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo) {
        boolean isNotNullByDataFlowInfo = dataFlowInfo.getStableNullability((DataFlowValue)expressionTypeDataFlowValue.invoke()) == Nullability.NOT_NULL;
        return KotlinTypeKt.isNullable(expressionType2) && isNotNullByDataFlowInfo ? TypeUtilsKt.makeNotNullable(expressionType2) : expressionType2;
    }

    private final <T> T doIfNotNull(KotlinType type2, Function0<DataFlowValue> dataFlowValue2, ResolutionContext<?> c, Function0<? extends T> body2) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull(type2);
        return (T)((enhancedNullabilityInfo != null ? enhancedNullabilityInfo.isFromJava() : false) && c.dataFlowInfo.getStableNullability((DataFlowValue)dataFlowValue2.invoke()).canBeNull() ? body2.invoke() : null);
    }

    private static final DataFlowValue checkType$lambda$0(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    private static final DataFlowValue checkReceiver$lambda$2(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return (DataFlowValue)lazy.getValue();
    }

    public static final /* synthetic */ DataFlowValue access$checkType$lambda$0(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkType$lambda$0((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityChecker $this, KotlinType type2, Function0 dataFlowValue2, ResolutionContext c, Function0 body2) {
        return $this.doIfNotNull(type2, (Function0<DataFlowValue>)dataFlowValue2, c, body2);
    }

    public static final /* synthetic */ DataFlowValue access$checkReceiver$lambda$2(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkReceiver$lambda$2((Lazy<DataFlowValue>)$dataFlowValue$delegate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$Companion;", "", "<init>", "()V", "typeCheckerForEnhancedTypes", "Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "getTypeCheckerForEnhancedTypes", "()Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "typeCheckerForBaseTypes", "getTypeCheckerForBaseTypes", "isNullableTypeAgainstNotNullTypeParameter", "", "subType", "Lorg/jetbrains/kotlin/types/KotlinType;", "superType", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForEnhancedTypes() {
            return typeCheckerForEnhancedTypes;
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForBaseTypes() {
            return typeCheckerForBaseTypes;
        }

        public final boolean isNullableTypeAgainstNotNullTypeParameter(@NotNull KotlinType subType, @NotNull KotlinType superType2) {
            Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
            Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
            if (!(superType2 instanceof NotNullTypeParameter) || subType instanceof NotNullTypeParameter) {
                return false;
            }
            return !AbstractNullabilityChecker.INSTANCE.isSubtypeOfAny(ClassicTypeCheckerStateKt.createClassicTypeCheckerState$default(true, false, null, null, null, 30, null), (KotlinTypeMarker)subType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

