/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.terminal.impl.DumbTerminalProvider;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_PROVIDERS_DEFAULT = String.join((CharSequence)",", "ffm", "jni", "jansi", "jna", "exec");
    public static final String PROP_FILE_DESCRIPTOR_CREATION_MODE_DEFAULT = String.join((CharSequence)",", "reflection", "native");
    public static final String PROP_REDIRECT_PIPE_CREATION_MODE_DEFAULT = String.join((CharSequence)",", "reflection", "native");
    private static final AtomicReference<Terminal> SYSTEM_TERMINAL = new AtomicReference();
    private static final AtomicReference<Terminal> TERMINAL_OVERRIDE = new AtomicReference();
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private Charset encoding;
    private int codepage;
    private Boolean system;
    private SystemOutput systemOutput;
    private String provider;
    private String providers;
    private Boolean jna;
    private Boolean jansi;
    private Boolean jni;
    private Boolean exec;
    private Boolean ffm;
    private Boolean dumb;
    private Boolean color;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;
    private boolean paused = false;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public Terminal build() throws IOException {
        Terminal terminal;
        Terminal override = TERMINAL_OVERRIDE.get();
        Terminal terminal2 = terminal = override != null ? override : this.doBuild();
        if (override != null) {
            Log.debug(() -> "Overriding terminal with global value set by TerminalBuilder.setTerminalOverride");
        }
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Terminal terminal;
        IllegalStateException exception;
        block23: {
            List<TerminalProvider> providers;
            String type2;
            Charset encoding;
            String name2;
            block22: {
                name2 = this.name;
                if (name2 == null) {
                    name2 = "JLine terminal";
                }
                encoding = this.computeEncoding();
                type2 = this.computeType();
                String provider2 = this.provider;
                if (provider2 == null) {
                    provider2 = System.getProperty("org.jline.terminal.provider", null);
                }
                boolean forceDumb = "dumb".equals(type2) || type2 != null && type2.startsWith("dumb-color") || provider2 != null && provider2.equals("dumb");
                Boolean dumb = this.dumb;
                if (dumb == null) {
                    dumb = TerminalBuilder.getBoolean("org.jline.terminal.dumb", null);
                }
                exception = new IllegalStateException("Unable to create a terminal");
                providers = this.getProviders(provider2, exception);
                terminal = null;
                if ((this.system == null || !this.system.booleanValue()) && (this.system != null || this.in != null || this.out != null)) break block22;
                if (this.system != null && (this.in != null && !this.in.equals(System.in) || this.out != null && !this.out.equals(System.out) && !this.out.equals(System.err))) {
                    throw new IllegalArgumentException("Cannot create a system terminal using non System streams");
                }
                if (this.attributes != null || this.size != null) {
                    Log.warn("Attributes and size fields are ignored when creating a system terminal");
                }
                SystemOutput systemOutput = this.computeSystemOutput();
                Map<SystemStream, Boolean> system2 = Stream.of(SystemStream.values()).collect(Collectors.toMap(stream -> stream, stream -> providers.stream().anyMatch(p -> p.isSystemStream((SystemStream)((Object)stream)))));
                SystemStream systemStream = this.select(system2, systemOutput);
                if (!forceDumb && system2.get((Object)SystemStream.Input).booleanValue() && systemStream != null) {
                    if (this.attributes != null || this.size != null) {
                        Log.warn("Attributes and size fields are ignored when creating a system terminal");
                    }
                    boolean ansiPassThrough = OSUtils.IS_CONEMU;
                    if ((OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) && "xterm".equals(type2) && this.type == null && System.getProperty("org.jline.terminal.type") == null) {
                        type2 = "xterm-256color";
                    }
                    for (TerminalProvider prov : providers) {
                        if (terminal != null) continue;
                        try {
                            terminal = prov.sysTerminal(name2, type2, ansiPassThrough, encoding, this.nativeSignals, this.signalHandler, this.paused, systemStream);
                        }
                        catch (Throwable t) {
                            Log.debug("Error creating " + prov.name() + " based terminal: ", t.getMessage(), t);
                            exception.addSuppressed(t);
                        }
                    }
                    if (!(terminal != null || !OSUtils.IS_WINDOWS || this.jna.booleanValue() || this.jansi.booleanValue() || this.jni.booleanValue() || dumb != null && dumb.booleanValue())) {
                        throw new IllegalStateException("Unable to create a system terminal. On windows, either JNA or JANSI library is required.  Make sure to add one of those in the classpath.");
                    }
                }
                if (terminal instanceof AbstractTerminal) {
                    AbstractTerminal t = (AbstractTerminal)terminal;
                    if (SYSTEM_TERMINAL.compareAndSet(null, t)) {
                        t.setOnClose(() -> SYSTEM_TERMINAL.compareAndSet(t, null));
                    } else {
                        exception.addSuppressed(new IllegalStateException("A system terminal is already running. Make sure to use the created system Terminal on the LineReaderBuilder if you're using one or that previously created system Terminals have been correctly closed."));
                        terminal.close();
                        terminal = null;
                    }
                }
                if (terminal != null || !forceDumb && dumb != null && !dumb.booleanValue()) break block23;
                if (!forceDumb && dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("input is tty: {}", system2.get((Object)SystemStream.Input));
                        Log.warn("output is tty: {}", system2.get((Object)SystemStream.Output));
                        Log.warn("error is tty: {}", system2.get((Object)SystemStream.Error));
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                type2 = this.getDumbTerminalType(dumb, systemStream);
                terminal = new DumbTerminalProvider().sysTerminal(name2, type2, false, encoding, this.nativeSignals, this.signalHandler, this.paused, systemStream);
                if (!OSUtils.IS_WINDOWS) break block23;
                Attributes attr = terminal.getAttributes();
                attr.setInputFlag(Attributes.InputFlag.IGNCR, true);
                terminal.setAttributes(attr);
                break block23;
            }
            for (TerminalProvider prov : providers) {
                if (terminal != null) continue;
                try {
                    terminal = prov.newTerminal(name2, type2, this.in, this.out, encoding, this.signalHandler, this.paused, this.attributes, this.size);
                }
                catch (Throwable t) {
                    Log.debug("Error creating " + prov.name() + " based terminal: ", t.getMessage(), t);
                    exception.addSuppressed(t);
                }
            }
        }
        if (terminal == null) {
            throw exception;
        }
        return terminal;
    }

    private String getDumbTerminalType(Boolean dumb, SystemStream systemStream) {
        Boolean color = this.color;
        if (color == null) {
            color = TerminalBuilder.getBoolean("org.jline.terminal.dumb.color", null);
        }
        if (dumb == null) {
            String emacs;
            if (color == null && (emacs = System.getenv("INSIDE_EMACS")) != null && emacs.contains("comint")) {
                color = true;
            }
            if (color == null) {
                String ideHome = System.getenv("IDE_HOME");
                if (ideHome != null) {
                    color = true;
                } else {
                    String command = TerminalBuilder.getParentProcessCommand();
                    if (command != null && command.endsWith("/idea")) {
                        color = true;
                    }
                }
            }
            if (color == null) {
                color = systemStream != null && System.getenv("TERM") != null;
            }
        } else if (color == null) {
            color = false;
        }
        return color != false ? "dumb-color" : "dumb";
    }

    public SystemOutput computeSystemOutput() {
        String str;
        SystemOutput systemOutput = null;
        if (this.out != null) {
            if (this.out.equals(System.out)) {
                systemOutput = SystemOutput.SysOut;
            } else if (this.out.equals(System.err)) {
                systemOutput = SystemOutput.SysErr;
            }
        }
        if (systemOutput == null) {
            systemOutput = this.systemOutput;
        }
        if (systemOutput == null && (str = System.getProperty("org.jline.terminal.output")) != null) {
            switch (str.trim().toLowerCase(Locale.ROOT)) {
                case "out": {
                    systemOutput = SystemOutput.SysOut;
                    break;
                }
                case "err": {
                    systemOutput = SystemOutput.SysErr;
                    break;
                }
                case "out-err": {
                    systemOutput = SystemOutput.SysOutOrSysErr;
                    break;
                }
                case "err-out": {
                    systemOutput = SystemOutput.SysErrOrSysOut;
                    break;
                }
                case "forced-out": {
                    systemOutput = SystemOutput.ForcedSysOut;
                    break;
                }
                case "forced-err": {
                    systemOutput = SystemOutput.ForcedSysErr;
                    break;
                }
                default: {
                    Log.debug("Unsupported value for org.jline.terminal.output: " + str + ". Supported values are: " + String.join((CharSequence)", ", "out", "err", "out-err", "err-out") + ".");
                }
            }
        }
        if (systemOutput == null) {
            systemOutput = SystemOutput.SysOutOrSysErr;
        }
        return systemOutput;
    }

    public String computeType() {
        String type2 = this.type;
        if (type2 == null) {
            type2 = System.getProperty("org.jline.terminal.type");
        }
        if (type2 == null) {
            type2 = System.getenv("TERM");
        }
        return type2;
    }

    public Charset computeEncoding() {
        String charsetName;
        Charset encoding = this.encoding;
        if (encoding == null && (charsetName = System.getProperty("org.jline.terminal.encoding")) != null && Charset.isSupported(charsetName)) {
            encoding = Charset.forName(charsetName);
        }
        if (encoding == null) {
            String str;
            int codepage = this.codepage;
            if (codepage <= 0 && (str = System.getProperty("org.jline.terminal.codepage")) != null) {
                codepage = Integer.parseInt(str);
            }
            encoding = codepage >= 0 ? TerminalBuilder.getCodepageCharset(codepage) : StandardCharsets.UTF_8;
        }
        return encoding;
    }

    public List<TerminalProvider> getProviders(String provider2, IllegalStateException exception) {
        ArrayList<TerminalProvider> providers = new ArrayList<TerminalProvider>();
        this.checkProvider(provider2, exception, providers, this.ffm, "org.jline.terminal.ffm", "ffm");
        this.checkProvider(provider2, exception, providers, this.jni, "org.jline.terminal.jni", "jni");
        this.checkProvider(provider2, exception, providers, this.jansi, "org.jline.terminal.jansi", "jansi");
        this.checkProvider(provider2, exception, providers, this.jna, "org.jline.terminal.jna", "jna");
        this.checkProvider(provider2, exception, providers, this.exec, "org.jline.terminal.exec", "exec");
        List<String> order = Arrays.asList((this.providers != null ? this.providers : System.getProperty("org.jline.terminal.providers", PROP_PROVIDERS_DEFAULT)).split(","));
        providers.sort(Comparator.comparing(l -> {
            int idx = order.indexOf(l.name());
            return idx >= 0 ? idx : Integer.MAX_VALUE;
        }));
        String names2 = providers.stream().map(TerminalProvider::name).collect(Collectors.joining(", "));
        Log.debug("Available providers: " + names2);
        return providers;
    }

    private void checkProvider(String provider2, IllegalStateException exception, List<TerminalProvider> providers, Boolean load2, String property, String name2) {
        Boolean doLoad;
        Boolean bl = doLoad = provider2 != null ? Boolean.valueOf(name2.equals(provider2)) : load2;
        if (doLoad == null) {
            doLoad = TerminalBuilder.getBoolean(property, true);
        }
        if (doLoad.booleanValue()) {
            try {
                TerminalProvider prov = TerminalProvider.load(name2);
                prov.isSystemStream(SystemStream.Output);
                providers.add(prov);
            }
            catch (Throwable t) {
                Log.debug("Unable to load " + name2 + " provider: ", t);
                exception.addSuppressed(t);
            }
        }
    }

    private SystemStream select(Map<SystemStream, Boolean> system2, SystemOutput systemOutput) {
        switch (systemOutput.ordinal()) {
            case 0: {
                return TerminalBuilder.select(system2, SystemStream.Output);
            }
            case 1: {
                return TerminalBuilder.select(system2, SystemStream.Error);
            }
            case 2: {
                return TerminalBuilder.select(system2, SystemStream.Output, SystemStream.Error);
            }
            case 3: {
                return TerminalBuilder.select(system2, SystemStream.Error, SystemStream.Output);
            }
            case 4: {
                return SystemStream.Output;
            }
            case 5: {
                return SystemStream.Error;
            }
        }
        return null;
    }

    private static SystemStream select(Map<SystemStream, Boolean> system2, SystemStream ... streams) {
        for (SystemStream s : streams) {
            if (!system2.get((Object)s).booleanValue()) continue;
            return s;
        }
        return null;
    }

    private static String getParentProcessCommand() {
        try {
            Class<?> phClass = Class.forName("java.lang.ProcessHandle");
            Object current = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object parent2 = ((Optional)phClass.getMethod("parent", new Class[0]).invoke(current, new Object[0])).orElse(null);
            Method infoMethod = phClass.getMethod("info", new Class[0]);
            Object info = infoMethod.invoke(parent2, new Object[0]);
            Object command = ((Optional)infoMethod.getReturnType().getMethod("command", new Class[0]).invoke(info, new Object[0])).orElse(null);
            return command;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Boolean getBoolean(String name2, Boolean def) {
        try {
            String str = System.getProperty(name2);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private static Charset getCodepageCharset(int codepage) {
        if (codepage == 65001) {
            return StandardCharsets.UTF_8;
        }
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return Charset.forName(charsetMS);
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return Charset.forName(charsetCP);
        }
        return Charset.defaultCharset();
    }

    public static enum SystemOutput {
        SysOut,
        SysErr,
        SysOutOrSysErr,
        SysErrOrSysOut,
        ForcedSysOut,
        ForcedSysErr;

    }
}

