/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance(PsiAugmentProvider.class);
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");
    @NotNull
    private static final NotNullLazyValue<ExtensionPoint<PsiAugmentProvider>> EP = NotNullLazyValue.lazy(() -> EP_NAME.getPoint());
    private final Key<CachedValue<Map<Class, List>>> myCacheKey = Key.create(this.getClass().getName());

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2, @Nullable String nameHint) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(1);
        }
        if (nameHint == null) {
            List<Psi> list = this.getAugments(element, type2);
            if (list == null) {
                PsiAugmentProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Map cache2 = (Map)CachedValuesManager.getCachedValue(element, this.myCacheKey, () -> {
            ConcurrentMap<Class, List> map = ConcurrentFactoryMap.createMap(c -> this.getAugments(element, (Class)c));
            return CachedValueProvider.Result.create(map, PsiModificationTracker.MODIFICATION_COUNT);
        });
        List list = (List)cache2.get(type2);
        if (list == null) {
            PsiAugmentProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @ApiStatus.Experimental
    protected List<PsiExtensionMethod> getExtensionMethods(@NotNull PsiClass aClass, @NotNull String nameHint, @NotNull PsiElement context) {
        if (aClass == null) {
            PsiAugmentProvider.$$$reportNull$$$0(4);
        }
        if (nameHint == null) {
            PsiAugmentProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PsiAugmentProvider.$$$reportNull$$$0(6);
        }
        return Collections.emptyList();
    }

    @Deprecated
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(7);
        }
        if (type2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(8);
        }
        List list = Collections.emptyList();
        if (list == null) {
            PsiAugmentProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(10);
        }
        return null;
    }

    protected boolean canInferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(11);
        }
        return this.inferType(typeElement) != null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList2, @NotNull Set<String> modifiers) {
        if (modifierList2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(12);
        }
        if (modifiers == null) {
            PsiAugmentProvider.$$$reportNull$$$0(13);
        }
        Set<String> set = modifiers;
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type2, @Nullable String nameHint) {
        if (element == null) {
            PsiAugmentProvider.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(16);
        }
        SmartList result2 = new SmartList();
        PsiAugmentProvider.forEach(element.getProject(), provider2 -> {
            List augments = provider2.getAugments(element, type2, nameHint);
            for (PsiElement augment : augments) {
                if (nameHint != null && augment instanceof PsiNamedElement && !nameHint.equals(((PsiNamedElement)augment).getName())) continue;
                try {
                    PsiUtilCore.ensureValid(augment);
                    result2.add(augment);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(PluginException.createByClass(e, provider2.getClass()));
                }
            }
            return true;
        });
        SmartList smartList = result2;
        if (smartList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<PsiExtensionMethod> collectExtensionMethods(PsiClass aClass, @NotNull String nameHint, PsiElement context) {
        if (nameHint == null) {
            PsiAugmentProvider.$$$reportNull$$$0(18);
        }
        SmartList<PsiExtensionMethod> extensionMethods = new SmartList<PsiExtensionMethod>();
        PsiAugmentProvider.forEach(aClass.getProject(), provider2 -> {
            List<PsiExtensionMethod> methods2 = provider2.getExtensionMethods(aClass, nameHint, context);
            for (PsiExtensionMethod method : methods2) {
                try {
                    PsiUtilCore.ensureValid(method);
                    extensionMethods.add(method);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(PluginException.createByClass(e, provider2.getClass()));
                }
            }
            return true;
        });
        SmartList<PsiExtensionMethod> smartList = extensionMethods;
        if (smartList == null) {
            PsiAugmentProvider.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(20);
        }
        Ref result2 = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider2 -> {
            PsiType type2 = provider2.inferType(typeElement);
            if (type2 != null) {
                try {
                    PsiUtil.ensureValidType(type2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass(e, provider2.getClass());
                }
                result2.set(type2);
                return false;
            }
            return true;
        });
        return (PsiType)result2.get();
    }

    public static boolean isInferredType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            PsiAugmentProvider.$$$reportNull$$$0(21);
        }
        AtomicBoolean result2 = new AtomicBoolean();
        PsiAugmentProvider.forEach(typeElement.getProject(), provider2 -> {
            boolean canInfer = provider2.canInferType(typeElement);
            if (canInfer) {
                result2.set(true);
            }
            return !canInfer;
        });
        return result2.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList2, @NotNull Project project, @NotNull Set<String> modifiers) {
        if (modifierList2 == null) {
            PsiAugmentProvider.$$$reportNull$$$0(22);
        }
        if (project == null) {
            PsiAugmentProvider.$$$reportNull$$$0(23);
        }
        if (modifiers == null) {
            PsiAugmentProvider.$$$reportNull$$$0(24);
        }
        Ref<Set<String>> result2 = Ref.create(modifiers);
        PsiAugmentProvider.forEach(project, provider2 -> {
            result2.set(provider2.transformModifiers(modifierList2, Collections.unmodifiableSet((Set)result2.get())));
            return true;
        });
        Set<String> set = result2.get();
        if (set == null) {
            PsiAugmentProvider.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static void forEach(Project project, Processor<? super PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb(project);
        for (PsiAugmentProvider provider2 : EP.getValue().getExtensionList()) {
            if (dumb && !DumbService.isDumbAware(provider2)) continue;
            try {
                boolean goOn = processor.process(provider2);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider2, e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/augment/PsiAugmentProvider";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAugments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionMethods";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifierProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 25: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectAugments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionMethods";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInferredType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInferredType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "transformModifierProperties";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

