/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Bits;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.FilePageCache;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagedFileStorageCache;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagedFileStorage
implements Forceable {
    private static final Logger LOG = Logger.getInstance(PagedFileStorage.class);
    private static final OpenChannelsCache CHANNELS_CACHE = new OpenChannelsCache(200);
    public static final int BUFFER_SIZE = FilePageCache.BUFFER_SIZE;
    @NotNull
    private static final ThreadLocal<byte[]> ourTypedIOBuffer = ThreadLocal.withInitial(() -> new byte[8]);
    private static final StorageLockContext ourDefaultContext = new StorageLockContext(true, false);
    @NotNull
    public static final ThreadLocal<StorageLockContext> THREAD_LOCAL_STORAGE_LOCK_CONTEXT = new ThreadLocal();
    @NotNull
    private final StorageLockContext myStorageLockContext;
    private final boolean myNativeBytesOrder;
    private int myStorageIndex;
    @NotNull
    private final PagedFileStorageCache myLastAccessedBufferCache;
    @NotNull
    private final Path myFile;
    private final boolean myReadOnly;
    private final Object myInputStreamLock;
    protected final int myPageSize;
    protected final boolean myValuesAreBufferAligned;
    private volatile boolean isDirty;
    private volatile long mySize;

    public PagedFileStorage(@NotNull Path file2, @Nullable StorageLockContext storageLockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) {
        if (file2 == null) {
            PagedFileStorage.$$$reportNull$$$0(0);
        }
        this.myLastAccessedBufferCache = new PagedFileStorageCache();
        this.myInputStreamLock = new Object();
        this.mySize = -1L;
        this.myFile = file2;
        this.myReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get() == Boolean.TRUE;
        StorageLockContext context = THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get();
        if (context != null) {
            if (storageLockContext != null && storageLockContext != context) {
                throw new IllegalStateException();
            }
            storageLockContext = context;
        }
        this.myStorageLockContext = storageLockContext != null ? storageLockContext : ourDefaultContext;
        this.myPageSize = Math.max(pageSize > 0 ? pageSize : BUFFER_SIZE, Page.PAGE_SIZE);
        this.myValuesAreBufferAligned = valuesAreBufferAligned;
        this.myStorageIndex = this.myStorageLockContext.getBufferCache().registerPagedFileStorage(this);
        this.myNativeBytesOrder = nativeBytesOrder;
    }

    public int getPageSize() {
        return this.myPageSize;
    }

    public void lockRead() {
        this.myStorageLockContext.lockRead();
    }

    public void unlockRead() {
        this.myStorageLockContext.unlockRead();
    }

    public void lockWrite() {
        this.myStorageLockContext.lockWrite();
    }

    public void unlockWrite() {
        this.myStorageLockContext.unlockWrite();
    }

    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.myStorageLockContext;
        if (storageLockContext == null) {
            PagedFileStorage.$$$reportNull$$$0(1);
        }
        return storageLockContext;
    }

    @NotNull
    Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            PagedFileStorage.$$$reportNull$$$0(2);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public <R> R readInputStream(@NotNull ThrowableNotNullFunction<? super InputStream, R, ? extends IOException> consumer) throws IOException {
        Object object;
        if (consumer == null) {
            PagedFileStorage.$$$reportNull$$$0(3);
        }
        Object object2 = this.myInputStreamLock;
        synchronized (object2) {
            try {
                object = this.useChannel(ch -> {
                    ch.position(0L);
                    return consumer.fun(Channels.newInputStream(ch));
                }, true);
            }
            catch (NoSuchFileException ignored) {
                R r = consumer.fun(new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY));
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : object2
                if (r == null) {
                    PagedFileStorage.$$$reportNull$$$0(5);
                }
                return r;
            }
        }
        if (object == null) {
            PagedFileStorage.$$$reportNull$$$0(4);
        }
        return (R)object;
    }

    <R> R useChannel(@NotNull OpenChannelsCache.ChannelProcessor<R> processor, boolean read2) throws IOException {
        if (processor == null) {
            PagedFileStorage.$$$reportNull$$$0(6);
        }
        if (this.myStorageLockContext.useChannelCache()) {
            return CHANNELS_CACHE.useChannel(this.myFile, processor, read2);
        }
        try (OpenChannelsCache.ChannelDescriptor desc = new OpenChannelsCache.ChannelDescriptor(this.myFile, read2);){
            R r = processor.process(desc.getChannel());
            return r;
        }
    }

    public void putInt(long addr, int value2) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            this.getBuffer(page).putInt(page_offset, value2);
        } else {
            Bits.putInt(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, value2);
            this.put(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 4);
        }
    }

    public int getInt(long addr) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            return this.getReadOnlyBuffer(page).getInt(page_offset);
        }
        this.get(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 4);
        return Bits.getInt(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0);
    }

    public int getOffsetInPage(long addr) {
        return (int)(addr % (long)this.myPageSize);
    }

    public DirectBufferWrapper getByteBuffer(long address, boolean modify) throws IOException {
        long page = address / (long)this.myPageSize;
        assert (page >= 0L && page <= 65535L) : address + " in " + this.myFile;
        return this.getBufferWrapper(page, modify);
    }

    public void putLong(long addr, long value2) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            this.getBuffer(page).putLong(page_offset, value2);
        } else {
            Bits.putLong(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, value2);
            this.put(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 8);
        }
    }

    public long getLong(long addr) throws IOException {
        if (this.myValuesAreBufferAligned) {
            long page = addr / (long)this.myPageSize;
            int page_offset = (int)(addr % (long)this.myPageSize);
            return this.getReadOnlyBuffer(page).getLong(page_offset);
        }
        this.get(addr, PagedFileStorage.getThreadLocalTypedIOBuffer(), 0, 8);
        return Bits.getLong(PagedFileStorage.getThreadLocalTypedIOBuffer(), 0);
    }

    public byte get(long index) throws IOException {
        long page = index / (long)this.myPageSize;
        int offset2 = (int)(index % (long)this.myPageSize);
        return this.getReadOnlyBuffer(page).get(offset2);
    }

    public void get(long index, byte[] dst, int offset2, int length) throws IOException {
        long i = index;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i / (long)this.myPageSize;
            int page_offset = (int)(i % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            DirectBufferWrapper buffer = this.getReadOnlyBuffer(page);
            buffer.readToArray(dst, o, page_offset, page_len);
            l -= page_len;
            o += page_len;
            i += (long)page_len;
        }
    }

    public void put(long index, byte[] src, int offset2, int length) throws IOException {
        long i = index;
        int o = offset2;
        int l = length;
        while (l > 0) {
            long page = i / (long)this.myPageSize;
            int page_offset = (int)(i % (long)this.myPageSize);
            int page_len = Math.min(l, this.myPageSize - page_offset);
            DirectBufferWrapper buffer = this.getBuffer(page);
            buffer.putFromArray(src, o, page_offset, page_len);
            l -= page_len;
            o += page_len;
            i += (long)page_len;
        }
    }

    public void close() throws IOException {
        SmartList exceptions = new SmartList();
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> this.force()));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> {
            this.unmapAll();
            this.myStorageLockContext.getBufferCache().removeStorage(this.myStorageIndex);
            this.myStorageIndex = -1;
        }));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> CHANNELS_CACHE.closeChannel(this.myFile)));
        if (!exceptions.isEmpty()) {
            throw new IOException(new CompoundRuntimeException(exceptions));
        }
    }

    private void unmapAll() {
        this.myStorageLockContext.getBufferCache().unmapBuffersForOwner(this.myStorageIndex, this.myStorageLockContext);
        this.myLastAccessedBufferCache.clear();
    }

    public void resize(long newSize) throws IOException {
        long finished;
        long oldSize;
        if (Files.exists(this.myFile, new LinkOption[0])) {
            oldSize = Files.size(this.myFile);
        } else {
            Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
            oldSize = 0L;
        }
        if (oldSize == newSize && oldSize == this.length()) {
            return;
        }
        long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.myStorageLockContext.getBufferCache().invalidateBuffer(this.myStorageIndex | (int)(oldSize / (long)this.myPageSize));
        long unmapAllFinished = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        this.resizeFile(newSize);
        long delta = newSize - oldSize;
        if (delta > 0L) {
            this.fillWithZeros(oldSize, delta);
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Resized " + this.myFile + " from " + oldSize + " to " + newSize + " for " + (finished - started) + ", unmap all:" + (finished - unmapAllFinished));
        }
    }

    private void resizeFile(long newSize) throws IOException {
        this.mySize = -1L;
        try (RandomAccessFile raf = new RandomAccessFile(this.myFile.toFile(), "rw");){
            raf.setLength(newSize);
        }
        this.mySize = newSize;
    }

    private void fillWithZeros(long from2, long length) throws IOException {
        byte[] buff = new byte[8192];
        Arrays.fill(buff, (byte)0);
        while (length > 0L) {
            int filled = Math.min((int)length, 8192);
            this.put(from2, buff, 0, filled);
            length -= (long)filled;
            from2 += (long)filled;
        }
    }

    public final long length() {
        long size = this.mySize;
        if (size == -1L) {
            if (Files.exists(this.myFile, new LinkOption[0])) {
                try {
                    this.mySize = size = Files.size(this.myFile);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            } else {
                size = 0L;
                this.mySize = 0L;
            }
        }
        return size;
    }

    private DirectBufferWrapper getBuffer(long page) throws IOException {
        return this.getBufferWrapper(page, true);
    }

    private DirectBufferWrapper getReadOnlyBuffer(long page) throws IOException {
        return this.getBufferWrapper(page, false);
    }

    private DirectBufferWrapper getBufferWrapper(long page, boolean modify) throws IOException {
        DirectBufferWrapper pageFromCache = this.myLastAccessedBufferCache.getPageFromCache(page, this.myStorageLockContext.getBufferCache().getMappingChangeCount());
        if (this.myReadOnly && modify) {
            throw new IOException("Read-only storage can't be modified");
        }
        if (pageFromCache != null) {
            if (modify) {
                this.markDirty();
            }
            return pageFromCache;
        }
        assert (page >= 0L && page <= 65535L) : page;
        if (this.myStorageIndex == -1) {
            throw new IOException("storage is already closed; path " + this.myFile);
        }
        DirectBufferWrapper byteBufferWrapper = this.myStorageLockContext.getBufferCache().get(this.myStorageIndex | (int)page, !modify, this.myReadOnly);
        if (modify) {
            this.markDirty();
        }
        if (this.myNativeBytesOrder) {
            byteBufferWrapper.useNativeByteOrder();
        }
        this.myLastAccessedBufferCache.updateCache(page, byteBufferWrapper, this.myStorageLockContext.getBufferCache().getMappingChangeCount());
        return byteBufferWrapper;
    }

    void markDirty() {
        if (!this.isDirty) {
            this.isDirty = true;
        }
    }

    private static byte[] getThreadLocalTypedIOBuffer() {
        return ourTypedIOBuffer.get();
    }

    @Override
    public void force() throws IOException {
        long finished;
        long started;
        long l = started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        if (this.isDirty) {
            this.myStorageLockContext.getBufferCache().flushBuffersForOwner(this.myStorageIndex, this.myStorageLockContext);
            if (!this.myReadOnly) {
                // empty if block
            }
            this.isDirty = false;
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Flushed " + this.myFile + " for " + (finished - started));
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PagedFileStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PagedFileStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "useChannel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

