/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JO\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0001(\u0000J*\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020#\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "deprecatedClassId", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "reportIfMfvc", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "hint", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkMultiFieldValueClassAnnotationRestrictions", "checkAnnotationTarget", "checkAnnotationUseSiteTarget", "annotated", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "checkPropertyGetter", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkDeprecatedCalls", "deprecatedSinceKotlin", "deprecated", "checkDeclaredRepeatedAnnotations", "annotationContainer", "checkAllRepeatedAnnotations", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkRepeatedAnnotationsInProperty", "property", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n+ 2 TypeExpansionUtils.kt\norg/jetbrains/kotlin/fir/resolve/TypeExpansionUtilsKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n205#2:385\n28#3,15:386\n45#3:403\n13409#4,2:401\n1755#5,3:404\n1755#5,3:407\n1557#5:410\n1628#5,3:411\n*S KotlinDebug\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n*L\n348#1:385\n348#1:386,15\n348#1:403\n348#1:401,2\n165#1:404,3\n173#1:407,3\n359#1:410\n359#1:411,3\n*E\n"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");

    private FirAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration instanceof FirDanglingModifierList) {
                return;
            }
            this.checkAnnotationContainer(declaration, context, reporter);
            if (!(declaration instanceof FirCallableDeclaration)) break block2;
            FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it = firReceiverParameter;
                boolean bl = false;
                INSTANCE.checkAnnotationContainer(it, context, reporter);
            }
        }
    }

    private final void checkAnnotationContainer(FirAnnotationContainer declaration, CheckerContext context, DiagnosticReporter reporter) {
        FirReceiverParameter receiverParameter;
        FirAnnotation deprecated = null;
        FirAnnotation deprecatedSinceKotlin = null;
        for (FirAnnotation annotation : declaration.getAnnotations()) {
            FqName fqName;
            if (CallableIdUtilsKt.fqName(annotation, context.getSession()) == null) continue;
            if (Intrinsics.areEqual((Object)fqName, (Object)deprecatedClassId)) {
                deprecated = annotation;
            } else if (Intrinsics.areEqual((Object)fqName, (Object)deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlin = annotation;
            }
            this.checkAnnotationTarget(declaration, annotation, context, reporter);
        }
        if (declaration instanceof FirCallableDeclaration && (receiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter()) != null) {
            for (FirAnnotation receiverAnnotation : receiverParameter.getAnnotations()) {
                this.reportIfMfvc(context, reporter, receiverAnnotation, "receivers", FirTypeUtilsKt.getConeType(receiverParameter.getTypeRef()));
            }
        }
        if (deprecatedSinceKotlin != null) {
            this.checkDeprecatedCalls(deprecatedSinceKotlin, deprecated, context, reporter);
        }
        this.checkDeclaredRepeatedAnnotations(declaration, context, reporter);
        if (declaration instanceof FirCallableDeclaration) {
            if (declaration instanceof FirProperty) {
                this.checkRepeatedAnnotationsInProperty((FirProperty)declaration, context, reporter);
            }
            KtSourceElement ktSourceElement = ((FirCallableDeclaration)declaration).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
                KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)declaration).getReturnTypeRef().getSource();
                if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtRealSourceElementKind) {
                    this.checkAllRepeatedAnnotations(((FirCallableDeclaration)declaration).getReturnTypeRef(), context, reporter);
                }
            }
        } else if (declaration instanceof FirTypeAlias) {
            this.checkAllRepeatedAnnotations(((FirTypeAlias)declaration).getExpandedTypeRef(), context, reporter);
        }
    }

    private final void reportIfMfvc(CheckerContext context, DiagnosticReporter reporter, FirAnnotation annotation, String hint, ConeKotlinType type2) {
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(type2, context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET(), (Object)hint, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkMultiFieldValueClassAnnotationRestrictions(FirAnnotationContainer declaration, FirAnnotation annotation, CheckerContext context, DiagnosticReporter reporter) {
        Pair pair;
        AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
        switch (annotationUseSiteTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget.ordinal()]) {
            case 1: {
                FirPureAbstractElement firPureAbstractElement = declaration instanceof FirBackingField ? (FirBackingField)declaration : null;
                if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"fields", (Object)firPureAbstractElement);
                break;
            }
            case 2: {
                Object object = declaration instanceof FirBackingField ? (FirBackingField)declaration : null;
                if (object == null || (object = ((FirBackingField)object).getPropertySymbol()) == null || (object = ((FirPropertySymbol)object).getDelegate()) == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"delegate fields", (Object)object);
                break;
            }
            case 3: {
                FirPureAbstractElement firPureAbstractElement = declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null;
                if (firPureAbstractElement == null || (firPureAbstractElement = ((FirCallableDeclaration)firPureAbstractElement).getReceiverParameter()) == null || (firPureAbstractElement = ((FirReceiverParameter)firPureAbstractElement).getTypeRef()) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"receivers", (Object)firPureAbstractElement);
                break;
            }
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (declaration instanceof FirProperty && !((FirProperty)declaration).isLocal()) {
                    Set<KotlinTarget> allowedAnnotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context.getSession());
                    if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration), (Object)true) && allowedAnnotationTargets.contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.PROPERTY)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.FIELD)) {
                        pair = TuplesKt.to((Object)"fields", (Object)((FirProperty)declaration).getReturnTypeRef());
                        break;
                    }
                    return;
                }
                if (declaration instanceof FirField) {
                    pair = TuplesKt.to((Object)"fields", (Object)((FirField)declaration).getReturnTypeRef());
                    break;
                }
                if (declaration instanceof FirValueParameter) {
                    pair = TuplesKt.to((Object)"parameters", (Object)((FirValueParameter)declaration).getReturnTypeRef());
                    break;
                }
                if (declaration instanceof FirVariable) {
                    pair = TuplesKt.to((Object)"variables", (Object)((FirVariable)declaration).getReturnTypeRef());
                    break;
                }
                if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isGetter() && FirAnnotationChecker.checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers((FirPropertyAccessor)declaration)) {
                    pair = TuplesKt.to((Object)"getters", (Object)((FirPropertyAccessor)declaration).getReturnTypeRef());
                    break;
                }
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        String hint = (String)pair2.component1();
        Object type2 = pair2.component2();
        ConeKotlinType coneKotlinType = type2 instanceof ConeKotlinType ? (ConeKotlinType)type2 : null;
        if (coneKotlinType == null) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
            coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)type2);
        }
        this.reportIfMfvc(context, reporter, annotation, hint, coneKotlinType);
    }

    private final void checkAnnotationTarget(FirAnnotationContainer declaration, FirAnnotation annotation, CheckerContext context, DiagnosticReporter reporter) {
        Object targetDescription;
        AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context.getSession());
        AnnotationUseSiteTarget useSiteTarget = annotation.getUseSiteTarget();
        if (useSiteTarget != null) {
            this.checkAnnotationUseSiteTarget(declaration, annotation, useSiteTarget, context, reporter);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                this.checkMultiFieldValueClassAnnotationRestrictions(declaration, annotation, context, reporter);
            }
            return;
        }
        Object object = (KotlinTarget)((Object)kotlin.collections.CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
        if (object == null || (object = object.getDescription()) == null) {
            object = targetDescription = "unidentified target";
        }
        if (useSiteTarget != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, (Object)useSiteTarget.getRenderName(), (DiagnosticContext)context, null, 32, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, CheckerContext context, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = annotation.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 5: 
            case 6: {
                KtDiagnosticFactory1<String> ktDiagnosticFactory1;
                boolean bl = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                if (bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY();
                } else if (!bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY_WARNING();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.checkPropertyGetter(annotated, annotation, target, context, reporter, ktDiagnosticFactory1);
                break;
            }
            case 1: {
                FirPropertySymbol propertySymbol;
                if (!(annotated instanceof FirBackingField) || (propertySymbol = ((FirBackingField)annotated).getPropertySymbol()).getDelegateFieldSymbol() == null || DeclarationAttributesKt.getHasBackingField(propertySymbol)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 2: {
                if (!(annotated instanceof FirBackingField) || ((FirBackingField)annotated).getPropertySymbol().getDelegateFieldSymbol() != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 7: 
            case 9: {
                if (this.checkPropertyGetter(annotated, annotation, target, context, reporter, FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY()) || ((FirProperty)annotated).isVar()) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirValueParameter) {
                    FirDeclaration container = (FirDeclaration)kotlin.collections.CollectionsKt.lastOrNull(context.getContainingDeclarations());
                    if (container instanceof FirConstructor && ((FirConstructor)container).isPrimary()) {
                        KtSourceElement ktSourceElement2 = ((FirValueParameter)annotated).getSource();
                        if (ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement2) : false) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context, null, 8, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 4: {
                if (annotated instanceof FirFile) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), (DiagnosticContext)context, null, 8, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"declaration", (Object)target.getRenderName(), (DiagnosticContext)context, null, 32, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean checkPropertyGetter(FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, CheckerContext context, DiagnosticReporter reporter, KtDiagnosticFactory1<String> diagnostic) {
        boolean isReport;
        boolean bl = isReport = !(annotated instanceof FirProperty) || ((FirProperty)annotated).isLocal();
        if (isReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), diagnostic, (Object)target.getRenderName(), (DiagnosticContext)context, null, 16, null);
        }
        return isReport;
    }

    private final void checkDeprecatedCalls(FirAnnotation deprecatedSinceKotlin, FirAnnotation deprecated, CheckerContext context, DiagnosticReporter reporter) {
        FirFile closestFirFile = context.getContainingFile();
        if (closestFirFile != null && !UtilsKt.getPackageFqName(closestFirFile).startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), (DiagnosticContext)context, null, 8, null);
        }
        if (deprecated == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), (DiagnosticContext)context, null, 8, null);
        } else {
            Map<Name, FirExpression> argumentMapping2 = deprecated.getArgumentMapping().getMapping();
            for (Name name2 : argumentMapping2.keySet()) {
                if (!Intrinsics.areEqual((Object)name2.getIdentifier(), (Object)"level")) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), (DiagnosticContext)context, null, 8, null);
                break;
            }
        }
    }

    private final void checkDeclaredRepeatedAnnotations(FirAnnotationContainer annotationContainer, CheckerContext context, DiagnosticReporter reporter) {
        Map annotationSources = CollectionsKt.keysToMap((Iterable)annotationContainer.getAnnotations(), FirAnnotationChecker::checkDeclaredRepeatedAnnotations$lambda$3);
        FirAnnotationHelpersKt.checkRepeatedAnnotation(annotationContainer, annotationContainer.getAnnotations(), context, reporter, annotationSources, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAllRepeatedAnnotations(FirTypeRef typeRef, CheckerContext context, DiagnosticReporter reporter) {
        void $this$forEachExpandedType$iv;
        Map annotationSources = CollectionsKt.keysToMap((Iterable)typeRef.getAnnotations(), FirAnnotationChecker::checkAllRepeatedAnnotations$lambda$4);
        KtSourceElement useSiteSource = typeRef.getSource();
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(typeRef);
        FirSession session$iv = context.getSession();
        boolean $i$f$forEachExpandedType = false;
        void $this$forEachType$iv$iv = $this$forEachExpandedType$iv;
        boolean $i$f$forEachType = false;
        Object[] objectArray = new ConeKotlinType[]{$this$forEachType$iv$iv};
        List stack$iv$iv = kotlin.collections.CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack$iv$iv).isEmpty()) {
            ConeKotlinType next$iv$iv;
            ConeKotlinType it$iv = (ConeKotlinType)AddToStdlibKt.popLast(stack$iv$iv);
            boolean bl = false;
            ConeKotlinType type2 = next$iv$iv = TypeExpansionUtilsKt.fullyExpandedType(it$iv, session$iv);
            boolean bl2 = false;
            FirAnnotationHelpersKt.checkRepeatedAnnotation(null, CustomAnnotationTypeAttributeKt.getCustomAnnotations(type2.getAttributes()), context, reporter, annotationSources, useSiteSource);
            ConeKotlinType coneKotlinType2 = next$iv$iv;
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getLowerBound());
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getUpperBound());
                continue;
            }
            if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                stack$iv$iv.add(((ConeDefinitelyNotNullType)next$iv$iv).getOriginal());
                continue;
            }
            if (coneKotlinType2 instanceof ConeIntersectionType) {
                stack$iv$iv.addAll(((ConeIntersectionType)next$iv$iv).getIntersectedTypes());
                continue;
            }
            ConeTypeProjection[] $this$forEach$iv$iv$iv = next$iv$iv.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv$iv$iv;
                ConeTypeProjection it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl3 = false;
                if (!(it$iv$iv instanceof ConeKotlinTypeProjection)) continue;
                stack$iv$iv.add(((ConeKotlinTypeProjection)it$iv$iv).getType());
            }
        }
    }

    private final void checkRepeatedAnnotationsInProperty(FirProperty property, CheckerContext context, DiagnosticReporter reporter) {
        Pair[] pairArray = new Pair[3];
        FirPropertyAccessor firPropertyAccessor = property.getGetter();
        pairArray[0] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER), firPropertyAccessor != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor) : null);
        FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
        pairArray[1] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER), firPropertyAccessor2 != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor2) : null);
        Object object = property.getSetter();
        pairArray[2] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.SETTER_PARAMETER), FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null ? (FirValueParameter)kotlin.collections.CollectionsKt.single((List)object) : null));
        Map propertyAnnotations = MapsKt.mapOf((Pair[])pairArray);
        boolean isError = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        for (FirAnnotation annotation : property.getAnnotations()) {
            List existingAnnotations;
            AnnotationUseSiteTarget useSiteTarget;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(property, annotation, context);
            }
            if ((List)propertyAnnotations.get((Object)(useSiteTarget = annotationUseSiteTarget)) == null || !existingAnnotations.contains(FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef())) || FirAnnotationHelpersKt.isRepeatable(annotation, context.getSession())) continue;
            KtDiagnosticFactory0 factory = isError ? FirErrors.INSTANCE.getREPEATED_ANNOTATION() : FirErrors.INSTANCE.getREPEATED_ANNOTATION_WARNING();
            KtSourceElement ktSourceElement = annotation.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), factory, (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers(FirPropertyAccessor $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers) {
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getContextReceivers().isEmpty()) return false;
        FirReceiverParameter firReceiverParameter = $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getReceiverParameter();
        if ((firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null) != null) return false;
        if ($this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedReceiverTypeRef() != null) return false;
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedContextReceivers().isEmpty()) return false;
        return true;
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final KtSourceElement checkDeclaredRepeatedAnnotations$lambda$3(FirAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSource();
    }

    private static final KtSourceElement checkAllRepeatedAnnotations$lambda$4(FirAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSource();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> checkRepeatedAnnotationsInProperty$getAnnotationTypes(FirAnnotationContainer $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes) {
        List list;
        Object object = $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes;
        if (object != null && (object = object.getAnnotations()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

