/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuperclassNotAccessibleFromInterfaceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,39:1\n93#2,3:40\n98#2:44\n93#3:43\n*S KotlinDebug\n*F\n+ 1 FirSuperclassNotAccessibleFromInterfaceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker\n*L\n27#1:40,3\n27#1:44\n27#1:43\n*E\n"})
public final class FirSuperclassNotAccessibleFromInterfaceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuperclassNotAccessibleFromInterfaceChecker INSTANCE = new FirSuperclassNotAccessibleFromInterfaceChecker();

    private FirSuperclassNotAccessibleFromInterfaceChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        block8: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block8;
            }
            firElement = null;
        }
        FirClass firClass = (FirClass)firElement;
        if (firClass == null) {
            return;
        }
        FirClass closestClass = firClass;
        if (closestClass.getClassKind() == ClassKind.INTERFACE) {
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            FirClassLikeSymbol<?> firClassLikeSymbol = firCallableSymbol != null ? FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)firCallableSymbol, context.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            if (containingClassSymbol.getSource() != null && containingClassSymbol.getClassKind() == ClassKind.CLASS && !Intrinsics.areEqual((Object)containingClassSymbol.getClassId(), (Object)StandardClassIds.INSTANCE.getAny())) {
                FirExpression firExpression = expression2.getExplicitReceiver();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }
}

