/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "ReassignedVariableCollector", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1#2:70\n1782#3,4:71\n1797#3,3:75\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker\n*L\n36#1:71,4\n40#1:75,3\n*E\n"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();

    private CanBeValChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull PropertyInitializationInfoData data, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Iterator<FirPropertySymbol> iterator2;
        ReassignedVariableCollector reassignedVariableCollector;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReassignedVariableCollector $this$analyze_u24lambda_u240 = reassignedVariableCollector = new ReassignedVariableCollector(data);
        boolean bl = false;
        data.getGraph().traverse($this$analyze_u24lambda_u240);
        ReassignedVariableCollector collector2 = reassignedVariableCollector;
        Iterator<FirPropertySymbol> iterator3 = iterator2 = data.getProperties().iterator();
        while (iterator3.hasNext()) {
            boolean canBeVal;
            boolean bl2;
            KtSourceElement source;
            FirPropertySymbol symbol = iterator3.next();
            if (symbol.getSource() == null) continue;
            if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                void $this$fold$iv;
                int n;
                Iterable $this$count$iv = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count = n;
                $this$count$iv = (Iterable)RangesKt.until((int)0, (int)count);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                Iterator iterator4 = $this$fold$iv.iterator();
                while (iterator4.hasNext()) {
                    int element$iv = ((IntIterator)iterator4).nextInt();
                    boolean acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = iterator2.hasNext() && collector2.canBeVal(iterator2.next()) && acc;
                }
                bl2 = accumulator$iv;
            } else {
                bl2 = collector2.canBeVal(symbol);
            }
            if (!(canBeVal = bl2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCAN_BE_VAL(), (DiagnosticContext)context, null, 8, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;)V", "getData", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reassigned", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "canBeVal", "", "symbol", "checkers"})
    @SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1755#2,3:70\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$ReassignedVariableCollector\n*L\n59#1:70,3\n*E\n"})
    private static final class ReassignedVariableCollector
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final PropertyInitializationInfoData data;
        @NotNull
        private final Set<FirPropertySymbol> reassigned;

        public ReassignedVariableCollector(@NotNull PropertyInitializationInfoData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            this.reassigned = new LinkedHashSet();
        }

        @NotNull
        public final PropertyInitializationInfoData getData() {
            return this.data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            block9: {
                Object symbol;
                block10: {
                    boolean bl;
                    block8: {
                        boolean isForInitialization;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                        if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                            return;
                        }
                        symbol = object;
                        if (!((FirPropertySymbol)symbol).isVar()) break block9;
                        KtSourceElement ktSourceElement = ((FirBasedSymbol)symbol).getSource();
                        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind || !this.data.getProperties().contains(symbol)) break block9;
                        boolean bl2 = isForInitialization = this.data.getGraph().getKind() == ControlFlowGraph.Kind.Class || this.data.getGraph().getKind() == ControlFlowGraph.Kind.File;
                        if (!FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol, isForInitialization)) break block10;
                        Iterable $this$any$iv = this.data.getValue(node).values();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PersistentMap it = (PersistentMap)element$iv;
                                boolean bl3 = false;
                                MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)it.get(symbol);
                                boolean bl4 = markedEventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                                if (!bl4) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block9;
                }
                this.reassigned.add((FirPropertySymbol)symbol);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canBeVal(@NotNull FirPropertySymbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            if (!symbol.isVar()) return false;
            if (symbol.getHasDelegate()) return false;
            KtSourceElement ktSourceElement = symbol.getSource();
            if (ktSourceElement == null) return false;
            KtSourceElementKind ktSourceElementKind = ktSourceElement.getKind();
            if (ktSourceElementKind == null) {
                return false;
            }
            boolean bl = ktSourceElementKind instanceof KtFakeSourceElementKind;
            if (bl) return false;
            if (this.reassigned.contains(symbol)) return false;
            return true;
        }
    }
}

