/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousFunctionTypeKinds;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolver;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolverKt;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolutionResult;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeForbiddenIntersection;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOuterClassArgumentsRequired;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeArgumentsForOuterClassWhenNestedReferencedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeArgumentsNotAllowedOnPackageError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeWrongNumberOfTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultStarImportingScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002>?B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000fJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J$\u0010\"\u001a\u0004\u0018\u00010#2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030$2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J*\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&*\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010(\u001a\u00020)H\u0002J2\u0010*\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u00020\u000fH\u0002J\u001e\u00100\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\nH\u0002J$\u00103\u001a\u0004\u0018\u0001042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030$2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J4\u00105\u001a\u0004\u0018\u000104*\b\u0012\u0004\u0012\u000202062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010.\u001a\u0004\u0018\u00010\u00132\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020;H\u0002JB\u0010<\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020=2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "resolveSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "qualifier", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "qualifierResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirQualifierResolver;", "isVisible", "", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "resolveUserTypeToSymbol", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "scopeClassDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "resolveDeprecations", "filterOutAmbiguousTypealiases", "", "candidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "resolveLocalClassChain", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "resolveEnumEntrySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveUserType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "result", "areBareTypesAllowed", "topContainer", "isOperandOfIsOperator", "isPossibleBareType", "allTypeArguments", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "matchQualifierPartsAndClasses", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "addImplicitTypeArgumentsOrReturnError", "", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "createFunctionType", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolutionResult;", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "resolveType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "TypeResolutionResult", "TypeCandidate", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTypeResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeResolverImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,515:1\n1#2:516\n62#3:517\n60#4:518\n38#4:537\n37#5:519\n295#6,2:520\n1368#6:522\n1454#6,5:523\n1628#6,3:528\n1782#6,4:533\n1557#6:538\n1628#6,3:539\n1557#6:542\n1628#6,3:543\n37#7,2:531\n37#7,2:546\n*S KotlinDebug\n*F\n+ 1 FirTypeResolverImpl.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl\n*L\n195#1:517\n227#1:518\n342#1:537\n227#1:519\n229#1:520,2\n251#1:522\n251#1:523,5\n251#1:528,3\n330#1:533,4\n390#1:538\n390#1:539,3\n392#1:542\n392#1:543,3\n259#1:531,2\n423#1:546,2\n*E\n"})
public final class FirTypeResolverImpl
extends FirTypeResolver {
    @NotNull
    private final FirSession session;

    public FirTypeResolverImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    private final FirBasedSymbol<?> resolveSymbol(FirBasedSymbol<?> symbol, List<? extends FirQualifierPart> qualifier, FirQualifierResolver qualifierResolver) {
        FirBasedSymbol firBasedSymbol;
        FirBasedSymbol firBasedSymbol2 = symbol;
        if (firBasedSymbol2 instanceof FirClassLikeSymbol) {
            if (qualifier.size() == 1) {
                firBasedSymbol = symbol;
            } else {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveLocalClassChain((FirClassLikeSymbol)symbol, qualifier);
                if (firRegularClassSymbol != null) {
                    firBasedSymbol = firRegularClassSymbol;
                } else {
                    FirClassifierSymbol<?> firClassifierSymbol = qualifierResolver.resolveSymbolWithPrefix(qualifier, ((FirClassLikeSymbol)symbol).getClassId());
                    firBasedSymbol = firClassifierSymbol != null ? (FirBasedSymbol)firClassifierSymbol : (FirBasedSymbol)this.resolveEnumEntrySymbol(qualifierResolver, qualifier, ((FirClassLikeSymbol)symbol).getClassId());
                }
            }
        } else if (firBasedSymbol2 instanceof FirTypeParameterSymbol) {
            FirBasedSymbol firBasedSymbol3 = symbol;
            FirTypeParameterSymbol it = (FirTypeParameterSymbol)firBasedSymbol3;
            boolean bl = false;
            firBasedSymbol = qualifier.size() == 1 ? firBasedSymbol3 : null;
        } else {
            throw new IllegalStateException("!".toString());
        }
        return firBasedSymbol;
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations, SupertypeSupplier supertypeSupplier) {
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        Object declaration = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return useSiteFile != null && declaration instanceof FirMemberDeclaration ? FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.session), (FirMemberDeclaration)declaration, this.session, useSiteFile, containingDeclarations, null, false, null, false, supertypeSupplier, 192, null) : true;
    }

    @NotNull
    public final TypeResolutionResult resolveUserTypeToSymbol(@NotNull FirUserTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, @Nullable FirFile useSiteFile, @NotNull SupertypeSupplier supertypeSupplier, boolean resolveDeprecations) {
        TypeResolutionResult typeResolutionResult;
        FirClassifierSymbol<?> symbol;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)scopeClassDeclaration, (String)"scopeClassDeclaration");
        Intrinsics.checkNotNullParameter((Object)supertypeSupplier, (String)"supertypeSupplier");
        FirQualifierResolver qualifierResolver = FirQualifierResolverKt.getQualifierResolver(this.session);
        Ref.ObjectRef applicability = new Ref.ObjectRef();
        Set candidates = new LinkedHashSet();
        List<FirQualifierPart> qualifier = typeRef.getQualifier();
        Iterable<FirScope> scopes = scopeClassDeclaration.getScopes();
        List<FirDeclaration> containingDeclarations = scopeClassDeclaration.getContainingDeclarations();
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
        if (firLookupTrackerComponent != null) {
            FirFile firFile = useSiteFile;
            FirLookupTrackerComponentKt.recordUserTypeRefLookup(firLookupTrackerComponent, typeRef, SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence(scopes), FirTypeResolverImpl::resolveUserTypeToSymbol$lambda$1)), firFile != null ? firFile.getSource() : null);
        }
        for (FirScope scope2 : scopes) {
            if (applicability.element == CandidateApplicability.RESOLVED) break;
            Name name2 = ((FirQualifierPart)CollectionsKt.first(qualifier)).getName();
            Function2 processor = (arg_0, arg_1) -> FirTypeResolverImpl.resolveUserTypeToSymbol$lambda$2(this, qualifier, qualifierResolver, useSiteFile, containingDeclarations, supertypeSupplier, resolveDeprecations, applicability, candidates, arg_0, arg_1);
            if (scope2 instanceof FirDefaultStarImportingScope) {
                ((FirDefaultStarImportingScope)scope2).processClassifiersByNameWithSubstitutionFromBothLevelsConditionally(name2, (arg_0, arg_1) -> FirTypeResolverImpl.resolveUserTypeToSymbol$lambda$3(processor, applicability, arg_0, arg_1));
                continue;
            }
            scope2.processClassifiersByNameWithSubstitution(name2, processor);
        }
        if (applicability.element != CandidateApplicability.RESOLVED && (symbol = qualifierResolver.resolveSymbol(qualifier)) != null) {
            FirTypeResolverImpl.resolveUserTypeToSymbol$processCandidate(this, useSiteFile, containingDeclarations, supertypeSupplier, resolveDeprecations, (Ref.ObjectRef<CandidateApplicability>)applicability, candidates, (FirBasedSymbol)symbol, null);
        }
        this.filterOutAmbiguousTypealiases(candidates);
        int candidateCount = candidates.size();
        if (candidateCount == 1) {
            TypeCandidate candidate2 = (TypeCandidate)CollectionsKt.single((Iterable)candidates);
            typeResolutionResult = new TypeResolutionResult.Resolved(candidate2);
        } else if (candidateCount > 1) {
            typeResolutionResult = new TypeResolutionResult.Ambiguity(CollectionsKt.toList((Iterable)candidates));
        } else if (candidateCount == 0) {
            typeResolutionResult = TypeResolutionResult.Unresolved.INSTANCE;
        } else {
            throw new IllegalStateException("Unexpected".toString());
        }
        return typeResolutionResult;
    }

    private final void filterOutAmbiguousTypealiases(Set<TypeCandidate> candidates) {
        if (candidates.size() <= 1) {
            return;
        }
        Set aliasesToRemove = new LinkedHashSet();
        Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity = FirPlatformClassMapperKt.getPlatformClassMapper(this.session).getClassTypealiasesThatDontCauseAmbiguity();
        for (TypeCandidate candidate2 : candidates) {
            ClassId it;
            FirBasedSymbol<?> symbol = candidate2.getSymbol();
            if (!(symbol instanceof FirClassLikeSymbol)) continue;
            if (classTypealiasesThatDontCauseAmbiguity.get(((FirClassLikeSymbol)symbol).getClassId()) == null) continue;
            boolean bl = false;
            aliasesToRemove.add(it);
        }
        if (!((Collection)aliasesToRemove).isEmpty()) {
            CollectionsKt.removeAll((Iterable)candidates, arg_0 -> FirTypeResolverImpl.filterOutAmbiguousTypealiases$lambda$6(aliasesToRemove, arg_0));
        }
    }

    private final FirRegularClassSymbol resolveLocalClassChain(FirClassLikeSymbol<?> symbol, List<? extends FirQualifierPart> qualifier) {
        block3: {
            block2: {
                if (!(symbol instanceof FirRegularClassSymbol)) break block2;
                FirClassLikeSymbol<?> $this$isLocal$iv = symbol;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) break block3;
            }
            return null;
        }
        return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain(qualifier, (FirRegularClassSymbol)symbol, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final FirVariableSymbol<FirEnumEntry> resolveEnumEntrySymbol(FirQualifierResolver $this$resolveEnumEntrySymbol, List<? extends FirQualifierPart> qualifier, ClassId classId) {
        FirEnumEntry enumEntryMatchingLastQualifier;
        Object v2;
        block4: {
            void $this$firstOrNull$iv;
            FirClassifierSymbol<?> firClassifierSymbol = $this$resolveEnumEntrySymbol.resolveSymbolWithPrefix(CollectionsKt.dropLast(qualifier, (int)1), classId);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> enumClassSymbol = firClassifierSymbol;
            Object e = enumClassSymbol.getFir();
            FirRegularClass firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass enumClassFir = firRegularClass;
            FirClass $this$isEnumClass$iv = enumClassFir;
            boolean $i$f$isEnumClass = false;
            Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                return null;
            }
            $this$isEnumClass$iv$iv = enumClassFir.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it).getName(), (Object)((FirQualifierPart)CollectionsKt.last(qualifier)).getName()))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Object var7_7 = v2;
        FirEnumEntry firEnumEntry = enumEntryMatchingLastQualifier = var7_7 instanceof FirEnumEntry ? (FirEnumEntry)var7_7 : null;
        return firEnumEntry != null ? firEnumEntry.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType resolveUserType(FirUserTypeRef typeRef, TypeResolutionResult result2, boolean areBareTypesAllowed, FirDeclaration topContainer, boolean isOperandOfIsOperator) {
        ConeTypeProjection[] resultingArguments;
        Object object;
        FirBasedSymbol symbol;
        block18: {
            block17: {
                void destination$iv;
                ConeDiagnostic $this$mapTo$iv;
                void $this$flatMapTo$iv$iv;
                Pair pair;
                TypeResolutionResult typeResolutionResult = result2;
                if (typeResolutionResult instanceof TypeResolutionResult.Resolved) {
                    pair = TuplesKt.to(((TypeResolutionResult.Resolved)result2).getTypeCandidate().getSymbol(), (Object)((TypeResolutionResult.Resolved)result2).getTypeCandidate().getSubstitutor());
                } else if (typeResolutionResult instanceof TypeResolutionResult.Ambiguity) {
                    pair = TuplesKt.to(null, null);
                } else if (Intrinsics.areEqual((Object)typeResolutionResult, (Object)TypeResolutionResult.Unresolved.INSTANCE)) {
                    pair = TuplesKt.to(null, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Pair pair2 = pair;
                symbol = (FirBasedSymbol)pair2.component1();
                ConeSubstitutor substitutor2 = (ConeSubstitutor)pair2.component2();
                List<FirQualifierPart> qualifier = typeRef.getQualifier();
                Iterable $this$flatMap$iv = CollectionsKt.reversed((Iterable)qualifier);
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FirQualifierPart it = (FirQualifierPart)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getTypeArgumentList().getTypeArguments();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                Collection $i$f$flatMap22 = new ArrayList();
                boolean $i$f$mapTo = false;
                destination$iv$iv = $this$mapTo$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    void it;
                    Object item$iv = destination$iv$iv.next();
                    object = (FirTypeProjection)item$iv;
                    void var20_31 = destination$iv;
                    boolean bl = false;
                    var20_31.add(FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)it));
                }
                List allTypeArguments = (List)destination$iv;
                if (symbol instanceof FirClassLikeSymbol && !this.isPossibleBareType(areBareTypesAllowed, allTypeArguments)) {
                    $this$mapTo$iv = this.matchQualifierPartsAndClasses((FirClassLikeSymbol)symbol, qualifier);
                    if ($this$mapTo$iv != null) {
                        ConeDiagnostic it = $this$mapTo$iv;
                        boolean bl = false;
                        return new ConeErrorType(it, false, null, null, null, 30, null);
                    }
                    $this$mapTo$iv = this.addImplicitTypeArgumentsOrReturnError(allTypeArguments, (FirClassLikeSymbol)symbol, topContainer, substitutor2);
                    if ($this$mapTo$iv != null) {
                        ConeDiagnostic it = $this$mapTo$iv;
                        boolean bl = false;
                        return new ConeErrorType(it, false, null, null, null, 30, null);
                    }
                }
                Collection $this$toTypedArray$iv = allTypeArguments;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                resultingArguments = thisCollection$iv.toArray(new ConeTypeProjection[0]);
                if (symbol == null) break block17;
                if (symbol instanceof FirClassifierSymbol) break block18;
            }
            FirBasedSymbol firBasedSymbol = symbol;
            ConeDiagnostic diagnostic = (firBasedSymbol != null ? firBasedSymbol.getFir() : null) instanceof FirEnumEntry ? (ConeDiagnostic)(isOperandOfIsOperator ? new ConeSimpleDiagnostic("'is' operator can not be applied to an enum entry.", DiagnosticKind.IsEnumEntry) : new ConeSimpleDiagnostic("An enum entry should not be used as a type.", DiagnosticKind.EnumEntryAsType)) : (result2 instanceof TypeResolutionResult.Ambiguity ? (ConeDiagnostic)new ConeAmbiguityError(((FirQualifierPart)CollectionsKt.last(typeRef.getQualifier())).getName(), ((TypeCandidate)CollectionsKt.first(((TypeResolutionResult.Ambiguity)result2).getTypeCandidates())).getApplicability(), (Collection<? extends AbstractCandidate>)((TypeResolutionResult.Ambiguity)result2).getTypeCandidates()) : (ConeDiagnostic)new ConeUnresolvedTypeQualifierError(typeRef.getQualifier(), typeRef.isMarkedNullable()));
            return new ConeErrorType(diagnostic, false, null, resultingArguments, CopyUtilsKt.computeTypeAttributes$default(typeRef.getAnnotations(), this.session, null, false, true, 6, null), 6, null);
        }
        if (symbol instanceof FirTypeParameterSymbol) {
            for (FirQualifierPart part : typeRef.getQualifier()) {
                if (!(!((Collection)part.getTypeArgumentList().getTypeArguments()).isEmpty())) continue;
                return new ConeErrorType(new ConeUnexpectedTypeArgumentsError("Type arguments not allowed for type parameters", part.getTypeArgumentList().getSource()), false, null, resultingArguments, null, 22, null);
            }
        }
        Object object2 = typeRef.getAnnotations();
        FirSession part = this.session;
        object = ((FirClassifierSymbol)symbol).toLookupTag();
        ConeClassLikeLookupTag coneClassLikeLookupTag = object instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)object : null;
        boolean thisCollection$iv = coneClassLikeLookupTag != null ? FunctionalTypeUtilsKt.isSomeFunctionType(coneClassLikeLookupTag, this.session) : false;
        Object it = object2 = TypeConstructionUtilsKt.constructType((FirClassifierSymbol)symbol, resultingArguments, typeRef.isMarkedNullable(), CopyUtilsKt.computeTypeAttributes$default((List)object2, part, null, thisCollection$iv, true, 2, null));
        boolean bl = false;
        ConeClassifierLookupTag lookupTag = ((ConeLookupTagBasedType)it).getLookupTag();
        if (lookupTag instanceof ConeClassLikeLookupTagImpl && symbol instanceof FirClassLikeSymbol) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)lookupTag, this.session, (FirClassLikeSymbol)symbol);
        }
        return (ConeKotlinType)object2;
    }

    private final boolean isPossibleBareType(boolean areBareTypesAllowed, List<? extends ConeTypeProjection> allTypeArguments) {
        return areBareTypesAllowed && allTypeArguments.isEmpty();
    }

    private final ConeDiagnostic matchQualifierPartsAndClasses(FirClassLikeSymbol<?> symbol, List<? extends FirQualifierPart> qualifier) {
        FirClassLikeDeclaration currentDeclaration = (FirClassLikeDeclaration)symbol.getFir();
        boolean areTypeArgumentsAllowed = true;
        for (FirQualifierPart qualifierPart : CollectionsKt.asReversed(qualifier)) {
            int desiredTypeParametersCount;
            int n;
            FirTypeArgumentList typeArgumentList = qualifierPart.getTypeArgumentList();
            int qualifierPartArgsCount = typeArgumentList.getTypeArguments().size();
            if (currentDeclaration == null) {
                if (qualifierPartArgsCount <= 0) break;
                KtSourceElement ktSourceElement = typeArgumentList.getSource();
                Intrinsics.checkNotNull((Object)ktSourceElement);
                return new ConeTypeArgumentsNotAllowedOnPackageError(ktSourceElement);
            }
            Iterable $this$count$iv = currentDeclaration.getTypeParameters();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof FirOuterClassTypeParameterRef)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = desiredTypeParametersCount = count$iv;
            }
            if (areTypeArgumentsAllowed) {
                if (desiredTypeParametersCount != qualifierPartArgsCount) {
                    KtSourceElement source = qualifierPartArgsCount == 0 ? qualifierPart.getSource() : typeArgumentList.getSource();
                    FirClassLikeSymbol<FirClassLikeDeclaration> firClassLikeSymbol = currentDeclaration.getSymbol();
                    KtSourceElement ktSourceElement = source;
                    Intrinsics.checkNotNull((Object)ktSourceElement);
                    return new ConeWrongNumberOfTypeArgumentsError(desiredTypeParametersCount, firClassLikeSymbol, ktSourceElement);
                }
            } else if (qualifierPartArgsCount > 0) {
                KtSourceElement ktSourceElement = typeArgumentList.getSource();
                Intrinsics.checkNotNull((Object)ktSourceElement);
                return new ConeTypeArgumentsForOuterClassWhenNestedReferencedError(ktSourceElement);
            }
            FirMemberDeclaration $this$isInner$iv = currentDeclaration;
            boolean $i$f$isInner = false;
            areTypeArgumentsAllowed = $this$isInner$iv.getStatus().isInner();
            currentDeclaration = DeclarationUtilsKt.getContainingDeclaration(currentDeclaration, this.session);
        }
        return null;
    }

    private final ConeDiagnostic addImplicitTypeArgumentsOrReturnError(List<ConeTypeProjection> $this$addImplicitTypeArgumentsOrReturnError, FirClassLikeSymbol<?> symbol, FirDeclaration topContainer, ConeSubstitutor substitutor2) {
        int explicitTypeArgumentsNumber = $this$addImplicitTypeArgumentsOrReturnError.size();
        Iterator iterator2 = ((Iterable)((FirClassLikeDeclaration)symbol.getFir()).getTypeParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int typeParameterIndex = n++;
            FirTypeParameterRef typeParameter = (FirTypeParameterRef)iterator2.next();
            if (typeParameterIndex < explicitTypeArgumentsNumber) continue;
            if (!(typeParameter instanceof FirOuterClassTypeParameterRef) || DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(((FirOuterClassTypeParameterRef)typeParameter).getSymbol(), topContainer, this.session)) {
                ConeKotlinType substituted;
                ConeSubstitutor coneSubstitutor = substitutor2;
                ConeKotlinType coneKotlinType = substituted = coneSubstitutor != null ? coneSubstitutor.substituteOrNull(ResolveUtilsKt.getDefaultType(typeParameter.getSymbol())) : null;
                if (substituted == null) {
                    FirBasedSymbol<?> firBasedSymbol = typeParameter.getSymbol().getContainingDeclarationSymbol();
                    Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol<*>");
                    return new ConeOuterClassArgumentsRequired((FirClassLikeSymbol)firBasedSymbol);
                }
                $this$addImplicitTypeArgumentsOrReturnError.add(substituted);
                continue;
            }
            FirBasedSymbol<?> firBasedSymbol = ((FirOuterClassTypeParameterRef)typeParameter).getSymbol().getContainingDeclarationSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol<*>");
            return new ConeOuterClassArgumentsRequired((FirClassLikeSymbol)firBasedSymbol);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeResolutionResult createFunctionType(FirFunctionTypeRef typeRef) {
        void $this$createFunctionType_u24lambda_u2416;
        FunctionTypeKind functionTypeKind;
        Iterable<FirAnnotation> iterable;
        FirFunctionTypeParameter it;
        List<FirAnnotation> list;
        Object item$iv$iv2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = typeRef.getContextReceiverTypeRefs();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        List<FirAnnotation> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv2;
            list = destination$iv$iv;
            boolean bl = false;
            list.add((FirAnnotation)((Object)FirTypeUtilsKt.getConeType((FirTypeRef)((Object)it))));
        }
        FirTypeRef firTypeRef = typeRef.getReceiverTypeRef();
        $this$map$iv = typeRef.getParameters();
        list = CollectionsKt.plus((Collection)destination$iv$iv, (Iterable)CollectionsKt.listOfNotNull((Object)(firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null)));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            it = (FirFunctionTypeParameter)item$iv$iv2;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add((FirAnnotation)((Object)LookupTagUtilsKt.withParameterNameAnnotation(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), it, this.session)));
        }
        List parameters = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)list, (Iterable)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)FirTypeUtilsKt.getConeType(typeRef.getReturnTypeRef())));
        List<FunctionTypeKind> functionKinds = FirFunctionTypeKindServiceKt.getFunctionTypeService(this.session).extractAllSpecialKindsForFunctionTypeRef(typeRef);
        ConeDiagnostic diagnostic = null;
        switch (functionKinds.size()) {
            case 0: {
                functionTypeKind = FunctionTypeKind.Function.INSTANCE;
                break;
            }
            case 1: {
                functionTypeKind = (FunctionTypeKind)CollectionsKt.single(functionKinds);
                break;
            }
            default: {
                diagnostic = new ConeAmbiguousFunctionTypeKinds(functionKinds);
                functionTypeKind = FunctionTypeKind.Function.INSTANCE;
            }
        }
        FunctionTypeKind kind = functionTypeKind;
        ClassId classId = kind.numberedClassId(FirTypeUtilsKt.getParametersCount(typeRef));
        List list2 = CollectionsKt.createListBuilder();
        item$iv$iv2 = list2;
        iterable = this.session;
        list = typeRef.getAnnotations();
        boolean bl = false;
        if (typeRef.getReceiverTypeRef() != null) {
            $this$createFunctionType_u24lambda_u2416.add(CompilerConeAttributes.ExtensionFunctionType.INSTANCE);
        }
        if (!((Collection)typeRef.getContextReceiverTypeRefs()).isEmpty()) {
            $this$createFunctionType_u24lambda_u2416.add(new CompilerConeAttributes.ContextFunctionTypeParams(typeRef.getContextReceiverTypeRefs().size()));
        }
        Unit unit = Unit.INSTANCE;
        ConeAttributes attributes = CopyUtilsKt.computeTypeAttributes$default(list, iterable, CollectionsKt.build((List)list2), false, true, 4, null);
        Collection $this$toTypedArray$iv = parameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FirTypeResolutionResult(new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(classId), thisCollection$iv.toArray(new ConeKotlinType[0]), typeRef.isMarkedNullable(), attributes), diagnostic);
    }

    @Override
    @NotNull
    public FirTypeResolutionResult resolveType(@NotNull FirTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, boolean areBareTypesAllowed, boolean isOperandOfIsOperator, boolean resolveDeprecations, @Nullable FirFile useSiteFile, @NotNull SupertypeSupplier supertypeSupplier) {
        Object object;
        block10: {
            FirTypeResolutionResult firTypeResolutionResult;
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            Intrinsics.checkNotNullParameter((Object)scopeClassDeclaration, (String)"scopeClassDeclaration");
            Intrinsics.checkNotNullParameter((Object)supertypeSupplier, (String)"supertypeSupplier");
            object = typeRef;
            if (object instanceof FirResolvedTypeRef) {
                throw new IllegalStateException("Do not resolve, resolved type-refs".toString());
            }
            if (object instanceof FirUserTypeRef) {
                TypeResolutionResult result2 = this.resolveUserTypeToSymbol((FirUserTypeRef)typeRef, scopeClassDeclaration, useSiteFile, supertypeSupplier, resolveDeprecations);
                FirUserTypeRef firUserTypeRef = (FirUserTypeRef)typeRef;
                FirDeclaration firDeclaration = scopeClassDeclaration.getTopContainer();
                if (firDeclaration == null) {
                    firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(scopeClassDeclaration.getContainingDeclarations());
                }
                ConeKotlinType resolvedType = this.resolveUserType(firUserTypeRef, result2, areBareTypesAllowed, firDeclaration, isOperandOfIsOperator);
                Object object2 = result2 instanceof TypeResolutionResult.Resolved ? (TypeResolutionResult.Resolved)result2 : null;
                firTypeResolutionResult = new FirTypeResolutionResult(resolvedType, object2 != null && (object2 = ((TypeResolutionResult.Resolved)object2).getTypeCandidate()) != null ? ((TypeCandidate)object2).getDiagnostic() : null);
            } else if (object instanceof FirFunctionTypeRef) {
                firTypeResolutionResult = this.createFunctionType((FirFunctionTypeRef)typeRef);
            } else if (object instanceof FirDynamicTypeRef) {
                ConeAttributes attributes = CopyUtilsKt.computeTypeAttributes$default(((FirDynamicTypeRef)typeRef).getAnnotations(), this.session, null, false, true, 6, null);
                firTypeResolutionResult = new FirTypeResolutionResult(TypeUtilsKt.create(ConeDynamicType.Companion, this.session, attributes), null);
            } else if (object instanceof FirIntersectionTypeRef) {
                ConeKotlinType leftType = FirTypeUtilsKt.getConeType(((FirIntersectionTypeRef)typeRef).getLeftType());
                firTypeResolutionResult = leftType instanceof ConeTypeParameterType ? new FirTypeResolutionResult(new ConeDefinitelyNotNullType((ConeSimpleKotlinType)leftType), null) : new FirTypeResolutionResult(new ConeErrorType(ConeForbiddenIntersection.INSTANCE, false, null, null, null, 30, null), null);
            } else {
                throw new IllegalStateException(UtilsKt.render(typeRef).toString());
            }
            Object it = object = firTypeResolutionResult;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent == null) break block10;
            FirFile firFile = useSiteFile;
            FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, ((FirTypeResolutionResult)it).getType(), ((FirTypeRefWithNullability)typeRef).getSource(), firFile != null ? firFile.getSource() : null);
        }
        return object;
    }

    private static final void resolveUserTypeToSymbol$processCandidate(FirTypeResolverImpl this$0, FirFile $useSiteFile, List<? extends FirDeclaration> containingDeclarations, SupertypeSupplier $supertypeSupplier, boolean $resolveDeprecations, Ref.ObjectRef<CandidateApplicability> applicability, Set<TypeCandidate> candidates, FirBasedSymbol<?> symbol, ConeSubstitutor substitutor2) {
        ConeDiagnostic diagnostic;
        CandidateApplicability symbolApplicability;
        block7: {
            block6: {
                symbolApplicability = CandidateApplicability.RESOLVED;
                diagnostic = null;
                if (!this$0.isVisible(symbol, $useSiteFile, containingDeclarations, $supertypeSupplier)) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Comparable)((Object)CandidateApplicability.K2_VISIBILITY_ERROR)), (Comparable)((Comparable)((Object)symbolApplicability))));
                    diagnostic = new ConeVisibilityError(symbol);
                }
                if ($resolveDeprecations && DeprecationUtilsKt.isDeprecationLevelHidden(symbol, this$0.session)) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Comparable)((Object)CandidateApplicability.HIDDEN)), (Comparable)((Comparable)((Object)symbolApplicability))));
                    diagnostic = null;
                }
                if (applicability.element == null) break block6;
                Object object = applicability.element;
                Intrinsics.checkNotNull((Object)object);
                if (symbolApplicability.compareTo((Enum)object) <= 0) break block7;
            }
            applicability.element = symbolApplicability;
            candidates.clear();
        }
        if (symbolApplicability == applicability.element) {
            candidates.add(new TypeCandidate(symbol, substitutor2, diagnostic, symbolApplicability));
        }
    }

    private static final Iterable resolveUserTypeToSymbol$lambda$1(FirScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getScopeOwnerLookupNames();
    }

    private static final Unit resolveUserTypeToSymbol$lambda$2(FirTypeResolverImpl this$0, List $qualifier, FirQualifierResolver $qualifierResolver, FirFile $useSiteFile, List $containingDeclarations, SupertypeSupplier $supertypeSupplier, boolean $resolveDeprecations, Ref.ObjectRef $applicability, Set $candidates, FirClassifierSymbol symbol, ConeSubstitutor substitutorFromScope) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutorFromScope, (String)"substitutorFromScope");
        FirBasedSymbol<?> resolvedSymbol = this$0.resolveSymbol(symbol, $qualifier, $qualifierResolver);
        if (resolvedSymbol != null) {
            FirTypeResolverImpl.resolveUserTypeToSymbol$processCandidate(this$0, $useSiteFile, $containingDeclarations, $supertypeSupplier, $resolveDeprecations, (Ref.ObjectRef<CandidateApplicability>)$applicability, $candidates, resolvedSymbol, substitutorFromScope);
        }
        return Unit.INSTANCE;
    }

    private static final boolean resolveUserTypeToSymbol$lambda$3(Function2 $processor, Ref.ObjectRef $applicability, FirClassifierSymbol symbol, ConeSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        $processor.invoke((Object)symbol, (Object)substitutor2);
        return $applicability.element == CandidateApplicability.RESOLVED;
    }

    private static final boolean filterOutAmbiguousTypealiases$lambda$6(Set $aliasesToRemove, TypeCandidate it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
        Object object = firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
        if (object != null && (object = ((FirClassLikeSymbol)object).getClassId()) != null) {
            Object classId = object;
            boolean bl2 = false;
            bl = $aliasesToRemove.contains(classId);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final FirRegularClassSymbol resolveLocalClassChain$resolveLocalClassChain(List<? extends FirQualifierPart> $qualifier, FirRegularClassSymbol classSymbol, int qualifierIndex) {
        if (qualifierIndex == $qualifier.size()) {
            return classSymbol;
        }
        Name qualifierName = $qualifier.get(qualifierIndex).getName();
        for (FirBasedSymbol<?> declarationSymbol : classSymbol.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirRegularClassSymbol) || !Intrinsics.areEqual((Object)((FirRegularClassSymbol)declarationSymbol).toLookupTag().getName(), (Object)qualifierName)) continue;
            return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain($qualifier, (FirRegularClassSymbol)declarationSymbol, qualifierIndex + 1);
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCandidate;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "applicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getSubstitutor", "()Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getDispatchReceiver", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "chosenExtensionReceiver", "getChosenExtensionReceiver", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "getExplicitReceiverKind", "()Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "diagnostics", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "getDiagnostics", "()Ljava/util/List;", "errors", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintSystemError;", "getErrors", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCallInfo;", "getCallInfo", "()Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCallInfo;", "equals", "", "other", "", "hashCode", "", "resolve"})
    public static final class TypeCandidate
    extends AbstractCandidate {
        @NotNull
        private final FirBasedSymbol<?> symbol;
        @Nullable
        private final ConeSubstitutor substitutor;
        @Nullable
        private final ConeDiagnostic diagnostic;
        @NotNull
        private final CandidateApplicability applicability;

        public TypeCandidate(@NotNull FirBasedSymbol<?> symbol, @Nullable ConeSubstitutor substitutor2, @Nullable ConeDiagnostic diagnostic, @NotNull CandidateApplicability applicability) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)((Object)applicability), (String)"applicability");
            this.symbol = symbol;
            this.substitutor = substitutor2;
            this.diagnostic = diagnostic;
            this.applicability = applicability;
        }

        @Override
        @NotNull
        public FirBasedSymbol<?> getSymbol() {
            return this.symbol;
        }

        @Nullable
        public final ConeSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        @Nullable
        public final ConeDiagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public CandidateApplicability getApplicability() {
            return this.applicability;
        }

        @Override
        @Nullable
        public FirExpression getDispatchReceiver() {
            return null;
        }

        @Override
        @Nullable
        public FirExpression getChosenExtensionReceiver() {
            return null;
        }

        @Override
        @NotNull
        public ExplicitReceiverKind getExplicitReceiverKind() {
            return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
        }

        @Override
        @NotNull
        public List<ResolutionDiagnostic> getDiagnostics() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public List<ConstraintSystemError> getErrors() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public AbstractCallInfo getCallInfo() {
            AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
            throw null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeCandidate)) {
                return false;
            }
            return Intrinsics.areEqual(this.getSymbol(), ((TypeCandidate)other).getSymbol());
        }

        public int hashCode() {
            return this.getSymbol().hashCode();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "", "<init>", "()V", "Ambiguity", "Unresolved", "Resolved", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Unresolved;", "resolve"})
    public static abstract class TypeResolutionResult {
        private TypeResolutionResult() {
        }

        public /* synthetic */ TypeResolutionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "typeCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "<init>", "(Ljava/util/List;)V", "getTypeCandidates", "()Ljava/util/List;", "resolve"})
        public static final class Ambiguity
        extends TypeResolutionResult {
            @NotNull
            private final List<TypeCandidate> typeCandidates;

            public Ambiguity(@NotNull List<TypeCandidate> typeCandidates) {
                Intrinsics.checkNotNullParameter(typeCandidates, (String)"typeCandidates");
                super(null);
                this.typeCandidates = typeCandidates;
            }

            @NotNull
            public final List<TypeCandidate> getTypeCandidates() {
                return this.typeCandidates;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "typeCandidate", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;)V", "getTypeCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeCandidate;", "resolve"})
        public static final class Resolved
        extends TypeResolutionResult {
            @NotNull
            private final TypeCandidate typeCandidate;

            public Resolved(@NotNull TypeCandidate typeCandidate) {
                Intrinsics.checkNotNullParameter((Object)typeCandidate, (String)"typeCandidate");
                super(null);
                this.typeCandidate = typeCandidate;
            }

            @NotNull
            public final TypeCandidate getTypeCandidate() {
                return this.typeCandidate;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult$Unresolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$TypeResolutionResult;", "<init>", "()V", "resolve"})
        public static final class Unresolved
        extends TypeResolutionResult {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }
        }
    }
}

