/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.mpp.PropertySymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u0013\u0010$\u001a\u0004\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u0004\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0011\u0010-\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/mpp/PropertySymbolMarker;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)V", "isLocal", "", "()Z", "getterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertyAccessorSymbol;", "getGetterSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertyAccessorSymbol;", "setterSymbol", "getSetterSymbol", "backingFieldSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirBackingFieldSymbol;", "getBackingFieldSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirBackingFieldSymbol;", "delegateFieldSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirDelegateFieldSymbol;", "getDelegateFieldSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirDelegateFieldSymbol;", "delegate", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getDelegate", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "hasDelegate", "getHasDelegate", "hasInitializer", "getHasInitializer", "initializerSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "getInitializerSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "getControlFlowGraphReference", "()Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "isVal", "isVar", "tree"})
public class FirPropertySymbol
extends FirVariableSymbol<FirProperty>
implements PropertySymbolMarker {
    public FirPropertySymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        super(callableId, null);
    }

    public FirPropertySymbol(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this(new CallableId(name2));
    }

    public final boolean isLocal() {
        return ((FirProperty)this.getFir()).isLocal();
    }

    @Nullable
    public FirPropertyAccessorSymbol getGetterSymbol() {
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)this.getFir()).getGetter();
        return firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
    }

    @Nullable
    public FirPropertyAccessorSymbol getSetterSymbol() {
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)this.getFir()).getSetter();
        return firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
    }

    @Nullable
    public final FirBackingFieldSymbol getBackingFieldSymbol() {
        FirBackingField firBackingField = ((FirProperty)this.getFir()).getBackingField();
        return firBackingField != null ? firBackingField.getSymbol() : null;
    }

    @Nullable
    public final FirDelegateFieldSymbol getDelegateFieldSymbol() {
        return ((FirProperty)this.getFir()).getDelegateFieldSymbol();
    }

    @Nullable
    public final FirExpression getDelegate() {
        return ((FirProperty)this.getFir()).getDelegate();
    }

    public final boolean getHasDelegate() {
        return ((FirProperty)this.getFir()).getDelegate() != null;
    }

    public final boolean getHasInitializer() {
        return ((FirProperty)this.getFir()).getInitializer() != null;
    }

    @Nullable
    public final KtSourceElement getInitializerSource() {
        FirExpression firExpression = ((FirProperty)this.getFir()).getInitializer();
        return firExpression != null ? firExpression.getSource() : null;
    }

    @Nullable
    public final FirControlFlowGraphReference getControlFlowGraphReference() {
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirProperty)this.getFir()).getControlFlowGraphReference();
    }

    public final boolean isVal() {
        return ((FirProperty)this.getFir()).isVal();
    }

    public final boolean isVar() {
        return ((FirProperty)this.getFir()).isVar();
    }
}

