/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ScopeStack;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011BQ\u0012:\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003j\u0002`\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004RB\u0010\u0002\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003j\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator;", "", "reportError", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ParameterName;", "name", "element", "", "message", "", "Lorg/jetbrains/kotlin/backend/common/ReportError;", "parentChain", "", "<init>", "(Lkotlin/jvm/functions/Function2;Ljava/util/List;)V", "check", "Checker", "ir.backend.common"})
public final class IrTypeParameterScopeValidator {
    @NotNull
    private final Function2<IrElement, String, Unit> reportError;
    @NotNull
    private final List<IrElement> parentChain;

    public IrTypeParameterScopeValidator(@NotNull Function2<? super IrElement, ? super String, Unit> reportError, @NotNull List<IrElement> parentChain) {
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Intrinsics.checkNotNullParameter(parentChain, (String)"parentChain");
        this.reportError = reportError;
        this.parentChain = parentChain;
    }

    public final void check(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptVoid(element, new Checker());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J)\u0010\u0014\u001a\u0002H\u0015\"\n\b\u0000\u0010\u0015*\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeTransformerVoid;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator;)V", "scopeStack", "Lorg/jetbrains/kotlin/backend/common/ScopeStack;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "checkTypeParameterReference", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "typeParameterSymbol", "visitTypeAccess", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "withTypeParametersInScope", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "block", "Lkotlin/Function0;", "transformType", "Type", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;", "visitElement", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nIrTypeParameterScopeValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeParameterScopeValidator.kt\norg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker\n+ 2 Utils.kt\norg/jetbrains/kotlin/backend/common/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n24#2,6:97\n1863#3,2:103\n*S KotlinDebug\n*F\n+ 1 IrTypeParameterScopeValidator.kt\norg/jetbrains/kotlin/backend/common/IrTypeParameterScopeValidator$Checker\n*L\n73#1:97,6\n60#1:103,2\n*E\n"})
    private final class Checker
    extends IrTypeTransformerVoid {
        @NotNull
        private final ScopeStack<IrTypeParameterSymbol> scopeStack = new ScopeStack();

        private final void checkTypeParameterReference(IrElement element, IrTypeParameterSymbol typeParameterSymbol) {
            if (!this.scopeStack.isVisibleInCurrentScope(typeParameterSymbol)) {
                IrTypeParameterScopeValidator.this.reportError.invoke((Object)element, (Object)("The following element references a type parameter '" + RenderIrElementKt.render$default((IrElement)typeParameterSymbol.getOwner(), null, 1, null) + "' that is not available in the current scope."));
            }
        }

        private final void visitTypeAccess(IrElement element, IrType type2) {
            if (!(type2 instanceof IrSimpleType)) {
                return;
            }
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)type2).getClassifier();
            IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
            if (irTypeParameterSymbol != null) {
                IrTypeParameterSymbol it = irTypeParameterSymbol;
                boolean bl = false;
                this.checkTypeParameterReference(element, it);
            }
            for (IrTypeArgument arg : ((IrSimpleType)type2).getArguments()) {
                if (!(arg instanceof IrTypeProjection)) continue;
                this.visitTypeAccess(element, ((IrTypeProjection)arg).getType());
            }
        }

        private final void withTypeParametersInScope(IrTypeParametersContainer container, Function0<Unit> block) {
            ScopeStack.withNewScope$default(this.scopeStack, false, container instanceof IrClass && !((IrClass)container).isInner() && !Intrinsics.areEqual((Object)((IrClass)container).getVisibility(), (Object)DescriptorVisibilities.LOCAL), arg_0 -> Checker.withTypeParametersInScope$lambda$2(container, arg_0), block, 1, null);
        }

        @Override
        public <Type extends IrType> Type transformType(@NotNull IrElement container, Type type2) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (type2 != null) {
                this.visitTypeAccess(container, type2);
            }
            return type2;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List $this$temporarilyPushing$iv = IrTypeParameterScopeValidator.this.parentChain;
            boolean $i$f$temporarilyPushing = false;
            UtilsKt.push($this$temporarilyPushing$iv, element);
            IrElement it = element;
            boolean bl = false;
            IrVisitorsKt.acceptChildrenVoid(element, this);
            Unit result$iv = Unit.INSTANCE;
            UtilsKt.pop($this$temporarilyPushing$iv);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.withTypeParametersInScope(declaration, (Function0<Unit>)((Function0)() -> Checker.visitFunction$lambda$4(this, declaration)));
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.withTypeParametersInScope(declaration, (Function0<Unit>)((Function0)() -> Checker.visitClass$lambda$5(this, declaration)));
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.withTypeParametersInScope(declaration, (Function0<Unit>)((Function0)() -> Checker.visitTypeAlias$lambda$6(this, declaration)));
        }

        private static final Unit withTypeParametersInScope$lambda$2(IrTypeParametersContainer $container, Set $this$withNewScope) {
            Intrinsics.checkNotNullParameter((Object)$this$withNewScope, (String)"$this$withNewScope");
            Iterable $this$forEach$iv = $container.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeParameter it = (IrTypeParameter)element$iv;
                boolean bl = false;
                $this$withNewScope.add(it.getSymbol());
            }
            return Unit.INSTANCE;
        }

        private static final Unit visitFunction$lambda$4(Checker this$0, IrFunction $declaration) {
            super.visitFunction($declaration);
            return Unit.INSTANCE;
        }

        private static final Unit visitClass$lambda$5(Checker this$0, IrClass $declaration) {
            super.visitClass($declaration);
            return Unit.INSTANCE;
        }

        private static final Unit visitTypeAlias$lambda$6(Checker this$0, IrTypeAlias $declaration) {
            super.visitTypeAlias($declaration);
            return Unit.INSTANCE;
        }
    }
}

