/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalClasses;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.MainMethodGenerationLowering;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="InventNamesForLocalClasses", description="Invent names for local classes and anonymous objects", prerequisite={MainMethodGenerationLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClasses;", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "sanitizeNameIfNeeded", "name", "putLocalClassName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "backend.jvm.lower"})
public final class JvmInventNamesForLocalClasses
extends InventNamesForLocalClasses {
    @NotNull
    private final JvmBackendContext context;

    public JvmInventNamesForLocalClasses(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(false, 1, null);
        this.context = context;
    }

    @Override
    @NotNull
    protected String computeTopLevelClassName(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        IrDeclarationParent irDeclarationParent = clazz.getParent();
        IrFile irFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        if (irFile == null) {
            throw new AssertionError((Object)("Top-level class expected: " + RenderIrElementKt.render$default(clazz, null, 1, null)));
        }
        IrFile file2 = irFile;
        FqName classFqn = Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFILE_CLASS()) || Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.Companion.getSYNTHETIC_FILE_CLASS()) ? FileClassLoweringKt.getFileClassInfo(file2).getFileClassFqName() : file2.getPackageFqName().child(clazz.getName());
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(classFqn).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        return string2;
    }

    @Override
    @NotNull
    protected String sanitizeNameIfNeeded(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string2 = JvmCodegenUtil.sanitizeNameIfNeeded(name2, this.context.getConfig().getLanguageVersionSettings());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeNameIfNeeded(...)");
        return string2;
    }

    @Override
    protected void putLocalClassName(@NotNull IrAttributeContainer declaration, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)localClassName, (String)"localClassName");
        if (JvmIrAttributesKt.getLocalClassType(declaration) != null) {
            return;
        }
        JvmIrAttributesKt.setLocalClassType(declaration, Type.getObjectType(localClassName));
    }
}

