/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.linkage.issues.ChecksKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SimpleNamedCompilerPhase;
import org.jetbrains.kotlin.backend.wasm.DebugInformation;
import org.jetbrains.kotlin.backend.wasm.LoweredIrWithExtraArtifacts;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.export.ExportModelGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsHelpersKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.SourceMapGenerator;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelToTsDeclarations;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.TypeScriptFragment;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aP\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001ag\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00102\b\b\u0002\u0010\u001e\u001a\u00020\u00102\b\b\u0002\u0010\u001f\u001a\u00020\u00102\b\b\u0002\u0010 \u001a\u00020\u00102\b\b\u0002\u0010!\u001a\u00020\u0010\u00a2\u0006\u0004\b\"\u0010#\u001a\u0012\u0010$\u001a\u00020\u001c*\u00020%2\u0006\u0010&\u001a\u00020\u001c\u001a(\u0010'\u001a\u00020\u001c*\u00020%2\u0006\u0010&\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\r2\u0006\u0010*\u001a\u00020\u0010\u001a(\u0010+\u001a\u00020\u001c*\u00020%2\u0006\u0010,\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0-2\u0006\u0010.\u001a\u00020\u0010\u001a&\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0010\u001a\n\u00105\u001a\u00020\u001c*\u00020%\u00a8\u00066"}, d2={"compileToLoweredIr", "Lorg/jetbrains/kotlin/backend/wasm/LoweredIrWithExtraArtifacts;", "irModuleInfo", "Lorg/jetbrains/kotlin/ir/backend/js/IrModuleInfo;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateTypeScriptFragment", "", "propertyLazyInitialization", "compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "allModules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "typeScriptFragment", "Lorg/jetbrains/kotlin/ir/backend/js/export/TypeScriptFragment;", "baseFileName", "", "emitNameSection", "allowIncompleteImplementations", "generateWat", "generateSourceMaps", "useDebuggerCustomFormatters", "compileWasm-2S3SmqY", "(Ljava/util/List;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Ljava/lang/String;Ljava/lang/String;ZZZZZ)Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "generateAsyncWasiWrapper", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "wasmFilePath", "generateAsyncJsWrapper", "jsModuleAndQualifierReferences", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/JsModuleAndQualifierReference;", "useJsTag", "generateEsmExportsWrapper", "asyncWrapperFileName", "", "useCustomFormatters", "writeCompilationResult", "", "result", "dir", "Ljava/io/File;", "fileNameBase", "generateExports", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nwasmCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 wasmCompiler.kt\norg/jetbrains/kotlin/backend/wasm/WasmCompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n1863#2,2:481\n1863#2,2:483\n1872#2,2:486\n1863#2,2:488\n1874#2:490\n1863#2,2:491\n1863#2,2:493\n1557#2:497\n1628#2,3:498\n1557#2:501\n1628#2,3:502\n774#2:505\n865#2,2:506\n1557#2:508\n1628#2,3:509\n1663#2,8:512\n1053#2:520\n827#2:521\n855#2,2:522\n227#3:485\n227#3:495\n227#3:496\n189#3:524\n1#4:525\n*S KotlinDebug\n*F\n+ 1 wasmCompiler.kt\norg/jetbrains/kotlin/backend/wasm/WasmCompilerKt\n*L\n82#1:481,2\n88#1:483,2\n109#1:486,2\n110#1:488,2\n109#1:490\n139#1:491,2\n140#1:493,2\n244#1:497\n244#1:498,3\n373#1:501\n373#1:502,3\n380#1:505\n380#1:506,2\n381#1:508\n381#1:509,3\n392#1:512,8\n394#1:520\n462#1:521\n462#1:522,2\n98#1:485\n142#1:495\n145#1:496\n463#1:524\n*E\n"})
public final class WasmCompilerKt {
    @NotNull
    public static final LoweredIrWithExtraArtifacts compileToLoweredIr(@NotNull IrModuleInfo irModuleInfo, @NotNull MainModule mainModule, @NotNull CompilerConfiguration configuration2, @Nullable CommonCompilerPerformanceManager performanceManager2, @NotNull PhaseConfig phaseConfig, @NotNull Set<FqName> exportedDeclarations, boolean generateTypeScriptFragment, boolean propertyLazyInitialization) {
        String typeScriptFragment;
        WasmBackendContext context;
        List allModules;
        block16: {
            TypeScriptFragment typeScriptFragment2;
            IrModuleFragment it;
            Object element$iv;
            List list;
            Intrinsics.checkNotNullParameter((Object)irModuleInfo, (String)"irModuleInfo");
            Intrinsics.checkNotNullParameter((Object)mainModule, (String)"mainModule");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
            Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
            IrModuleFragment moduleFragment = irModuleInfo.component1();
            List dependencyModules = irModuleInfo.component2();
            IrBuiltIns irBuiltIns = irModuleInfo.component3();
            SymbolTable symbolTable = irModuleInfo.component4();
            JsIrLinker irLinker = irModuleInfo.component5();
            MainModule mainModule2 = mainModule;
            if (mainModule2 instanceof MainModule.SourceFiles) {
                list = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment));
            } else if (mainModule2 instanceof MainModule.Klib) {
                list = dependencyModules;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            allModules = list;
            ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
            context = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, propertyLazyInitialization, configuration2);
            Object $this$forEach$iv = allModules;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (IrModuleFragment)element$iv;
                boolean bl = false;
                new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)irLinker)).generateUnboundSymbolsAsDependencies();
            }
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)irLinker)).generateUnboundSymbolsAsDependencies();
            $this$forEach$iv = allModules;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (IrModuleFragment)element$iv;
                boolean bl = false;
                PatchDeclarationParentsKt.patchDeclarationParents$default(it, null, 1, null);
            }
            irLinker.postProcess(true);
            ChecksKt.checkNoUnboundSymbols(irLinker, symbolTable, "at the end of IR linkage process");
            irLinker.clear();
            for (IrModuleFragment module2 : allModules) {
                for (IrFile file2 : module2.getFiles()) {
                    MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context, file2, exportedDeclarations);
                }
            }
            boolean $i$f$runIf = false;
            if (generateTypeScriptFragment) {
                boolean bl = false;
                ExportedModule exportModel = new ExportModelGenerator(context).generateExport(allModules);
                ExportModelToTsDeclarations exportModelToDtsTranslator = new ExportModelToTsDeclarations();
                String fragment = exportModelToDtsTranslator.generateTypeScriptFragment-2EUUaHo(ModuleKind.ES, exportModel.getDeclarations());
                typeScriptFragment2 = TypeScriptFragment.box-impl(TypeScriptFragment.constructor-impl(exportModelToDtsTranslator.generateTypeScript("", ModuleKind.ES, CollectionsKt.listOf((Object)TypeScriptFragment.box-impl(fragment)))));
            } else {
                typeScriptFragment2 = null;
            }
            typeScriptFragment = typeScriptFragment2 != null ? typeScriptFragment2.unbox-impl() : null;
            CommonCompilerPerformanceManager commonCompilerPerformanceManager = performanceManager2;
            if (commonCompilerPerformanceManager != null) {
                commonCompilerPerformanceManager.notifyIRTranslationFinished();
            }
            CommonCompilerPerformanceManager commonCompilerPerformanceManager2 = performanceManager2;
            if (commonCompilerPerformanceManager2 != null) {
                commonCompilerPerformanceManager2.notifyGenerationStarted();
            }
            CommonCompilerPerformanceManager commonCompilerPerformanceManager3 = performanceManager2;
            if (commonCompilerPerformanceManager3 != null) {
                commonCompilerPerformanceManager3.notifyIRLoweringStarted();
            }
            PhaserState phaserState = new PhaserState(null, 0, 0, null, 15, null);
            Iterable $this$forEachIndexed$iv = WasmLoweringPhasesKt.getLoweringList();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SimpleNamedCompilerPhase lowering = (SimpleNamedCompilerPhase)item$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = allModules;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IrModuleFragment module3 = (IrModuleFragment)element$iv2;
                    boolean bl2 = false;
                    lowering.invoke(phaseConfig, phaserState, (LoggingContext)context, module3);
                }
            }
            CommonCompilerPerformanceManager commonCompilerPerformanceManager4 = performanceManager2;
            if (commonCompilerPerformanceManager4 == null) break block16;
            commonCompilerPerformanceManager4.notifyIRLoweringFinished();
        }
        return new LoweredIrWithExtraArtifacts(allModules, context, typeScriptFragment, null);
    }

    public static /* synthetic */ LoweredIrWithExtraArtifacts compileToLoweredIr$default(IrModuleInfo irModuleInfo, MainModule mainModule, CompilerConfiguration compilerConfiguration, CommonCompilerPerformanceManager commonCompilerPerformanceManager, PhaseConfig phaseConfig, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            set = SetsKt.emptySet();
        }
        return WasmCompilerKt.compileToLoweredIr(irModuleInfo, mainModule, compilerConfiguration, commonCompilerPerformanceManager, phaseConfig, set, bl, bl2);
    }

    @NotNull
    public static final WasmCompilerResult compileWasm-2S3SmqY(@NotNull List<? extends IrModuleFragment> allModules, @NotNull WasmBackendContext backendContext, @Nullable String typeScriptFragment, @NotNull String baseFileName, boolean emitNameSection, boolean allowIncompleteImplementations, boolean generateWat, boolean generateSourceMaps, boolean useDebuggerCustomFormatters) {
        String string2;
        SourceMapGenerator sourceMapGenerator;
        SourceMapGenerator sourceMapGenerator2;
        IrModuleFragment it;
        Intrinsics.checkNotNullParameter(allModules, (String)"allModules");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        boolean useJsTag = backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_JS_TAG);
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment(backendContext.getIrBuiltIns(), backendContext.getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS), backendContext.isWasmJsTarget() && useJsTag);
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(backendContext, compiledWasmModule, allowIncompleteImplementations);
        Iterable $this$forEach$iv = allModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.collectInterfaceTables(it);
        }
        $this$forEach$iv = allModules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.generateModule(it);
        }
        boolean $i$f$runIf = false;
        if (generateSourceMaps) {
            boolean bl = false;
            sourceMapGenerator2 = new SourceMapGenerator(baseFileName + ".wasm", backendContext.getConfiguration());
        } else {
            sourceMapGenerator2 = null;
        }
        SourceMapGenerator sourceMapGeneratorForBinary = sourceMapGenerator2;
        boolean condition$iv = generateWat && generateSourceMaps;
        boolean $i$f$runIf2 = false;
        if (condition$iv) {
            boolean bl = false;
            sourceMapGenerator = new SourceMapGenerator(baseFileName + ".wat", backendContext.getConfiguration());
        } else {
            sourceMapGenerator = null;
        }
        SourceMapGenerator sourceMapGeneratorForText = sourceMapGenerator;
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        if (generateWat) {
            WasmIrToText watGenerator = new WasmIrToText(sourceMapGeneratorForText);
            watGenerator.appendWasmModule(linkedModule);
            string2 = watGenerator.toString();
        } else {
            string2 = null;
        }
        String wat = string2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStream outputStream = os;
        String string3 = ((IrModuleFragment)CollectionsKt.last(allModules)).getDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        WasmIrToBinary wasmIrToBinary = new WasmIrToBinary(outputStream, linkedModule, string3, emitNameSection, sourceMapGeneratorForBinary);
        wasmIrToBinary.appendWasmModule();
        byte[] byteArray = os.toByteArray();
        String jsUninstantiatedWrapper = null;
        String jsWrapper = null;
        if (backendContext.isWasmJsTarget()) {
            jsUninstantiatedWrapper = WasmCompilerKt.generateAsyncJsWrapper(compiledWasmModule, "./" + baseFileName + ".wasm", backendContext.getJsModuleAndQualifierReferences(), useJsTag);
            jsWrapper = WasmCompilerKt.generateEsmExportsWrapper(compiledWasmModule, "./" + baseFileName + ".uninstantiated.mjs", backendContext.getJsModuleAndQualifierReferences(), useDebuggerCustomFormatters);
        } else {
            jsUninstantiatedWrapper = null;
            jsWrapper = WasmCompilerKt.generateAsyncWasiWrapper(compiledWasmModule, "./" + baseFileName + ".wasm");
        }
        Intrinsics.checkNotNull((Object)byteArray);
        SourceMapGenerator sourceMapGenerator3 = sourceMapGeneratorForBinary;
        SourceMapGenerator sourceMapGenerator4 = sourceMapGeneratorForText;
        DebugInformation debugInformation = new DebugInformation(sourceMapGenerator3 != null ? sourceMapGenerator3.generate() : null, sourceMapGenerator4 != null ? sourceMapGenerator4.generate() : null);
        String string4 = typeScriptFragment;
        if (string4 == null) {
            string4 = null;
        }
        return new WasmCompilerResult(wat, jsUninstantiatedWrapper, jsWrapper, byteArray, debugInformation, string4);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm-2S3SmqY$default(List list, WasmBackendContext wasmBackendContext, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        if ((n & 0x100) != 0) {
            bl5 = false;
        }
        return WasmCompilerKt.compileWasm-2S3SmqY(list, wasmBackendContext, string2, string3, bl, bl2, bl3, bl4, bl5);
    }

    @NotNull
    public static final String generateAsyncWasiWrapper(@NotNull WasmCompiledModuleFragment $this$generateAsyncWasiWrapper, @NotNull String wasmFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$generateAsyncWasiWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        return "\nimport { WASI } from 'wasi';\nimport { argv, env } from 'node:process';\n\nconst wasi = new WASI({ version: 'preview1', args: argv, env, });\n\nconst fs = await import('node:fs');\nconst url = await import('node:url');\nconst wasmBuffer = fs.readFileSync(url.fileURLToPath(import.meta.resolve('" + wasmFilePath + "')));\nconst wasmModule = new WebAssembly.Module(wasmBuffer);\nconst wasmInstance = new WebAssembly.Instance(wasmModule, wasi.getImportObject());\n\nwasi.initialize(wasmInstance);\n\nconst exports = wasmInstance.exports\n" + WasmCompilerKt.generateExports($this$generateAsyncWasiWrapper) + '\n';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateAsyncJsWrapper(@NotNull WasmCompiledModuleFragment $this$generateAsyncJsWrapper, @NotNull String wasmFilePath, @NotNull Set<JsModuleAndQualifierReference> jsModuleAndQualifierReferences, boolean useJsTag) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$generateAsyncJsWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        Intrinsics.checkNotNullParameter(jsModuleAndQualifierReferences, (String)"jsModuleAndQualifierReferences");
        String jsCodeBody = CollectionsKt.joinToString$default((Iterable)$this$generateAsyncJsWrapper.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, WasmCompilerKt::generateAsyncJsWrapper$lambda$9, (int)30, null);
        String jsCodeBodyIndented = StringsKt.prependIndent((String)jsCodeBody, (String)"        ");
        String imports = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)$this$generateAsyncJsWrapper.getJsModuleImports())), (CharSequence)"", null, null, (int)0, null, WasmCompilerKt::generateAsyncJsWrapper$lambda$10, (int)30, null);
        Iterable iterable = jsModuleAndQualifierReferences;
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StringBuilder stringBuilder;
            void it;
            JsModuleAndQualifierReference jsModuleAndQualifierReference = (JsModuleAndQualifierReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String module2 = it.getModule();
            String qualifier = it.getQualifier();
            StringBuilder $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append("    const ");
            $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append(it.getJsVariableName());
            $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append(" = ");
            if (module2 != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append("imports[" + JsHelpersKt.toJsStringLiteral(module2) + ']');
                if (qualifier != null) {
                    $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append(".");
                }
            }
            if (qualifier != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append(qualifier);
            }
            $this$generateAsyncJsWrapper_u24lambda_u2412_u24lambda_u2411.append(";");
            collection.add(stringBuilder.toString());
        }
        String referencesToQualifiedAndImportedDeclarations = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return "\nexport async function instantiate(imports={}, runInitializer=true) {\n    const cachedJsObjects = new WeakMap();\n    // ref must be non-null\n    function getCachedJsObject(ref, ifNotCached) {\n        if (typeof ref !== 'object' && typeof ref !== 'function') return ifNotCached;\n        const cached = cachedJsObjects.get(ref);\n        if (cached !== void 0) return cached;\n        cachedJsObjects.set(ref, ifNotCached);\n        return ifNotCached;\n    }\n\n" + referencesToQualifiedAndImportedDeclarations + "\n    \n    const js_code = {\n" + jsCodeBodyIndented + "\n    }\n    \n    // Placed here to give access to it from externals (js_code)\n    let wasmInstance;\n    let require; \n    let wasmExports;\n\n    const isNodeJs = (typeof process !== 'undefined') && (process.release.name === 'node');\n    const isDeno = !isNodeJs && (typeof Deno !== 'undefined')\n    const isStandaloneJsVM =\n        !isDeno && !isNodeJs && (\n            typeof d8 !== 'undefined' // V8\n            || typeof inIon !== 'undefined' // SpiderMonkey\n            || typeof jscOptions !== 'undefined' // JavaScriptCore\n        );\n    const isBrowser = !isNodeJs && !isDeno && !isStandaloneJsVM && (typeof window !== 'undefined' || typeof self !== 'undefined');\n    \n    if (!isNodeJs && !isDeno && !isStandaloneJsVM && !isBrowser) {\n      throw \"Supported JS engine not detected\";\n    }\n    \n    const wasmFilePath = " + JsHelpersKt.toJsStringLiteral(wasmFilePath) + ";\n    const importObject = {\n        js_code,\n        intrinsics: {\n            " + (useJsTag ? "js_error_tag: WebAssembly.JSTag" : "") + "\n        },\n" + imports + "\n    };\n    \n    try {\n      if (isNodeJs) {\n        const module = await import(/* webpackIgnore: true */'node:module');\n        const importMeta = import.meta;\n        require = module.default.createRequire(importMeta.url);\n        const fs = require('fs');\n        const url = require('url');\n        const filepath = import.meta.resolve(wasmFilePath);\n        const wasmBuffer = fs.readFileSync(url.fileURLToPath(filepath));\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isDeno) {\n        const path = await import(/* webpackIgnore: true */'https://deno.land/std/path/mod.ts');\n        const binary = Deno.readFileSync(path.fromFileUrl(import.meta.resolve(wasmFilePath)));\n        const module = await WebAssembly.compile(binary);\n        wasmInstance = await WebAssembly.instantiate(module, importObject);\n      }\n      \n      if (isStandaloneJsVM) {\n        const wasmBuffer = read(wasmFilePath, 'binary');\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isBrowser) {\n        wasmInstance = (await WebAssembly.instantiateStreaming(fetch(wasmFilePath), importObject)).instance;\n      }\n    } catch (e) {\n      if (e instanceof WebAssembly.CompileError) {\n        let text = `Please make sure that your runtime environment supports the latest version of Wasm GC and Exception-Handling proposals.\nFor more information, see https://kotl.in/wasm-help\n`;\n        if (isBrowser) {\n          console.error(text);\n        } else {\n          const t = \"\\n\" + text;\n          if (typeof console !== \"undefined\" && console.log !== void 0) \n            console.log(t);\n          else \n            print(t);\n        }\n      }\n      throw e;\n    }\n    \n    wasmExports = wasmInstance.exports;\n    if (runInitializer) {\n        wasmExports._initialize();\n    }\n\n    return { instance: wasmInstance,  exports: wasmExports };\n}\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateEsmExportsWrapper(@NotNull WasmCompiledModuleFragment $this$generateEsmExportsWrapper, @NotNull String asyncWrapperFileName, @NotNull Set<JsModuleAndQualifierReference> jsModuleAndQualifierReferences, boolean useCustomFormatters) {
        void $this$sortedBy$iv;
        Iterable $this$distinctBy$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$generateEsmExportsWrapper, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)asyncWrapperFileName, (String)"asyncWrapperFileName");
        Intrinsics.checkNotNullParameter(jsModuleAndQualifierReferences, (String)"jsModuleAndQualifierReferences");
        Iterable iterable = $this$generateEsmExportsWrapper.getJsModuleImports();
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String moduleSpecifier = ((Object)JsHelpersKt.toJsStringLiteral((String)it)).toString();
            String importVariableString = JsModuleAndQualifierReference.Companion.encode((String)it);
            collection.add(TuplesKt.to((Object)moduleSpecifier, (Object)importVariableString));
        }
        List importedModules = (List)destination$iv$iv;
        Iterable $i$f$map22 = jsModuleAndQualifierReferences;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsModuleAndQualifierReference it = (JsModuleAndQualifierReference)element$iv$iv;
            boolean bl = false;
            if (!(it.getModule() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map32 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String module2;
            JsModuleAndQualifierReference it = (JsModuleAndQualifierReference)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getModule());
            String stringLiteral = ((Object)JsHelpersKt.toJsStringLiteral(module2)).toString();
            collection.add(TuplesKt.to((Object)stringLiteral, (Object)(it.getQualifier() != null ? it.getImportVariableName() : it.getJsVariableName())));
        }
        List referencesToImportedDeclarations = (List)destination$iv$iv2;
        Iterable $i$f$map32 = CollectionsKt.plus((Collection)importedModules, (Iterable)referencesToImportedDeclarations);
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair it = (Pair)e$iv;
            boolean bl = false;
            String key$iv = (String)it.getFirst();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        List allModules = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        });
        String importsImportedSection = CollectionsKt.joinToString$default((Iterable)allModules, (CharSequence)"\n", null, null, (int)0, null, WasmCompilerKt::generateEsmExportsWrapper$lambda$19, (int)30, null);
        String imports = CollectionsKt.joinToString$default((Iterable)allModules, (CharSequence)",\n", null, null, (int)0, null, WasmCompilerKt::generateEsmExportsWrapper$lambda$20, (int)30, null);
        return '\n' + importsImportedSection + "\nimport { instantiate } from " + JsHelpersKt.toJsStringLiteral(asyncWrapperFileName) + ";\n" + (useCustomFormatters ? "import \"./custom-formatters.js\"" : "") + "\n\nconst exports = (await instantiate({\n" + imports + "\n})).exports;\n" + WasmCompilerKt.generateExports($this$generateEsmExportsWrapper) + '\n';
    }

    public static final void writeCompilationResult(@NotNull WasmCompilerResult result2, @NotNull File dir2, @NotNull String fileNameBase, boolean useDebuggerCustomFormatters) {
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameBase, (String)"fileNameBase");
        dir2.mkdirs();
        if (result2.getWat() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".wat"), (String)result2.getWat(), null, (int)2, null);
        }
        FilesKt.writeBytes((File)new File(dir2, fileNameBase + ".wasm"), (byte[])result2.getWasm());
        if (result2.getJsUninstantiatedWrapper() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".uninstantiated.mjs"), (String)result2.getJsUninstantiatedWrapper(), null, (int)2, null);
        }
        FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".mjs"), (String)result2.getJsWrapper(), null, (int)2, null);
        Object object2 = result2.getDebugInformation();
        if (object2 != null && (object2 = ((DebugInformation)object2).getSourceMapForBinary()) != null) {
            it = object2;
            boolean bl = false;
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".wasm.map"), (String)it, null, (int)2, null);
        }
        if ((object = result2.getDebugInformation()) != null && (object = ((DebugInformation)object).getSourceMapForText()) != null) {
            it = object;
            boolean bl = false;
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".wat.map"), (String)it, null, (int)2, null);
        }
        if (useDebuggerCustomFormatters) {
            String fileName = "custom-formatters.js";
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            InputStream customFormattersInputStream = systemClassLoader.getResourceAsStream(fileName);
            Object[] objectArray = new String[]{fileName};
            Path path = Paths.get(dir2.getPath(), (String[])objectArray);
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(customFormattersInputStream, path, (CopyOption[])objectArray);
        }
        if (result2.getDts() != null) {
            FilesKt.writeText$default((File)new File(dir2, fileNameBase + ".d.ts"), (String)result2.getDts(), null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateExports(@NotNull WasmCompiledModuleFragment $this$generateExports) {
        String string2;
        String string3;
        String string4;
        String string5;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$generateExports, (String)"<this>");
        Iterable $this$filterNot$iv = $this$generateExports.getExports();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            WasmExport it = (WasmExport)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it.getName(), (String)"__callFunction_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$ifNotEmpty$iv = (List)destination$iv$iv;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$generateExports_u24lambda_u2425 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string5 = CollectionsKt.joinToString$default((Iterable)$this$generateExports_u24lambda_u2425, (CharSequence)",\n", null, null, (int)0, null, WasmCompilerKt::generateExports$lambda$25$lambda$24, (int)30, null);
        } else {
            string5 = string4 = null;
        }
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            string3 = StringsKt.trimMargin$default((String)("\n            |const {\n                |" + it + "\n            |}\n        "), null, (int)1, null);
        } else {
            string3 = null;
        }
        String exportNames = string3;
        StringBuilder stringBuilder = new StringBuilder().append('\n');
        String string6 = exportNames;
        if (string6 != null) {
            void it;
            $this$ifNotEmpty$iv = string6;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            string2 = "export " + (String)it + " = exports;";
            stringBuilder = stringBuilder2;
        } else {
            string2 = null;
        }
        return stringBuilder.append(string2).append('\n').toString();
    }

    private static final CharSequence generateAsyncJsWrapper$lambda$9(WasmCompiledModuleFragment.JsCodeSnippet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JsHelpersKt.toJsStringLiteral(it.getImportName()) + " : " + it.getJsCode();
    }

    private static final CharSequence generateAsyncJsWrapper$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence moduleSpecifier = JsHelpersKt.toJsStringLiteral(it);
        return "        " + moduleSpecifier + ": imports[" + moduleSpecifier + "],\n";
    }

    private static final CharSequence generateEsmExportsWrapper$lambda$19(Pair it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418.append("import * as ");
        $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418.append((String)it.getSecond());
        $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418.append(" from ");
        $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418.append((String)it.getFirst());
        $this$generateEsmExportsWrapper_u24lambda_u2419_u24lambda_u2418.append(";");
        return stringBuilder.toString();
    }

    private static final CharSequence generateEsmExportsWrapper$lambda$20(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "    " + (String)it.getFirst() + ": " + (String)it.getSecond();
    }

    private static final CharSequence generateExports$lambda$25$lambda$24(WasmExport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "    " + it.getName();
    }
}

