/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.EnumIntrinsicsUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCallTypeArgumentsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irBuiltins", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "getKClassCtorArgument", "type", "getExternalKClassCtorArgument", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nBuiltInsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n350#2,12:252\n402#3,13:264\n98#4,2:277\n1#5:279\n*S KotlinDebug\n*F\n+ 1 BuiltInsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering\n*L\n41#1:252,12\n115#1:264,13\n115#1:277,2\n*E\n"})
public final class BuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns irBuiltins;
    @NotNull
    private final WasmSymbols symbols;

    public BuiltInsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irBuiltins = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction findEqualsMethod(IrType $this$findEqualsMethod) {
        IrClass irClass = IrTypesKt.getClass($this$findEqualsMethod);
        if (irClass == null) {
            irClass = (IrClass)this.irBuiltins.getAnyClass().getOwner();
        }
        IrClass klass = irClass;
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(klass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!MiscKt.isEqualsInheritedFromAny(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression transformCall(IrCall call2, DeclarationIrBuilder builder) {
        IrSimpleFunctionSymbol symbol;
        block35: {
            block37: {
                block36: {
                    block32: {
                        block34: {
                            block33: {
                                symbol = call2.getSymbol();
                                if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getLinkageErrorSymbol())) {
                                    return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.context.getWasmSymbols().getThrowLinkageError(), false, false, null, null, 60, null);
                                }
                                if (!Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getFloatClass()))) break block32;
                                IrExpression irExpression = call2.getValueArgument(0);
                                Intrinsics.checkNotNull((Object)irExpression);
                                if (IrTypeUtilsKt.isNullable(irExpression.getType())) break block33;
                                IrExpression irExpression2 = call2.getValueArgument(1);
                                Intrinsics.checkNotNull((Object)irExpression2);
                                if (!IrTypeUtilsKt.isNullable(irExpression2.getType())) break block34;
                            }
                            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getNullableFloatIeee754Equals(), false, false, null, null, 60, null);
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getFloatType()), false, false, null, null, 60, null);
                    }
                    if (!Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getDoubleClass()))) break block35;
                    IrExpression irExpression = call2.getValueArgument(0);
                    Intrinsics.checkNotNull((Object)irExpression);
                    if (IrTypeUtilsKt.isNullable(irExpression.getType())) break block36;
                    IrExpression irExpression3 = call2.getValueArgument(1);
                    Intrinsics.checkNotNull((Object)irExpression3);
                    if (!IrTypeUtilsKt.isNullable(irExpression3.getType())) break block37;
                }
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.symbols.getNullableDoubleIeee754Equals(), false, false, null, null, 60, null);
            }
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getDoubleType()), false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getEqeqSymbol()) || Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getEqeqeqSymbol())) {
            IrType rhsType;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression lhs = irExpression;
            IrExpression irExpression4 = call2.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression4);
            IrExpression rhs = irExpression4;
            if (IrUtilsKt.isNullConst(lhs)) {
                return BuiltInsLowering.transformCall$callRefIsNull(this, builder, rhs);
            }
            if (IrUtilsKt.isNullConst(rhs)) {
                return BuiltInsLowering.transformCall$callRefIsNull(this, builder, lhs);
            }
            IrType lhsType = lhs.getType();
            if (Intrinsics.areEqual((Object)lhsType, (Object)(rhsType = rhs.getType()))) {
                IrSimpleFunctionSymbol newSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getEqualityFunctions().get(lhsType);
                if (irSimpleFunctionSymbol == null) {
                    irSimpleFunctionSymbol = call2.getSymbol() == this.irBuiltins.getEqeqeqSymbol() ? this.symbols.getFloatEqualityFunctions().get(lhsType) : null;
                }
                if ((newSymbol = irSimpleFunctionSymbol) != null) {
                    return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, null, 60, null);
                }
            }
            if (call2.getSymbol() == this.irBuiltins.getEqeqSymbol() && !IrTypeUtilsKt.isNullable(lhsType) && !IrTypePredicatesKt.isNothing(lhsType)) {
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.findEqualsMethod(lhsType).getSymbol(), false, true, null, null, 52, null);
            }
            IrSimpleFunctionSymbol fallbackEqFun = call2.getSymbol() == this.irBuiltins.getEqeqeqSymbol() ? this.symbols.getRefEq() : this.symbols.getNullableEquals();
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, fallbackEqFun, false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getCheckNotNullSymbol())) {
            void this_$iv$iv;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression arg = irExpression;
            if (IrUtilsKt.isNullConst(arg)) {
                return ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, this.symbols.getThrowNullPointerException());
            }
            IrBuilderWithScope $this$irComposite_u24default$iv = builder;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$transformCall_u24lambda_u242 = this_$iv$iv;
            boolean bl = false;
            IrVariable temporary = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$transformCall_u24lambda_u242, arg, null, null, false, null, 30, null);
            $this$transformCall_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irIfNull(builder, IrTypesKt.makeNotNull(arg.getType()), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformCall_u24lambda_u242, temporary), ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, this.symbols.getThrowNullPointerException()), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformCall_u24lambda_u242, temporary)));
            return this_$iv$iv.doBuild();
        }
        if (this.symbols.getComparisonBuiltInsToWasmIntrinsics().keySet().contains(symbol)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getComparisonBuiltInsToWasmIntrinsics().get(symbol);
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, false, null, null, 60, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getNoWhenBranchMatchedExceptionSymbol())) {
            return ExpressionHelpersKt.irCall$default(builder, this.symbols.getThrowNoBranchMatchedException(), this.irBuiltins.getNothingType(), 0, 0, null, 28, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getIllegalArgumentExceptionSymbol())) {
            IrCall newSymbol;
            IrCall $this$transformCall_u24lambda_u243 = newSymbol = ExpressionHelpersKt.irCall$default(builder, this.symbols.getThrowIAE(), this.irBuiltins.getNothingType(), 1, 0, null, 24, null);
            boolean bl = false;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            $this$transformCall_u24lambda_u243.putValueArgument(0, irExpression);
            return newSymbol;
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol()) || Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberToStringSymbol())) {
            IrCall irCall;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression argument = irExpression;
            IrType argumentType = argument.getType();
            IrSimpleFunctionSymbol overloadSymbol = null;
            IrType returnType = null;
            if (Intrinsics.areEqual((Object)symbol, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol())) {
                overloadSymbol = this.symbols.findContentHashCodeOverload(argumentType);
                returnType = this.irBuiltins.getIntType();
            } else {
                overloadSymbol = this.symbols.findContentToStringOverload(argumentType);
                returnType = this.irBuiltins.getStringType();
            }
            IrCall $this$transformCall_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall$default(builder, overloadSymbol, returnType, 0, 0, null, 28, null);
            boolean bl = false;
            $this$transformCall_u24lambda_u244.setExtensionReceiver(argument);
            if (Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull(argumentType), (Object)this.irBuiltins.getArrayClass())) {
                $this$transformCall_u24lambda_u244.putTypeArgument(0, IrTypeUtilsKt.getArrayElementType(argumentType, this.irBuiltins));
            }
            return irCall;
        }
        if (this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().contains(symbol)) {
            int arity = this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().indexOf(symbol);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.irBuiltins.suspendFunctionN(arity), "invoke");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, newSymbol, false, true, null, null, 52, null);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.context.getReflectionSymbols().getGetKClass())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType type2 = irType;
            Object object = IrTypesKt.getClassOrNull(type2);
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                throw new IllegalStateException("Invalid type".toString());
            }
            Object klass = object;
            IrExpression constructorArgument = null;
            IrConstructor kclassConstructor = null;
            if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)klass)) {
                if (!this.context.isWasmJsTarget()) {
                    boolean $i$a$-check-BuiltInsLowering$transformCall$52 = false;
                    String $i$a$-check-BuiltInsLowering$transformCall$52 = "External classes reflection in WASI mode are not supported";
                    throw new IllegalStateException($i$a$-check-BuiltInsLowering$transformCall$52.toString());
                }
                kclassConstructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)this.symbols.getJsRelatedSymbols().getKExternalClassImpl().getOwner()));
                constructorArgument = this.getExternalKClassCtorArgument(type2, builder);
            } else {
                kclassConstructor = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)this.symbols.getReflectionSymbols$backend_wasm().getKClassImpl().getOwner()));
                constructorArgument = this.getKClassCtorArgument(type2, builder);
            }
            Object object2 = kclassConstructor.getReturnType();
            IrConstructorSymbol $i$a$-check-BuiltInsLowering$transformCall$52 = kclassConstructor.getSymbol();
            Object it = object2 = BuildersKt.IrConstructorCallImpl$default(-1, -1, (IrType)object2, $i$a$-check-BuiltInsLowering$transformCall$52, 1, 0, 1, null, null, 384, null);
            boolean bl = false;
            IrConstructorCallTypeArgumentsKt.putClassTypeArgument((IrConstructorCall)it, 0, type2);
            ((IrMemberAccessExpression)it).putValueArgument(0, constructorArgument);
            return (IrExpression)object2;
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumValueOfIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumValueOfIntrinsic(call2);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumValuesIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumValuesIntrinsic(call2);
        }
        if (Intrinsics.areEqual((Object)symbol, (Object)this.symbols.getEnumEntriesIntrinsic())) {
            return EnumIntrinsicsUtils.INSTANCE.transformEnumEntriesIntrinsic(call2);
        }
        return call2;
    }

    private final IrExpression getKClassCtorArgument(IrType type2, DeclarationIrBuilder builder) {
        IrConstructorCall irConstructorCall;
        Object object;
        IrCall irCall;
        Object object2 = IrTypesKt.getClassOrNull(type2);
        if (object2 == null || (object2 = (IrClass)object2.getOwner()) == null) {
            throw new IllegalStateException("Invalid type".toString());
        }
        Object klass = object2;
        IrCall it = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, this.symbols.getWasmTypeId());
        boolean bl = false;
        it.putTypeArgument(0, type2);
        IrCall typeId = irCall;
        if (!IrUtilsKt.isInterface((IrClass)klass)) {
            it = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, this.context.getWasmSymbols().getReflectionSymbols$backend_wasm().getGetTypeInfoTypeDataByPtr());
            boolean bl2 = false;
            it.putValueArgument(0, typeId);
            return irCall;
        }
        FqName fqName = IrTypesKt.getClassFqName(type2);
        Intrinsics.checkNotNull((Object)fqName);
        FqName fqName2 = fqName;
        boolean fqnShouldBeEmitted = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            object = FqNamesUtilKt.parentOrNull(fqName2);
            if (object == null || (object = ((FqName)object).asString()) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        String packageName2 = object;
        String string2 = fqName2.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String typeName = string2;
        IrConstructorCall it2 = irConstructorCall = ExpressionHelpersKt.irCallConstructor(builder, (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(this.symbols.getReflectionSymbols$backend_wasm().getWasmTypeInfoData())), CollectionsKt.emptyList());
        boolean bl3 = false;
        it2.putValueArgument(0, typeId);
        it2.putValueArgument(1, IrUtilsKt.toIrConst$default(packageName2, this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null));
        it2.putValueArgument(2, IrUtilsKt.toIrConst$default(typeName, this.context.getIrBuiltIns().getStringType(), 0, 0, 6, null));
        return irConstructorCall;
    }

    private final IrExpression getExternalKClassCtorArgument(IrType type2, DeclarationIrBuilder builder) {
        Object object = IrTypesKt.getClassOrNull(type2);
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            throw new IllegalStateException("Invalid type".toString());
        }
        Object klass = object;
        if (!(((IrClass)klass).getKind() != ClassKind.INTERFACE)) {
            boolean $i$a$-check-BuiltInsLowering$getExternalKClassCtorArgument$22 = false;
            String $i$a$-check-BuiltInsLowering$getExternalKClassCtorArgument$22 = "External interface must not be a class literal";
            throw new IllegalStateException($i$a$-check-BuiltInsLowering$getExternalKClassCtorArgument$22.toString());
        }
        IrSimpleFunction irSimpleFunction = this.context.getMapping().getWasmGetJsClass().get((IrClass)((IrDeclaration)klass));
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction classGetClassFunction = irSimpleFunction;
        IrSimpleFunction irSimpleFunction2 = this.context.getMapping().getWasmJsInteropFunctionToWrapper().get((IrSimpleFunction)((IrDeclaration)classGetClassFunction));
        if (irSimpleFunction2 == null) {
            irSimpleFunction2 = classGetClassFunction;
        }
        IrSimpleFunction wrappedGetClassIfAny = irSimpleFunction2;
        return ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, wrappedGetClassIfAny);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)irFile.getSymbol(), 0, 0, 6, null);
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this, builder){
            final /* synthetic */ BuiltInsLowering this$0;
            final /* synthetic */ DeclarationIrBuilder $builder;
            {
                this.this$0 = $receiver;
                this.$builder = $builder;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression newExpression = BuiltInsLowering.access$transformCall(this.this$0, expression2, this.$builder);
                IrElementTransformerVoidKt.transformChildrenVoid(newExpression, this);
                return newExpression;
            }
        });
    }

    private static final IrCall transformCall$callRefIsNull(BuiltInsLowering this$0, DeclarationIrBuilder $builder, IrExpression expr) {
        IrCall irCall;
        if (!this$0.context.isWasmJsTarget()) {
            IrClass irClass = TypeTranformerKt.getErasedUpperBound(expr.getType());
            boolean bl = irClass != null ? irClass.isExternal() : false;
            if (bl) {
                throw new IllegalStateException("Unexpected external refs in wasi mode".toString());
            }
        }
        IrClass irClass = TypeTranformerKt.getErasedUpperBound(expr.getType());
        IrSimpleFunctionSymbol refIsNull = (irClass != null ? irClass.isExternal() : false) ? this$0.symbols.getJsRelatedSymbols().getExternRefIsNull() : this$0.symbols.getRefIsNull();
        IrCall $this$transformCall_u24callRefIsNull_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$builder, refIsNull);
        boolean bl = false;
        $this$transformCall_u24callRefIsNull_u24lambda_u241.putValueArgument(0, expr);
        return irCall;
    }

    public static final /* synthetic */ IrExpression access$transformCall(BuiltInsLowering $this, IrCall call2, DeclarationIrBuilder builder) {
        return $this.transformCall(call2, builder);
    }
}

