/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tR\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "jsRelatedSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getJsRelatedSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getJsCode", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nJsCodeCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,120:1\n1755#2,3:121\n1557#2:124\n1628#2,3:125\n1872#2,3:139\n1872#2,3:142\n416#3,10:128\n72#4:138\n73#4:145\n*S KotlinDebug\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n*L\n66#1:121,3\n77#1:124\n77#1:125,3\n80#1:139,3\n83#1:142,3\n78#1:128,10\n78#1:138\n78#1:145\n*E\n"})
public final class JsCodeCallsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public JsCodeCallsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final WasmSymbols.JsRelatedSymbols getJsRelatedSymbols() {
        return this.context.getWasmSymbols().getJsRelatedSymbols();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.isWasmJsTarget()) {
            return;
        }
        TransformKt.transformDeclarationsFlat(irFile, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)arg_0 -> JsCodeCallsLowering.lower$lambda$0(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformFunction(IrSimpleFunction function2) {
        void it;
        IrConstructorCall irConstructorCall;
        boolean bl;
        String jsFunCode;
        block20: {
            StringBuilder stringBuilder;
            IrBody irBody = function2.getBody();
            if (irBody == null) {
                return null;
            }
            IrBody body2 = irBody;
            if (!(body2 instanceof IrBlockBody)) {
                throw new IllegalStateException("Check failed.");
            }
            IrStatement irStatement = (IrStatement)CollectionsKt.singleOrNull(((IrBlockBody)body2).getStatements());
            if (irStatement == null) {
                return null;
            }
            IrStatement statement = irStatement;
            boolean isSingleExpressionJsCode = false;
            String jsCode = null;
            IrStatement irStatement2 = statement;
            if (irStatement2 instanceof IrReturn) {
                String string2 = this.getJsCode(((IrReturn)statement).getValue());
                if (string2 == null) {
                    return null;
                }
                jsCode = string2;
                isSingleExpressionJsCode = true;
            } else if (irStatement2 instanceof IrCall) {
                String string3 = this.getJsCode((IrExpression)statement);
                if (string3 == null) {
                    return null;
                }
                jsCode = string3;
                isSingleExpressionJsCode = false;
            } else {
                return null;
            }
            List<IrValueParameter> valueParameters = function2.getValueParameters();
            StringBuilder $this$transformFunction_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$transformFunction_u24lambda_u242.append('(');
            $this$transformFunction_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)valueParameters, null, null, null, (int)0, null, JsCodeCallsLowering::transformFunction$lambda$2$lambda$1, (int)31, null));
            $this$transformFunction_u24lambda_u242.append(") => ");
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u242.append("{ ");
            }
            $this$transformFunction_u24lambda_u242.append(jsCode);
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u242.append(" }");
            }
            jsFunCode = stringBuilder.toString();
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it2 = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getDefaultValue() != null)) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            IrTypeParameter parameter;
            int index;
            int n;
            void $this$transformFunction_u24lambda_u247;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            IrSimpleFunction externalFun = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, function2.getName(), "_js_code", function2.getReturnType(), jsFunCode);
            IrUtilsKt.copyTypeParametersFrom$default(externalFun, function2, null, null, 6, null);
            Iterable $i$f$any = function2.getValueParameters();
            IrSimpleFunction irSimpleFunction = externalFun;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it3;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it3, externalFun, null, 0, 0, null, null, null, null, null, false, false, false, 3838, null));
            }
            irSimpleFunction.setValueParameters((List)destination$iv$iv);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            item$iv$iv2 = this_$iv$iv;
            irSimpleFunction = function2;
            boolean bl5 = false;
            IrCall call2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$transformFunction_u24lambda_u247, externalFun.getSymbol());
            Iterable $this$forEachIndexed$iv = function2.getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                index = n;
                boolean bl6 = false;
                call2.putValueArgument(index, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformFunction_u24lambda_u247, (IrValueDeclaration)((Object)parameter)));
            }
            $this$forEachIndexed$iv = function2.getTypeParameters();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void typeParameter;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                parameter = (IrTypeParameter)item$iv;
                index = n;
                boolean bl7 = false;
                call2.putTypeArgument(index, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
            }
            $this$transformFunction_u24lambda_u247.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformFunction_u24lambda_u247, call2));
            irSimpleFunction.setBody(this_$iv$iv.doBuild());
            Object[] objectArray = new IrSimpleFunction[]{function2, externalFun};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        IrConstructorCall startOffset$iv = irConstructorCall = ExpressionHelpersKt.irCallConstructor(builder, this.getJsRelatedSymbols().getJsFunConstructor(), CollectionsKt.emptyList());
        Collection collection = function2.getAnnotations();
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl8 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irString(builder, jsFunCode));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCall));
        function2.setBody(null);
        return null;
    }

    private final List<IrDeclaration> transformProperty(IrProperty property) {
        IrField irField = property.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField field = irField;
        IrExpressionBody irExpressionBody = field.getInitializer();
        if (irExpressionBody == null) {
            return null;
        }
        IrExpressionBody initializer = irExpressionBody;
        String string2 = this.getJsCode(initializer.getExpression());
        if (string2 == null) {
            return null;
        }
        String jsCode = string2;
        IrSimpleFunction externalFun = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this.context, property.getName(), "_js_code", field.getType(), "() => (" + jsCode + ')');
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)field.getSymbol(), 0, 0, 6, null);
        initializer.setExpression(ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, externalFun));
        Object[] objectArray = new IrDeclaration[]{property, externalFun};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String getJsCode(IrExpression $this$getJsCode) {
        IrCall irCall = $this$getJsCode instanceof IrCall ? (IrCall)$this$getJsCode : null;
        if (irCall == null) {
            return null;
        }
        IrCall call2 = irCall;
        if (!Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.getJsRelatedSymbols().getJsCode())) {
            return null;
        }
        IrExpression irExpression = call2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object = ((IrConst)irExpression).getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    private static final List lower$lambda$0(JsCodeCallsLowering this$0, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration2 = declaration;
        return irDeclaration2 instanceof IrSimpleFunction ? this$0.transformFunction((IrSimpleFunction)declaration) : (irDeclaration2 instanceof IrProperty ? this$0.transformProperty((IrProperty)declaration) : null);
    }

    private static final CharSequence transformFunction$lambda$2$lambda$1(IrValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        return string2;
    }
}

