/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.utils;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.utils.OffsetUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\bH\u0002\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"getIrConstKind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toIrConstKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "asCompileTimeIrInitializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nConstantUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantUtils.kt\norg/jetbrains/kotlin/fir/backend/utils/ConstantUtilsKt\n+ 2 OffsetUtils.kt\norg/jetbrains/kotlin/fir/backend/utils/OffsetUtilsKt\n*L\n1#1,88:1\n39#2:89\n68#2,16:90\n*S KotlinDebug\n*F\n+ 1 ConstantUtils.kt\norg/jetbrains/kotlin/fir/backend/utils/ConstantUtilsKt\n*L\n37#1:89\n37#1:90,16\n*E\n"})
public final class ConstantUtilsKt {
    @NotNull
    public static final IrConstKind getIrConstKind(@NotNull FirLiteralExpression $this$getIrConstKind) {
        IrConstKind irConstKind;
        Intrinsics.checkNotNullParameter((Object)$this$getIrConstKind, (String)"<this>");
        ConstantValueKind constantValueKind = $this$getIrConstKind.getKind();
        if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE) || Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType($this$getIrConstKind);
            Intrinsics.checkNotNull((Object)coneKotlinType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType");
            ConeIntegerLiteralType type2 = (ConeIntegerLiteralType)coneKotlinType;
            ConstantValueKind constantValueKind2 = FirTypeUtilsKt.toConstKind(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
            Intrinsics.checkNotNull((Object)constantValueKind2);
            irConstKind = ConstantUtilsKt.toIrConstKind(constantValueKind2);
        } else {
            irConstKind = ConstantUtilsKt.toIrConstKind($this$getIrConstKind.getKind());
        }
        return irConstKind;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final IrConst toIrConst(@NotNull FirLiteralExpression $this$toIrConst, @NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)$this$toIrConst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        $this$convertWithOffsets$iv = $this$toIrConst;
        $i$f$convertWithOffsets = false;
        $this$convertWithOffsets$iv$iv = $this$convertWithOffsets$iv.getSource();
        $i$f$convertWithOffsets = false;
        startOffset$iv$iv = 0;
        endOffset$iv$iv = 0;
        if (OffsetUtilsKt.access$isCompiledElement(KtSourceElementKt.getPsi($this$convertWithOffsets$iv$iv))) ** GOTO lbl-1000
        v0 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v0 != null ? v0.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) ** GOTO lbl-1000
        v1 = $this$convertWithOffsets$iv$iv;
        if (Intrinsics.areEqual((Object)(v1 != null ? v1.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitThisReceiverExpression.INSTANCE)) lbl-1000:
        // 3 sources

        {
            startOffset$iv$iv = -1;
            endOffset$iv$iv = -1;
        } else {
            v2 = $this$convertWithOffsets$iv$iv;
            if (v2 != null && (v2 = OffsetUtilsKt.startOffsetSkippingComments((AbstractKtSourceElement)v2)) != null) {
                v3 = v2.intValue();
            } else {
                v4 = $this$convertWithOffsets$iv$iv;
                v3 = v4 != null ? v4.getStartOffset() : -1;
            }
            startOffset$iv$iv = v3;
            v5 = $this$convertWithOffsets$iv$iv;
            endOffset$iv$iv = v5 != null ? v5.getEndOffset() : -1;
        }
        var8_8 = endOffset$iv$iv;
        startOffset = startOffset$iv$iv;
        $i$a$-convertWithOffsets-ConstantUtilsKt$toIrConst$1 = false;
        kind = ConstantUtilsKt.getIrConstKind($this$toIrConst);
        var12_12 = $this$toIrConst.getValue();
        v6 = var12_12 instanceof Long != false ? (Long)var12_12 : null;
        if (v6 != null) {
            it = ((Number)v6).longValue();
            $i$a$-let-ConstantUtilsKt$toIrConst$1$value$1 = false;
            var16_15 = kind;
            v7 = Intrinsics.areEqual((Object)var16_15, (Object)IrConstKind.Byte.INSTANCE) ? Byte.valueOf((byte)it) : (Intrinsics.areEqual((Object)var16_15, (Object)IrConstKind.Short.INSTANCE) ? Short.valueOf((short)it) : (Intrinsics.areEqual((Object)var16_15, (Object)IrConstKind.Int.INSTANCE) ? Integer.valueOf((int)it) : (Intrinsics.areEqual((Object)var16_15, (Object)IrConstKind.Float.INSTANCE) ? Float.valueOf(it) : (Intrinsics.areEqual((Object)var16_15, (Object)IrConstKind.Double.INSTANCE) ? Double.valueOf(it) : Long.valueOf(it)))));
        } else {
            v7 = $this$toIrConst.getValue();
        }
        value = v7;
        return (IrConst)((IrElement)BuildersKt.IrConstImpl(startOffset, (int)endOffset, IrTypesKt.removeAnnotations(irType), kind, value));
    }

    private static final IrConstKind toIrConstKind(ConstantValueKind $this$toIrConstKind) {
        IrConstKind irConstKind;
        ConstantValueKind constantValueKind = $this$toIrConstKind;
        if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            irConstKind = IrConstKind.Null.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            irConstKind = IrConstKind.Boolean.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            irConstKind = IrConstKind.Char.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            irConstKind = IrConstKind.String.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            irConstKind = IrConstKind.Float.INSTANCE;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            irConstKind = IrConstKind.Double.INSTANCE;
        } else {
            if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE) || Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
                throw new IllegalArgumentException();
            }
            if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Error.INSTANCE)) {
                throw new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return irConstKind;
    }

    @NotNull
    public static final IrExpressionBody asCompileTimeIrInitializer(@NotNull FirExpression $this$asCompileTimeIrInitializer, @NotNull Fir2IrComponents components, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$asCompileTimeIrInitializer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Fir2IrVisitor visitor2 = new Fir2IrVisitor(components, new Fir2IrConversionScope(components.getConfiguration()));
        IrExpression expression2 = Fir2IrVisitor.convertToIrExpression$fir2ir$default(visitor2, $this$asCompileTimeIrInitializer, false, expectedType, 2, null);
        return IrFactoryHelpersKt.createExpressionBody(IrFactoryImpl.INSTANCE, expression2);
    }

    public static /* synthetic */ IrExpressionBody asCompileTimeIrInitializer$default(FirExpression firExpression, Fir2IrComponents fir2IrComponents, ConeKotlinType coneKotlinType, int n, Object object) {
        if ((n & 2) != 0) {
            coneKotlinType = null;
        }
        return ConstantUtilsKt.asCompileTimeIrInitializer(firExpression, fir2IrComponents, coneKotlinType);
    }
}

