/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.DfaVariablesKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.PropertyStability;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.SmartcastStability;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0001(B7\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isReceiver", "", "dispatchReceiver", "extensionReceiver", "originalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;ZLorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "()Z", "getDispatchReceiver", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "getExtensionReceiver", "getOriginalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "equals", "other", "", "hashCode", "", "toString", "", "getStability", "Lorg/jetbrains/kotlin/types/SmartcastStability;", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasFinalType", "propertyStability", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PropertyStability;", "getPropertyStability", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/PropertyStability;", "propertyStability$delegate", "Lkotlin/Lazy;", "Companion", "semantics"})
@SourceDebugExtension(value={"SMAP\nDfaVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaVariables.kt\norg/jetbrains/kotlin/fir/resolve/dfa/RealVariable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,160:1\n1#2:161\n1755#3,3:162\n17#4,2:165\n34#4:167\n21#4:168\n17#4,2:169\n*S KotlinDebug\n*F\n+ 1 DfaVariables.kt\norg/jetbrains/kotlin/fir/resolve/dfa/RealVariable\n*L\n109#1:162,3\n122#1:165,2\n126#1:167\n135#1:168\n136#1:169,2\n*E\n"})
public final class RealVariable
extends DataFlowVariable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirBasedSymbol<?> symbol;
    private final boolean isReceiver;
    @Nullable
    private final RealVariable dispatchReceiver;
    @Nullable
    private final RealVariable extensionReceiver;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final Lazy propertyStability$delegate;

    public RealVariable(@NotNull FirBasedSymbol<?> symbol, boolean isReceiver, @Nullable RealVariable dispatchReceiver, @Nullable RealVariable extensionReceiver, @NotNull ConeKotlinType originalType) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        super(null);
        this.symbol = symbol;
        this.isReceiver = isReceiver;
        this.dispatchReceiver = dispatchReceiver;
        this.extensionReceiver = extensionReceiver;
        this.originalType = originalType;
        this.propertyStability$delegate = LazyKt.lazy(() -> RealVariable.propertyStability_delegate$lambda$4(this));
    }

    @NotNull
    public final FirBasedSymbol<?> getSymbol() {
        return this.symbol;
    }

    public final boolean isReceiver() {
        return this.isReceiver;
    }

    @Nullable
    public final RealVariable getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @Nullable
    public final RealVariable getExtensionReceiver() {
        return this.extensionReceiver;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RealVariable && Intrinsics.areEqual(this.symbol, ((RealVariable)other).symbol) && this.isReceiver == ((RealVariable)other).isReceiver && Intrinsics.areEqual((Object)this.dispatchReceiver, (Object)((RealVariable)other).dispatchReceiver) && Intrinsics.areEqual((Object)this.extensionReceiver, (Object)((RealVariable)other).extensionReceiver);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.symbol, this.isReceiver, this.dispatchReceiver, this.extensionReceiver};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string2;
        FirBasedSymbol<?> firBasedSymbol;
        StringBuilder stringBuilder = new StringBuilder().append(this.isReceiver ? "this@" : "").append((firBasedSymbol = this.symbol) instanceof FirClassSymbol ? String.valueOf(((FirClassSymbol)this.symbol).getClassId()) : (firBasedSymbol instanceof FirCallableSymbol ? String.valueOf(((FirCallableSymbol)this.symbol).getCallableId()) : String.valueOf(this.symbol)));
        if (this.dispatchReceiver != null && this.extensionReceiver != null) {
            string2 = "" + '(' + this.dispatchReceiver + ", " + this.extensionReceiver + ')';
        } else if (this.dispatchReceiver != null || this.extensionReceiver != null) {
            StringBuilder stringBuilder2 = new StringBuilder().append('(');
            RealVariable realVariable = this.dispatchReceiver;
            if (realVariable == null) {
                realVariable = this.extensionReceiver;
            }
            string2 = stringBuilder2.append(realVariable).append(')').toString();
        } else {
            string2 = "";
        }
        return stringBuilder.append(string2).toString();
    }

    @NotNull
    public final SmartcastStability getStability(@NotNull Flow flow, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!this.isReceiver) {
            Object object;
            Object object2;
            PropertyStability stability = this.getPropertyStability();
            boolean isUnstableSmartcastOnDelegatedProperties = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.UnstableSmartcastOnDelegatedProperties);
            if (isUnstableSmartcastOnDelegatedProperties) {
                object2 = this.symbol.getFir();
                FirProperty firProperty = object2 instanceof FirProperty ? (FirProperty)object2 : null;
                boolean bl = firProperty != null ? ClassMembersKt.isDelegated(firProperty) : false;
                if (bl) {
                    return SmartcastStability.DELEGATED_PROPERTY;
                }
            }
            if ((object = stability.getInherentInstability()) != null) {
                SmartcastStability it = object;
                boolean bl = false;
                return it;
            }
            if (stability.getCheckReceiver()) {
                RealVariable realVariable = this.dispatchReceiver;
                boolean bl = realVariable != null ? !realVariable.hasFinalType(flow, session2) : false;
                if (bl) {
                    return SmartcastStability.PROPERTY_WITH_GETTER;
                }
            }
            if (stability.getCheckModule()) {
                Object obj = this.symbol.getFir();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable");
                if (!DfaVariablesKt.access$isInCurrentOrFriendModule((FirVariable)obj, session2)) {
                    return SmartcastStability.ALIEN_PUBLIC_PROPERTY;
                }
            }
            if ((object = this.dispatchReceiver) != null && (object2 = ((RealVariable)object).getStability(flow, session2)) != null) {
                Object object3;
                Object object4;
                Object it = object4 = object2;
                boolean bl = false;
                Object object5 = object3 = it != SmartcastStability.STABLE_VALUE ? object4 : null;
                if (object3 != null) {
                    it = object3;
                    boolean bl2 = false;
                    return it;
                }
            }
        }
        return SmartcastStability.STABLE_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFinalType(Flow flow, FirSession session2) {
        ConeKotlinType it;
        if (DfaVariablesKt.access$isFinal(this.originalType, session2)) return true;
        TypeStatement typeStatement = flow.getTypeStatement(this);
        Object object = typeStatement;
        if (typeStatement == null) return false;
        Set<ConeKotlinType> set = ((TypeStatement)object).getExactType();
        object = set;
        if (set == null) return false;
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ConeKotlinType)element$iv;
            boolean bl = false;
        } while (!DfaVariablesKt.access$isFinal(it, session2));
        return true;
    }

    private final PropertyStability getPropertyStability() {
        Lazy lazy = this.propertyStability$delegate;
        return (PropertyStability)((Object)lazy.getValue());
    }

    private static final PropertyStability propertyStability_delegate$lambda$4(RealVariable this$0) {
        PropertyStability propertyStability;
        Object fir = this$0.symbol.getFir();
        if (!(fir instanceof FirVariable)) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirEnumEntry) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirErrorProperty) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirValueParameter) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirBackingField) {
            propertyStability = ((FirBackingField)fir).isVal() ? PropertyStability.PRIVATE_OR_CONST_VAL : PropertyStability.MUTABLE_PROPERTY;
        } else if (fir instanceof FirField) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)fir;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            propertyStability = (modality == null ? true : (modality$iv = modality) == Modality.FINAL) ? PropertyStability.PUBLIC_FINAL_VAL : PropertyStability.MUTABLE_PROPERTY;
        } else if (fir instanceof FirProperty) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)fir;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                propertyStability = PropertyStability.EXPECT_PROPERTY;
            } else if (((FirProperty)fir).getDelegate() != null) {
                propertyStability = PropertyStability.DELEGATED_PROPERTY;
            } else if (((FirProperty)fir).isLocal() && ((FirProperty)fir).isVar()) {
                propertyStability = PropertyStability.CAPTURED_VARIABLE;
            } else if (((FirProperty)fir).isLocal()) {
                propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
            } else if (((FirProperty)fir).isVar()) {
                propertyStability = PropertyStability.MUTABLE_PROPERTY;
            } else if (((FirProperty)fir).getReceiverParameter() != null) {
                propertyStability = PropertyStability.PROPERTY_WITH_GETTER;
            } else {
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)fir).getGetter();
                if (!(firPropertyAccessor == null ? true : firPropertyAccessor instanceof FirDefaultPropertyAccessor)) {
                    propertyStability = PropertyStability.PROPERTY_WITH_GETTER;
                } else {
                    FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)fir;
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                        propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
                    } else {
                        Modality modality$iv;
                        FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)fir;
                        boolean $i$f$isFinal = false;
                        Modality modality = $this$isFinal$iv.getStatus().getModality();
                        propertyStability = (modality == null ? true : (modality$iv = modality) == Modality.FINAL) ? PropertyStability.PUBLIC_FINAL_VAL : PropertyStability.PUBLIC_OPEN_VAL;
                    }
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return propertyStability;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001a\u0010\b\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable$Companion;", "", "<init>", "()V", "local", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "receiver", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "semantics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RealVariable local(@NotNull FirVariableSymbol<?> symbol) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            return new RealVariable((FirBasedSymbol)symbol, false, null, null, symbol.getResolvedReturnType());
        }

        @NotNull
        public final RealVariable receiver(@NotNull FirBasedSymbol<?> symbol, @NotNull ConeKotlinType type2) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new RealVariable(symbol, true, null, null, type2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

