/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutliningLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.JsScopesCollector;
import org.jetbrains.kotlin.ir.backend.js.lower.KotlinLocalsUsageCollector;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u0013J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020.J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J*\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00140:H\u0002J\u001c\u0010<\u001a\u0002032\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00140:H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R3\u0010\u0011\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u00150\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutlineTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "outlinedFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getOutlinedFunctions", "()Ljava/util/List;", "localScopes", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lkotlin/collections/HashMap;", "getLocalScopes", "withLocalScope", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "registerValueDeclaration", "", "irValueDeclaration", "findValueDeclarationWithName", "name", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "outlineJsCodeIfNeeded", "addJsFunAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "outlinedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createJsFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "jsStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "kotlinLocalsUsedInJs", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "createOutlinedFunction", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutlineTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,325:1\n116#1,4:328\n116#1,4:332\n1863#2,2:326\n1872#2,3:337\n1863#2,2:340\n1863#2:346\n1864#2:353\n1#3:336\n237#4,4:342\n349#4,6:347\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutlineTransformer\n*L\n144#1:328,4\n148#1:332,4\n109#1:326,2\n190#1:337,3\n221#1:340,2\n239#1:346\n239#1:353\n228#1:342,4\n240#1:347,6\n*E\n"})
final class JsCodeOutlineTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext backendContext;
    @NotNull
    private final IrDeclaration container;
    @NotNull
    private final List<IrFunction> outlinedFunctions;
    @NotNull
    private final List<HashMap<String, IrValueDeclaration>> localScopes;

    public JsCodeOutlineTransformer(@NotNull JsIrBackendContext backendContext, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.backendContext = backendContext;
        this.container = container;
        this.outlinedFunctions = new ArrayList();
        Object[] objectArray = new HashMap[]{new HashMap()};
        this.localScopes = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.container instanceof IrFunction) {
            Iterable $this$forEach$iv = ((IrFunction)this.container).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                this.registerValueDeclaration(it);
            }
        }
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final IrDeclaration getContainer() {
        return this.container;
    }

    @NotNull
    public final List<IrFunction> getOutlinedFunctions() {
        return this.outlinedFunctions;
    }

    @NotNull
    public final List<HashMap<String, IrValueDeclaration>> getLocalScopes() {
        return this.localScopes;
    }

    public final <T> T withLocalScope(@NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this.getLocalScopes(), new HashMap());
        Object res2 = body2.invoke();
        UtilsKt.pop(this.getLocalScopes());
        return (T)res2;
    }

    public final void registerValueDeclaration(@NotNull IrValueDeclaration irValueDeclaration) {
        Intrinsics.checkNotNullParameter((Object)irValueDeclaration, (String)"irValueDeclaration");
        Name name2 = irValueDeclaration.getName();
        if (!name2.isSpecial()) {
            String string2 = name2.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
            String identifier = string2;
            HashMap hashMap = (HashMap)CollectionsKt.lastOrNull(this.localScopes);
            if (hashMap == null) {
                CompilationExceptionKt.compilationException("Expecting a scope", irValueDeclaration);
                throw new KotlinNothingValueException();
            }
            HashMap currentScope = hashMap;
            ((Map)currentScope).put(identifier, irValueDeclaration);
        }
    }

    @Nullable
    public final IrValueDeclaration findValueDeclarationWithName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        for (int i = this.localScopes.size() - 1; -1 < i; --i) {
            HashMap<String, IrValueDeclaration> scope2 = this.localScopes.get(i);
            IrValueDeclaration irValueDeclaration = scope2.get(name2);
            if (irValueDeclaration == null) continue;
            return irValueDeclaration;
        }
        return null;
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsCodeOutlineTransformer this_$iv = this;
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this_$iv.getLocalScopes(), new HashMap());
        boolean bl = false;
        IrExpression res$iv = super.visitContainerExpression(expression2);
        UtilsKt.pop(this_$iv.getLocalScopes());
        return res$iv;
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JsCodeOutlineTransformer this_$iv = this;
        boolean $i$f$withLocalScope = false;
        UtilsKt.push(this_$iv.getLocalScopes(), new HashMap());
        boolean bl = false;
        IrStatement res$iv = super.visitDeclaration(declaration);
        UtilsKt.pop(this_$iv.getLocalScopes());
        return res$iv;
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrStatement it = irStatement = super.visitValueParameter(declaration);
        boolean bl = false;
        this.registerValueDeclaration(declaration);
        return irStatement;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrStatement it = irStatement = super.visitVariable(declaration);
        boolean bl = false;
        this.registerValueDeclaration(declaration);
        return irStatement;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = this.outlineJsCodeIfNeeded(expression2);
        if (irExpression == null) {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrExpression outlineJsCodeIfNeeded(@NotNull IrCall expression2) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.backendContext.getIntrinsics().getJsCode())) {
            return null;
        }
        IrExpression irExpression = expression2.getValueArgument(0);
        if (irExpression == null) {
            CompilationExceptionKt.compilationException("Expected js code string", expression2);
            throw new KotlinNothingValueException();
        }
        IrExpression jsCodeArg = irExpression;
        List<JsStatement> list = JsCodeKt.translateJsCodeIntoStatementList(jsCodeArg, this.backendContext, this.container);
        if (list == null) {
            return null;
        }
        List<JsStatement> jsStatements = list;
        JsScopesCollector jsScopesCollector = new JsScopesCollector();
        RecursiveJsVisitor $this$outlineJsCodeIfNeeded_u24lambda_u245 = jsScopesCollector;
        boolean bl = false;
        $this$outlineJsCodeIfNeeded_u24lambda_u245.acceptList(jsStatements);
        JsScopesCollector scope2 = jsScopesCollector;
        RecursiveJsVisitor $this$outlineJsCodeIfNeeded_u24lambda_u246 = $this$outlineJsCodeIfNeeded_u24lambda_u245 = new KotlinLocalsUsageCollector(scope2, (Function1<? super String, ? extends IrValueDeclaration>)((Function1)new Function1<String, IrValueDeclaration>((Object)this){

            public final IrValueDeclaration invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JsCodeOutlineTransformer)this.receiver).findValueDeclarationWithName(p0);
            }
        }));
        boolean bl2 = false;
        $this$outlineJsCodeIfNeeded_u24lambda_u246.acceptList(jsStatements);
        RecursiveJsVisitor localsUsageCollector2 = $this$outlineJsCodeIfNeeded_u24lambda_u245;
        Map<JsName, IrValueDeclaration> kotlinLocalsUsedInJs = ((KotlinLocalsUsageCollector)localsUsageCollector2).getUsedLocals();
        if (kotlinLocalsUsedInJs.isEmpty()) {
            return null;
        }
        IrSimpleFunction outlinedFunction = this.createOutlinedFunction(kotlinLocalsUsedInJs);
        ((Collection)this.outlinedFunctions).add(outlinedFunction);
        IrConstructorCall annotation = this.addJsFunAnnotation(outlinedFunction);
        JsFunction newFun2 = this.createJsFunction(jsStatements, kotlinLocalsUsedInJs);
        String string2 = newFun2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String jsFunCode = string2;
        annotation.putValueArgument(0, IrUtilsKt.toIrConst$default(jsFunCode, this.backendContext.getIrBuiltIns().getStringType(), 0, 0, 6, null));
        DeclarationIrBuilder $this$outlineJsCodeIfNeeded_u24lambda_u249 = LowerUtilsKt.createIrBuilder$default(this.backendContext, this.container.getSymbol(), 0, 0, 6, null);
        boolean bl3 = false;
        IrFunctionAccessExpression $this$outlineJsCodeIfNeeded_u24lambda_u249_u24lambda_u248 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$outlineJsCodeIfNeeded_u24lambda_u249, outlinedFunction);
        boolean bl4 = false;
        Iterable $this$forEachIndexed$iv = kotlinLocalsUsedInJs.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void local;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv;
            int index = n;
            boolean bl5 = false;
            $this$outlineJsCodeIfNeeded_u24lambda_u249_u24lambda_u248.putValueArgument(index, ExpressionHelpersKt.irGet($this$outlineJsCodeIfNeeded_u24lambda_u249, (IrValueDeclaration)local));
        }
        return irFunctionAccessExpression;
    }

    private final IrConstructorCall addJsFunAnnotation(IrSimpleFunction outlinedFunction) {
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.backendContext, (IrSymbol)outlinedFunction.getSymbol(), 0, 0, 6, null);
        IrConstructorCall annotation = ExpressionHelpersKt.irCallConstructor(builder, (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(this.backendContext.getIntrinsics().getJsFunAnnotationSymbol())), CollectionsKt.emptyList());
        outlinedFunction.setAnnotations(CollectionsKt.plus((Collection)outlinedFunction.getAnnotations(), (Object)annotation));
        return annotation;
    }

    private final JsFunction createJsFunction(List<? extends JsStatement> jsStatements, Map<JsName, ? extends IrValueDeclaration> kotlinLocalsUsedInJs) {
        JsStatement jsStatement;
        Object object;
        block5: {
            object = jsStatements;
            ListIterator<? extends JsStatement> listIterator = object.listIterator(object.size());
            while (listIterator.hasPrevious()) {
                JsStatement jsStatement2;
                JsStatement it = jsStatement2 = listIterator.previous();
                boolean bl = false;
                if (!(!(it instanceof JsSingleLineComment) && !(it instanceof JsMultiLineComment))) continue;
                jsStatement = jsStatement2;
                break block5;
            }
            jsStatement = null;
        }
        JsStatement lastStatement = jsStatement;
        List newStatements = CollectionsKt.toMutableList((Collection)jsStatements);
        object = lastStatement;
        if (!(object instanceof JsReturn)) {
            if (object instanceof JsExpressionStatement) {
                newStatements.set(CollectionsKt.getLastIndex(jsStatements), new JsReturn(((JsExpressionStatement)lastStatement).getExpression()));
            } else {
                ((Collection)newStatements).add(new JsReturn(new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3))));
            }
        }
        JsFunction newFun2 = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(newStatements), "Outlined js() call");
        Iterable $this$forEach$iv = kotlinLocalsUsedInJs.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName jsName = (JsName)element$iv;
            boolean bl = false;
            newFun2.getParameters().add(new JsParameter(jsName));
        }
        return newFun2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createOutlinedFunction(Map<JsName, ? extends IrValueDeclaration> kotlinLocalsUsedInJs) {
        String string2;
        IrFunctionBuilder irFunctionBuilder;
        IrFunctionBuilder $this$createOutlinedFunction_u24lambda_u2413;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv;
        IrFactory $this$buildFun$iv;
        block4: {
            block3: {
                void it;
                $this$buildFun$iv = this.backendContext.getIrFactory();
                boolean $i$f$buildFun = false;
                $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
                boolean bl = false;
                $this$createOutlinedFunction_u24lambda_u2413 = $this$buildFun_u24lambda_u2420$iv;
                boolean bl2 = false;
                IrDeclaration irDeclaration2 = this.container;
                Object object = irDeclaration2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclaration2 : null;
                String containerName = object != null && (object = object.getName()) != null ? ((Name)object).asString() : null;
                irFunctionBuilder = $this$createOutlinedFunction_u24lambda_u2413;
                string2 = containerName;
                if (string2 == null) break block3;
                String string3 = string2;
                IrFunctionBuilder irFunctionBuilder2 = irFunctionBuilder;
                boolean bl3 = false;
                String string4 = (String)it + "$outlinedJsCode$";
                irFunctionBuilder = irFunctionBuilder2;
                string2 = string4;
                if (string4 != null) break block4;
            }
            string2 = "outlinedJsCode$";
        }
        irFunctionBuilder.setName(Name.identifier(string2));
        $this$createOutlinedFunction_u24lambda_u2413.setReturnType(this.backendContext.getDynamicType());
        $this$createOutlinedFunction_u24lambda_u2413.setVisibility(DescriptorVisibilities.LOCAL);
        $this$createOutlinedFunction_u24lambda_u2413.setExternal(true);
        $this$createOutlinedFunction_u24lambda_u2413.setOrigin(JsCodeOutliningLowering.Companion.getOUTLINED_JS_CODE_ORIGIN());
        IrSimpleFunction outlinedFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        outlinedFunction.setBody(this.backendContext.getIrFactory().createBlockBody(-1, -1));
        Iterable $this$forEach$iv = kotlinLocalsUsedInJs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            IrValueDeclaration local = (IrValueDeclaration)element$iv;
            boolean bl = false;
            IrFunction $this$addValueParameter$iv = outlinedFunction;
            boolean $i$f$addValueParameter = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
            boolean bl4 = false;
            IrValueParameterBuilder $this$createOutlinedFunction_u24lambda_u2415_u24lambda_u2414 = $this$addValueParameter_u24lambda_u2432$iv;
            boolean bl5 = false;
            $this$createOutlinedFunction_u24lambda_u2415_u24lambda_u2414.setName(local.getName());
            $this$createOutlinedFunction_u24lambda_u2415_u24lambda_u2414.setType(local.getType());
            IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2432$iv, $this$addValueParameter$iv);
            boolean bl6 = false;
            $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        }
        return outlinedFunction;
    }
}

