/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateStaticPropertyProxy", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "proxyParent", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateStaticMethodProxy", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isJsStaticDeclaration", "", "excludeFromJsExport", "", "generateJsExportIgnoreCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsStaticLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsStaticLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,100:1\n1#2:101\n1#2:103\n28#3:102\n29#3:104\n121#4,4:105\n237#4,4:109\n1557#5:113\n1628#5,3:114\n416#6,10:117\n72#7,2:127\n*S KotlinDebug\n*F\n+ 1 JsStaticLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsStaticLowering\n*L\n29#1:103\n29#1:102\n29#1:104\n43#1:105,4\n56#1:109,4\n66#1:113\n66#1:114,3\n68#1:117,10\n68#1:127,2\n*E\n"})
public final class JsStaticLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public JsStaticLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrClass irClass = IrUtilsKt.getParentClassOrNull(declaration);
        if (!(irClass != null ? irClass.isCompanion() : false) || !this.isJsStaticDeclaration(declaration)) {
            return null;
        }
        IrClass containingClass = IrUtilsKt.getParentAsClass(IrUtilsKt.getParentAsClass(declaration));
        IrDeclaration irDeclaration2 = declaration;
        if (irDeclaration2 instanceof IrSimpleFunction) {
            IrDeclaration irDeclaration3 = declaration;
            IrSimpleFunction it = (IrSimpleFunction)irDeclaration3;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)(it.getCorrespondingPropertySymbol() == null ? irDeclaration3 : null);
            irElement = irSimpleFunction != null ? this.generateStaticMethodProxy(irSimpleFunction, containingClass) : null;
        } else if (irDeclaration2 instanceof IrProperty) {
            irElement = this.generateStaticPropertyProxy((IrProperty)declaration, containingClass);
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unexpected declaration type";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$transformFlat_u24lambda_u241 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$transformFlat_u24lambda_u241.withIrEntry("declaration", declaration);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (irElement == null) {
            return null;
        }
        IrElement proxyDeclaration = irElement;
        containingClass.getDeclarations().add((IrDeclaration)proxyDeclaration);
        this.excludeFromJsExport(declaration);
        return null;
    }

    private final IrProperty generateStaticPropertyProxy(IrProperty $this$generateStaticPropertyProxy, IrClass proxyParent) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction irSimpleFunction2;
        IrSimpleFunction it;
        IrProperty irProperty;
        IrProperty originalProperty = $this$generateStaticPropertyProxy;
        IrFactory $this$buildProperty$iv = this.context.getIrFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv = new IrPropertyBuilder();
        boolean bl = false;
        Object $this$generateStaticPropertyProxy_u24lambda_u242 = $this$buildProperty_u24lambda_u248$iv;
        boolean bl2 = false;
        ((IrPropertyBuilder)$this$generateStaticPropertyProxy_u24lambda_u242).updateFrom(originalProperty);
        ((IrDeclarationBuilder)$this$generateStaticPropertyProxy_u24lambda_u242).setName(originalProperty.getName());
        IrProperty $this$generateStaticPropertyProxy_u24lambda_u245 = irProperty = DeclarationBuildersKt.buildProperty($this$buildProperty$iv, $this$buildProperty_u24lambda_u248$iv);
        boolean bl3 = false;
        IrUtilsKt.copyAnnotationsFrom($this$generateStaticPropertyProxy_u24lambda_u245, originalProperty);
        $this$generateStaticPropertyProxy_u24lambda_u245.setParent(proxyParent);
        IrProperty irProperty2 = $this$generateStaticPropertyProxy_u24lambda_u245;
        IrSimpleFunction irSimpleFunction3 = originalProperty.getGetter();
        if (irSimpleFunction3 != null && (irSimpleFunction3 = this.generateStaticMethodProxy(irSimpleFunction3, proxyParent)) != null) {
            IrSimpleFunction irSimpleFunction4 = irSimpleFunction3;
            $this$generateStaticPropertyProxy_u24lambda_u242 = irSimpleFunction4;
            IrProperty irProperty3 = irProperty2;
            boolean bl4 = false;
            it.setCorrespondingPropertySymbol($this$generateStaticPropertyProxy_u24lambda_u245.getSymbol());
            irProperty2 = irProperty3;
            irSimpleFunction2 = irSimpleFunction4;
        } else {
            irSimpleFunction2 = null;
        }
        irProperty2.setGetter(irSimpleFunction2);
        IrProperty irProperty4 = $this$generateStaticPropertyProxy_u24lambda_u245;
        IrSimpleFunction irSimpleFunction5 = originalProperty.getSetter();
        if (irSimpleFunction5 != null && (irSimpleFunction5 = this.generateStaticMethodProxy(irSimpleFunction5, proxyParent)) != null) {
            IrSimpleFunction irSimpleFunction6;
            it = irSimpleFunction6 = irSimpleFunction5;
            IrProperty irProperty5 = irProperty4;
            boolean bl5 = false;
            it.setCorrespondingPropertySymbol($this$generateStaticPropertyProxy_u24lambda_u245.getSymbol());
            irProperty4 = irProperty5;
            irSimpleFunction = irSimpleFunction6;
        } else {
            irSimpleFunction = null;
        }
        irProperty4.setSetter(irSimpleFunction);
        return irProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateStaticMethodProxy(IrSimpleFunction $this$generateStaticMethodProxy, IrClass proxyParent) {
        void $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction originalFun = $this$generateStaticMethodProxy;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$generateStaticMethodProxy_u24lambda_u246 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl = false;
        $this$generateStaticMethodProxy_u24lambda_u246.updateFrom(originalFun);
        $this$generateStaticMethodProxy_u24lambda_u246.setName(originalFun.getName());
        $this$generateStaticMethodProxy_u24lambda_u246.setReturnType(originalFun.getReturnType());
        IrSimpleFunction $this$generateStaticMethodProxy_u24lambda_u2411 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl2 = false;
        IrUtilsKt.copyTypeParametersFrom$default($this$generateStaticMethodProxy_u24lambda_u2411, originalFun, null, null, 6, null);
        IrUtilsKt.copyAnnotationsFrom($this$generateStaticMethodProxy_u24lambda_u2411, originalFun);
        $this$generateStaticMethodProxy_u24lambda_u2411.setParent(proxyParent);
        IrValueParameter irValueParameter = originalFun.getExtensionReceiverParameter();
        $this$generateStaticMethodProxy_u24lambda_u2411.setExtensionReceiverParameter(irValueParameter != null ? IrUtilsKt.copyTo$default(irValueParameter, $this$generateStaticMethodProxy_u24lambda_u2411, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null) : null);
        Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = originalFun.getValueParameters();
        IrSimpleFunction irSimpleFunction2 = $this$generateStaticMethodProxy_u24lambda_u2411;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, $this$generateStaticMethodProxy_u24lambda_u2411, null, 0, 0, null, null, null, null, null, false, false, false, 4094, null));
        }
        irSimpleFunction2.setValueParameters((List)destination$iv$iv);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$generateStaticMethodProxy_u24lambda_u2411.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        item$iv$iv2 = this_$iv$iv;
        irSimpleFunction2 = $this$generateStaticMethodProxy_u24lambda_u2411;
        boolean bl4 = false;
        IrFunctionAccessExpression $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410, originalFun);
        boolean bl5 = false;
        IrUtilsKt.passTypeArgumentsFrom$default($this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410_u24lambda_u249, $this$generateStaticMethodProxy_u24lambda_u2411, 0, 2, null);
        if (originalFun.getDispatchReceiverParameter() != null) {
            $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setDispatchReceiver(IrBuilderKt.irGetObject((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410, IrUtilsKt.getParentAsClass(originalFun).getSymbol()));
        }
        IrValueParameter irValueParameter3 = $this$generateStaticMethodProxy_u24lambda_u2411.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            IrValueParameter it = irValueParameter3;
            boolean bl6 = false;
            $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setExtensionReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410, it));
        }
        Iterator iterator2 = ((Iterable)$this$generateStaticMethodProxy_u24lambda_u2411.getValueParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            IrValueParameter valueParameter2 = (IrValueParameter)iterator2.next();
            $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.putValueArgument(i, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410, valueParameter2));
        }
        IrFunctionAccessExpression delegatingCall = irFunctionAccessExpression;
        $this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$generateStaticMethodProxy_u24lambda_u2411_u24lambda_u2410, delegatingCall));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        return irSimpleFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsStaticDeclaration(IrDeclaration $this$isJsStaticDeclaration) {
        boolean bl;
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isJsStaticDeclaration, JsStandardClassIds.Annotations.JsStatic)) return true;
        Object object = $this$isJsStaticDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isJsStaticDeclaration : null;
        if (object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null) {
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)object, JsStandardClassIds.Annotations.JsStatic)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!($this$isJsStaticDeclaration instanceof IrProperty)) return false;
        IrProperty irProperty = (IrProperty)$this$isJsStaticDeclaration;
        IrDeclarationBase irDeclarationBase = irProperty;
        if (irProperty == null) return false;
        IrSimpleFunction irSimpleFunction = irDeclarationBase.getGetter();
        irDeclarationBase = irSimpleFunction;
        if (irSimpleFunction == null) return false;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irDeclarationBase, JsStandardClassIds.Annotations.JsStatic)) return false;
        return true;
    }

    private final void excludeFromJsExport(IrDeclaration $this$excludeFromJsExport) {
        $this$excludeFromJsExport.setAnnotations(CollectionsKt.plus((Collection)$this$excludeFromJsExport.getAnnotations(), (Object)this.generateJsExportIgnoreCall()));
    }

    private final IrConstructorCall generateJsExportIgnoreCall() {
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)this.context.getIntrinsics().getJsExportIgnoreAnnotationSymbol().getOwner());
        Intrinsics.checkNotNull((Object)irConstructor);
        return JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, irConstructor.getSymbol(), null, null, null, 14, null);
    }
}

