/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateStubsBody", "", "delegate", "factory", "generateFactoryBody", "stub", "generateInitBody", "ThisUsageReplaceTransformer", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSecondaryCtorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecondaryCtorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering\n+ 2 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n22#2,16:327\n38#2:344\n24#3:343\n1187#4,2:345\n1261#4,4:347\n*S KotlinDebug\n*F\n+ 1 SecondaryCtorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering\n*L\n138#1:327,16\n138#1:344\n138#1:343\n150#1:345,2\n150#1:347,4\n*E\n"})
public final class SecondaryConstructorLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public SecondaryConstructorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.context.getEs6mode()) {
            return null;
        }
        if (declaration instanceof IrConstructor && !((IrConstructor)declaration).isPrimary()) {
            IrClass irClass = IrUtilsKt.getParentAsClass(declaration);
            if (this.context.getInlineClassesUtils().isClassInlineLike(irClass)) {
                return null;
            }
            return this.transformConstructor((IrConstructor)declaration, irClass);
        }
        return null;
    }

    private final List<IrSimpleFunction> transformConstructor(IrConstructor constructor, IrClass irClass) {
        IrSimpleFunction delegate = SecondaryCtorLoweringKt.access$buildConstructorDelegate(this.context, constructor, irClass);
        IrSimpleFunction factory = SecondaryCtorLoweringKt.access$buildConstructorFactory(this.context, constructor, irClass);
        this.generateStubsBody(constructor, irClass, delegate, factory);
        Object[] objectArray = new IrSimpleFunction[]{delegate, factory};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void generateStubsBody(IrConstructor constructor, IrClass irClass, IrSimpleFunction delegate, IrSimpleFunction factory) {
        this.generateInitBody(constructor, irClass, delegate);
        this.generateFactoryBody(constructor, irClass, factory, delegate);
    }

    private final void generateFactoryBody(IrConstructor constructor, IrClass irClass, IrSimpleFunction stub, IrSimpleFunction delegate) {
        stub.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> SecondaryConstructorLowering.generateFactoryBody$lambda$2(irClass, this, delegate, stub, constructor, arg_0))));
    }

    private final void generateInitBody(IrConstructor constructor, IrClass irClass, IrSimpleFunction delegate) {
        IrValueParameter thisParam = (IrValueParameter)CollectionsKt.last(delegate.getValueParameters());
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameter oldThisReceiver = irValueParameter;
        IrBody constructorBody = constructor.getBody();
        List oldValueParameters = CollectionsKt.plus((Collection)constructor.getValueParameters(), (Object)oldThisReceiver);
        if (constructorBody != null) {
            delegate.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> SecondaryConstructorLowering.generateInitBody$lambda$4(constructorBody, delegate, thisParam, this, constructor, oldValueParameters, arg_0))));
        }
    }

    private static final Unit generateFactoryBody$lambda$2(IrClass $irClass, SecondaryConstructorLowering this$0, IrSimpleFunction $delegate, IrSimpleFunction $stub, IrConstructor $constructor, IrBlockBody $this$createBlockBody) {
        int i;
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        IrSimpleType type2 = IrUtilsKt.getDefaultType($irClass);
        IrSimpleFunctionSymbol createFunctionIntrinsic = this$0.context.getIntrinsics().getJsObjectCreateSymbol();
        IrCall irCreateCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, createFunctionIntrinsic, type2, CollectionsKt.listOf((Object)type2), null, null, 24, null);
        IrCall call2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, $delegate.getSymbol(), type2, null, null, null, 28, null);
        boolean bl = false;
        int n = $stub.getTypeParameters().size();
        for (i = 0; i < n; ++i) {
            call2.putTypeArgument(i, SecondaryCtorLoweringKt.access$toIrType($stub.getTypeParameters().get(i)));
        }
        n = $stub.getValueParameters().size();
        for (i = 0; i < n; ++i) {
            call2.putValueArgument(i, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, $stub.getValueParameters().get(i).getSymbol(), null, 2, null));
        }
        call2.putValueArgument($constructor.getValueParameters().size(), irCreateCall);
        IrCall irDelegateCall = irCall;
        if (IrUtilsKt.isSubclassOf($irClass, (IrClass)this$0.context.getIrBuiltIns().getThrowableClass().getOwner())) {
            IrCall irCall2;
            IrVariable tmp = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, irDelegateCall.getType(), $stub, null, false, false, false, irDelegateCall, null, 188, null);
            ((Collection)$this$createBlockBody.getStatements()).add(tmp);
            Collection collection = $this$createBlockBody.getStatements();
            IrCall call3 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this$0.context.getIntrinsics().getCaptureStack(), null, null, null, null, 30, null);
            boolean bl2 = false;
            call3.putValueArgument(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, tmp.getSymbol(), null, 2, null));
            call3.putValueArgument(1, BuildersKt.IrRawFunctionReferenceImpl(-1, -1, this$0.context.getIrBuiltIns().getAnyType(), $stub.getSymbol()));
            collection.add(irCall2);
            ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn($stub.getSymbol(), JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, tmp.getSymbol(), null, 2, null), this$0.context.getIrBuiltIns().getNothingType()));
        } else {
            IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn($stub.getSymbol(), irDelegateCall, this$0.context.getIrBuiltIns().getNothingType());
            ((Collection)$this$createBlockBody.getStatements()).add(irReturn);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateInitBody$lambda$4(IrBody $constructorBody, IrSimpleFunction $delegate, IrValueParameter $thisParam, SecondaryConstructorLowering this$0, IrConstructor $constructor, List $oldValueParameters, IrBlockBody $this$createBlockBody) {
        Map map;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        Iterable iterable = $this$createBlockBody.getStatements();
        IrElement $this$deepCopyWithSymbols_u24default$iv = $constructorBody;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        Object object = symbolRemapper$iv$iv;
        boolean bl = false;
        ReferencedSymbolRemapper p0 = (ReferencedSymbolRemapper)object;
        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
        IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
        if (irElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
        }
        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrBody)irElement), $delegate);
        Intrinsics.checkNotNull((Object)irElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrStatementContainer");
        CollectionsKt.addAll((Collection)iterable, (Iterable)((IrStatementContainer)irElement2).getStatements());
        ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn($delegate.getSymbol(), JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, $thisParam.getSymbol(), null, 2, null), this$0.context.getIrBuiltIns().getNothingType()));
        iterable = CollectionsKt.zip((Iterable)$oldValueParameters, (Iterable)$delegate.getValueParameters());
        IrFunctionSymbol irFunctionSymbol = $delegate.getSymbol();
        IrConstructorSymbol irConstructorSymbol = $constructor.getSymbol();
        IrElement irElement3 = $this$createBlockBody;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var10_24 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            IrValueParameter old = (IrValueParameter)pair.component1();
            IrValueParameter irValueParameter = (IrValueParameter)pair.component2();
            pair = TuplesKt.to((Object)old.getSymbol(), (Object)irValueParameter.getSymbol());
            object.put(pair.getFirst(), pair.getSecond());
        }
        Map map2 = map = destination$iv$iv;
        IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
        IrConstructorSymbol irConstructorSymbol2 = irConstructorSymbol;
        IrElementTransformerVoidKt.transformChildrenVoid(irElement3, new ThisUsageReplaceTransformer(irConstructorSymbol2, irFunctionSymbol2, map2));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering$ThisUsageReplaceTransformer;", "Lorg/jetbrains/kotlin/backend/common/ir/ValueRemapper;", "constructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "symbolMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Map;)V", "getConstructor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newThisSymbol", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
    private static final class ThisUsageReplaceTransformer
    extends ValueRemapper {
        @NotNull
        private final IrConstructorSymbol constructor;
        @NotNull
        private final IrFunctionSymbol function;
        @NotNull
        private final IrValueSymbol newThisSymbol;

        public ThisUsageReplaceTransformer(@NotNull IrConstructorSymbol constructor, @NotNull IrFunctionSymbol function2, @NotNull Map<IrValueSymbol, ? extends IrValueSymbol> symbolMapping) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter(symbolMapping, (String)"symbolMapping");
            super(symbolMapping);
            this.constructor = constructor;
            this.function = function2;
            this.newThisSymbol = (IrValueSymbol)CollectionsKt.last((Iterable)symbolMapping.values());
        }

        @NotNull
        public final IrConstructorSymbol getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final IrFunctionSymbol getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return !Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.constructor) ? super.visitReturn(expression2) : (IrExpression)new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.function, BuildersKt.IrGetValueImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), this.newThisSymbol.getOwner().getType(), this.newThisSymbol, null, 16, null));
        }
    }
}

