/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolverReplacingCoroutineIntrinsics;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/JsInlineFunctionResolver;", "Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolverReplacingCoroutineIntrinsics;", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "context", "inlineOnlyPrivateFunctions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getInlineOnlyPrivateFunctions", "()Z", "enumEntriesIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "inlineFunctionsBeforeInlining", "Lorg/jetbrains/kotlin/backend/common/Mapping$DeclarationMapping;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "allowExternalInlining", "getAllowExternalInlining", "shouldExcludeFunctionFromInlining", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getFunctionDeclaration", "backend.js"})
public final class JsInlineFunctionResolver
extends InlineFunctionResolverReplacingCoroutineIntrinsics<JsIrBackendContext> {
    private final boolean inlineOnlyPrivateFunctions;
    @NotNull
    private final IrSimpleFunctionSymbol enumEntriesIntrinsic;
    @NotNull
    private final Mapping.DeclarationMapping<IrFunction, IrFunction> inlineFunctionsBeforeInlining;
    private final boolean allowExternalInlining;

    public JsInlineFunctionResolver(@NotNull JsIrBackendContext context, boolean inlineOnlyPrivateFunctions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((CommonBackendContext)context);
        this.inlineOnlyPrivateFunctions = inlineOnlyPrivateFunctions;
        this.enumEntriesIntrinsic = context.getIntrinsics().getEnumEntriesIntrinsic();
        this.inlineFunctionsBeforeInlining = context.getMapping().getInlineFunctionsBeforeInlining();
        this.allowExternalInlining = true;
    }

    @Override
    protected boolean getInlineOnlyPrivateFunctions() {
        return this.inlineOnlyPrivateFunctions;
    }

    @Override
    public boolean getAllowExternalInlining() {
        return this.allowExternalInlining;
    }

    @Override
    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol, (Object)this.enumEntriesIntrinsic) || super.shouldExcludeFunctionFromInlining(symbol);
    }

    @Override
    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        IrFunction irFunction = super.getFunctionDeclaration(symbol);
        if (irFunction == null) {
            return null;
        }
        IrFunction function2 = irFunction;
        IrFunction irFunction2 = this.inlineFunctionsBeforeInlining.get((IrFunction)((IrDeclaration)function2));
        if (irFunction2 == null) {
            return function2;
        }
        return irFunction2;
    }
}

