/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractVariableRemapper;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessorKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="JvmOptimizationLowering", description="Optimize code for JVM code generation")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isObjectEquals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getOperandsIfCallToEQEQOrEquals", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Companion", "Transformer", "backend.jvm.lower"})
public final class JvmOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmBackendContext context;

    public JvmOptimizationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final boolean isObjectEquals(IrFunction $this$isObjectEquals) {
        return Intrinsics.areEqual((Object)$this$isObjectEquals.getName().asString(), (Object)"equals") && ((Collection)$this$isObjectEquals.getValueParameters()).size() == 1 && IrTypePredicatesKt.isNullableAny($this$isObjectEquals.getValueParameters().get(0).getType()) && $this$isObjectEquals.getExtensionReceiverParameter() == null && $this$isObjectEquals.getDispatchReceiverParameter() != null;
    }

    private final Pair<IrExpression, IrExpression> getOperandsIfCallToEQEQOrEquals(IrCall call2) {
        Pair pair;
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.context.getIrBuiltIns().getEqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression2 = call2.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression right = irExpression2;
            pair = TuplesKt.to((Object)left, (Object)right);
        } else if (this.isObjectEquals((IrFunction)call2.getSymbol().getOwner())) {
            IrExpression irExpression = call2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression left = irExpression;
            IrExpression irExpression3 = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression3);
            IrExpression right = irExpression3;
            pair = TuplesKt.to((Object)left, (Object)right);
        } else {
            pair = null;
        }
        return pair;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren(new Transformer(irFile.getFileEntry(), IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context)), null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Companion;", "", "<init>", "()V", "isNegation", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNegation(IrExpression expression2) {
            if (!(expression2 instanceof IrCall)) return false;
            IrSimpleFunction not = (IrSimpleFunction)((IrCall)expression2).getSymbol().getOwner();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)not.getName(), (Object)OperatorNameConventions.NOT)) return false;
            if (not.getExtensionReceiverParameter() != null) return false;
            if (!not.getValueParameters().isEmpty()) return false;
            IrValueParameter receiver = not.getDispatchReceiverParameter();
            boolean bl2 = false;
            if (receiver == null) return false;
            if (!IrTypePredicatesKt.isBoolean(receiver.getType())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020%2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020%H\u0002J\u001e\u0010(\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020*\u0018\u00010)2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\f\u0010+\u001a\u00020,*\u00020\u000eH\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010\u0015*\u00020%H\u0002J\u001a\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020/2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00100\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u000201H\u0002J$\u00103\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u0002012\b\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u00105\u001a\u00020,H\u0002J\u0018\u00106\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002012\u0006\u00107\u001a\u00020*H\u0002J\u0018\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020*H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering;Lorg/jetbrains/kotlin/ir/IrFileEntry;Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;)V", "dontTouchTemporaryVals", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashSet;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "data", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "optimizePropertyAccess", "unwrapSingleExpressionBlock", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "getInlineableValueForTemporaryVal", "statement", "removeUnnecessaryTemporaryVariables", "", "statements", "", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "reuseLoopVariableAsInductionVariableIfPossible", "irForLoopBlock", "findLoopVariablePosition", "Lkotlin/Pair;", "", "isLoopVariable", "", "rewritePostfixIncrDecr", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "rewritePrefixIncrDecr", "rewriteCompoundAssignmentAsPrefixIncrDecr", "value", "isMinus", "prefixIncr", "delta", "hasSameLineNumber", "e1", "Lorg/jetbrains/kotlin/ir/IrElement;", "e2", "getLineNumberForOffset", "offset", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1#2:504\n79#3,6:505\n156#4,6:511\n98#5,2:517\n360#6,7:519\n360#6,7:526\n*S KotlinDebug\n*F\n+ 1 JvmOptimizationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOptimizationLowering$Transformer\n*L\n123#1:505,6\n123#1:511,6\n123#1:517,2\n322#1:519,7\n365#1:526,7\n*E\n"})
    private final class Transformer
    implements IrElementTransformer<IrDeclaration> {
        @NotNull
        private final IrFileEntry fileEntry;
        @NotNull
        private final IrInlineScopeResolver inlineScopeResolver;
        @NotNull
        private final HashSet<IrVariable> dontTouchTemporaryVals;

        public Transformer(@NotNull IrFileEntry fileEntry, IrInlineScopeResolver inlineScopeResolver) {
            Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
            Intrinsics.checkNotNullParameter((Object)inlineScopeResolver, (String)"inlineScopeResolver");
            this.fileEntry = fileEntry;
            this.inlineScopeResolver = inlineScopeResolver;
            this.dontTouchTemporaryVals = new HashSet();
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, declaration);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
                return this.optimizePropertyAccess(expression2, data);
            }
            if (Companion.isNegation(expression2)) {
                Companion companion = Companion;
                IrExpression irExpression = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression);
                if (companion.isNegation(irExpression)) {
                    IrExpression irExpression2 = expression2.getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                    IrExpression irExpression3 = ((IrCall)irExpression2).getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression3);
                    return irExpression3;
                }
            }
            Pair pair = JvmOptimizationLowering.this.getOperandsIfCallToEQEQOrEquals(expression2);
            if (pair != null) {
                Pair pair2 = pair;
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                Pair pair3 = pair2;
                boolean bl = false;
                IrExpression left = (IrExpression)pair3.component1();
                IrExpression right = (IrExpression)pair3.component2();
                if (IrUtilsKt.isNullConst(left) && IrUtilsKt.isNullConst(right)) {
                    return IrConstImpl.Companion.constTrue(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
                if (IrUtilsKt.isNullConst(left) && right instanceof IrConst || IrUtilsKt.isNullConst(right) && left instanceof IrConst) {
                    return IrConstImpl.Companion.constFalse(expression2.getStartOffset(), expression2.getEndOffset(), jvmOptimizationLowering.getContext().getIrBuiltIns().getBooleanType());
                }
            }
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression optimizePropertyAccess(IrCall expression2, IrDeclaration data) {
            void $this$optimizePropertyAccess_u24lambda_u243;
            void this_$iv$iv$iv;
            void startOffset$iv$iv;
            void $this$irBlock$iv$iv;
            void $this$irBlock_u24default$iv;
            Object object;
            IrElement irElement;
            IrField backingField;
            IrSimpleFunction accessor;
            block12: {
                block11: {
                    accessor = (IrSimpleFunction)expression2.getSymbol().getOwner();
                    if (accessor.getModality() != Modality.FINAL || accessor.isExternal()) {
                        return expression2;
                    }
                    Object object2 = accessor.getCorrespondingPropertySymbol();
                    if (object2 == null || (object2 = (IrProperty)object2.getOwner()) == null) {
                        return expression2;
                    }
                    Object property2 = object2;
                    if (((IrProperty)property2).isLateinit()) {
                        return expression2;
                    }
                    IrField irField = ((IrProperty)property2).getBackingField();
                    if (irField == null) {
                        return expression2;
                    }
                    backingField = irField;
                    irElement = data;
                    if (irElement == null) break block11;
                    object = irElement;
                    IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
                    IrElement p0 = (IrElement)object;
                    boolean bl = false;
                    IrDeclarationContainer irDeclarationContainer = irInlineScopeResolver.findContainer(p0);
                    irElement = irDeclarationContainer;
                    if (irDeclarationContainer != null) break block12;
                }
                return expression2;
            }
            IrElement scope2 = irElement;
            if (!Intrinsics.areEqual((Object)scope2, (Object)accessor.getParent()) || !Intrinsics.areEqual((Object)scope2, (Object)backingField.getParent())) {
                return expression2;
            }
            IrExpression receiver = expression2.getDispatchReceiver();
            object = LowerUtilsKt.createIrBuilder(JvmOptimizationLowering.this.getContext(), (IrSymbol)expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = ((IrExpression)expression2).getType();
            boolean $i$f$irBlock = false;
            void var13_14 = $this$irBlock_u24default$iv;
            int n = ((IrExpression)expression2).getStartOffset();
            int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
            boolean $i$f$irBlock2 = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void var19_20 = this_$iv$iv$iv;
            Transformer transformer2 = this;
            boolean bl = false;
            if (backingField.isStatic() && receiver != null && !(receiver instanceof IrGetValue)) {
                $this$optimizePropertyAccess_u24lambda_u243.unaryPlus(IrUtilsKt.coerceToUnit(receiver, $this$optimizePropertyAccess_u24lambda_u243.getContext().getIrBuiltIns(), jvmOptimizationLowering.getContext().getTypeSystem()));
            }
            if (!((Collection)accessor.getValueParameters()).isEmpty()) {
                IrExpression irExpression;
                IrExpression irExpression2 = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u243;
                void var24_29 = $this$optimizePropertyAccess_u24lambda_u243;
                boolean bl2 = false;
                boolean bl3 = backingField.isStatic();
                IrExpression irExpression3 = !bl3 ? irExpression : null;
                IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
                Intrinsics.checkNotNull((Object)irExpression4);
                var24_29.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression3, backingField, irExpression4, null, 8, null));
            } else {
                IrExpression irExpression;
                IrExpression it = irExpression = receiver;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$optimizePropertyAccess_u24lambda_u243;
                void var24_30 = $this$optimizePropertyAccess_u24lambda_u243;
                boolean bl4 = false;
                boolean bl5 = backingField.isStatic();
                var24_30.unaryPlus(ExpressionHelpersKt.irGetField$default(irBuilderWithScope, !bl5 ? irExpression : null, backingField, null, 4, null));
            }
            return transformer2.unwrapSingleExpressionBlock(this_$iv$iv$iv.doBuild());
        }

        private final IrExpression unwrapSingleExpressionBlock(IrExpression $this$unwrapSingleExpressionBlock) {
            IrStatement irStatement;
            Object object = $this$unwrapSingleExpressionBlock instanceof IrBlock ? (IrBlock)$this$unwrapSingleExpressionBlock : null;
            IrStatement irStatement2 = irStatement = object != null && (object = object.getStatements()) != null ? (IrStatement)CollectionsKt.singleOrNull((List)object) : null;
            IrExpression irExpression = irStatement instanceof IrExpression ? (IrExpression)irStatement : null;
            if (irExpression == null) {
                irExpression = $this$unwrapSingleExpressionBlock;
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            boolean isCompilerGenerated = expression2.getOrigin() == null;
            expression2.transformChildren(this, data);
            expression2.getBranches().removeIf(arg_0 -> Transformer.visitWhen$lambda$5(arg_0 -> Transformer.visitWhen$lambda$4(isCompilerGenerated, arg_0), arg_0));
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getANDAND())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl2 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition()) && IrUtilsKt.isFalseConst(expression2.getBranches().get(1).getResult());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32 = "ANDAND condition should have an 'if true then false' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$32);
                }
                IrCallImpl $this$visitWhen_u24lambda_u247 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getAndandSymbol(), null, null, 48, null);
                boolean bl3 = false;
                $this$visitWhen_u24lambda_u247.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u247.putValueArgument(1, expression2.getBranches().get(0).getResult());
                return irCallImpl;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getOROR())) {
                IrCallImpl irCallImpl;
                boolean bl;
                boolean bl4 = bl = IrTypePredicatesKt.isBoolean(expression2.getType()) && expression2.getBranches().size() == 2 && IrUtilsKt.isTrueConst(expression2.getBranches().get(0).getResult()) && IrUtilsKt.isTrueConst(expression2.getBranches().get(1).getCondition());
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = false;
                    String $i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52 = "OROR condition should have an 'if a then true' body on its first branch, and an 'if true then b' body on its second branch. Failing expression: " + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                    throw new AssertionError((Object)$i$a$-assert-JvmOptimizationLowering$Transformer$visitWhen$52);
                }
                IrCallImpl $this$visitWhen_u24lambda_u249 = irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getBooleanType(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getOrorSymbol(), null, null, 48, null);
                boolean bl5 = false;
                $this$visitWhen_u24lambda_u249.putValueArgument(0, expression2.getBranches().get(0).getCondition());
                $this$visitWhen_u24lambda_u249.putValueArgument(1, expression2.getBranches().get(1).getResult());
                return irCallImpl;
            }
            if (expression2.getBranches().size() == 0) {
                return org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrBlockImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
            IrBranch firstBranch = (IrBranch)CollectionsKt.first(expression2.getBranches());
            if (IrUtilsKt.isTrueConst(firstBranch.getCondition()) && isCompilerGenerated) {
                return firstBranch.getResult();
            }
            return expression2;
        }

        private final IrExpression getInlineableValueForTemporaryVal(IrStatement statement) {
            IrVariable irVariable = statement instanceof IrVariable ? (IrVariable)statement : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable variable = irVariable;
            if (!Intrinsics.areEqual((Object)variable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) || variable.isVar()) {
                return null;
            }
            if (this.dontTouchTemporaryVals.contains(variable)) {
                return null;
            }
            IrExpression initializer = variable.getInitializer();
            if (initializer instanceof IrConst) {
                return initializer;
            }
            if (initializer instanceof IrGetValue) {
                IrValueDeclaration initializerValue = ((IrGetValue)initializer).getSymbol().getOwner();
                if (initializerValue instanceof IrVariable) {
                    IrExpression irExpression;
                    if (((IrVariable)initializerValue).isVar()) {
                        irExpression = null;
                    } else if (Intrinsics.areEqual((Object)initializerValue.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE())) {
                        irExpression = this.getInlineableValueForTemporaryVal(initializerValue);
                        if (irExpression == null) {
                            irExpression = initializer;
                        }
                    } else {
                        irExpression = initializer;
                    }
                    return irExpression;
                }
                if (initializerValue instanceof IrValueParameter) {
                    return ((IrValueParameter)initializerValue).isAssignable() ? null : initializer;
                }
            }
            return null;
        }

        private final void removeUnnecessaryTemporaryVariables(List<IrStatement> statements) {
            block2: {
                statements.removeIf(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda$11(arg_0 -> Transformer.removeUnnecessaryTemporaryVariables$lambda$10(this, arg_0), arg_0));
                if (statements.size() != 2) break block2;
                IrStatement first = statements.get(0);
                IrStatement second = statements.get(1);
                if (first instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)first).getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) && second instanceof IrGetValue && Intrinsics.areEqual((Object)((IrVariable)first).getSymbol(), (Object)((IrGetValue)second).getSymbol())) {
                    statements.clear();
                    IrExpression irExpression = ((IrVariable)first).getInitializer();
                    if (irExpression != null) {
                        IrExpression it = irExpression;
                        boolean bl = false;
                        statements.add(it);
                    }
                }
            }
        }

        @Override
        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
            body2.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(body2.getStatements());
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclaration data) {
            IrCall irCall;
            IrStatement subject;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN()) && (subject = (IrStatement)CollectionsKt.firstOrNull(expression2.getStatements())) instanceof IrVariable && ((IrVariable)subject).getInitializer() instanceof IrGetValue) {
                this.dontTouchTemporaryVals.add((IrVariable)subject);
            }
            if ((Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR()) || Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR())) && (irCall = this.rewritePostfixIncrDecr(expression2)) != null) {
                IrCall it = irCall;
                boolean bl = false;
                return it;
            }
            if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP())) {
                this.reuseLoopVariableAsInductionVariableIfPossible(expression2);
            }
            expression2.transformChildren(this, data);
            this.removeUnnecessaryTemporaryVariables(expression2.getStatements());
            return expression2;
        }

        /*
         * WARNING - void declaration
         */
        private final void reuseLoopVariableAsInductionVariableIfPossible(IrContainerExpression irForLoopBlock) {
            int inductionVariableIndex;
            IrStatement it;
            IrComposite loopInitialization;
            block13: {
                int n;
                void $this$indexOfFirst$iv;
                if (irForLoopBlock.getStatements().size() != 2) {
                    return;
                }
                Object object = irForLoopBlock.getStatements().get(0);
                IrComposite irComposite = object instanceof IrComposite ? (IrComposite)object : null;
                if (irComposite == null) {
                    return;
                }
                loopInitialization = irComposite;
                object = loopInitialization.getStatements();
                JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (IrStatement)item$iv;
                    boolean bl = false;
                    if (HeaderProcessorKt.isInductionVariable(it, jvmOptimizationLowering.getContext())) {
                        n = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n = inductionVariableIndex = -1;
            }
            if (inductionVariableIndex < 0) {
                return;
            }
            IrStatement $i$f$indexOfFirst = loopInitialization.getStatements().get(inductionVariableIndex);
            IrVariable irVariable = $i$f$indexOfFirst instanceof IrVariable ? (IrVariable)$i$f$indexOfFirst : null;
            if (irVariable == null) {
                return;
            }
            IrVariable inductionVariable = irVariable;
            Pair<IrContainerExpression, Integer> pair = this.findLoopVariablePosition(irForLoopBlock.getStatements().get(1));
            if (pair == null) {
                return;
            }
            Pair<IrContainerExpression, Integer> loopVariablePosition = pair;
            IrContainerExpression loopVariableContainer = (IrContainerExpression)loopVariablePosition.component1();
            int loopVariableIndex = ((Number)loopVariablePosition.component2()).intValue();
            it = loopVariableContainer.getStatements().get(loopVariableIndex);
            IrVariable irVariable2 = it instanceof IrVariable ? (IrVariable)it : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable loopVariable = irVariable2;
            IrExpression irExpression = loopVariable.getInitializer();
            if (irExpression == null) {
                return;
            }
            IrExpression loopVariableInitializer = irExpression;
            if (!(loopVariableInitializer instanceof IrGetValue)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((IrGetValue)loopVariableInitializer).getSymbol(), (Object)inductionVariable.getSymbol())) {
                return;
            }
            IrType inductionVariableType = inductionVariable.getType();
            IrType loopVariableType = loopVariable.getType();
            if (IrTypeUtilsKt.isNullable(loopVariableType)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull(loopVariableType), (Object)IrTypesKt.getClassifierOrNull(inductionVariableType))) {
                return;
            }
            IrVariableImpl newLoopVariable = BuildersKt.IrVariableImpl(loopVariable.getStartOffset(), loopVariable.getEndOffset(), loopVariable.getOrigin(), new IrVariableSymbolImpl(null, 1, null), loopVariable.getName(), loopVariableType, true, false, false);
            newLoopVariable.setInitializer(inductionVariable.getInitializer());
            newLoopVariable.setParent(inductionVariable.getParent());
            loopInitialization.getStatements().set(inductionVariableIndex, newLoopVariable);
            loopVariableContainer.getStatements().remove(loopVariableIndex);
            AbstractVariableRemapper remapper2 = new AbstractVariableRemapper(inductionVariable, loopVariable, newLoopVariable){
                final /* synthetic */ IrVariable $inductionVariable;
                final /* synthetic */ IrVariable $loopVariable;
                final /* synthetic */ IrVariableImpl $newLoopVariable;
                {
                    this.$inductionVariable = $inductionVariable;
                    this.$loopVariable = $loopVariable;
                    this.$newLoopVariable = $newLoopVariable;
                }

                protected IrValueDeclaration remapVariable(IrValueDeclaration value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return Intrinsics.areEqual((Object)value2, (Object)this.$inductionVariable) || Intrinsics.areEqual((Object)value2, (Object)this.$loopVariable) ? (IrValueDeclaration)this.$newLoopVariable : null;
                }
            };
            irForLoopBlock.getStatements().get(1).transformChildren(remapper2, null);
        }

        private final Pair<IrContainerExpression, Integer> findLoopVariablePosition(IrStatement statement) {
            IrStatement irStatement = statement;
            if (irStatement instanceof IrDoWhileLoop) {
                int loopVariableIndex;
                IrComposite iterationInitialization;
                block10: {
                    int n;
                    if (!Intrinsics.areEqual((Object)((IrDoWhileLoop)statement).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getDO_WHILE_COUNTER_LOOP())) {
                        return null;
                    }
                    IrExpression irExpression = ((IrDoWhileLoop)statement).getBody();
                    IrComposite irComposite = irExpression instanceof IrComposite ? (IrComposite)irExpression : null;
                    if (irComposite == null) {
                        return null;
                    }
                    IrComposite doWhileLoopBody = irComposite;
                    if (!Intrinsics.areEqual((Object)doWhileLoopBody.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE())) {
                        return null;
                    }
                    IrStatement irStatement2 = doWhileLoopBody.getStatements().get(0);
                    IrComposite irComposite2 = irStatement2 instanceof IrComposite ? (IrComposite)irStatement2 : null;
                    if (irComposite2 == null) {
                        return null;
                    }
                    iterationInitialization = irComposite2;
                    List<IrStatement> $this$indexOfFirst$iv = iterationInitialization.getStatements();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<IrStatement> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        IrStatement item$iv;
                        IrStatement it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (this.isLoopVariable(it)) {
                            n = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n = loopVariableIndex = -1;
                }
                if (loopVariableIndex < 0) {
                    return null;
                }
                return TuplesKt.to((Object)iterationInitialization, (Object)loopVariableIndex);
            }
            if (irStatement instanceof IrWhen) {
                IrExpression irExpression = ((IrWhen)statement).getBranches().get(0).getResult();
                IrDoWhileLoop irDoWhileLoop = irExpression instanceof IrDoWhileLoop ? (IrDoWhileLoop)irExpression : null;
                if (irDoWhileLoop == null) {
                    return null;
                }
                IrDoWhileLoop doWhileLoop = irDoWhileLoop;
                return this.findLoopVariablePosition(doWhileLoop);
            }
            return null;
        }

        private final boolean isLoopVariable(IrStatement $this$isLoopVariable) {
            return $this$isLoopVariable instanceof IrVariable && Intrinsics.areEqual((Object)((IrVariable)$this$isLoopVariable).getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_VARIABLE());
        }

        private final IrCall rewritePostfixIncrDecr(IrContainerExpression $this$rewritePostfixIncrDecr) {
            if (!Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_INCR()) && !Intrinsics.areEqual((Object)$this$rewritePostfixIncrDecr.getOrigin(), (Object)IrStatementOrigin.Companion.getPOSTFIX_DECR())) {
                return null;
            }
            IrStatement irStatement = $this$rewritePostfixIncrDecr.getStatements().get(0);
            IrVariable irVariable = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
            if (irVariable == null) {
                return null;
            }
            IrVariable tmpVar = irVariable;
            IrExpression irExpression = tmpVar.getInitializer();
            IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
            if (irGetValue == null) {
                return null;
            }
            IrGetValue getIncrVar = irGetValue;
            if (!IrTypePredicatesKt.isInt(getIncrVar.getType())) {
                return null;
            }
            IrStatement irStatement2 = $this$rewritePostfixIncrDecr.getStatements().get(1);
            IrSetValue irSetValue = irStatement2 instanceof IrSetValue ? (IrSetValue)irStatement2 : null;
            if (irSetValue == null) {
                return null;
            }
            IrSetValue setVar = irSetValue;
            if (!Intrinsics.areEqual((Object)setVar.getSymbol(), (Object)getIncrVar.getSymbol())) {
                return null;
            }
            IrExpression irExpression2 = setVar.getValue();
            IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
            if (irCall == null) {
                return null;
            }
            IrCall setVarValue = irCall;
            Name calleeName = ((IrSimpleFunction)setVarValue.getSymbol().getOwner()).getName();
            if (!Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) && !Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.DEC)) {
                return null;
            }
            IrExpression irExpression3 = setVarValue.getDispatchReceiver();
            IrGetValue irGetValue2 = irExpression3 instanceof IrGetValue ? (IrGetValue)irExpression3 : null;
            if (irGetValue2 == null) {
                return null;
            }
            IrGetValue calleeArg = irGetValue2;
            if (!Intrinsics.areEqual((Object)calleeArg.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrStatement irStatement3 = $this$rewritePostfixIncrDecr.getStatements().get(2);
            IrGetValue irGetValue3 = irStatement3 instanceof IrGetValue ? (IrGetValue)irStatement3 : null;
            if (irGetValue3 == null) {
                return null;
            }
            IrGetValue getTmpVar = irGetValue3;
            if (!Intrinsics.areEqual((Object)getTmpVar.getSymbol(), (Object)tmpVar.getSymbol())) {
                return null;
            }
            IrConstImpl delta = Intrinsics.areEqual((Object)calleeName, (Object)OperatorNameConventions.INC) ? IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), 1) : IrConstImpl.Companion.int($this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIrBuiltIns().getIntType(), -1);
            IrStatement $this$rewritePostfixIncrDecr_u24lambda_u2416 = irStatement3 = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$rewritePostfixIncrDecr.getStartOffset(), $this$rewritePostfixIncrDecr.getEndOffset(), JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPostfixIncrDecr());
            boolean bl = false;
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u2416).putValueArgument(0, getIncrVar);
            ((IrMemberAccessExpression)$this$rewritePostfixIncrDecr_u24lambda_u2416).putValueArgument(1, delta);
            return (IrCall)irStatement3;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration variable = expression2.getSymbol().getOwner();
            IrExpression replacement = this.getInlineableValueForTemporaryVal(variable);
            return replacement instanceof IrConst ? (IrExpression)IrUtilsKt.copyWithOffsets((IrConst)replacement, expression2.getStartOffset(), expression2.getEndOffset()) : (replacement instanceof IrGetValue ? (IrExpression)IrUtilsKt.copyWithOffsets((IrGetValue)replacement, expression2.getStartOffset(), expression2.getEndOffset()) : (IrExpression)expression2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @Nullable IrDeclaration data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            IrExpression irExpression = this.rewritePrefixIncrDecr(expression2);
            if (irExpression == null) {
                irExpression = expression2;
            }
            return irExpression;
        }

        private final IrExpression rewritePrefixIncrDecr(IrSetValue expression2) {
            if (!IrTypePredicatesKt.isInt(expression2.getSymbol().getOwner().getType())) {
                return null;
            }
            IrStatementOrigin irStatementOrigin = expression2.getOrigin();
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPREFIX_DECR())) {
                return this.prefixIncr(expression2, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getPREFIX_INCR()) ? 1 : -1);
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getPLUSEQ()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getMINUSEQ())) {
                IrExpression irExpression = expression2.getValue();
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrExpression irExpression2 = ((IrCall)irExpression).getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression2);
                IrExpression argument = irExpression2;
                if (!this.hasSameLineNumber(argument, expression2)) {
                    return null;
                }
                return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getMINUSEQ()));
            }
            if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getEQ())) {
                IrExpression value2 = expression2.getValue();
                if (!this.hasSameLineNumber(value2, expression2)) {
                    return null;
                }
                if (value2 instanceof IrCall) {
                    IrExpression irExpression = ((IrCall)value2).getDispatchReceiver();
                    if (irExpression == null) {
                        return null;
                    }
                    IrExpression receiver = irExpression;
                    IrValueSymbol symbol = expression2.getSymbol();
                    if (!this.hasSameLineNumber(receiver, expression2)) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getPLUS()) || Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS())) {
                        IrExpression irExpression3 = ((IrCall)value2).getValueArgument(0);
                        Intrinsics.checkNotNull((Object)irExpression3);
                        IrExpression argument = irExpression3;
                        if (receiver instanceof IrGetValue && Intrinsics.areEqual((Object)((IrGetValue)receiver).getSymbol(), (Object)symbol) && this.hasSameLineNumber(argument, expression2)) {
                            return this.rewriteCompoundAssignmentAsPrefixIncrDecr(expression2, argument, Intrinsics.areEqual((Object)((IrCall)value2).getOrigin(), (Object)IrStatementOrigin.Companion.getMINUS()));
                        }
                    }
                }
            }
            return null;
        }

        private final IrExpression rewriteCompoundAssignmentAsPrefixIncrDecr(IrSetValue expression2, IrExpression value2, boolean isMinus) {
            if (value2 instanceof IrConst && Intrinsics.areEqual((Object)((IrConst)value2).getKind(), (Object)IrConstKind.Int.INSTANCE)) {
                Object object = ((IrConst)value2).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int delta = (Integer)object;
                int upperBound = 127 + (isMinus ? 1 : 0);
                int lowerBound = -128 + (isMinus ? 1 : 0);
                boolean bl = lowerBound <= delta ? delta <= upperBound : false;
                if (bl) {
                    return this.prefixIncr(expression2, isMinus ? -delta : delta);
                }
            }
            return null;
        }

        private final IrExpression prefixIncr(IrSetValue expression2, int delta) {
            int startOffset = expression2.getStartOffset();
            int endOffset = expression2.getEndOffset();
            IrCallImpl irCallImpl = org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.fromSymbolOwner(IrCallImpl.Companion, startOffset, endOffset, JvmOptimizationLowering.this.getContext().getIr().getSymbols().getIntPrefixIncrDecr());
            JvmOptimizationLowering jvmOptimizationLowering = JvmOptimizationLowering.this;
            IrCallImpl $this$prefixIncr_u24lambda_u2417 = irCallImpl;
            boolean bl = false;
            $this$prefixIncr_u24lambda_u2417.putValueArgument(0, org.jetbrains.kotlin.ir.expressions.impl.BuildersKt.IrGetValueImpl$default(startOffset, endOffset, expression2.getSymbol(), null, 8, null));
            $this$prefixIncr_u24lambda_u2417.putValueArgument(1, IrConstImpl.Companion.int(startOffset, endOffset, jvmOptimizationLowering.getContext().getIrBuiltIns().getIntType(), delta));
            return irCallImpl;
        }

        private final boolean hasSameLineNumber(IrElement e1, IrElement e2) {
            return this.getLineNumberForOffset(e1.getStartOffset()) == this.getLineNumberForOffset(e2.getStartOffset());
        }

        private final int getLineNumberForOffset(int offset2) {
            return this.fileEntry.getLineNumber(offset2) + 1;
        }

        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
        }

        @Override
        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitConst(@NotNull IrConst expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
        }

        @Override
        @NotNull
        public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclaration data) {
            return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
        }

        private static final boolean visitWhen$lambda$4(boolean $isCompilerGenerated, IrBranch it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return IrUtilsKt.isFalseConst(it.getCondition()) && $isCompilerGenerated;
        }

        private static final boolean visitWhen$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda$10(Transformer this$0, IrStatement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.getInlineableValueForTemporaryVal(it) != null;
        }

        private static final boolean removeUnnecessaryTemporaryVariables$lambda$11(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

