/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.dce.Context;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u000b*\u00020\u0015\u001a&\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u00020\u0019*\f\u0012\b\u0012\u00060\u001aR\u00020\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002\u001a*\u0010\u001c\u001a\u00020\u001d*\u00060\u001aR\u00020\u00022\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0002H\u0002\u00a8\u0006 "}, d2={"isObjectDefineProperty", "", "Lorg/jetbrains/kotlin/js/dce/Context;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "isObjectGetOwnPropertyDescriptor", "isDefineModule", "isDefineInlineFunction", "isWrapFunction", "isObjectFunction", "functionName", "", "isKotlinFunction", "name", "isSpecialFunction", "expr", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "isAmdDefine", "isTopLevelFunction", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "asString", "extractReachableRoots", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "context", "extractRootsImpl", "", "target", "", "js.dce"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/kotlin/js/dce/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1863#3,2:96\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/jetbrains/kotlin/js/dce/UtilKt\n*L\n80#1:96,2\n*E\n"})
public final class UtilKt {
    public static final boolean isObjectDefineProperty(@NotNull Context $this$isObjectDefineProperty, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectDefineProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($this$isObjectDefineProperty, function2, "defineProperty");
    }

    public static final boolean isObjectGetOwnPropertyDescriptor(@NotNull Context $this$isObjectGetOwnPropertyDescriptor, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectGetOwnPropertyDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isObjectFunction($this$isObjectGetOwnPropertyDescriptor, function2, "getOwnPropertyDescriptor");
    }

    public static final boolean isDefineModule(@NotNull Context $this$isDefineModule, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefineModule, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isDefineModule, function2, "defineModule");
    }

    public static final boolean isDefineInlineFunction(@NotNull Context $this$isDefineInlineFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefineInlineFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isDefineInlineFunction, function2, "defineInlineFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.DEFINE_INLINE_FUNCTION);
    }

    public static final boolean isWrapFunction(@NotNull Context $this$isWrapFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isWrapFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isKotlinFunction($this$isWrapFunction, function2, "wrapFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.WRAP_FUNCTION);
    }

    public static final boolean isObjectFunction(@NotNull Context $this$isObjectFunction, @NotNull JsExpression function2, @NotNull String functionName) {
        Context.Node node;
        Intrinsics.checkNotNullParameter((Object)$this$isObjectFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        if (!(function2 instanceof JsNameRef)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)functionName)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        if (jsNameRef == null) {
            return false;
        }
        JsNameRef receiver = jsNameRef;
        JsName jsName = receiver.getName();
        if (jsName != null) {
            JsName it = jsName;
            boolean bl = false;
            node = $this$isObjectFunction.getNodes().get(it);
        } else {
            node = null;
        }
        if (node != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)receiver.getIdent(), (Object)"Object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFunction(@NotNull Context $this$isKotlinFunction, @NotNull JsExpression function2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!(function2 instanceof JsNameRef)) return false;
        if (!Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name2)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        if (!(jsExpression instanceof JsNameRef)) return false;
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        HasMetadata hasMetadata = jsNameRef;
        if (jsNameRef == null) return false;
        if ((hasMetadata = ((JsNameRef)hasMetadata).getName()) == null) {
            return false;
        }
        HasMetadata receiver = hasMetadata;
        if (!$this$isKotlinFunction.getNodes().containsKey(receiver)) return false;
        String string2 = ((JsName)receiver).getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string3, (Object)"kotlin")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSpecialFunction(@NotNull JsExpression expr, @NotNull SpecialFunction specialFunction) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)((Object)specialFunction), (String)"specialFunction");
        if (!(expr instanceof JsNameRef)) return false;
        if (((JsNameRef)expr).getQualifier() != null) return false;
        JsName jsName = ((JsNameRef)expr).getName();
        if ((jsName != null ? MetadataProperties.getSpecialFunction(jsName) : null) != specialFunction) return false;
        return true;
    }

    public static final boolean isAmdDefine(@NotNull Context $this$isAmdDefine, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter((Object)$this$isAmdDefine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilKt.isTopLevelFunction($this$isAmdDefine, function2, "define");
    }

    public static final boolean isTopLevelFunction(@NotNull Context $this$isTopLevelFunction, @NotNull JsExpression function2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$isTopLevelFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!(function2 instanceof JsNameRef) || ((JsNameRef)function2).getQualifier() != null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((JsNameRef)function2).getIdent(), (Object)name2) && !CollectionsKt.contains((Iterable)$this$isTopLevelFunction.getNodes().keySet(), (Object)((JsNameRef)function2).getName());
    }

    @Nullable
    public static final JsLocation extractLocation(@NotNull JsNode $this$extractLocation) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$extractLocation, (String)"<this>");
        JsNode jsNode = $this$extractLocation;
        JsLocation jsLocation = jsNode instanceof SourceInfoAwareJsNode ? ((object2 = ((SourceInfoAwareJsNode)$this$extractLocation).getSource()) instanceof JsLocation ? (JsLocation)object2 : null) : (jsNode instanceof JsExpressionStatement ? ((object = ((JsExpressionStatement)$this$extractLocation).getExpression().getSource()) instanceof JsLocation ? (JsLocation)object : null) : null);
        return jsLocation;
    }

    @NotNull
    public static final String asString(@NotNull JsLocation $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        String string2 = $this$asString.getFile().substring(StringsKt.lastIndexOf$default((CharSequence)$this$asString.getFile(), (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String simpleFileName = string2;
        return simpleFileName + ':' + ($this$asString.getStartLine() + 1);
    }

    @NotNull
    public static final Iterable<Context.Node> extractReachableRoots(@NotNull Iterable<Context.Node> $this$extractReachableRoots, @NotNull Context context) {
        Intrinsics.checkNotNullParameter($this$extractReachableRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.clearVisited();
        List result2 = new ArrayList();
        Iterable<Context.Node> $this$forEach$iv = $this$extractReachableRoots;
        boolean $i$f$forEach = false;
        Iterator<Context.Node> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Context.Node element$iv;
            Context.Node it = element$iv = iterator2.next();
            boolean bl = false;
            if (!it.getReachable()) continue;
            UtilKt.extractRootsImpl(it.getOriginal(), result2, context);
        }
        return result2;
    }

    private static final void extractRootsImpl(Context.Node $this$extractRootsImpl, List<Context.Node> target, Context context) {
        if (!context.visit($this$extractRootsImpl.getOriginal())) {
            return;
        }
        Context.Node parent2 = $this$extractRootsImpl.getOriginal().getParent();
        if (parent2 == null) {
            ((Collection)target).add($this$extractRootsImpl.getOriginal());
        } else {
            UtilKt.extractRootsImpl(parent2, target, context);
        }
    }
}

