/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirCompositeSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.AbstractFirBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirClasspathBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirFallbackBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J&\u0010\u001b\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J&\u0010\u001d\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinsSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "classpathBuiltinSymbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirClasspathBuiltinSymbolProvider;", "fallbackBuiltinSymbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirFallbackBuiltinSymbolProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirClasspathBuiltinSymbolProvider;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirFallbackBuiltinSymbolProvider;)V", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPackage", "fqName", "fir-deserialization"})
public final class FirBuiltinsSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirClasspathBuiltinSymbolProvider classpathBuiltinSymbolProvider;
    @NotNull
    private final FirFallbackBuiltinSymbolProvider fallbackBuiltinSymbolProvider;

    public FirBuiltinsSymbolProvider(@NotNull FirSession session2, @NotNull FirClasspathBuiltinSymbolProvider classpathBuiltinSymbolProvider, @NotNull FirFallbackBuiltinSymbolProvider fallbackBuiltinSymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)classpathBuiltinSymbolProvider, (String)"classpathBuiltinSymbolProvider");
        Intrinsics.checkNotNullParameter((Object)fallbackBuiltinSymbolProvider, (String)"fallbackBuiltinSymbolProvider");
        super(session2);
        this.classpathBuiltinSymbolProvider = classpathBuiltinSymbolProvider;
        this.fallbackBuiltinSymbolProvider = fallbackBuiltinSymbolProvider;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        Object[] objectArray = new AbstractFirBuiltinSymbolProvider[]{this.classpathBuiltinSymbolProvider, this.fallbackBuiltinSymbolProvider};
        return FirCompositeSymbolNamesProvider.Companion.fromSymbolProviders(CollectionsKt.listOf((Object[])objectArray));
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirRegularClassSymbol firRegularClassSymbol = this.classpathBuiltinSymbolProvider.getClassLikeSymbolByClassId(classId);
        if (firRegularClassSymbol == null) {
            firRegularClassSymbol = this.fallbackBuiltinSymbolProvider.getClassLikeSymbolByClassId(classId);
        }
        return firRegularClassSymbol;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelCallableSymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelCallableSymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelFunctionSymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelFunctionSymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelPropertySymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelPropertySymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        FqName fqName2 = this.classpathBuiltinSymbolProvider.getPackage(fqName);
        if (fqName2 == null) {
            fqName2 = this.fallbackBuiltinSymbolProvider.getPackage(fqName);
        }
        return fqName2;
    }
}

