/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.partial;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.PartialLinkageErrorsLogged;
import org.jetbrains.kotlin.backend.common.linkage.partial.ClassifierExplorer;
import org.jetbrains.kotlin.backend.common.linkage.partial.MissingDeclarationStubGenerator;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartiallyLinkedIrTreePatcher;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideProvider;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageLogLevel;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageLogger;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001fH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u001e\u0010&\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinkerImpl;", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "logger", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogger;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageLogger;)V", "stubGenerator", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/MissingDeclarationStubGenerator;", "classifierExplorer", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/ClassifierExplorer;", "patcher", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartiallyLinkedIrTreePatcher;", "isEnabled", "", "()Z", "shouldBeSkipped", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exploreClassifiers", "", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "exploreClassifiersInInlineLazyIrFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateStubsAndPatchUsages", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "roots", "Lkotlin/Function0;", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "root", "collectAllStubbedSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateStubsAndPatchUsagesInternal", "patchIrTree", "ir.serialization.common"})
public final class PartialLinkageSupportForLinkerImpl
implements PartialLinkageSupportForLinker {
    @NotNull
    private final PartialLinkageLogger logger;
    @NotNull
    private final MissingDeclarationStubGenerator stubGenerator;
    @NotNull
    private final ClassifierExplorer classifierExplorer;
    @NotNull
    private final PartiallyLinkedIrTreePatcher patcher;

    public PartialLinkageSupportForLinkerImpl(@NotNull IrBuiltIns builtIns, @NotNull PartialLinkageLogger logger) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.stubGenerator = new MissingDeclarationStubGenerator(builtIns);
        this.classifierExplorer = new ClassifierExplorer(builtIns, this.stubGenerator);
        this.patcher = new PartiallyLinkedIrTreePatcher(builtIns, this.classifierExplorer, this.stubGenerator, this.logger);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean shouldBeSkipped(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.patcher.shouldBeSkipped(declaration);
    }

    @Override
    public void exploreClassifiers(@NotNull IrLinkerFakeOverrideProvider fakeOverrideBuilder) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder, (String)"fakeOverrideBuilder");
        Map<IrClass, CompatibilityMode> entries = fakeOverrideBuilder.getFakeOverrideCandidates();
        if (entries.isEmpty()) {
            return;
        }
        Set $this$exploreClassifiers_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (IrClass clazz : entries.keySet()) {
            if (this.classifierExplorer.exploreSymbol(clazz.getSymbol()) == null) continue;
            ((Collection)$this$exploreClassifiers_u24lambda_u240).add(clazz);
        }
        Set toExclude = SetsKt.build((Set)set);
        CollectionsKt.removeAll((Collection)entries.keySet(), (Iterable)toExclude);
    }

    @Override
    public void exploreClassifiersInInlineLazyIrFunction(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.classifierExplorer.exploreIrElement(function2);
    }

    @Override
    public void generateStubsAndPatchUsages(@NotNull SymbolTable symbolTable, @NotNull Function0<? extends Sequence<? extends IrModuleFragment>> roots) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        this.generateStubsAndPatchUsagesInternal(symbolTable, (Function0<Unit>)((Function0)() -> PartialLinkageSupportForLinkerImpl.generateStubsAndPatchUsages$lambda$1(this, roots)));
    }

    @Override
    public void generateStubsAndPatchUsages(@NotNull SymbolTable symbolTable, @NotNull IrDeclaration root) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.generateStubsAndPatchUsagesInternal(symbolTable, (Function0<Unit>)((Function0)() -> PartialLinkageSupportForLinkerImpl.generateStubsAndPatchUsages$lambda$2(this, root)));
    }

    @Override
    @NotNull
    public Set<IrSymbol> collectAllStubbedSymbols() {
        return this.stubGenerator.getAllStubbedSymbols();
    }

    private final void generateStubsAndPatchUsagesInternal(SymbolTable symbolTable, Function0<Unit> patchIrTree) {
        for (IrSymbol symbol : symbolTable.getDescriptorExtension().getAllUnboundSymbols()) {
            this.stubGenerator.getDeclaration(symbol);
        }
        patchIrTree.invoke();
        this.patcher.patchDeclarations(this.stubGenerator.grabDeclarationsToPatch());
        if (this.logger.getLogLevel() == PartialLinkageLogLevel.ERROR && this.patcher.getLinkageIssuesLogged() > 0) {
            PartialLinkageErrorsLogged.INSTANCE.raiseIssue(this.logger.getMessageCollector());
            throw new KotlinNothingValueException();
        }
    }

    private static final Unit generateStubsAndPatchUsages$lambda$1(PartialLinkageSupportForLinkerImpl this$0, Function0 $roots) {
        this$0.patcher.patchModuleFragments((Sequence<? extends IrModuleFragment>)((Sequence)$roots.invoke()));
        return Unit.INSTANCE;
    }

    private static final Unit generateStubsAndPatchUsages$lambda$2(PartialLinkageSupportForLinkerImpl this$0, IrDeclaration $root) {
        this$0.patcher.patchDeclarations(CollectionsKt.listOf((Object)$root));
        return Unit.INSTANCE;
    }
}

