/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.TailSuspendCalls;
import org.jetbrains.kotlin.backend.common.TailSuspendCallsCollectorKt;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 F*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003FGHB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H$J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H$J\u001c\u0010\u001b\u001a\u00020\u0014*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH$J\u001e\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H$J\u001c\u0010&\u001a\u00020\u001f*\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001fH\u0014J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010\"2\u0006\u00100\u001a\u000201H\u0002J\f\u00102\u001a\u000203*\u000204H\u0004J\u001e\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020409H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u00106\u001a\u000207H\u0002J\"\u0010A\u001a\u00020\u001a*\u00020B2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u000203R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;", "C", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "stateMachineMethodName", "Lorg/jetbrains/kotlin/name/Name;", "getStateMachineMethodName", "()Lorg/jetbrains/kotlin/name/Name;", "getCoroutineBaseClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "nameForCoroutineClass", "buildStateMachine", "", "stateMachineFunction", "transformingFunction", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateCoroutineStart", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "invokeSuspendFunction", "receiver", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializeStateMachine", "coroutineConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineClassThis", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "generateDelegatedCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "expectedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "delegatingCall", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tryTransformSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "isReturnIfSuspendedCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "simplifyTailSuspendCalls", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "tailSuspendCalls", "", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "getContinuationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "continuationClassSymbol", "buildCoroutine", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "addField", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "name", "type", "isMutable", "Companion", "BuiltCoroutine", "CoroutineBuilder", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAbstractSuspendFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering\n+ 2 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,275:1\n94#2:276\n180#3,5:277\n72#4:282\n73#4:290\n1557#5:283\n1628#5,3:284\n1872#5,3:287\n74#6,4:291\n*S KotlinDebug\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering\n*L\n109#1:276\n109#1:277,5\n109#1:282\n109#1:290\n112#1:283\n112#1:284,3\n116#1:287,3\n261#1:291,4\n*E\n"})
public abstract class AbstractSuspendFunctionsLowering<C extends CommonBackendContext>
implements FileLoweringPass {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final C context;
    @NotNull
    private final Symbols symbols;
    @NotNull
    private final IrSimpleFunctionSymbol getContinuationSymbol;
    @NotNull
    private final IrClassSymbol continuationClassSymbol;
    @NotNull
    private static final IrStatementOriginImpl STATEMENT_ORIGIN_COROUTINE_IMPL = new IrStatementOriginImpl("COROUTINE_IMPL");
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_COROUTINE_IMPL = new IrDeclarationOriginImpl("COROUTINE_IMPL", false, 2, null);

    public AbstractSuspendFunctionsLowering(@NotNull C context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.context = context;
        this.symbols = this.context.getIr().getSymbols();
        this.getContinuationSymbol = this.symbols.getGetContinuation();
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType());
        Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        this.continuationClassSymbol = (IrClassSymbol)irClassifierSymbol;
    }

    @NotNull
    public final C getContext() {
        return this.context;
    }

    @NotNull
    protected abstract Name getStateMachineMethodName();

    @NotNull
    protected abstract IrClassSymbol getCoroutineBaseClass(@NotNull IrFunction var1);

    @NotNull
    protected abstract Name nameForCoroutineClass(@NotNull IrFunction var1);

    protected abstract void buildStateMachine(@NotNull IrFunction var1, @NotNull IrFunction var2, @NotNull Map<IrValueParameter, ? extends IrField> var3);

    protected abstract void generateCoroutineStart(@NotNull IrBlockBodyBuilder var1, @NotNull IrFunction var2, @NotNull IrExpression var3);

    protected abstract void initializeStateMachine(@NotNull List<? extends IrConstructor> var1, @NotNull IrValueDeclaration var2);

    @NotNull
    protected IrExpression generateDelegatedCall(@NotNull IrBuilderWithScope $this$generateDelegatedCall, @NotNull IrType expectedType, @NotNull IrExpression delegatingCall) {
        Intrinsics.checkNotNullParameter((Object)$this$generateDelegatedCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)delegatingCall, (String)"delegatingCall");
        return delegatingCall;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        TransformKt.transformDeclarationsFlat(irFile, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrElement, List<? extends IrDeclaration>>((Object)this){

            public final List<IrDeclaration> invoke(IrElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
            }
        }));
        IrVisitorsKt.acceptVoid(irFile, new IrElementVisitorVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrVisitorsKt.acceptChildrenVoid(declaration, this);
                if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)AbstractSuspendFunctionsLowering.Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL())) {
                    TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrElement, List<? extends IrDeclaration>>(this.this$0){

                        public final List<IrDeclaration> invoke(IrElement p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
                        }
                    }));
                }
            }

            public void visitElement(IrElement element, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitValueParameter(IrValueParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitValueParameter(IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitClass(IrClass declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitFunction(IrFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitFunction(IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitConstructor(IrConstructor declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitConstructor(IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitField(IrField declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitField(IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitProperty(IrProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitProperty(IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitScript(IrScript declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitScript(IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitVariable(IrVariable declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitVariable(IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitFile(IrFile declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitFile(IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitBody(IrBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBody(IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitExpressionBody(IrExpressionBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitBlockBody(IrBlockBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCall(IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitConst(IrConst expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConst(IrConst expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetField(IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }
        });
    }

    private final List<IrDeclaration> tryTransformSuspendFunction(IrElement element) {
        List list;
        IrSimpleFunction irSimpleFunction = element instanceof IrSimpleFunction ? (IrSimpleFunction)element : null;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction function2 = irSimpleFunction;
        if (!function2.isSuspend() || function2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        TailSuspendCalls tailSuspendCalls = TailSuspendCallsCollectorKt.collectTailSuspendCalls(this.context, function2);
        Set<IrCall> tailSuspendCalls2 = tailSuspendCalls.component1();
        boolean hasNotTailSuspendCalls = tailSuspendCalls.component2();
        if (hasNotTailSuspendCalls) {
            Object[] objectArray = new IrDeclaration[]{this.buildCoroutine(function2).getClazz(), function2};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            this.simplifyTailSuspendCalls(function2, tailSuspendCalls2);
            list = null;
        }
        return list;
    }

    protected final boolean isReturnIfSuspendedCall(@NotNull IrCall $this$isReturnIfSuspendedCall) {
        Intrinsics.checkNotNullParameter((Object)$this$isReturnIfSuspendedCall, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isReturnIfSuspendedCall.getSymbol(), (Object)this.context.getIr().getSymbols().getReturnIfSuspended());
    }

    private final void simplifyTailSuspendCalls(IrSimpleFunction irFunction, Set<? extends IrCall> tailSuspendCalls) {
        if (tailSuspendCalls.isEmpty()) {
            return;
        }
        DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default((BackendContext)this.context, (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        IrBody irBody = irFunction.getBody();
        Intrinsics.checkNotNull((Object)irBody);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this, tailSuspendCalls, irBuilder, irFunction){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            final /* synthetic */ Set<IrCall> $tailSuspendCalls;
            final /* synthetic */ DeclarationIrBuilder $irBuilder;
            final /* synthetic */ IrSimpleFunction $irFunction;
            {
                this.this$0 = $receiver;
                this.$tailSuspendCalls = $tailSuspendCalls;
                this.$irBuilder = $irBuilder;
                this.$irFunction = $irFunction;
            }

            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (this.this$0.isReturnIfSuspendedCall(expression2)) {
                    IrExpression irExpression2 = expression2.getValueArgument(0);
                    irExpression = irExpression2;
                    Intrinsics.checkNotNull((Object)irExpression2);
                } else {
                    irExpression = expression2;
                }
                IrExpression shortCut = irExpression;
                IrElementTransformerVoidKt.transformChildrenVoid(shortCut, this);
                return !IrUtilsKt.isSuspend(expression2) || !this.$tailSuspendCalls.contains(expression2) ? shortCut : (IrExpression)ExpressionHelpersKt.irReturn((IrBuilderWithScope)LowerUtilsKt.at((IrBuilder)this.$irBuilder, expression2), this.this$0.generateDelegatedCall(this.$irBuilder, this.$irFunction.getReturnType(), shortCut));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final BuiltCoroutine buildCoroutine(IrSimpleFunction irFunction) {
        void $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        Collection<IrType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        BuiltCoroutine builtCoroutine;
        BuiltCoroutine coroutine = builtCoroutine = new CoroutineBuilder(irFunction).build();
        boolean bl = false;
        DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)this.context, (IrSymbol)irFunction.getSymbol(), irFunction.getStartOffset(), irFunction.getEndOffset());
        IrGeneratorWithScope $this$irBlockBody$iv = irBuilder;
        boolean $i$f$irBlockBody = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
        int n = ((IrElement)irFunction).getStartOffset();
        int endOffset$iv$iv = ((IrElement)irFunction).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var14_14 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl2 = false;
        IrConstructor constructor = coroutine.getConstructor();
        Object object = irFunction.getTypeParameters();
        IrConstructorSymbol irConstructorSymbol = constructor.getSymbol();
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        IrFunction irFunction2 = coroutine.getStateMachineFunction();
        void var22_22 = $this$buildCoroutine_u24lambda_u244_u24lambda_u243;
        AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = this;
        boolean $i$f$map22 = false;
        void var25_26 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(IrTypesKt.makeNullable(IrTypesKt.getDefaultType((IrTypeParameter)it)));
        }
        collection = (List)destination$iv$iv;
        Object $i$f$map22 = object = ExpressionHelpersKt.irCallConstructor(irBuilderWithScope, irConstructorSymbol, (List<? extends IrType>)collection);
        boolean bl4 = false;
        List<IrValueParameter> functionParameters = IrUtilsKt.getExplicitParameters(irFunction);
        Iterable $this$forEachIndexed$iv = functionParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void argument;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index = n2;
            boolean bl5 = false;
            $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242.putValueArgument(index, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243, (IrValueDeclaration)argument));
        }
        $this$buildCoroutine_u24lambda_u244_u24lambda_u243_u24lambda_u242.putValueArgument(functionParameters.size(), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u244_u24lambda_u243, this.getContinuationSymbol, ((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType(), CollectionsKt.listOf((Object)irFunction.getReturnType())));
        irBuilderWithScope = Unit.INSTANCE;
        abstractSuspendFunctionsLowering.generateCoroutineStart((IrBlockBodyBuilder)var22_22, irFunction2, (IrExpression)object);
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return builtCoroutine;
    }

    @NotNull
    public final IrField addField(@NotNull IrClass $this$addField, @NotNull Name name2, @NotNull IrType type2, boolean isMutable) {
        IrField irField;
        Intrinsics.checkNotNullParameter((Object)$this$addField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrClass klass = $this$addField;
        IrFactory $this$buildField$iv = $this$addField.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$addField_u24lambda_u245 = $this$buildField_u24lambda_u244$iv;
        boolean bl2 = false;
        $this$addField_u24lambda_u245.setStartOffset(klass.getStartOffset());
        $this$addField_u24lambda_u245.setEndOffset(klass.getEndOffset());
        $this$addField_u24lambda_u245.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL);
        $this$addField_u24lambda_u245.setName(name2);
        $this$addField_u24lambda_u245.setType(type2);
        $this$addField_u24lambda_u245.setVisibility(DescriptorVisibilities.PRIVATE);
        $this$addField_u24lambda_u245.setFinal(!isMutable);
        IrField it = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl3 = false;
        it.setParent($this$addField);
        IrUtilsKt.addChild($this$addField, it);
        return irField;
    }

    public static final /* synthetic */ List access$tryTransformSuspendFunction(AbstractSuspendFunctionsLowering $this, IrElement element) {
        return $this.tryTransformSuspendFunction(element);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "stateMachineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getClazz", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getStateMachineFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
    private static final class BuiltCoroutine {
        @NotNull
        private final IrClass clazz;
        @NotNull
        private final IrConstructor constructor;
        @NotNull
        private final IrFunction stateMachineFunction;

        public BuiltCoroutine(@NotNull IrClass clazz, @NotNull IrConstructor constructor, @NotNull IrFunction stateMachineFunction) {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)stateMachineFunction, (String)"stateMachineFunction");
            this.clazz = clazz;
            this.constructor = constructor;
            this.stateMachineFunction = stateMachineFunction;
        }

        @NotNull
        public final IrClass getClazz() {
            return this.clazz;
        }

        @NotNull
        public final IrConstructor getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final IrFunction getStateMachineFunction() {
            return this.stateMachineFunction;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$Companion;", "", "<init>", "()V", "STATEMENT_ORIGIN_COROUTINE_IMPL", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "getSTATEMENT_ORIGIN_COROUTINE_IMPL", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "DECLARATION_ORIGIN_COROUTINE_IMPL", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_COROUTINE_IMPL", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "ir.backend.common"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrStatementOriginImpl getSTATEMENT_ORIGIN_COROUTINE_IMPL() {
            return STATEMENT_ORIGIN_COROUTINE_IMPL;
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_COROUTINE_IMPL() {
            return DECLARATION_ORIGIN_COROUTINE_IMPL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "coroutineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "coroutineClassThis", "continuationType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "coroutineBaseClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "coroutineBaseClassConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineConstructors", "", "build", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "buildConstructor", "buildInvokeSuspendMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "stateMachineFunction", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nAbstractSuspendFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,275:1\n50#2,4:276\n283#2,4:315\n237#2,4:338\n16#3:280\n16#3:319\n16#3:342\n16#3:346\n1628#4,2:281\n1630#4:284\n1279#4,2:285\n1293#4,4:287\n626#4,12:303\n1628#4,3:320\n1872#4,3:334\n1628#4,3:343\n1628#4,3:347\n1#5:283\n350#6,12:291\n411#7,10:323\n72#8:333\n73#8:337\n*S KotlinDebug\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder\n*L\n137#1:276,4\n179#1:315,4\n222#1:338,4\n146#1:280\n191#1:319\n240#1:342\n245#1:346\n146#1:281,2\n146#1:284\n156#1:285,2\n156#1:287,4\n168#1:303,12\n191#1:320,3\n208#1:334,3\n240#1:343,3\n245#1:347,3\n159#1:291,12\n201#1:323,10\n201#1:333\n201#1:337\n*E\n"})
    private final class CoroutineBuilder {
        @NotNull
        private final IrFunction irFunction;
        @NotNull
        private final List<IrValueParameter> functionParameters;
        @NotNull
        private final IrClass coroutineClass;
        @NotNull
        private final IrValueParameter coroutineClassThis;
        @NotNull
        private final IrSimpleType continuationType;
        @NotNull
        private final Map<IrValueParameter, IrField> argumentToPropertiesMap;
        @NotNull
        private final IrClassSymbol coroutineBaseClass;
        @NotNull
        private final IrConstructor coroutineBaseClassConstructor;
        @NotNull
        private final List<IrConstructor> coroutineConstructors;

        /*
         * WARNING - void declaration
         */
        public CoroutineBuilder(IrFunction irFunction) {
            void $this$single$iv;
            Sequence<IrConstructor> $this$associateWith$iv;
            Iterator $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            AbstractSuspendFunctionsLowering $this$coroutineClass_u24lambda_u243;
            Object $this$buildClass$iv;
            void $this$coroutineClass_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            this.irFunction = irFunction;
            this.functionParameters = IrUtilsKt.getExplicitParameters(this.irFunction);
            IrFactory irFactory = ((BackendContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            Object object = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildClass = false;
            Object $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = false;
            IrClassBuilder irClassBuilder = $this$buildClass_u24lambda_u241$iv;
            CoroutineBuilder coroutineBuilder = this;
            boolean $i$a$-buildClass-AbstractSuspendFunctionsLowering$CoroutineBuilder$coroutineClass$22 = false;
            $this$coroutineClass_u24lambda_u240.setStartOffset(this.irFunction.getStartOffset());
            $this$coroutineClass_u24lambda_u240.setEndOffset(this.irFunction.getEndOffset());
            $this$coroutineClass_u24lambda_u240.setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            $this$coroutineClass_u24lambda_u240.setName(((AbstractSuspendFunctionsLowering)object).nameForCoroutineClass(this.irFunction));
            $this$coroutineClass_u24lambda_u240.setVisibility(DescriptorVisibilities.PRIVATE);
            $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
            object = $this$buildClass$iv;
            boolean bl = false;
            ((IrDeclarationBase)((Object)$this$coroutineClass_u24lambda_u243)).setParent(this.irFunction.getParent());
            IrUtilsKt.createParameterDeclarations((IrClass)((Object)$this$coroutineClass_u24lambda_u243));
            $this$buildClass_u24lambda_u241$iv = this.irFunction.getTypeParameters();
            void $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22 = $this$coroutineClass_u24lambda_u243;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable $i$a$-buildClass-AbstractSuspendFunctionsLowering$CoroutineBuilder$coroutineClass$22 = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void typeParam;
                IrTypeParameter irTypeParameter;
                Object item$iv$iv = iterator2.next();
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                IrTypeParameter $this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241 = irTypeParameter = IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)typeParam, (IrTypeParametersContainer)((Object)$this$coroutineClass_u24lambda_u243), 0, null, 6, null);
                boolean bl3 = false;
                $this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241.setSuperTypes(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$coroutineClass_u24lambda_u243_u24lambda_u242_u24lambda_u241.getSuperTypes(), typeParam.getSuperTypes()));
                collection.add(irTypeParameter);
            }
            $i$a$-run-DeclarationBuildersKt$buildClass$2$iv22.setTypeParameters(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            coroutineBuilder.coroutineClass = $this$buildClass$iv;
            IrValueParameter irValueParameter = this.coroutineClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            this.coroutineClassThis = irValueParameter;
            $this$buildClass$iv = new IrType[]{this.irFunction.getReturnType()};
            this.continuationType = IrTypesKt.typeWith((IrClassifierSymbol)AbstractSuspendFunctionsLowering.this.continuationClassSymbol, $this$buildClass$iv);
            $this$buildClass$iv = this.functionParameters;
            $this$coroutineClass_u24lambda_u243 = AbstractSuspendFunctionsLowering.this;
            coroutineBuilder = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                IrValueParameter $i$f$mapTo2 = (IrValueParameter)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl4 = false;
                IrField irField = $this$coroutineClass_u24lambda_u243.addField(this.coroutineClass, it.getName(), it.getType(), false);
                map.put(t, irField);
            }
            coroutineBuilder.argumentToPropertiesMap = result$iv;
            this.coroutineBaseClass = AbstractSuspendFunctionsLowering.this.getCoroutineBaseClass(this.irFunction);
            $this$associateWith$iv = IrUtilsKt.getConstructors((IrClass)this.coroutineBaseClass.getOwner());
            coroutineBuilder = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl5 = false;
                if (!(it.getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            coroutineBuilder.coroutineBaseClassConstructor = single$iv;
            this.coroutineConstructors = new ArrayList();
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuiltCoroutine build() {
            void $this$single$iv;
            Object[] objectArray = new IrType[]{IrTypesKt.getDefaultType(this.coroutineBaseClass)};
            this.coroutineClass.setSuperTypes(CollectionsKt.mutableListOf((Object[])objectArray));
            IrConstructor coroutineConstructor = this.buildConstructor();
            Iterable iterable = IrUtilsKt.simpleFunctions((IrDeclarationContainer)this.coroutineBaseClass.getOwner());
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)abstractSuspendFunctionsLowering.getStateMachineMethodName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superInvokeSuspendFunction = single$iv;
            IrSimpleFunction invokeSuspendMethod = this.buildInvokeSuspendMethod(superInvokeSuspendFunction, this.coroutineClass);
            IrUtilsKt.addFakeOverrides$default(this.coroutineClass, ((BackendContext)AbstractSuspendFunctionsLowering.this.getContext()).getTypeSystem(), null, null, 6, null);
            AbstractSuspendFunctionsLowering.this.initializeStateMachine(this.coroutineConstructors, this.coroutineClassThis);
            return new BuiltCoroutine(this.coroutineClass, coroutineConstructor, invokeSuspendMethod);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrConstructor buildConstructor() {
            void $this$buildConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249;
            void $this$buildConstructor_u24lambda_u2412_u24lambda_u2411;
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            IrFactory $this$buildConstructor$iv = ((BackendContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$buildConstructor_u24lambda_u247 = $this$buildConstructor_u24lambda_u2424$iv;
            boolean bl2 = false;
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u247).setStartOffset(this.irFunction.getStartOffset());
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u247).setEndOffset(this.irFunction.getEndOffset());
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u247).setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u247).setVisibility(this.irFunction.getVisibility());
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u247).setReturnType(IrUtilsKt.getDefaultType(this.coroutineClass));
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u247).setPrimary(true);
            IrConstructor irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            IrConstructor $this$buildConstructor_u24lambda_u2412 = irConstructor;
            boolean bl3 = false;
            $this$buildConstructor_u24lambda_u2412.setParent(this.coroutineClass);
            ((Collection)this.coroutineClass.getDeclarations()).add($this$buildConstructor_u24lambda_u2412);
            ((Collection)this.coroutineConstructors).add($this$buildConstructor_u24lambda_u2412);
            $this$buildConstructor_u24lambda_u247 = this.functionParameters;
            IrConstructor irConstructor2 = $this$buildConstructor_u24lambda_u2412;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void parameter;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)parameter, $this$buildConstructor_u24lambda_u2412, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, null, null, null, false, false, false, 4092, null));
            }
            irConstructor2.setValueParameters(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            IrValueParameter continuationParameter = this.coroutineBaseClassConstructor.getValueParameters().get(0);
            $this$buildConstructor_u24lambda_u2412.setValueParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$buildConstructor_u24lambda_u2412.getValueParameters(), IrUtilsKt.copyTo$default(continuationParameter, $this$buildConstructor_u24lambda_u2412, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, this.continuationType, null, null, false, false, false, 4028, null)));
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)$this$buildConstructor_u24lambda_u2412.getSymbol(), $this$buildConstructor_u24lambda_u2412.getStartOffset(), $this$buildConstructor_u24lambda_u2412.getEndOffset());
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv2 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void bl4 = this_$iv$iv;
            irConstructor2 = $this$buildConstructor_u24lambda_u2412;
            boolean bl5 = false;
            IrValueParameter completionParameter = (IrValueParameter)CollectionsKt.last($this$buildConstructor_u24lambda_u2412.getValueParameters());
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, this.coroutineBaseClassConstructor);
            void var20_28 = $this$buildConstructor_u24lambda_u2412_u24lambda_u2411;
            boolean bl6 = false;
            $this$buildConstructor_u24lambda_u2412_u24lambda_u2411_u24lambda_u249.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, completionParameter));
            var20_28.unaryPlus(irDelegatingConstructorCall);
            $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(BuildersKt.IrInstanceInitializerCallImpl($this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getStartOffset(), $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getEndOffset(), this.coroutineClass.getSymbol(), $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.getContext().getIrBuiltIns().getUnitType()));
            Iterable $this$forEachIndexed$iv = this.functionParameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                int index = n;
                boolean bl7 = false;
                $this$buildConstructor_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, this.coroutineClassThis), (IrField)MapsKt.getValue(this.argumentToPropertiesMap, (Object)parameter), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2412_u24lambda_u2411, $this$buildConstructor_u24lambda_u2412.getValueParameters().get(index)), null, 8, null));
            }
            irConstructor2.setBody(this_$iv$iv.doBuild());
            return irConstructor;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildInvokeSuspendMethod(IrSimpleFunction stateMachineFunction, IrClass coroutineClass) {
            IrValueParameter parameter;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Collection $this$memoryOptimizedMap$iv;
            void $this$buildFun$iv;
            Object object = ((BackendContext)AbstractSuspendFunctionsLowering.this.getContext()).getIrFactory();
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildFun = false;
            Object $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildInvokeSuspendMethod_u24lambda_u2413 = $this$buildFun_u24lambda_u2420$iv;
            boolean $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeSuspendMethod$function$22 = false;
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setStartOffset(this.irFunction.getStartOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setEndOffset(this.irFunction.getEndOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setOrigin(Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setName(stateMachineFunction.getName());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setVisibility(stateMachineFunction.getVisibility());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setReturnType(((BackendContext)abstractSuspendFunctionsLowering.getContext()).getIrBuiltIns().getAnyNType());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setInline(stateMachineFunction.isInline());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setExternal(stateMachineFunction.isExternal());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setTailrec(stateMachineFunction.isTailrec());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setSuspend(stateMachineFunction.isSuspend());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setOperator(false);
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setExpect(stateMachineFunction.isExpect());
            $this$buildInvokeSuspendMethod_u24lambda_u2413.setFakeOverride(false);
            Object $this$buildInvokeSuspendMethod_u24lambda_u2417 = object = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
            boolean bl2 = false;
            ((IrDeclarationBase)$this$buildInvokeSuspendMethod_u24lambda_u2417).setParent(coroutineClass);
            ((Collection)coroutineClass.getDeclarations()).add($this$buildInvokeSuspendMethod_u24lambda_u2417);
            $this$buildFun_u24lambda_u2420$iv = stateMachineFunction.getTypeParameters();
            Object object2 = $this$buildInvokeSuspendMethod_u24lambda_u2417;
            boolean $i$f$memoryOptimizedMap = false;
            Iterable $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeSuspendMethod$function$22 = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrTypeParameter irTypeParameter;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                IrTypeParameter $this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414 = irTypeParameter = IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)((Object)parameter), (IrTypeParametersContainer)$this$buildInvokeSuspendMethod_u24lambda_u2417, 0, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 2, null);
                boolean bl4 = false;
                $this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414.setSuperTypes(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus($this$buildInvokeSuspendMethod_u24lambda_u2417_u24lambda_u2415_u24lambda_u2414.getSuperTypes(), ((IrTypeParameter)((Object)parameter)).getSuperTypes()));
                collection.add(irTypeParameter);
            }
            object2.setTypeParameters(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            $this$memoryOptimizedMap$iv = stateMachineFunction.getValueParameters();
            object2 = $this$buildInvokeSuspendMethod_u24lambda_u2417;
            $i$f$memoryOptimizedMap = false;
            $this$mapTo$iv$iv = $this$memoryOptimizedMap$iv;
            destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                parameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(IrUtilsKt.copyTo$default(parameter, (IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417, Companion.getDECLARATION_ORIGIN_COROUTINE_IMPL(), 0, 0, null, null, null, null, null, false, false, false, 4092, null));
            }
            ((IrFunction)object2).setValueParameters(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            IrUtilsKt.createDispatchReceiverParameter$default((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417, null, 1, null);
            ((IrSimpleFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(((IrSimpleFunction)$this$buildInvokeSuspendMethod_u24lambda_u2417).getOverriddenSymbols(), stateMachineFunction.getSymbol()));
            Object function2 = object;
            AbstractSuspendFunctionsLowering.this.buildStateMachine((IrFunction)function2, this.irFunction, this.argumentToPropertiesMap);
            return function2;
        }
    }
}

