/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\b\u001a\u00020\t\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\"\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"setInlineCallMetadata", "", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psiElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "aliasedName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "name", "getName", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
@JvmName(name="InlineUtils")
public final class InlineUtils {
    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl = CallExpressionTranslator.shouldBeInlined(descriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = false;
            String $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = "Expected descriptor of callable, that should be inlined, but got: " + descriptor;
            throw new AssertionError((Object)$i$a$-assert-InlineUtils$setInlineCallMetadata$22);
        }
        Object[] $i$a$-assert-InlineUtils$setInlineCallMetadata$22 = new JsName[]{InlineUtils.aliasedName(context, descriptor), context.getInnerNameForDescriptor(descriptor)};
        Set candidateNames = SetsKt.setOf((Object[])$i$a$-assert-InlineUtils$setInlineCallMetadata$22);
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(candidateNames, descriptor, psiElement){
            final /* synthetic */ Set<JsName> $candidateNames;
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ KtElement $psiElement;
            {
                this.$candidateNames = $candidateNames;
                this.$descriptor = $descriptor;
                this.$psiElement = $psiElement;
            }

            public void visitInvocation(JsInvocation invocation) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                super.visitInvocation(invocation);
                if (CollectionsKt.contains((Iterable)this.$candidateNames, (Object)InlineUtils.getName(invocation)) || Intrinsics.areEqual((Object)((object = InlineUtils.getName(invocation)) != null && (object = MetadataProperties.getDescriptor((JsName)object)) != null ? object.getOriginal() : null), (Object)this.$descriptor.getOriginal())) {
                    MetadataProperties.setDescriptor(invocation, this.$descriptor);
                    MetadataProperties.setInline(invocation, (Boolean)true);
                    MetadataProperties.setPsiElement(invocation, (PsiElement)this.$psiElement);
                }
            }
        };
        visitor2.accept((JsNode)expression2);
        context.addInlineCall(descriptor);
    }

    public static final void setInlineCallMetadata(@NotNull JsExpression expression2, @NotNull KtElement psiElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = PsiUtils.getFunctionDescriptor(resolvedCall2);
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getFunctionDescriptor(...)");
        InlineUtils.setInlineCallMetadata(expression2, psiElement, callableDescriptor, context);
    }

    public static final void setInlineCallMetadata(@NotNull JsNameRef nameRef, @NotNull KtElement psiElement, @NotNull CallableDescriptor descriptor, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (MetadataProperties.isInline(nameRef) != null) {
            return;
        }
        MetadataProperties.setDescriptor(nameRef, descriptor);
        MetadataProperties.setInline(nameRef, (Boolean)true);
        MetadataProperties.setPsiElement(nameRef, (PsiElement)psiElement);
        context.addInlineCall(descriptor);
    }

    @NotNull
    public static final JsName aliasedName(@NotNull TranslationContext $this$aliasedName, @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasedName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        JsExpression alias = $this$aliasedName.getAliasForDescriptor(descriptor);
        JsNameRef jsNameRef = alias instanceof JsNameRef ? (JsNameRef)alias : null;
        JsName aliasName = jsNameRef != null ? jsNameRef.getName() : null;
        JsName jsName = aliasName;
        if (jsName == null) {
            JsName jsName2 = $this$aliasedName.getNameForDescriptor(descriptor);
            jsName = jsName2;
            Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"getNameForDescriptor(...)");
        }
        return jsName;
    }

    @Nullable
    public static final JsName getName(@Nullable JsExpression $this$name) {
        JsName jsName;
        JsExpression jsExpression = $this$name;
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)$this$name).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"getQualifier(...)");
            JsExpression qualifier = jsExpression2;
            jsName = InvocationUtilsKt.isCallInvocation((JsInvocation)$this$name) ? InlineUtils.getName(((JsNameRef)qualifier).getQualifier()) : InlineUtils.getName(qualifier);
        } else {
            jsName = jsExpression instanceof JsNameRef ? ((JsNameRef)$this$name).getName() : null;
        }
        return jsName;
    }
}

