/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.analysis.decompiler.psi.LoggingErrorReporter;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolveEverythingToKotlinAnyLocalClassifierResolver;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImpl;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.serialization.deserialization.ContractDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDeserializerForDecompiler;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForDecompilerBase;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "resolveDeclarationsInFacade", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "facadeFqName", "Configuration", "Companion", "decompiler-to-psi"})
public final class KotlinMetadataDeserializerForDecompiler
extends DeserializerForDecompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoBuf.PackageFragment proto;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final DeserializationComponents deserializationComponents;
    @NotNull
    private static final Logger LOG;

    public KotlinMetadataDeserializerForDecompiler(@NotNull FqName packageFqName, @NotNull ProtoBuf.PackageFragment proto, @NotNull NameResolver nameResolver, @NotNull BinaryVersion metadataVersion, @NotNull SerializerExtensionProtocol serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkNotNullParameter((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        super(packageFqName);
        this.proto = proto;
        this.nameResolver = nameResolver;
        this.metadataVersion = metadataVersion;
        NotFoundClasses notFoundClasses = new NotFoundClasses(this.getStorageManager(), this.getModuleDescriptor());
        this.deserializationComponents = new DeserializationComponents(this.getStorageManager(), this.getModuleDescriptor(), Configuration.INSTANCE, new ProtoBasedClassDataFinder(this.proto, this.nameResolver, this.metadataVersion, null, 8, null), new AnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), notFoundClasses, serializerProtocol), this.getPackageFragmentProvider(), new ResolveEverythingToKotlinAnyLocalClassifierResolver(this.getBuiltIns()), new LoggingErrorReporter(LOG), LookupTracker.DO_NOTHING.INSTANCE, flexibleTypeDeserializer, CollectionsKt.emptyList(), notFoundClasses, ContractDeserializer.Companion.getDEFAULT(), null, null, serializerProtocol.getExtensionRegistry(), null, new SamConversionResolverImpl(this.getStorageManager(), CollectionsKt.emptyList()), null, this.getEnumEntriesDeserializationSupport(), 352256, null);
    }

    @Override
    @NotNull
    protected KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    protected DeserializationComponents getDeserializationComponents() {
        return this.deserializationComponents;
    }

    @Override
    @NotNull
    public List<DeclarationDescriptor> resolveDeclarationsInFacade(@NotNull FqName facadeFqName) {
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        boolean bl = Intrinsics.areEqual((Object)facadeFqName, (Object)this.getDirectoryPackageFqName());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22 = false;
            String $i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22 = "Was called for " + facadeFqName + "; only members of " + this.getDirectoryPackageFqName() + " package are expected.";
            throw new AssertionError((Object)$i$a$-assert-KotlinMetadataDeserializerForDecompiler$resolveDeclarationsInFacade$22);
        }
        MutablePackageFragmentDescriptor dummyPackageFragment = this.createDummyPackageFragment(facadeFqName);
        PackageFragmentDescriptor packageFragmentDescriptor = dummyPackageFragment;
        ProtoBuf.Package package_ = this.proto.getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
        DeserializedPackageMemberScope membersScope = new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, this.nameResolver, this.metadataVersion, null, this.getDeserializationComponents(), "scope of dummyPackageFragment " + dummyPackageFragment.getFqName() + " in module " + this.getDeserializationComponents().getModuleDescriptor() + " @KotlinMetadataDeserializerForDecompiler", (Function0<? extends Collection<Name>>)((Function0)KotlinMetadataDeserializerForDecompiler::resolveDeclarationsInFacade$lambda$1));
        return CollectionsKt.toList((Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope, null, null, 3, null));
    }

    private static final Collection resolveDeclarationsInFacade$lambda$1() {
        return CollectionsKt.emptyList();
    }

    static {
        Logger logger = Logger.getInstance(KotlinMetadataDeserializerForDecompiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDeserializerForDecompiler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "decompiler-to-psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDeserializerForDecompiler$Configuration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "<init>", "()V", "preserveDeclarationsOrdering", "", "getPreserveDeclarationsOrdering", "()Z", "allowUnstableDependencies", "getAllowUnstableDependencies", "isJvmPackageNameSupported", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "readDeserializedContracts", "getReadDeserializedContracts", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "skipMetadataVersionCheck", "getSkipMetadataVersionCheck", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "typeAliasesAllowed", "getTypeAliasesAllowed", "decompiler-to-psi"})
    private static final class Configuration
    implements DeserializationConfiguration {
        @NotNull
        public static final Configuration INSTANCE = new Configuration();
        private final /* synthetic */ DeserializationConfiguration.Default $$delegate_0;

        private Configuration() {
            this.$$delegate_0 = DeserializationConfiguration.Default.INSTANCE;
        }

        @Override
        public boolean getPreserveDeclarationsOrdering() {
            return true;
        }

        @Override
        @NotNull
        public MetadataVersion getMetadataVersion() {
            return this.$$delegate_0.getMetadataVersion();
        }

        @Override
        public boolean getSkipMetadataVersionCheck() {
            return this.$$delegate_0.getSkipMetadataVersionCheck();
        }

        @Override
        public boolean getSkipPrereleaseCheck() {
            return this.$$delegate_0.getSkipPrereleaseCheck();
        }

        @Override
        public boolean getReportErrorsOnPreReleaseDependencies() {
            return this.$$delegate_0.getReportErrorsOnPreReleaseDependencies();
        }

        @Override
        public boolean getAllowUnstableDependencies() {
            return this.$$delegate_0.getAllowUnstableDependencies();
        }

        @Override
        public boolean getTypeAliasesAllowed() {
            return this.$$delegate_0.getTypeAliasesAllowed();
        }

        @Override
        public boolean isJvmPackageNameSupported() {
            return this.$$delegate_0.isJvmPackageNameSupported();
        }

        @Override
        public boolean getReadDeserializedContracts() {
            return this.$$delegate_0.getReadDeserializedContracts();
        }
    }
}

