/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReplSnippet;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="FlattenStringConcatenationLowering")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "tryToFold", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "constToString", "", "const", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "normalizeUnsignedValue", "", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression2) || expression2 instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression2)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression2;
            boolean bl = false;
            irExpression = this.tryToFold(BuildersKt.IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)));
        } else {
            irExpression = expression2;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    private final IrExpression tryToFold(IrStringConcatenation $this$tryToFold) {
        List folded = new ArrayList();
        for (IrExpression next : $this$tryToFold.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!(next instanceof IrConst)) {
                ((Collection)folded).add(next);
                continue;
            }
            if (!(last instanceof IrConst)) {
                ((Collection)folded).add(IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next)));
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(((IrConst)last).getStartOffset(), next.getStartOffset()), Math.max(((IrConst)last).getEndOffset(), next.getEndOffset()), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last) + this.constToString((IrConst)next)));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
        return irConst != null ? (IrExpression)irConst : (IrExpression)BuildersKt.IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
    }

    private final String constToString(IrConst irConst) {
        return String.valueOf(this.normalizeUnsignedValue(irConst));
    }

    private final Object normalizeUnsignedValue(IrConst irConst) {
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            IrConstKind kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
                return UByte.box-impl((byte)UByte.constructor-impl((byte)((Byte)object)));
            }
            if (kind instanceof IrConstKind.Short) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                return UShort.box-impl((short)UShort.constructor-impl((short)((Short)object)));
            }
            if (kind instanceof IrConstKind.Int) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                return UInt.box-impl((int)UInt.constructor-impl((int)((Integer)object)));
            }
            if (kind instanceof IrConstKind.Long) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                return ULong.box-impl((long)ULong.constructor-impl((long)((Long)object)));
            }
        }
        return irConst.getValue();
    }

    static {
        Object[] objectArray = new FqName[]{StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.string.toSafe()};
        PARENT_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0015\u0010\u000b\u001a\u00020\b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0018\u0010\u000e\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0018\u0010\u000f\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0018\u0010\u0010\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "<init>", "()V", "PARENT_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "isStringPlusCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isToString", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isNullableToString", "isToStringCall", "isSpecialToStringCall", "isStringConcatenationExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "collectStringConcatenationArguments", "", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            if (!IrUtilsKt.hasShape$default(function2, true, false, 0, 1, null, 22, null)) {
                if (!IrUtilsKt.hasShape$default(function2, false, true, 0, 1, null, 21, null)) return false;
            }
            if (!IrTypePredicatesKt.isStringClassType(function2.getParameters().get(0).getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function2.getReturnType())) return false;
            if (!Intrinsics.areEqual((Object)function2.getName(), (Object)OperatorNameConventions.PLUS)) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function2);
            if (!CollectionsKt.contains((Iterable)PARENT_NAMES, (Object)(fqName != null ? fqName.parent() : null))) return false;
            return true;
        }

        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)OperatorNameConventions.TO_STRING) && IrUtilsKt.hasShape$default($this$isToString, true, false, 0, 0, null, 30, null) && IrTypePredicatesKt.isString($this$isToString.getReturnType()) && (IrTypePredicatesKt.isAny($this$isToString.getParameters().get(0).getType()) || !((Collection)$this$isToString.getOverriddenSymbols()).isEmpty());
        }

        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            IrFunction irFunction = $this$isNullableToString;
            String string2 = OperatorNameConventions.TO_STRING.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            return IrUtilsKt.isTopLevelInPackage(irFunction, string2, StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && IrTypePredicatesKt.isString($this$isNullableToString.getReturnType()) && IrUtilsKt.hasShape$default($this$isNullableToString, false, true, 0, 0, null, 29, null) && IrTypePredicatesKt.isNullableAny($this$isNullableToString.getParameters().get(0).getType());
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isToStringCall.getSymbol().getOwner();
            return this.isToString(function2) || this.isNullableToString(function2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression2) {
            return expression2 instanceof IrStringConcatenation || expression2 instanceof IrCall && this.isStringPlusCall((IrCall)expression2);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression2) {
            List arguments = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, new IrElementVisitorVoid(arguments){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitCall(IrCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression2) || org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression2)) {
                        IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                    } else {
                        this.$arguments.add(expression2);
                    }
                }

                public void visitStringConcatenation(IrStringConcatenation expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                }

                public void visitExpression(IrExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    this.$arguments.add(expression2);
                }

                public void visitElement(IrElement element, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                public void visitDeclaration(IrDeclarationBase declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitValueParameter(IrValueParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitValueParameter(IrValueParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitClass(IrClass declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClass(IrClass declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitTypeParameter(IrTypeParameter declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitFunction(IrFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitFunction(IrFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
                }

                public void visitConstructor(IrConstructor declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitConstructor(IrConstructor declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitEnumEntry(IrEnumEntry declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitField(IrField declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitField(IrField declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitModuleFragment(IrModuleFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitProperty(IrProperty declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitProperty(IrProperty declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitScript(IrScript declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
                }

                public void visitScript(IrScript declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
                }

                public void visitReplSnippet(IrReplSnippet declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReplSnippet(this, declaration, data);
                }

                public void visitReplSnippet(IrReplSnippet declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitReplSnippet(this, declaration);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeAlias(IrTypeAlias declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitVariable(IrVariable declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
                }

                public void visitVariable(IrVariable declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitPackageFragment(IrPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitFile(IrFile declaration, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFile(IrFile declaration) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitExpression(IrExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitBody(IrBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitConstructorCall(IrConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContainerExpression(IrContainerExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitBlock(IrBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlock(IrBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitComposite(IrComposite expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                }

                public void visitComposite(IrComposite expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
                }

                public void visitReturnableBlock(IrReturnableBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                    IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitCall(IrCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCallableReference(IrCallableReference<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitFunctionReference(IrFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitPropertyReference(IrPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitRichFunctionReference(IrRichFunctionReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRichFunctionReference(this, expression2, data);
                }

                public void visitRichFunctionReference(IrRichFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRichFunctionReference(this, expression2);
                }

                public void visitRichPropertyReference(IrRichPropertyReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitRichPropertyReference(this, expression2, data);
                }

                public void visitRichPropertyReference(IrRichPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRichPropertyReference(this, expression2);
                }

                public void visitClassReference(IrClassReference expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitClassReference(IrClassReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitConst(IrConst expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConst(IrConst expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public void visitConstantValue(IrConstantValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
                }

                public void visitConstantValue(IrConstantValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                }

                public void visitConstantObject(IrConstantObject expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
                }

                public void visitConstantObject(IrConstantObject expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                }

                public void visitConstantArray(IrConstantArray expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
                }

                public void visitConstantArray(IrConstantArray expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitErrorExpression(IrErrorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitGetField(IrGetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetField(IrGetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitSetField(IrSetField expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetField(IrSetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitGetClass(IrGetClass expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetClass(IrGetClass expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitLoop(IrLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
                }

                public void visitLoop(IrLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
                }

                public void visitWhileLoop(IrWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
                }

                public void visitWhileLoop(IrWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
                }

                public void visitReturn(IrReturn expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitReturn(IrReturn expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitThrow(IrThrow expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitThrow(IrThrow expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitTry(IrTry aTry, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitCatch(IrCatch aCatch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                public void visitValueAccess(IrValueAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                }

                public void visitGetValue(IrGetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitGetValue(IrGetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitSetValue(IrSetValue expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                }

                public void visitSetValue(IrSetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitVararg(IrVararg expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitVararg(IrVararg expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitWhen(IrWhen expression2, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhen(IrWhen expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitBranch(IrBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }
            });
            return arguments;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

