/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import org.jetbrains.kotlin.ir.IrElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ-\u0010\u001b\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/PsiIrFileEntry;", "Lorg/jetbrains/kotlin/ir/AbstractIrFileEntry;", "psiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFileName", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "maxOffset", "", "getMaxOffset", "()I", "lineStartOffsets", "", "getLineStartOffsets", "()[I", "fileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "getRecognizableName", "name", "getName", "()Ljava/lang/String;", "toString", "findPsiElement", "Lcom/intellij/psi/PsiElement;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "E", "psiElementClass", "Lkotlin/reflect/KClass;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lkotlin/reflect/KClass;)Lcom/intellij/psi/PsiElement;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nPsiIrFileEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiIrFileEntry.kt\norg/jetbrains/kotlin/ir/PsiIrFileEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class PsiIrFileEntry
extends AbstractIrFileEntry {
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final String psiFileName;
    private final int maxOffset;
    @NotNull
    private final int[] lineStartOffsets;
    @NotNull
    private final FileViewProvider fileViewProvider;

    /*
     * WARNING - void declaration
     */
    public PsiIrFileEntry(@NotNull PsiFile psiFile) {
        void it;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
        Object object = this.psiFile.getVirtualFile();
        if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
            String string = this.psiFile.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        this.psiFileName = object;
        FileViewProvider fileViewProvider = this.psiFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        this.fileViewProvider = fileViewProvider;
        Document document = this.fileViewProvider.getDocument();
        if (document == null) {
            throw new AssertionError((Object)("No document for " + this.psiFile));
        }
        Document document2 = document;
        this.maxOffset = document2.getTextLength();
        int n2 = 0;
        Integer n3 = document2.getLineCount();
        int n4 = ((Number)n3).intValue();
        PsiIrFileEntry psiIrFileEntry = this;
        boolean bl = false;
        boolean bl2 = it != false;
        Integer n5 = bl2 ? n3 : null;
        int n6 = n5 != null ? n5 : 1;
        int[] nArray = new int[n6];
        while (n2 < n6) {
            int n7 = n2++;
            nArray[n7] = document2.getLineStartOffset(n7);
        }
        psiIrFileEntry.lineStartOffsets = nArray;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    @NotNull
    protected int[] getLineStartOffsets() {
        return this.lineStartOffsets;
    }

    private final String getRecognizableName() {
        return this.psiFileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getRecognizableName();
    }

    @NotNull
    public String toString() {
        return this.getRecognizableName();
    }

    @Nullable
    public final PsiElement findPsiElement(@NotNull IrElement irElement) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        for (psiElement = this.fileViewProvider.findElementAt(irElement.getStartOffset()); psiElement != null; psiElement = psiElement.getParent()) {
            TextRange textRange = psiElement.getTextRange();
            if (textRange != null ? irElement.getEndOffset() == textRange.getEndOffset() : false) break;
        }
        return psiElement;
    }

    @Nullable
    public final <E extends PsiElement> E findPsiElement(@NotNull IrElement irElement, @NotNull KClass<E> psiElementClass) {
        E e2;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter(psiElementClass, (String)"psiElementClass");
        PsiElement psiElement = this.findPsiElement(irElement);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            e2 = (E)PsiTreeUtil.getParentOfType(it, JvmClassMappingKt.getJavaClass(psiElementClass), false);
        } else {
            e2 = null;
        }
        return e2;
    }
}

