/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.statistics.HttpReportParameters;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0015J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "Ljava/lang/AutoCloseable;", "<init>", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "retryQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "requestPreviousFailed", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportParameters;", "", "invalidUrl", "close", "", "httpReportParameters", "log", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "sendData", "prepareData", "Lkotlin/Function0;", "resentData", "data", "checkResponseAndLog", "connection", "Ljava/net/HttpURLConnection;", "submit", "useExecutor", "action", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nHttpReportParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpReportParameters.kt\norg/jetbrains/kotlin/build/report/statistics/HttpReportService\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,130:1\n29#2,3:131\n*S KotlinDebug\n*F\n+ 1 HttpReportParameters.kt\norg/jetbrains/kotlin/build/report/statistics/HttpReportService\n*L\n66#1:131,3\n*E\n"})
public final class HttpReportService
implements AutoCloseable {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ConcurrentLinkedQueue<Object> retryQueue;
    @NotNull
    private final ConcurrentHashMap<HttpReportParameters, Boolean> requestPreviousFailed;
    @NotNull
    private final ConcurrentHashMap<HttpReportParameters, Boolean> invalidUrl;

    public HttpReportService() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executorService = executorService;
        this.retryQueue = new ConcurrentLinkedQueue();
        this.requestPreviousFailed = new ConcurrentHashMap();
        this.invalidUrl = new ConcurrentHashMap();
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    public final void close(@NotNull HttpReportParameters httpReportParameters, @NotNull KotlinLogger log2) {
        Intrinsics.checkNotNullParameter((Object)httpReportParameters, (String)"httpReportParameters");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        this.resentData(httpReportParameters, log2);
        this.close();
    }

    public final void sendData(@NotNull HttpReportParameters httpReportParameters, @NotNull KotlinLogger log2, @NotNull Function0<? extends Object> prepareData) {
        Intrinsics.checkNotNullParameter((Object)httpReportParameters, (String)"httpReportParameters");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter(prepareData, (String)"prepareData");
        this.submit(httpReportParameters.getUseExecutor$kotlin_build_statistics(), (Function0<Unit>)((Function0)() -> HttpReportService.sendData$lambda$0(prepareData, this, httpReportParameters, log2)));
    }

    private final void resentData(HttpReportParameters httpReportParameters, KotlinLogger log2) {
        this.submit(httpReportParameters.getUseExecutor$kotlin_build_statistics(), (Function0<Unit>)((Function0)() -> HttpReportService.resentData$lambda$2(this, httpReportParameters, log2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sendData(HttpReportParameters httpReportParameters, Object data, KotlinLogger log2) {
        HttpURLConnection httpURLConnection;
        log2.debug("Http report: send data " + data);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (Intrinsics.areEqual((Object)this.invalidUrl.get(httpReportParameters), (Object)true)) {
            return true;
        }
        try {
            URLConnection uRLConnection = new URL(httpReportParameters.getUrl$kotlin_build_statistics()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        catch (IOException e2) {
            log2.warn("Http report: Unable to open connection to " + httpReportParameters.getUrl$kotlin_build_statistics() + ": " + e2.getMessage());
            ((Map)this.invalidUrl).put(httpReportParameters, true);
            return true;
        }
        HttpURLConnection connection = httpURLConnection;
        try {
            Object auth;
            Charset charset;
            Object object;
            if (httpReportParameters.getUser$kotlin_build_statistics() != null && httpReportParameters.getPassword$kotlin_build_statistics() != null) {
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = (httpReportParameters.getUser$kotlin_build_statistics() + ':' + httpReportParameters.getPassword$kotlin_build_statistics()).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
                object = byArray2;
                charset = Charsets.UTF_8;
                auth = new String((byte[])object, charset);
                connection.addRequestProperty("Authorization", "Basic " + (String)auth);
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object = null;
            try {
                OutputStream it = (OutputStream)auth;
                boolean bl2 = false;
                String string = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.write(byArray);
                charset = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object);
            }
            connection.connect();
            this.checkResponseAndLog(httpReportParameters, connection, log2);
        }
        catch (Exception e3) {
            log2.info("Http report: Unexpected exception happened: '" + e3.getMessage() + "': " + ExceptionsKt.stackTraceToString((Throwable)e3));
            boolean bl3 = false;
            return bl3;
        }
        finally {
            connection.disconnect();
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        log2.debug("Report statistic by http takes " + elapsedTime + " ms");
        return true;
    }

    private final void checkResponseAndLog(HttpReportParameters httpReportParameters, HttpURLConnection connection, KotlinLogger log2) {
        boolean isResponseBad;
        int n2 = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n2 ? n2 < 300 : false);
        if (isResponseBad) {
            String message2 = "Failed to send statistic to " + connection.getURL() + " with " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            if (!Intrinsics.areEqual((Object)this.requestPreviousFailed.get(httpReportParameters), (Object)true)) {
                log2.warn(message2);
            } else {
                log2.debug(message2);
            }
            ((Map)this.requestPreviousFailed).put(httpReportParameters, true);
        }
    }

    private final void submit(boolean useExecutor, Function0<Unit> action) {
        if (useExecutor) {
            this.executorService.submit(() -> HttpReportService.submit$lambda$5(action));
        } else {
            action.invoke();
        }
    }

    private static final Unit sendData$lambda$0(Function0 $prepareData, HttpReportService this$0, HttpReportParameters $httpReportParameters, KotlinLogger $log) {
        Object data = $prepareData.invoke();
        if (data != null && !this$0.sendData($httpReportParameters, data, $log)) {
            this$0.retryQueue.add(data);
        }
        return Unit.INSTANCE;
    }

    private static final boolean resentData$lambda$2$lambda$1(HttpReportService this$0, HttpReportParameters $httpReportParameters, KotlinLogger $log, Object it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.sendData($httpReportParameters, it, $log);
    }

    private static final Unit resentData$lambda$2(HttpReportService this$0, HttpReportParameters $httpReportParameters, KotlinLogger $log) {
        this$0.retryQueue.removeIf(arg_0 -> HttpReportService.resentData$lambda$2$lambda$1(this$0, $httpReportParameters, $log, arg_0));
        return Unit.INSTANCE;
    }

    private static final void submit$lambda$5(Function0 $action) {
        $action.invoke();
    }
}

