/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import com.intellij.openapi.Disposable;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.K1LegacyMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.K1MetadataKlibSerializer;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataCliPipeline;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataConfigurationUpdater;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0002H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\u0015\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J*\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/KotlinMetadataCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "<init>", "()V", "doExecutePhased", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "basicMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "createArguments", "setupPlatformSpecificArgumentsAndServices", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "addPlatformOptions", "", "", "doExecute", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "Companion", "cli"})
public final class KotlinMetadataCompiler
extends CLICompiler<K2MetadataCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    protected ExitCode doExecutePhased(@NotNull K2MetadataCompilerArguments arguments, @NotNull Services services, @NotNull MessageCollector basicMessageCollector) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)basicMessageCollector, (String)"basicMessageCollector");
        MetadataCliPipeline pipeline = new MetadataCliPipeline(this.getDefaultPerformanceManager());
        return pipeline.execute((CommonCompilerArguments)arguments, services, basicMessageCollector);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
    }

    @Override
    @NotNull
    public K2MetadataCompilerArguments createArguments() {
        return new K2MetadataCompilerArguments();
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2MetadataCompilerArguments arguments, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2MetadataCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
    }

    @Override
    @NotNull
    public ExitCode doExecute(@NotNull K2MetadataCompilerArguments arguments, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths2) {
        PerformanceManager performanceManager;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration2.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"getNotNull(...)");
        MessageCollector collector2 = messageCollector;
        PerformanceManager performanceManager2 = configuration2.getNotNull(CLIConfigurationKeys.PERF_MANAGER);
        Intrinsics.checkNotNullExpressionValue((Object)performanceManager2, (String)"getNotNull(...)");
        PerformanceManager performanceManager3 = performanceManager2;
        ExitCode pluginLoadResult = this.loadPlugins(paths2, (CommonCompilerArguments)arguments, configuration2, rootDisposable);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        MetadataConfigurationUpdater.INSTANCE.fillConfiguration(configuration2, arguments);
        String moduleName2 = CommonConfigurationKeysKt.getModuleName(configuration2);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.METADATA_CONFIG_FILES);
        List<KtFile> sourceFiles = environment.getSourceFiles();
        PerformanceManager $this$doExecute_u24lambda_u2402 = performanceManager = performanceManager3;
        boolean bl = false;
        $this$doExecute_u24lambda_u2402.setTargetDescription(moduleName2);
        $this$doExecute_u24lambda_u2402.setOutputKind(arguments.getMetadataKlib() ? "KLib" : "metadata");
        $this$doExecute_u24lambda_u2402.addSourcesStats(sourceFiles.size(), environment.countLinesOfCode(sourceFiles));
        if (environment.getSourceFiles().isEmpty()) {
            if (arguments.getVersion()) {
                return ExitCode.OK;
            }
            MessageCollector.report$default(collector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        UtilsKt.checkKotlinPackageUsageForPsi$default(environment.getConfiguration(), environment.getSourceFiles(), null, 4, null);
        try {
            AbstractMetadataSerializer abstractMetadataSerializer;
            boolean $this$doExecute_u24lambda_u2402 = arguments.getMetadataKlib();
            if ($this$doExecute_u24lambda_u2402) {
                abstractMetadataSerializer = new K1MetadataKlibSerializer(configuration2, environment);
            } else if (!$this$doExecute_u24lambda_u2402) {
                abstractMetadataSerializer = new K1LegacyMetadataSerializer(configuration2, environment, true, null, 8, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AbstractMetadataSerializer metadataSerializer = abstractMetadataSerializer;
            metadataSerializer.analyzeAndSerialize();
        }
        catch (CompilationException e2) {
            String string = OutputMessageUtil.renderException(e2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"renderException(...)");
            collector2.report(CompilerMessageSeverity.EXCEPTION, string, MessageUtil.psiElementToMessageLocation(e2.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc";
    }

    @Override
    @NotNull
    public BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new BuiltInsBinaryVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/KotlinMetadataCompiler$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLICompiler.Companion.doMain(new KotlinMetadataCompiler(), args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

